/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.model.Element;
import hec.rss.model.InvalidWaterControlDeviceTypeException;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterControlDeviceType;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;
import rma.swing.RmaJPanel;

public abstract class WaterControlDevicePanel<T extends WaterControlDevice>
extends RmaJPanel {
    protected T _device;
    Element _element;
    private String _deviceName = "Water Control Device";

    protected WaterControlDevicePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setBorder(new TitledBorder(this.getWaterControlDeviceType().toString()));
    }

    abstract boolean savePanel();

    abstract void fillPanel(T var1);

    abstract void resetPanel();

    abstract WaterControlDeviceType getWaterControlDeviceType();

    abstract void initializeWaterControlDevice();

    public T getWaterControlDevice() {
        return this._device;
    }

    public final void fillPanel(Element element) {
        WaterControlDevice waterControlDevice = element.getWaterControlDevice();
        if (waterControlDevice != null) {
            try {
                this.validateDeviceType(waterControlDevice);
                this._element = element;
                this._device = waterControlDevice;
                WaterControlDevicePanel waterControlDevicePanel = this;
                waterControlDevicePanel.fillPanel(waterControlDevicePanel._device);
                return;
            }
            catch (InvalidWaterControlDeviceTypeException invalidWaterControlDeviceTypeException) {
                JOptionPane.showMessageDialog((Component)((Object)this), invalidWaterControlDeviceTypeException.getMessage(), "Invalid Water Control Device Type", 0);
            }
        }
    }

    private void validateDeviceType(WaterControlDevice waterControlDevice) throws InvalidWaterControlDeviceTypeException {
        if (waterControlDevice != null && waterControlDevice.getType() != this.getWaterControlDeviceType()) {
            throw new InvalidWaterControlDeviceTypeException(this.getWaterControlDeviceType(), waterControlDevice.getType());
        }
    }

    public Element getElement() {
        return this._element;
    }

    public String getDeviceName() {
        return this._deviceName;
    }

    public void reset() {
        this._device = null;
        this.resetPanel();
    }

    void setDeviceName(String string) {
        this._deviceName = string;
    }

    void setElement(Element element) {
        this._element = element;
    }
}

