/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.rss.client.PhysicalTreeCardPanel;
import hec.rss.client.RSimTreeNode;
import hec.rss.client.WaterControlDeviceCardPanelFactory;
import hec.rss.client.WaterControlDevicePanel;
import hec.rss.model.Element;
import hec.rss.model.ReservoirElement;
import hec.rss.model.WaterControlDevice;
import hec.rss.model.WaterControlDeviceType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.list.RmaListModel;

public class WaterControlDevicePanelContainer
extends PhysicalTreeCardPanel {
    private RmaJComboBox<WaterControlDeviceType> _waterControlDeviceComboBox;
    private RmaJPanel _cardPanel;
    private WaterControlDevicePanel<? extends WaterControlDevice> _selectedPanel;
    private Element _element;

    public WaterControlDevicePanelContainer() {
        this.initComponents();
        this.addListeners();
    }

    private void addListeners() {
        this._waterControlDeviceComboBox.addActionListener(actionEvent -> this.waterControlDeviceSelectionChange());
    }

    private void waterControlDeviceSelectionChange() {
        WaterControlDeviceType waterControlDeviceType = (WaterControlDeviceType)((Object)this._waterControlDeviceComboBox.getSelectedItem());
        if (waterControlDeviceType != null) {
            CardLayout cardLayout = (CardLayout)this._cardPanel.getLayout();
            cardLayout.show((Container)this._cardPanel, waterControlDeviceType.toString());
            this._selectedPanel = this.getSelectedPanel(waterControlDeviceType);
            if (this._selectedPanel != null && this._element.hasWaterControlDevice()) {
                this._selectedPanel.setDeviceName(this._element.getWaterControlDevice().getName());
            }
        }
    }

    private WaterControlDevicePanel<? extends WaterControlDevice> getSelectedPanel(WaterControlDeviceType waterControlDeviceType) {
        Object object = null;
        for (Object object2 : this._cardPanel.getComponents()) {
            if (!(object2 instanceof WaterControlDevicePanel) || ((WaterControlDevicePanel)((Object)(object2 = (WaterControlDevicePanel)((Object)object2)))).getWaterControlDeviceType() != waterControlDeviceType) continue;
            object = object2;
            break;
        }
        return object;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(new JLabel("Water Control Device:"), gridBagConstraints);
        this._waterControlDeviceComboBox = new RmaJComboBox();
        this._waterControlDeviceComboBox.setModifiable(true);
        this._waterControlDeviceComboBox.setPrototypeDisplayValue((Object)WaterControlDeviceType.CONTINUOUS_INTAKE);
        WaterControlDeviceType[] waterControlDeviceTypeArray = new RmaListModel();
        waterControlDeviceTypeArray.addAll((Object[])WaterControlDeviceType.values());
        this._waterControlDeviceComboBox.setModel((ComboBoxModel)waterControlDeviceTypeArray);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        WaterControlDevicePanelContainer waterControlDevicePanelContainer = this;
        waterControlDevicePanelContainer.add((Component)waterControlDevicePanelContainer._waterControlDeviceComboBox, gridBagConstraints);
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        for (WaterControlDeviceType waterControlDeviceType : WaterControlDeviceType.values()) {
            this._cardPanel.add(WaterControlDeviceCardPanelFactory.a(waterControlDeviceType), (Object)waterControlDeviceType.toString());
        }
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        WaterControlDevicePanelContainer waterControlDevicePanelContainer2 = this;
        waterControlDevicePanelContainer2.add((Component)waterControlDevicePanelContainer2._cardPanel, gridBagConstraints);
    }

    @Override
    public void fillPanel(ReservoirElement element, RSimTreeNode object) {
        super.fillPanel((ReservoirElement)element, (RSimTreeNode)object);
        if (object == null) {
            return;
        }
        element = ((RSimTreeNode)object).d();
        if (element == null || !element.hasWaterControlDevice()) {
            return;
        }
        this._element = element;
        for (Component component : this._cardPanel.getComponents()) {
            if (!(component instanceof WaterControlDevicePanel)) continue;
            ((WaterControlDevicePanel)((Object)component)).reset();
        }
        object = element.getWaterControlDevice();
        this._waterControlDeviceComboBox.setSelectedItem((Object)((WaterControlDevice)object).getType());
        this.waterControlDeviceSelectionChange();
        if (this._selectedPanel != null) {
            this._selectedPanel.fillPanel(element);
        }
    }

    @Override
    public boolean savePanel() {
        boolean bl = true;
        if (this._element != null && this._selectedPanel != null) {
            if (this._selectedPanel.getWaterControlDevice() == null) {
                this._selectedPanel.initializeWaterControlDevice();
            }
            String string = this._selectedPanel.getDeviceName();
            if (this._element.hasWaterControlDevice()) {
                string = this._element.getWaterControlDevice().getName();
            }
            this._selectedPanel.setElement(this._element);
            bl = this._selectedPanel.savePanel();
            WaterControlDevice waterControlDevice = this._selectedPanel.getWaterControlDevice();
            waterControlDevice.setName(string);
            this._element.setWaterControlDevice(waterControlDevice);
        }
        return bl;
    }
}

