/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.WaterControlPortGeometry;
import hec.rss.client.WaterControlPortRowItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAIO;

public class WaterControlDeviceTableModel
extends AbstractRmaTableModel {
    List<WaterControlPortRowItem> _portRows = new ArrayList<WaterControlPortRowItem>();
    int _unitSystem = 0;

    public WaterControlDeviceTableModel() {
        this.setColumnParameters(new int[]{-1, Parameter.PARAMID_ELEV});
        this.m_columnNames = new String[]{"Port Level", "Invert\nElevation(%S)", "Number of Ports"};
    }

    public WaterControlDeviceTableModel(List<WaterControlPortRowItem> list, int n) {
        this();
        this._portRows = new ArrayList<WaterControlPortRowItem>();
        this._portRows.addAll(list);
        this._unitSystem = n;
    }

    public void setData(List<WaterControlPortRowItem> list, int n) {
        this._portRows = new ArrayList<WaterControlPortRowItem>();
        this._portRows.addAll(list);
        this._unitSystem = n;
        this.fireTableDataChanged();
    }

    public int getColumnParameter(int n) {
        if (n == 1) {
            return Parameter.PARAMID_ELEV;
        }
        return -1;
    }

    public void deleteRow(int n) {
        if (n >= 0 && n < this._portRows.size()) {
            this._portRows.remove(n);
            int n2 = n;
            this.fireTableRowsDeleted(n2, n2);
        }
    }

    public void addRow(Vector cloneable) {
        int n;
        cloneable = new WaterControlPortGeometry();
        cloneable = new WaterControlPortRowItem(Double.NEGATIVE_INFINITY, 1, (WaterControlPortGeometry)cloneable);
        this._portRows.add((WaterControlPortRowItem)cloneable);
        int n2 = n = this.getRowCount() - 1;
        this.fireTableRowsInserted(n2, n2);
    }

    public Vector getRow(int n) {
        Vector<Object> vector = new Vector<Object>(this.getColumnCount());
        if (n < 0 || n >= this.getRowCount()) {
            return vector;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            vector.add(this.getValueAt(n, i));
        }
        return vector;
    }

    public int getRowCount() {
        return this._portRows.size();
    }

    public Class getColumnClass(int n) {
        return super.getColumnClass(n);
    }

    public int getColumnCount() {
        return super.getColumnCount();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return n + 1;
        }
        if (n2 == 1) {
            if (this._portRows != null && this._portRows.get(n) != null) {
                return new ParamDouble(this._portRows.get(n).getInvertElevation(), Parameter.PARAMID_ELEV, this._unitSystem);
            }
            return new ParamDouble(Double.NEGATIVE_INFINITY, Parameter.PARAMID_ELEV, this._unitSystem);
        }
        if (this._portRows != null && this._portRows.get(n) != null) {
            return this._portRows.get(n).getNumOfPorts();
        }
        return 1;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 == 1) {
            double d = object instanceof ParamDouble ? ((ParamDouble)object).getValue() : RMAIO.parseDouble((String)(object != null ? object.toString() : ""));
            this._portRows.get(n).setInvertElevation(d);
            return;
        }
        if (n2 == 2) {
            int n3 = RMAIO.parseInt((Object)object);
            this._portRows.get(n).setNumOfPorts(n3);
        }
    }

    public List<WaterControlPortRowItem> getPortRows() {
        return this._portRows;
    }

    public int[] getPortNumbers() {
        int n = this.getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = n3 + 1;
        }
        return nArray;
    }
}

