/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.rss.client.RulePanel;
import hec.rss.client.RulePanel$DateTablePanel;
import hec.rss.client.RulePanel$DateTimeTablePanel;
import hec.rss.client.RulePanel$PairedValuesPanel;
import hec.rss.client.RulePanel$SeasonalPairedValuesPanel;
import hec.rss.client.WaterQualityRulePanel$1;
import hec.rss.client.WaterQualityRulePanel$2;
import hec.rss.client.WaterQualityRulePanel$3;
import hec.rss.client.WaterQualityRulePanel$4;
import hec.rss.client.WaterQualityRulePanel$5;
import hec.rss.client.WaterQualityRulePanel$6;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.RssNode;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.WaterQualityOpReleaseType;
import hec.rss.model.WaterQualityOpRule;
import hec.rss.wq.model.ConstituentSetManager;
import hec.wqenginecore.Constituent;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.metadata.Parameter;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class WaterQualityRulePanel
extends RulePanel {
    public static final String SPECIFIED = "Specified";
    public static final String[] DNSTRM_LIMIT_TYPES = new String[]{"Minimum", "Maximum", "Specified"};
    RmaJTextField _locationField;
    RmaJComboBox _constituentComboBox;
    ComboBoxModel<Constituent> _constituentListModel;
    JPanel _rocPanel;
    private JButton _advancedOptionsBtn;
    private ItemListener _parameterComboListener;
    private ItemListener _constituentComboListener;
    private boolean _showDownstreamLocationField = false;
    private RmaJComboBox<WaterQualityOpReleaseType> _releaseTypeComboBox;

    @Override
    protected void buildControls() {
        JLabel jLabel;
        this._limitTypes = DNSTRM_LIMIT_TYPES;
        super.buildControls();
        JPanel jPanel = new JPanel(new GridBagLayout());
        Object object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 4;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add(jPanel, object);
        if (this._showDownstreamLocationField) {
            jLabel = new JLabel("Downstream Location:");
            jLabel.setDisplayedMnemonic('o');
            object = new GridBagConstraints();
            new GridBagConstraints().gridx = 0;
            object.gridy = 0;
            object.gridwidth = 1;
            object.anchor = 17;
            object.fill = 0;
            object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            jPanel.add((Component)jLabel, object);
            this._locationField = new RmaJTextField();
            this._locationField.setEditable(false);
            jLabel.setLabelFor((Component)this._locationField);
            object = new GridBagConstraints();
            new GridBagConstraints().gridx = 1;
            object.gridy = 0;
            object.gridwidth = 1;
            object.weightx = 1.0;
            object.anchor = 17;
            object.fill = 2;
            object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            jPanel.add((Component)this._locationField, object);
        }
        jLabel = new JLabel("Constituent:");
        jLabel.setDisplayedMnemonic('C');
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 1;
        object.gridwidth = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)jLabel, object);
        object = new Constituent[]{};
        this._constituentListModel = new RmaListModel(false, (Object[])object);
        this._constituentComboBox = new RmaJComboBox(this._constituentListModel);
        this._constituentComboBox.setModifiable(true);
        jLabel.setLabelFor((Component)this._constituentComboBox);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 1;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jPanel.add((Component)this._constituentComboBox, object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.gridwidth = 1;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)new JLabel("Release Preference:"), object);
        this._releaseTypeComboBox = new RmaJComboBox();
        object = new RmaListModel(false, (Object[])WaterQualityOpReleaseType.values());
        this._releaseTypeComboBox.setModel((ComboBoxModel)object);
        this._releaseTypeComboBox.setModifiable(true);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 2;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 17;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._releaseTypeComboBox, object);
        this._rocPanel = new JPanel(new CardLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.weightx = 1.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._rightPanel.add((Component)this._rocPanel, object);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("ROCPANEL");
        this._rocPanel.add(jPanel.getName(), jPanel);
        jLabel = new JLabel("   ");
        jLabel.setName("EMPTYPANEL");
        this._rocPanel.add(jLabel.getName(), jLabel);
        this._risingFallingConditionCB.setSelected(false);
        this._risingFallingConditionCB.setEnabled(false);
        this._risingFallingConditionCB.setVisible(false);
        this._periodAverageLimitCB.setSelected(false);
        this._periodAverageLimitCB.setEnabled(false);
        this._periodAverageLimitCB.setVisible(false);
        this._hourOfDayMultiplyerCB.setSelected(false);
        this._hourOfDayMultiplyerCB.setEnabled(false);
        this._hourOfDayMultiplyerCB.setVisible(false);
        this._dayOfWeekMultiplerCB.setSelected(false);
        this._dayOfWeekMultiplerCB.setEnabled(false);
        this._dayOfWeekMultiplerCB.setVisible(false);
        this._flowContingencyCB.setSelected(false);
        this._flowContingencyCB.setEnabled(false);
        this._flowContingencyCB.setVisible(false);
        this._parameterComboListener = new WaterQualityRulePanel$1(this);
        this._constituentComboListener = new WaterQualityRulePanel$2(this);
        this._constituentComboBox.addItemListener(this._constituentComboListener);
        this.initMinimumSize();
    }

    private void initMinimumSize() {
        this.setMinimumSize(new Dimension(500, 400));
    }

    private String createPlotLabel() {
        int n = this._constituentComboBox != null ? this._constituentComboBox.getSelectedIndex() : -1;
        Object object = "";
        if (n >= 0) {
            Constituent constituent = (Constituent)this._constituentListModel.getElementAt(n);
            object = constituent.getId() == 1 ? constituent.toString() + " (%S)" : constituent.toString() + " (" + constituent.getUnit() + ")";
        }
        return object;
    }

    @Override
    protected void buildRightPanel() {
        this._rightPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        WaterQualityRulePanel waterQualityRulePanel = this;
        waterQualityRulePanel.add(waterQualityRulePanel._rightPanel, gridBagConstraints);
    }

    @Override
    protected RulePanel$PairedValuesPanel createPairedValuesPanel() {
        return new WaterQualityRulePanel$3(this);
    }

    @Override
    protected RulePanel$SeasonalPairedValuesPanel createSeasonalPairedValuesPanel() {
        return new WaterQualityRulePanel$4(this);
    }

    @Override
    protected RulePanel$DateTimeTablePanel createDateTimeTablePanel() {
        return new WaterQualityRulePanel$5(this);
    }

    @Override
    protected RulePanel$DateTablePanel createDateTablePanel() {
        return new WaterQualityRulePanel$6(this);
    }

    public void controlParameterChanged() {
        this._currentPanel.rebuildTableColumnLabels();
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        if (window instanceof RmaJDialog) {
            ((RmaJDialog)window).updateUnitSystem((Container)((Object)this));
        } else if (window instanceof RmaJFrame) {
            ((RmaJFrame)window).updateUnitSystem((Container)((Object)this));
        }
        this.plotTable();
    }

    @Override
    public boolean savePanel() {
        if (!super.savePanel()) {
            return false;
        }
        if (this._currentRuleRef == null) {
            return false;
        }
        WaterQualityOpRule waterQualityOpRule = (WaterQualityOpRule)this._currentRuleRef.getRule();
        if (waterQualityOpRule == null) {
            return false;
        }
        Object object = this._constituentComboBox.getSelectedItem();
        waterQualityOpRule.setConstituentName(object != null ? object.toString() : "");
        object = (WaterQualityOpReleaseType)((Object)this._releaseTypeComboBox.getSelectedItem());
        waterQualityOpRule.setReleaseType((WaterQualityOpReleaseType)((Object)object));
        return true;
    }

    @Override
    public void fillPanel(ReleaseFuncOpRule releaseFuncOpRule) {
        super.fillPanel(releaseFuncOpRule);
        if (this._locationField != null) {
            this._locationField.setEditable(false);
        }
        releaseFuncOpRule = (WaterQualityOpRule)releaseFuncOpRule;
        int n = ((WaterQualityOpRule)releaseFuncOpRule).getDownstreamControlLocationID();
        new ArrayList();
        Predicate<RssNode> cfr_ignored_0 = rssNode -> rssNode.getIndex() == n;
        List<Object> list = ((RssTSLocationObject)releaseFuncOpRule).getSystem().getNode(n);
        if (this._locationField != null) {
            this._locationField.setText(list != null ? ((RssTSLocationObject)releaseFuncOpRule).getSystem().getNameForKeyString(list.getName()) : "");
        }
        list = ClientApp.Workspace().getManagerProxyList("rss", ConstituentSetManager.class.getName());
        list = list.stream().map(managerProxy -> managerProxy.loadManager(null, null)).filter(manager -> manager != null).map(manager -> ((ConstituentSetManager)((Object)manager)).getSet()).collect(Collectors.toList());
        list = ConstituentSetManager.a(list);
        list = list.stream().filter(Constituent::getIsAdvected).collect(Collectors.toList());
        this._constituentListModel = new RmaListModel(true, (Object[])list.toArray(new Constituent[0]));
        this._constituentComboBox.setModel(this._constituentListModel);
        String string = ((WaterQualityOpRule)releaseFuncOpRule).getConstituentName();
        string = string != null ? string : "";
        list = list.stream().filter(constituent -> constituent.toString().equals(string)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            this._constituentComboBox.setSelectedItem(list.get(0));
            list = (Constituent)list.get(0);
            int n2 = list.getId();
            if (n2 == 1) {
                this.setYParamId(Parameter.PARAMID_TEMP);
            } else {
                this.setYParamId(Parameter.PARAMID_CONC);
            }
        }
        this._releaseTypeComboBox.setSelectedItem((Object)((WaterQualityOpRule)releaseFuncOpRule).getReleaseType());
        if (this._currentPanel != null) {
            this._currentPanel.rebuildTableColumnLabels();
        }
        this.limitTypeComboChanged();
    }

    @Override
    protected void limitTypeComboChanged() {
        Object object = this._limitTypeCombo.getSelectedItem();
        this._releaseTypeComboBox.setEnabled(object == null || !SPECIFIED.equals(object.toString()));
    }

    public static void a(String[] object) {
        object = new WaterQualityRulePanel();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add((Component)object, "Center");
        jFrame.pack();
        jFrame.setLocation(500, 500);
        jFrame.setVisible(true);
    }

    @Override
    protected void configureSeasonalRecordPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 2;
        g2dPlotProp.y1AxisProp.name = this.createPlotLabel();
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    @Override
    protected void configurePairedValuesPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        g2dPlotProp.x1AxisProp.name = this._xParamId == -1 ? this._xParamString : this._xParamString + " (%S)";
        g2dPlotProp.y1AxisProp.name = this.createPlotLabel();
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }
}

