/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.client.TextEditorPanel;
import hec.client.TextFileEditorDialog;
import hec.clientapp.client.ClientApp;
import hec.clientapp.io.WatershedInfoFile;
import hec.io.Identifier;
import hec.rss.client.WatershedInfoDialog$1;
import hec.rss.client.WatershedInfoDialog$2;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextArea;

public class WatershedInfoDialog
extends TextFileEditorDialog {
    private RmaJTextArea _commentArea;
    private JButton _addCommentBtn;
    private ButtonCmdPanel _cmdPanel;

    public WatershedInfoDialog(Frame frame, boolean bl, Identifier identifier) {
        super(frame, true, identifier, false);
        this.setSize(550, 400);
        this.setMinimumSize(new Dimension(400, 400));
        this.addListeners();
    }

    protected void buildControls(Identifier object, boolean bl) {
        super.buildControls(object, bl);
        object = (RSyntaxTextArea)super.getEditorPanel().getTextArea();
        object.setSyntaxEditingStyle("text/markdown");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 2;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JSeparator(), object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        object.gridx = 0;
        object.gridy = 3;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.75;
        object.anchor = 18;
        object.fill = 1;
        object.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)jPanel, object);
        JLabel jLabel = new JLabel("Add Comment:");
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 17;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, object);
        this._commentArea = new RmaJTextArea();
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.75;
        object.anchor = 17;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)new JScrollPane((Component)this._commentArea), object);
        jPanel = new JPanel(new GridBagLayout());
        object.gridx = 0;
        object.gridy = 4;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 2;
        object.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)jPanel, object);
        this._addCommentBtn = new JButton("Add");
        this._addCommentBtn.setToolTipText("Add the comment to the watershed info file");
        this._addCommentBtn.setMnemonic('A');
        object.gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.anchor = 18;
        object.fill = 0;
        object.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._addCommentBtn, object);
        this._cmdPanel = new ButtonCmdPanel(256);
        object.gridx = 0;
        object.gridy = 10;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 0.0;
        object.anchor = 16;
        object.fill = 2;
        object.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, object);
    }

    protected TextEditorPanel createTextEditorPanel(Identifier identifier, boolean bl) {
        return new WatershedInfoDialog$1(this, identifier, bl);
    }

    private void addListeners() {
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new WatershedInfoDialog$2(this));
        this._addCommentBtn.addActionListener(actionEvent -> this.addCommentAction());
    }

    protected void saveOutStandingComment() {
        if (this._commentArea.getText().isEmpty()) {
            return;
        }
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>There is still a comment that hasn't been added.<br>Do you want it added?</html>", "Outstanding Comment", 0);
        if (n == 0) {
            this.addCommentAction();
        }
        this._commentArea.setText("");
    }

    private void addCommentAction() {
        String string = this._commentArea.getText().trim();
        if (string.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a comment", "No Comment Entered", 1);
            return;
        }
        this.addCommentAction(string);
    }

    private void addCommentAction(String string) {
        WatershedInfoFile watershedInfoFile = ClientApp.Workspace().getWatershedInfoFile();
        if (watershedInfoFile != null && (string = watershedInfoFile.addRecord("Comment", string)) != null) {
            this.getEditorPanel().getTextArea().append(string);
            this.getEditorPanel().getTextArea().append(System.lineSeparator());
            this._commentArea.setText("");
        }
    }
}

