/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.HecClientFrame;
import hec.rss.client.WildcardFileSelector$1;
import hec.rss.client.WildcardFileSelector$2;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.swing.text.PathnameDocument;
import rma.util.RMAIO;

public class WildcardFileSelector
extends RmaJDialog {
    private boolean _controlsBuilt = false;
    private boolean _isCanceled = false;
    RmaJTextField _directoryText;
    RmaJTextField _patternText;
    ButtonCmdPanel _buttonCmdPanel;
    JList _matchList;
    JLabel _matchingFilesLabel;
    JButton _updateButton;

    public WildcardFileSelector(Frame frame, boolean bl) {
        super(frame, bl);
        this.buildControls();
    }

    public WildcardFileSelector(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.buildControls();
    }

    private void buildControls() {
        if (this._controlsBuilt) {
            return;
        }
        Component[] componentArray = new Insets(5, 5, 0, 5);
        this.setTitle("Enter Wildcard Filter");
        this.setSize(450, 170);
        this.setLocation();
        this.getContentPane().setLayout(new GridBagLayout());
        JComponent jComponent = new JLabel("Directory:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._directoryText = new RmaJTextField((Document)new PathnameDocument(), "", 20);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 7.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._directoryText, gridBagConstraints);
        jComponent = new JButton("Browse...");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = new JLabel("Pattern:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent2, gridBagConstraints);
        this._patternText = new RmaJTextField("", 20);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 7.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._patternText, gridBagConstraints);
        this._matchList = new RmaJList((ListModel)new RmaListModel(true));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jComponent2 = new JScrollPane(this._matchList);
        this._matchingFilesLabel = new JLabel(" Matching Files");
        ((JScrollPane)jComponent2).setColumnHeaderView(this._matchingFilesLabel);
        this.getContentPane().add((Component)jComponent2, gridBagConstraints);
        this._buttonCmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = componentArray;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._buttonCmdPanel, gridBagConstraints);
        componentArray = this._buttonCmdPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton) || !((JButton)componentArray[i]).getText().equals("Apply")) continue;
            this._updateButton = (JButton)componentArray[i];
            this._updateButton.setText("Update");
            break;
        }
        this._controlsBuilt = true;
        this._buttonCmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new WildcardFileSelector$1(this));
        ((AbstractButton)jComponent).addActionListener(new WildcardFileSelector$2(this));
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    protected void okAction() {
        this._isCanceled = false;
        this.setVisible(false);
    }

    protected void applyAction() {
        String[] stringArray = ClientApp.app().getFileManager();
        stringArray = (RmiFileManager)stringArray.getRemote();
        RmaListModel rmaListModel = (RmaListModel)this._matchList.getModel();
        rmaListModel.removeAllElements();
        try {
            stringArray = stringArray.list(this._directoryText.getText(), this._patternText.getText());
            if (stringArray == null || stringArray.length <= 0) {
                this._matchingFilesLabel.setText("0 Matching Files");
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                rmaListModel.addElement((Object)stringArray[i]);
            }
            this._matchingFilesLabel.setText(stringArray.length + " Matching Files");
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("Error getting listing from RmiFileManager " + String.valueOf(remoteException));
            return;
        }
    }

    protected void cancelAction() {
        this._isCanceled = true;
        this.setVisible(false);
    }

    protected void browse() {
        RmiFileDialog rmiFileDialog = new Vector(1);
        rmiFileDialog.addElement("*.*");
        ClientApp.app();
        HecClientFrame hecClientFrame = ClientApp.frame();
        ClientApp.app();
        rmiFileDialog = new RmiFileDialog((Frame)hecClientFrame, true, ClientApp.Workspace().getWorkspacePath(), rmiFileDialog);
        rmiFileDialog.setOpenDirectory();
        rmiFileDialog.setVisible(true);
        if (rmiFileDialog.isCanceled()) {
            return;
        }
        rmiFileDialog = rmiFileDialog.getIdentifier();
        this._directoryText.setText(rmiFileDialog.getPath());
    }

    public String getDirectory() {
        return this._directoryText.getText();
    }

    public String getPattern() {
        return this._patternText.getText();
    }

    public String getSelection() {
        return this._directoryText.getText() + "/" + this._patternText.getText();
    }

    public void setSelection(String string) {
        if (string == null) {
            this.clearForm();
            return;
        }
        String string2 = RMAIO.getDirectoryFromPath((String)string);
        string = RMAIO.getFileFromPath((String)string);
        this._directoryText.setText(string2);
        this._patternText.setText(string);
        this.applyAction();
    }
}

