/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.gfx2d.G2dDialog;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.PlotLayout;
import hec.io.PairedDataContainer;
import hec.rss.client.YieldFlowConvergencePlot;
import hec.rss.client.YieldResultsPlotBase;
import hec.rss.client.YieldStorageConvergencePlot;
import hec.rss.client.YieldTrialResultsPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;

class YieldAnalysisResultsPlotDialog
extends G2dDialog {
    private RmaJRadioButton _trialFactorsRad;
    private RmaJRadioButton _ruleDemandRad;
    private RmaJCheckBox _plotFlowFactor;
    private RmaJCheckBox _plotFlowConvergence;
    private RmaJCheckBox _plotStorageConvergence;
    private RmaJPanel _radioPanel;
    private final YieldTrialResultsPlot _flowFactor;
    private final YieldStorageConvergencePlot _storageConvergence;
    private final YieldFlowConvergencePlot _flowConvergence;
    private String _storOrFlowString;

    YieldAnalysisResultsPlotDialog(YieldTrialResultsPlot yieldTrialResultsPlot, YieldStorageConvergencePlot yieldStorageConvergencePlot, YieldFlowConvergencePlot yieldFlowConvergencePlot) {
        this._flowFactor = yieldTrialResultsPlot;
        this._storageConvergence = yieldStorageConvergencePlot;
        this._flowConvergence = yieldFlowConvergencePlot;
        this._storOrFlowString = this._flowFactor.m() ? "Storage" : "Flow";
        this.buildControls();
        this.addActionListeners();
        this.flowFactorRadioChanged();
        this.plotSelectedCurves();
        this.setSize(1000, 800);
    }

    private void buildControls() {
        YieldAnalysisResultsPlotDialog yieldAnalysisResultsPlotDialog = this;
        yieldAnalysisResultsPlotDialog.add((Component)yieldAnalysisResultsPlotDialog.createTopPanel(), "North");
    }

    private void addActionListeners() {
        this._plotFlowFactor.addActionListener(actionEvent -> this.flowFactorSelectionChanged());
        this._plotStorageConvergence.addActionListener(actionEvent -> this.plotSelectedCurves());
        this._plotFlowConvergence.addActionListener(actionEvent -> this.plotSelectedCurves());
        this._trialFactorsRad.addActionListener(actionEvent -> this.flowFactorRadioChanged());
        this._ruleDemandRad.addActionListener(actionEvent -> this.flowFactorRadioChanged());
    }

    private void flowFactorRadioChanged() {
        this._flowFactor.a(this._trialFactorsRad.isSelected());
        this.plotSelectedCurves();
    }

    private RmaJPanel createTopPanel() {
        this._plotFlowFactor = new RmaJCheckBox("Plot " + this._storOrFlowString + " Factor");
        this._plotFlowConvergence = new RmaJCheckBox("Plot Flow Convergence");
        this._plotStorageConvergence = new RmaJCheckBox("Plot Storage Convergence");
        this._plotFlowFactor.setSelected(true);
        this._plotFlowConvergence.setSelected(true);
        this._plotStorageConvergence.setSelected(true);
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._plotFlowFactor, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._plotStorageConvergence, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this._plotFlowConvergence, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)new RmaJPanel((LayoutManager)new GridBagLayout()), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        rmaJPanel.add((Component)this.createRadioButtonPanel(), (Object)gridBagConstraints);
        gridBagConstraints = new RmaJPanel((LayoutManager)new BorderLayout());
        gridBagConstraints.add((Component)rmaJPanel, "North");
        return gridBagConstraints;
    }

    private RmaJPanel createRadioButtonPanel() {
        this._radioPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._radioPanel.setBorder((Border)new TitledBorder(this._storOrFlowString + " Factor Display Options"));
        this._trialFactorsRad = new RmaJRadioButton("Trial Factors");
        this._trialFactorsRad.setSelected(true);
        Serializable serializable = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._radioPanel.add((Component)this._trialFactorsRad, (Object)serializable);
        String string = this._flowFactor.m() ? "Pool Storage" : "Rule Demand";
        this._ruleDemandRad = new RmaJRadioButton(string);
        ((GridBagConstraints)serializable).gridx = -1;
        ((GridBagConstraints)serializable).gridy = -1;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).weightx = 0.0;
        ((GridBagConstraints)serializable).weighty = 0.0;
        ((GridBagConstraints)serializable).anchor = 17;
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)5);
        this._radioPanel.add((Component)this._ruleDemandRad, (Object)serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add((AbstractButton)this._trialFactorsRad);
        ((ButtonGroup)serializable).add((AbstractButton)this._ruleDemandRad);
        return this._radioPanel;
    }

    private void flowFactorSelectionChanged() {
        boolean bl = this._plotFlowFactor.isSelected();
        this._radioPanel.setEnabled(bl);
        this.plotSelectedCurves();
    }

    private void plotSelectedCurves() {
        PlotLayout plotLayout = new PlotLayout();
        if (this._plotFlowFactor.isSelected()) {
            YieldAnalysisResultsPlotDialog yieldAnalysisResultsPlotDialog = this;
            yieldAnalysisResultsPlotDialog.addYieldPlotViewport(yieldAnalysisResultsPlotDialog._flowFactor, plotLayout);
        }
        if (this._plotFlowConvergence.isSelected()) {
            YieldAnalysisResultsPlotDialog yieldAnalysisResultsPlotDialog = this;
            yieldAnalysisResultsPlotDialog.addYieldPlotViewport(yieldAnalysisResultsPlotDialog._flowConvergence, plotLayout);
        }
        if (this._plotStorageConvergence.isSelected()) {
            YieldAnalysisResultsPlotDialog yieldAnalysisResultsPlotDialog = this;
            yieldAnalysisResultsPlotDialog.addYieldPlotViewport(yieldAnalysisResultsPlotDialog._storageConvergence, plotLayout);
        }
        G2dPanel g2dPanel = this.getPlotpanel();
        g2dPanel.setVisible(false);
        g2dPanel.buildComponents(plotLayout);
        g2dPanel.getAxisTics(0).getAxis().setMajorTicInterval(1.0);
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)g2dPanel);
        g2dPanel.setVisible(true);
    }

    private void addYieldPlotViewport(YieldResultsPlotBase yieldResultsPlotBase, PlotLayout plotLayout) {
        int n = yieldResultsPlotBase.g();
        plotLayout = plotLayout.addViewport();
        plotLayout.setAxisLabel("Y1", yieldResultsPlotBase.e());
        plotLayout.setAxisLabel("X1", yieldResultsPlotBase.d());
        plotLayout.setAxisName("Y1", yieldResultsPlotBase.h());
        for (int i = 0; i < n; ++i) {
            G2dLineProperties g2dLineProperties = yieldResultsPlotBase.a(i);
            PairedDataContainer pairedDataContainer = yieldResultsPlotBase.b(i);
            plotLayout.addCurve("Y1", (Object)pairedDataContainer, g2dLineProperties);
        }
    }
}

