/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.data.Parameter;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.UnitColumnCellRenderer;
import hec.rss.client.YieldDemandPanelBase$1;
import hec.rss.model.RssAlt;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import rma.services.ServiceLookup;
import rma.swing.RmaJTable;
import rma.swing.table.ToolTipHeader;

abstract class YieldDemandPanelBase
extends JPanel {
    int _paramFlow = Parameter.PARAMID_FLOW;
    int _paramPower = Parameter.PARAMID_POWER;
    Map<Integer, Boolean> _satisfyMap = new HashMap<Integer, Boolean>();
    RssAlt _alternative;
    AlternativeEditor _editor;
    RmaJTable _selectedRulesTable;
    List<YieldAnalysisRuleRef> _ruleRefList;

    YieldDemandPanelBase(AlternativeEditor alternativeEditor) {
        super(new GridBagLayout());
        this._editor = alternativeEditor;
        this.buildSelectedRulesTable();
    }

    private void buildSelectedRulesTable() {
        YieldDemandPanelBase yieldDemandPanelBase = this;
        this._selectedRulesTable = new YieldDemandPanelBase$1(yieldDemandPanelBase, yieldDemandPanelBase, new String[]{"Demand Rule", "Tolerance", "Units", "Satisfy"});
        Object[] objectArray = new String[]{"Demand Rule", "Tolerance", "Units", "<html>Selected rules will be checked against their requested demand<br>when determining whether a water supply pool size<br>was able to meet all requested demands</html>"};
        ToolTipHeader toolTipHeader = new ToolTipHeader(this._selectedRulesTable.getColumnModel());
        toolTipHeader.setToolTipStrings(objectArray);
        this._selectedRulesTable.setTableHeader((JTableHeader)toolTipHeader);
        this._selectedRulesTable.setColumnEnabled(true, 1);
        this._selectedRulesTable.setColumnEnabled(false, 2);
        this._selectedRulesTable.setColumnEnabled(true, 3);
        this._selectedRulesTable.setAddRemoveEnabled(false);
        this._selectedRulesTable.setSelectionMode(0);
        this._selectedRulesTable.setRowHeight(this._selectedRulesTable.getRowHeight() + 5);
        objectArray = this._selectedRulesTable.setDoubleCellEditor(1, true);
        objectArray.setMinValue(0.0);
        objectArray.setEmptyOk(false);
        this._selectedRulesTable.setCheckBoxCellEditor(3);
        this._selectedRulesTable.setUnitsHeaderRenderer();
        this._selectedRulesTable.removePopupMenuSumOptions();
        objectArray = new int[]{-1, this._paramFlow, -1, -1};
        this._selectedRulesTable.setColumnParameters((int[])objectArray);
        int n = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
        this._selectedRulesTable.setDisplayUnitsSystem(n);
        TableColumn tableColumn = this._selectedRulesTable.getColumnModel().getColumn(2);
        tableColumn.setCellRenderer((TableCellRenderer)((Object)new UnitColumnCellRenderer(false)));
    }

    boolean doesRuleAlreadyExist(RssAlt rssAlt, List<YieldAnalysisRuleRef> object, YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        boolean bl = false;
        int n = yieldAnalysisRuleRef.getRule().getIndex();
        object = object.iterator();
        while (object.hasNext()) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef2 = (YieldAnalysisRuleRef)object.next();
            if (!yieldAnalysisRuleRef2.isInitialized()) {
                yieldAnalysisRuleRef2.initializeData(rssAlt.getSystem());
            }
            if (yieldAnalysisRuleRef2.getRule().getIndex() != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    Map<Integer, Boolean> getSatisfyMap() {
        HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
        for (int i = 0; i < this._selectedRulesTable.getRowCount(); ++i) {
            boolean bl = (Boolean)this._selectedRulesTable.getValueAt(i, 3);
            YieldAnalysisRuleRef yieldAnalysisRuleRef = this._ruleRefList.get(i);
            int n = yieldAnalysisRuleRef.getRule().getIndex();
            hashMap.put(n, bl);
        }
        return hashMap;
    }

    void clearAllSatisfyCheckboxes(boolean bl) {
        for (int i = 0; i < this._selectedRulesTable.getRowCount(); ++i) {
            this._selectedRulesTable.getModel().setValueAt(!bl, i, 3);
        }
    }

    abstract void clearPanel();
}

