/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client;

import hec.clientapp.client.ClientApp;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.YieldDemandRulePanel$1;
import hec.rss.client.YieldDemandRulePanel$10;
import hec.rss.client.YieldDemandRulePanel$11;
import hec.rss.client.YieldDemandRulePanel$12;
import hec.rss.client.YieldDemandRulePanel$13;
import hec.rss.client.YieldDemandRulePanel$14;
import hec.rss.client.YieldDemandRulePanel$15;
import hec.rss.client.YieldDemandRulePanel$2;
import hec.rss.client.YieldDemandRulePanel$3;
import hec.rss.client.YieldDemandRulePanel$4;
import hec.rss.client.YieldDemandRulePanel$5;
import hec.rss.client.YieldDemandRulePanel$6;
import hec.rss.client.YieldDemandRulePanel$7;
import hec.rss.client.YieldDemandRulePanel$8;
import hec.rss.client.YieldDemandRulePanel$9;
import hec.rss.model.OpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirYieldAnalysis;
import hec.rss.model.RssAlt;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.StorageZone;
import hec.rss.model.StorageZoneRef;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableRowSorter;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaTableModel;
import rma.swing.table.WildcardRowFilter;

public class YieldDemandRulePanel
extends JPanel {
    private RmaJRadioButton _waterSupplyRulesRadio;
    private RmaJRadioButton _hydropowerRulesRadio;
    private EnabledJPanel _contentPanel;
    private RmaJComboBox _nameFilterCombo;
    private RmaJComboBox _ruleFilterCombo;
    private RmaJComboBox _ruleTypeFilterCombo;
    private RmaJTable _avalibleRulesTable;
    private RmaTableModel _elementTableModel;
    private JButton _selectButton;
    private JButton _deselectButton;
    private RmaJTable _resZoneTable;
    private AlternativeEditor _editor;
    private ItemListener _il;
    private ActionListener _al;
    private RssAlt _alternative;
    private List<YieldAnalysisRuleRef> _ruleRefList;
    private List<ReservoirElement> _reservoirList;
    private RmaJTable _selectedRulesTable;
    private int _paramFlow = Parameter.PARAMID_FLOW;
    private int _paramPower = Parameter.PARAMID_POWER;

    public YieldDemandRulePanel(AlternativeEditor alternativeEditor) {
        this.setLayout(new GridBagLayout());
        this._editor = alternativeEditor;
        this.setBorder(new TitledBorder("Select \"Demand\" Rule to Maximize"));
        this.buildControls();
        this.addListeners();
    }

    public void buildControls() {
        Object object = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)object, gridBagConstraints);
        this._waterSupplyRulesRadio = new RmaJRadioButton("Water Supply Rules");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._waterSupplyRulesRadio, gridBagConstraints);
        this._hydropowerRulesRadio = new RmaJRadioButton("Hydropower Rules");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        ((Container)object).add((Component)this._hydropowerRulesRadio, gridBagConstraints);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this._waterSupplyRulesRadio);
        ((ButtonGroup)object).add((AbstractButton)this._hydropowerRulesRadio);
        this._contentPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        YieldDemandRulePanel yieldDemandRulePanel = this;
        yieldDemandRulePanel.add((Component)yieldDemandRulePanel._contentPanel, gridBagConstraints);
        object = new JLabel("Filter");
        ((JLabel)object).setDisplayedMnemonic('F');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)object, (Object)gridBagConstraints);
        Object object2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._contentPanel.add((Component)object2, (Object)gridBagConstraints);
        this._nameFilterCombo = new RmaJComboBox();
        this._nameFilterCombo.setEditable(true);
        ((JLabel)object).setLabelFor((Component)this._nameFilterCombo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object2).add((Component)this._nameFilterCombo, gridBagConstraints);
        this._ruleFilterCombo = new RmaJComboBox();
        this._ruleFilterCombo.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object2).add((Component)this._ruleFilterCombo, gridBagConstraints);
        this._ruleTypeFilterCombo = new RmaJComboBox();
        this._ruleTypeFilterCombo.setEditable(true);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        ((Container)object2).add((Component)this._ruleTypeFilterCombo, gridBagConstraints);
        object = new String[]{"Location", "Rule", "Rule Type"};
        YieldDemandRulePanel yieldDemandRulePanel2 = this;
        this._avalibleRulesTable = new YieldDemandRulePanel$1(yieldDemandRulePanel2, yieldDemandRulePanel2, (Object[])object);
        this._avalibleRulesTable.setEditable(false);
        this._avalibleRulesTable.setAddRemoveEnabled(false);
        this._avalibleRulesTable.setRowHeight(this._avalibleRulesTable.getRowHeight() + 5);
        this._avalibleRulesTable.setSelectionMode(0);
        this._avalibleRulesTable.setColumnSelectionAllowed(false);
        this._avalibleRulesTable.setCellSelectionEnabled(false);
        this._avalibleRulesTable.setRowSelectionAllowed(true);
        this._elementTableModel = (RmaTableModel)this._avalibleRulesTable.getModel();
        object = new TableRowSorter<RmaTableModel>(this._elementTableModel);
        this._avalibleRulesTable.setRowSorter((RowSorter)object);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.75;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._avalibleRulesTable.getScrollPane(), (Object)gridBagConstraints);
        this._selectButton = new JButton("Select");
        this._selectButton.setMnemonic('S');
        this._selectButton.setEnabled(false);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._selectButton, (Object)gridBagConstraints);
        object = new JLabel("Yield alternatives require their demand rule value(s) to be updated prior to each simulation recompute");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._contentPanel.add((Component)object, (Object)gridBagConstraints);
        int n = ClientApp.app().getClientUnitSystem();
        YieldDemandRulePanel yieldDemandRulePanel3 = this;
        this._selectedRulesTable = new YieldDemandRulePanel$2(yieldDemandRulePanel3, yieldDemandRulePanel3, new String[]{"Selected Demand Rule", "Tolerance (%S)"});
        this._selectedRulesTable.setColumnEnabled(true, 1);
        this._selectedRulesTable.setAddRemoveEnabled(false);
        this._selectedRulesTable.setSelectionMode(0);
        this._selectedRulesTable.setRowHeight(this._selectedRulesTable.getRowHeight() + 5);
        this._selectedRulesTable.setDoubleCellEditor(1);
        this._selectedRulesTable.setUnitsHeaderRenderer();
        object2 = new int[]{0, this._paramFlow};
        this._selectedRulesTable.setColumnParameters((int[])object2);
        this._selectedRulesTable.setDisplayUnitsSystem(n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._contentPanel.add((Component)this._selectedRulesTable.getScrollPane(), (Object)gridBagConstraints);
        this._deselectButton = new JButton("Deselect");
        this._deselectButton.setMnemonic('D');
        this._deselectButton.setEnabled(false);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._contentPanel.add((Component)this._deselectButton, (Object)gridBagConstraints);
        YieldDemandRulePanel yieldDemandRulePanel4 = this;
        this._resZoneTable = new YieldDemandRulePanel$3(yieldDemandRulePanel4, yieldDemandRulePanel4, new String[]{"Reservoir", "Operations Set", "Lower Limit \nof Con Pool", "Tolerance (%S)"});
        this._resZoneTable.setEditable(false);
        this._resZoneTable.setAddRemoveEnabled(false);
        this._resZoneTable.setRowHeight(this._resZoneTable.getRowHeight() + 5);
        this._resZoneTable.deleteCells();
        this._resZoneTable.setColumnEnabled(false, 0);
        this._resZoneTable.setColumnEnabled(false, 1);
        this._resZoneTable.setUnitsHeaderRenderer();
        this._resZoneTable.setDoubleCellEditor(3);
        object2 = new int[]{0, 0, 0, Parameter.PARAMID_STOR};
        this._resZoneTable.setColumnParameters((int[])object2);
        this._resZoneTable.setDisplayUnitsSystem(n);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._contentPanel.add((Component)this._resZoneTable.getScrollPane(), (Object)gridBagConstraints);
    }

    protected void addListeners() {
        this._waterSupplyRulesRadio.addItemListener((ItemListener)new YieldDemandRulePanel$4(this));
        this._hydropowerRulesRadio.addItemListener((ItemListener)new YieldDemandRulePanel$5(this));
        this._selectButton.addActionListener(new YieldDemandRulePanel$6(this));
        this._deselectButton.addActionListener(new YieldDemandRulePanel$7(this));
        this._avalibleRulesTable.getSelectionModel().addListSelectionListener(new YieldDemandRulePanel$8(this));
        this._selectedRulesTable.getSelectionModel().addListSelectionListener(new YieldDemandRulePanel$9(this));
        YieldDemandRulePanel$10 yieldDemandRulePanel$10 = new YieldDemandRulePanel$10(this);
        YieldDemandRulePanel$11 yieldDemandRulePanel$11 = new YieldDemandRulePanel$11(this);
        YieldDemandRulePanel$12 yieldDemandRulePanel$12 = new YieldDemandRulePanel$12(this);
        this._nameFilterCombo.getActionMap().put("filter", yieldDemandRulePanel$11);
        this._nameFilterCombo.getEditor().getEditorComponent().addKeyListener(yieldDemandRulePanel$12);
        this._ruleFilterCombo.getActionMap().put("filter", yieldDemandRulePanel$11);
        this._ruleFilterCombo.getEditor().getEditorComponent().addKeyListener(yieldDemandRulePanel$12);
        this._ruleTypeFilterCombo.getActionMap().put("filter", yieldDemandRulePanel$11);
        this._ruleTypeFilterCombo.getEditor().getEditorComponent().addKeyListener(yieldDemandRulePanel$12);
        this._al = new YieldDemandRulePanel$13(this);
        this._il = new YieldDemandRulePanel$14(this);
        this._nameFilterCombo.addFocusListener((FocusListener)yieldDemandRulePanel$10);
        this._ruleFilterCombo.addFocusListener((FocusListener)yieldDemandRulePanel$10);
        this._ruleTypeFilterCombo.addFocusListener((FocusListener)yieldDemandRulePanel$10);
        this._nameFilterCombo.addActionListener(this._al);
        this._ruleFilterCombo.addActionListener(this._al);
        this._ruleTypeFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._ruleFilterCombo.addItemListener(this._il);
        this._ruleTypeFilterCombo.addItemListener(this._il);
    }

    private void ruleTypeRadioAction() {
        int[] nArray = new int[]{0, this._paramFlow};
        if (this._hydropowerRulesRadio.isSelected()) {
            nArray[1] = this._paramPower;
        }
        this._selectedRulesTable.setColumnParameters(nArray);
        this._selectedRulesTable.setDisplayUnitsSystem(this._alternative.getUnitSystem());
        this.fillTable();
    }

    void filterTable(Object object) {
        WildcardRowFilter wildcardRowFilter = null;
        Object object2 = null;
        Object object3 = null;
        if (object == this._nameFilterCombo) {
            object = this._nameFilterCombo.getSelectedItem();
            if (object != null) {
                wildcardRowFilter = object.toString();
            }
            object2 = (String)this._ruleFilterCombo.getSelectedItem();
            object3 = (String)this._ruleTypeFilterCombo.getSelectedItem();
        } else if (object == this._ruleFilterCombo) {
            object = this._ruleFilterCombo.getSelectedItem();
            if (object != null) {
                object2 = object.toString();
            }
            object3 = (String)this._ruleTypeFilterCombo.getSelectedItem();
            wildcardRowFilter = (String)this._nameFilterCombo.getSelectedItem();
        } else if (object == this._ruleTypeFilterCombo) {
            object = this._ruleTypeFilterCombo.getSelectedItem();
            if (object != null) {
                object3 = object.toString();
            }
            wildcardRowFilter = (String)this._nameFilterCombo.getSelectedItem();
            object2 = (String)this._ruleFilterCombo.getSelectedItem();
        } else {
            object3 = (String)this._ruleTypeFilterCombo.getEditor().getItem();
            wildcardRowFilter = (String)this._nameFilterCombo.getEditor().getItem();
            object2 = (String)this._ruleFilterCombo.getEditor().getItem();
        }
        if (wildcardRowFilter != null && !wildcardRowFilter.endsWith("*")) {
            wildcardRowFilter = (String)wildcardRowFilter + "*";
        }
        if (object2 != null && !((String)object2).endsWith("*")) {
            object2 = (String)object2 + "*";
        }
        if (object3 != null && !((String)object3).endsWith("*")) {
            object3 = (String)object3 + "*";
        }
        object = new ArrayList<WildcardRowFilter>(3);
        if (wildcardRowFilter != null && wildcardRowFilter.length() > 0) {
            wildcardRowFilter = new WildcardRowFilter((String)wildcardRowFilter, 0);
            object.add(wildcardRowFilter);
        }
        if (object2 != null && ((String)object2).length() > 0) {
            wildcardRowFilter = new WildcardRowFilter((String)object2, 1);
            object.add(wildcardRowFilter);
        }
        if (object3 != null && ((String)object3).length() > 0) {
            wildcardRowFilter = new WildcardRowFilter((String)object3, 2);
            object.add(wildcardRowFilter);
        }
        if (object.size() > 0) {
            wildcardRowFilter = RowFilter.andFilter(object);
            ((TableRowSorter)this._avalibleRulesTable.getRowSorter()).setRowFilter(wildcardRowFilter);
            return;
        }
        ((TableRowSorter)this._avalibleRulesTable.getRowSorter()).setRowFilter(null);
    }

    protected void updateSelectButtonStateAction() {
        int n = this._avalibleRulesTable.getSelectedRow();
        this._selectButton.setEnabled(n >= 0);
    }

    protected void updateDeselectButtonStateAction() {
        int n = this._selectedRulesTable.getSelectedRow();
        this._deselectButton.setEnabled(n >= 0);
    }

    protected void selectLocationAction() {
        YieldAnalysisRuleRef yieldAnalysisRuleRef;
        int n = this._avalibleRulesTable.getSelectedRow();
        if ((n = this._avalibleRulesTable.convertRowIndexToModel(n)) >= 0 && (yieldAnalysisRuleRef = (YieldAnalysisRuleRef)this._elementTableModel.getValueAt(n, 0)) != null) {
            if (this._ruleRefList == null) {
                this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
            }
            if (this._ruleRefList.contains(yieldAnalysisRuleRef)) {
                return;
            }
            this._ruleRefList.add(yieldAnalysisRuleRef);
            YieldDemandRulePanel yieldDemandRulePanel = this;
            yieldDemandRulePanel.updateRuleTable(yieldDemandRulePanel._ruleRefList);
        }
    }

    protected void deselectLocationAction() {
        YieldAnalysisRuleRef yieldAnalysisRuleRef;
        int n = this._selectedRulesTable.getSelectedRow();
        if (n >= 0 && (yieldAnalysisRuleRef = this._ruleRefList.get(n)) != null) {
            if (this._ruleRefList == null) {
                this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
            }
            if (this._ruleRefList.contains(yieldAnalysisRuleRef)) {
                this._ruleRefList.remove(yieldAnalysisRuleRef);
            }
            this._selectedRulesTable.deleteRow(n);
            this.reservoirTableDeselect(yieldAnalysisRuleRef);
        }
    }

    private void reservoirTableDeselect(YieldAnalysisRuleRef yieldAnalysisRuleRef) {
        int n;
        this._reservoirList = new ArrayList<ReservoirElement>();
        List<ReservoirElement> list = yieldAnalysisRuleRef.getReservoirList(this._alternative);
        if (list.size() == 0 && this._ruleRefList.size() == 0) {
            this._resZoneTable.deleteCells();
        }
        boolean[] blArray = new boolean[list.size()];
        for (n = 0; n < this._ruleRefList.size(); ++n) {
            RssReturnStatusConstants rssReturnStatusConstants = this._ruleRefList.get(n);
            if (rssReturnStatusConstants == null) continue;
            List<ReservoirElement> list2 = rssReturnStatusConstants.getReservoirList(this._alternative);
            block1: for (int i = 0; i < list2.size(); ++i) {
                ReservoirElement reservoirElement = list2.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    rssReturnStatusConstants = list.get(j);
                    if (rssReturnStatusConstants.equals(reservoirElement)) {
                        blArray[j] = true;
                        continue block1;
                    }
                    blArray[j] = false;
                }
            }
        }
        for (n = 0; n < list.size(); ++n) {
            if (blArray[n]) continue;
            this._reservoirList.remove(list.get(n));
            for (int i = 0; i < this._resZoneTable.getRowCount(); ++i) {
                if (!this._resZoneTable.getCell(i, 0).equals(list.get(n))) continue;
                this._resZoneTable.deleteRow(i);
            }
        }
        this._ruleRefList.remove(yieldAnalysisRuleRef);
    }

    private void updateRuleTable(List<YieldAnalysisRuleRef> list) {
        for (int i = 0; i < list.size(); ++i) {
            boolean bl = false;
            YieldAnalysisRuleRef yieldAnalysisRuleRef = list.get(i);
            for (int j = 0; j < this._selectedRulesTable.getRowCount(); ++j) {
                String string = (String)this._selectedRulesTable.getCell(j, 0);
                if (!string.equals(yieldAnalysisRuleRef.getLocationName() + " - " + yieldAnalysisRuleRef.getRuleName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Vector<CallSite> vector = new Vector<CallSite>();
            vector.add((CallSite)((Object)(yieldAnalysisRuleRef.getLocationName() + " - " + yieldAnalysisRuleRef.getRuleName())));
            ParamDouble paramDouble = this._hydropowerRulesRadio.isSelected() ? new ParamDouble(yieldAnalysisRuleRef.getTolerance(), this._paramPower, this._alternative.getUnitSystem()) : new ParamDouble(yieldAnalysisRuleRef.getTolerance(), this._paramFlow, this._alternative.getUnitSystem());
            vector.add((CallSite)paramDouble);
            this._selectedRulesTable.appendRow(vector);
            YieldDemandRulePanel yieldDemandRulePanel = this;
            yieldDemandRulePanel.updateReservoirTable(yieldDemandRulePanel._ruleRefList);
        }
    }

    public void fillPanel(ReservoirYieldAnalysis reservoirYieldAnalysis, RssAlt rssAlt) {
        if (rssAlt == null) {
            return;
        }
        this._alternative = rssAlt;
        if (reservoirYieldAnalysis == null) {
            this._waterSupplyRulesRadio.setSelected(true);
            this.fillTable();
            this._selectedRulesTable.deleteCells();
            return;
        }
        List<YieldAnalysisRuleRef> list = reservoirYieldAnalysis.getYieldAnalysisRuleRefs();
        for (int i = 0; i < list.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = list.get(i);
            if (yieldAnalysisRuleRef.isInitialized()) continue;
            yieldAnalysisRuleRef.initializeData(rssAlt.getSystem());
        }
        if (reservoirYieldAnalysis.useHydropowerRules()) {
            this._hydropowerRulesRadio.setSelected(true);
        } else {
            this._waterSupplyRulesRadio.setSelected(true);
        }
        this.fillTable();
        if (list != null && list.size() > 0) {
            this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
            this.updateSelectedTable(list);
            this.updateReservoirTable(list);
        } else {
            this.updateSelectedTable(null);
        }
        EventQueue.invokeLater(new YieldDemandRulePanel$15(this));
    }

    private void updateSelectedTable(List<YieldAnalysisRuleRef> list) {
        this._selectedRulesTable.deleteCells();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            YieldAnalysisRuleRef yieldAnalysisRuleRef = list.get(i);
            Vector<CallSite> vector = new Vector<CallSite>(3);
            vector.add((CallSite)((Object)(yieldAnalysisRuleRef.getLocationName() + " - " + yieldAnalysisRuleRef.getRuleName())));
            if (this._hydropowerRulesRadio.isSelected()) {
                vector.add((CallSite)new ParamDouble(yieldAnalysisRuleRef.getTolerance(), this._paramPower, this._alternative.getUnitSystem()));
            } else {
                vector.add((CallSite)new ParamDouble(yieldAnalysisRuleRef.getTolerance(), this._paramFlow, this._alternative.getUnitSystem()));
            }
            this._selectedRulesTable.appendRow(vector);
            if (this._ruleRefList == null) {
                this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
            }
            this._ruleRefList.add(yieldAnalysisRuleRef);
        }
    }

    private void updateReservoirTable(List<YieldAnalysisRuleRef> list) {
        this._resZoneTable.clear();
        for (int i = 0; i < list.size(); ++i) {
            Vector vector;
            OpSet opSet;
            ReservoirElement reservoirElement;
            YieldAnalysisRuleRef yieldAnalysisRuleRef = list.get(i);
            if (yieldAnalysisRuleRef == null) continue;
            List<StorageZoneRef> list2 = yieldAnalysisRuleRef.getZones();
            if (list2 != null && list2.size() > 0) {
                StorageZoneRef storageZoneRef;
                for (int j = 0; j < list2.size() && !this._reservoirList.contains(reservoirElement = (storageZoneRef = list2.get(j)).getStorageZone().getReservoirElement()); ++j) {
                    int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
                    opSet = reservoirElement.getReservoirOp().getOperationSet(n);
                    if (opSet == null) continue;
                    Vector<Object> vector2 = new Vector<Object>(4);
                    vector2.add(reservoirElement);
                    vector2.add(opSet);
                    vector = opSet.getZoneVector();
                    vector2.add(storageZoneRef.getStorageZone());
                    vector2.add(new ParamDouble(storageZoneRef.getTolerance(), Parameter.PARAMID_STOR, this._alternative.getUnitSystem()));
                    this._resZoneTable.appendRow(vector2);
                    this._resZoneTable.setComboBoxRowEditor(this._resZoneTable.getRowCount() - 1, 2, vector);
                    this._reservoirList.add(reservoirElement);
                }
                continue;
            }
            List<ReservoirElement> list3 = yieldAnalysisRuleRef.getReservoirList(this._alternative);
            for (int j = 0; j < list3.size() && !this._reservoirList.contains(reservoirElement = list3.get(j)); ++j) {
                int n = this._alternative.getResOpSetSelection(reservoirElement.getIndex());
                opSet = reservoirElement.getReservoirOp().getOperationSet(n);
                if (opSet == null) continue;
                Vector<Object> vector3 = new Vector<Object>(4);
                vector3.add(reservoirElement);
                vector3.add(opSet);
                vector = opSet.getZoneVector();
                OpSet opSet2 = opSet;
                vector3.add(opSet2.getZone(opSet2.getInactiveZoneIndex()));
                vector3.add(new ParamDouble(1000.0, Parameter.PARAMID_STOR, this._alternative.getUnitSystem()));
                this._resZoneTable.appendRow(vector3);
                this._resZoneTable.setComboBoxRowEditor(this._resZoneTable.getRowCount() - 1, 2, vector);
                this._reservoirList.add(reservoirElement);
            }
        }
    }

    public void fillTable() {
        Object object;
        this._avalibleRulesTable.deleteCells();
        List<YieldAnalysisRuleRef> list = this._waterSupplyRulesRadio.isSelected() ? this._alternative.getYieldAnalysisWaterSupplyRules() : this._alternative.getYieldAnalysisHydropowerRules();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            Vector<Object> vector = new Vector<Object>(3);
            vector.add(object);
            vector.add(((YieldAnalysisRuleRef)object).getRuleName());
            vector.add(((YieldAnalysisRuleRef)object).getRuleTypeString());
            this._avalibleRulesTable.appendRow(vector);
        }
        String string = (String)this._nameFilterCombo.getSelectedItem();
        if (string == null) {
            string = "";
        }
        if ((list = (String)this._ruleFilterCombo.getSelectedItem()) == null) {
            list = "";
        }
        object = (String)this._ruleTypeFilterCombo.getSelectedItem();
        if (list == null) {
            object = "";
        }
        this.fillCombos(string, (String)((Object)list), (String)object);
    }

    private void fillCombos(String string, String string2, String string3) {
        this.getFilterString(string);
        this.getFilterString(string2);
        this.getFilterString(string3);
        RmaListModel rmaListModel = new RmaListModel(false);
        rmaListModel.addElement((Object)"");
        RmaListModel rmaListModel2 = new RmaListModel(false);
        rmaListModel2.addElement((Object)"");
        RmaListModel rmaListModel3 = new RmaListModel(false);
        rmaListModel3.addElement((Object)"");
        int n = this._avalibleRulesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = (YieldAnalysisRuleRef)this._avalibleRulesTable.getValueAt(i, 0);
            if (object == null) continue;
            String string4 = ((YieldAnalysisRuleRef)object).getLocationName();
            String string5 = ((YieldAnalysisRuleRef)object).getRuleName();
            object = ((YieldAnalysisRuleRef)object).getRuleTypeString();
            this.addToList(rmaListModel3, (String)object);
            this.addToList(rmaListModel, string4);
            this.addToList(rmaListModel2, string5);
        }
        this._nameFilterCombo.removeActionListener(this._al);
        this._ruleFilterCombo.removeActionListener(this._al);
        this._ruleTypeFilterCombo.removeActionListener(this._al);
        this._nameFilterCombo.removeItemListener(this._il);
        this._ruleFilterCombo.removeItemListener(this._il);
        this._ruleTypeFilterCombo.removeItemListener(this._il);
        this._nameFilterCombo.setModel((ComboBoxModel)rmaListModel);
        this._ruleFilterCombo.setModel((ComboBoxModel)rmaListModel2);
        this._ruleTypeFilterCombo.setModel((ComboBoxModel)rmaListModel3);
        this._nameFilterCombo.setSelectedItem((Object)string);
        this._ruleFilterCombo.setSelectedItem((Object)string2);
        this._ruleTypeFilterCombo.setSelectedItem((Object)string3);
        this._nameFilterCombo.addActionListener(this._al);
        this._ruleFilterCombo.addActionListener(this._al);
        this._ruleTypeFilterCombo.addActionListener(this._al);
        this._nameFilterCombo.addItemListener(this._il);
        this._ruleFilterCombo.addItemListener(this._il);
        this._ruleTypeFilterCombo.addItemListener(this._il);
    }

    private boolean passesFilter(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2);
    }

    private void addToList(RmaListModel rmaListModel, String string) {
        if (!rmaListModel.contains((Object)string)) {
            rmaListModel.addElement((Object)string);
        }
    }

    private String getFilterString(String string) {
        if (string != null) {
            return string.toLowerCase();
        }
        return "";
    }

    public YieldAnalysis savePanel(YieldAnalysis yieldAnalysis) {
        Cloneable cloneable;
        int n = this._resZoneTable.getRowCount();
        HashMap<ReservoirElement, Cloneable> hashMap = new HashMap<ReservoirElement, Cloneable>();
        this._resZoneTable.commitEdit(true);
        for (int i = 0; i < n; ++i) {
            if (!(this._resZoneTable.getValueAt(i, 2) instanceof StorageZone)) continue;
            cloneable = new StorageZoneRef((StorageZone)this._resZoneTable.getValueAt(i, 2));
            ((StorageZoneRef)cloneable).setTolerance(((ParamDouble)this._resZoneTable.getValueAt(i, 3)).getValue());
            if (hashMap.containsKey(((StorageZoneRef)cloneable).getStorageZone().getReservoirElement())) continue;
            hashMap.put(((StorageZoneRef)cloneable).getStorageZone().getReservoirElement(), cloneable);
        }
        ArrayList<YieldAnalysisRuleRef> arrayList = new ArrayList<YieldAnalysisRuleRef>();
        this._selectedRulesTable.commitEdit(true);
        n = this._selectedRulesTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            cloneable = this._ruleRefList.get(i);
            ((YieldAnalysisRuleRef)cloneable).setTolerence(((ParamDouble)this._selectedRulesTable.getValueAt(i, 1)).getValue());
            ArrayList<StorageZoneRef> arrayList2 = new ArrayList<StorageZoneRef>();
            if (arrayList.contains(cloneable)) continue;
            List<ReservoirElement> list = ((YieldAnalysisRuleRef)cloneable).getReservoirList(this._alternative);
            for (int j = 0; j < list.size(); ++j) {
                if (!hashMap.containsKey(list.get(j))) continue;
                arrayList2.add((StorageZoneRef)hashMap.get(list.get(j)));
            }
            ((YieldAnalysisRuleRef)cloneable).setZones(arrayList2);
            arrayList.add((YieldAnalysisRuleRef)cloneable);
        }
        yieldAnalysis.setRuleRefs(arrayList);
        yieldAnalysis.setUseHydropowerRules(this._hydropowerRulesRadio.isSelected());
        return yieldAnalysis;
    }

    public void clearPanel() {
        this._avalibleRulesTable.deleteCells();
        this._resZoneTable.deleteCells();
        this._selectedRulesTable.deleteCells();
        this._reservoirList = new ArrayList<ReservoirElement>();
        this._ruleRefList = new ArrayList<YieldAnalysisRuleRef>();
        this.repaint();
    }

    public void updateReservoirZones(ReservoirElement reservoirElement, OpSet opSet) {
        if (reservoirElement == null) {
            return;
        }
        for (int i = 0; i < this._resZoneTable.getRowCount(); ++i) {
            Object object = (ReservoirElement)this._resZoneTable.getValueAt(i, 0);
            if (object != reservoirElement || (object = (OpSet)this._resZoneTable.getValueAt(i, 1)) == opSet) continue;
            StorageZone storageZone = (StorageZone)this._resZoneTable.getValueAt(i, 2);
            this._resZoneTable.setValueAt((Object)opSet, i, 1);
            if (opSet == null) {
                this._resZoneTable.setComboBoxRowEditor(i, 2, new Vector(0));
                this._resZoneTable.setValueAt(null, i, 2);
                return;
            }
            object = opSet.getZoneVector();
            this._resZoneTable.setComboBoxRowEditor(i, 2, (Vector)object);
            if (storageZone != null) {
                String string = storageZone.getName();
                for (int j = 0; j < ((Vector)object).size(); ++j) {
                    storageZone = (StorageZone)((Vector)object).get(j);
                    if (!string.equals(storageZone.getName())) continue;
                    this._resZoneTable.setValueAt((Object)storageZone, i, 2);
                    return;
                }
                this._resZoneTable.setValueAt((Object)opSet.getInactiveZone(), i, 2);
                continue;
            }
            this._resZoneTable.setValueAt((Object)opSet.getInactiveZone(), i, 2);
        }
    }
}

