/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.datum;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.rss.client.RSS;
import hec.rss.client.datum.VerticalDatumPanel$1;
import hec.rss.client.datum.VerticalDatumPanel$2;
import hec.rss.client.datum.VerticalDatumPanel$ModifiedListener;
import hec.rss.model.VerticalDatumSettings;
import hec.rss.model.VerticalDatumType;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJLabel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTextField;

public class VerticalDatumPanel
extends JPanel {
    RmaJRadioButton mUnspecifiedRadioButton;
    RmaJRadioButton mNAVD88RadioButton;
    RmaJRadioButton mNGVD29RadioButton;
    RmaJRadioButton mLocalRadioButton;
    RmaJTextField mLocalDatumNameText;
    RmaJDecimalField mNGVD29ShiftToNAVD88Text;
    RmaJDecimalField mLocalShiftToNAVD88Text;

    public VerticalDatumPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    private void buildControls() {
        Object object = new GridBagConstraints();
        Object object2 = new JPanel(new GridBagLayout());
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = new Insets(0, 0, 0, 0);
        this.add((Component)object2, object);
        this.mUnspecifiedRadioButton = new RmaJRadioButton("Unspecified");
        this.mUnspecifiedRadioButton.setMargin(RmaInsets.INSETS0000);
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        ((Container)object2).add((Component)this.mUnspecifiedRadioButton, object);
        this.mNAVD88RadioButton = new RmaJRadioButton("NAVD88");
        this.mNAVD88RadioButton.setMargin(RmaInsets.INSETS0000);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        ((Container)object2).add((Component)this.mNAVD88RadioButton, object);
        this.mNGVD29RadioButton = new RmaJRadioButton("NGVD29");
        this.mNGVD29RadioButton.setMargin(RmaInsets.INSETS0000);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 2;
        ((GridBagConstraints)object).gridwidth = 2;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        ((Container)object2).add((Component)this.mNGVD29RadioButton, object);
        JPanel jPanel = new JPanel(new GridBagLayout());
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 3;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = RmaInsets.INSETS0000;
        ((Container)object2).add((Component)jPanel, object);
        object2 = "Enter a name for the local datum, e.g., MSL or Local";
        this.mLocalRadioButton = new RmaJRadioButton("Local");
        this.mLocalRadioButton.setToolTipText((String)object2);
        this.mLocalRadioButton.setMargin(RmaInsets.INSETS0000);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)this.mLocalRadioButton, object);
        this.mLocalDatumNameText = new RmaJTextField();
        this.mLocalDatumNameText.setToolTipText((String)object2);
        object = this.mLocalDatumNameText.getDocument();
        VerticalDatumPanel verticalDatumPanel = this;
        object.addDocumentListener(new VerticalDatumPanel$ModifiedListener(verticalDatumPanel, (Component)verticalDatumPanel.mLocalDatumNameText));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)this.mLocalDatumNameText, object);
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder("Datum Conversions"));
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = new Insets(5, 0, 0, 0);
        this.add((Component)object2, object);
        jPanel = new RmaJLabel("NGVD29 to NAVD88  (%S):");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 0);
        ((Container)object2).add((Component)jPanel, object);
        this.mNGVD29ShiftToNAVD88Text = new RmaJDecimalField();
        this.mNGVD29ShiftToNAVD88Text.setToolTipText("This value is needed in order to convert NGV2D29 to NAVD88.");
        ((JLabel)((Object)jPanel)).setLabelFor((Component)this.mNGVD29ShiftToNAVD88Text);
        object = this.mNGVD29ShiftToNAVD88Text.getPreferredSize();
        this.mNGVD29ShiftToNAVD88Text.getPreferredSize().width = 50;
        this.mNGVD29ShiftToNAVD88Text.setMinimumSize((Dimension)object);
        this.mNGVD29ShiftToNAVD88Text.setPreferredSize((Dimension)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        ((Container)object2).add((Component)this.mNGVD29ShiftToNAVD88Text, object);
        jPanel = new RmaJLabel("Local to NAVD88 (%S):");
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 0);
        ((Container)object2).add((Component)jPanel, object);
        this.mLocalShiftToNAVD88Text = new RmaJDecimalField();
        ((JLabel)((Object)jPanel)).setLabelFor((Component)this.mLocalShiftToNAVD88Text);
        object = this.mLocalShiftToNAVD88Text.getPreferredSize();
        this.mLocalShiftToNAVD88Text.getPreferredSize().width = 50;
        this.mLocalShiftToNAVD88Text.setMinimumSize((Dimension)object);
        this.mLocalShiftToNAVD88Text.setPreferredSize((Dimension)object);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        ((GridBagConstraints)object).gridy = 1;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).anchor = 17;
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 0, 5);
        ((Container)object2).add((Component)this.mLocalShiftToNAVD88Text, object);
        object = new ButtonGroup();
        ((ButtonGroup)object).add((AbstractButton)this.mLocalRadioButton);
        ((ButtonGroup)object).add((AbstractButton)this.mNAVD88RadioButton);
        ((ButtonGroup)object).add((AbstractButton)this.mNGVD29RadioButton);
        ((ButtonGroup)object).add((AbstractButton)this.mUnspecifiedRadioButton);
        this.mLocalRadioButton.getModel().addChangeListener(changeEvent -> {
            VerticalDatumPanel verticalDatumPanel = this;
            verticalDatumPanel.setLocalDatumState(verticalDatumPanel.mLocalRadioButton.isSelected());
        });
        this.mUnspecifiedRadioButton.setSelected(true);
        this.mNGVD29RadioButton.setSelected(false);
        this.mNAVD88RadioButton.setSelected(false);
        this.mLocalRadioButton.setSelected(false);
        VerticalDatumPanel verticalDatumPanel2 = this;
        verticalDatumPanel2.setLocalDatumState(verticalDatumPanel2.mLocalRadioButton.isSelected());
    }

    private void setLocalDatumState(boolean bl) {
        this.mLocalShiftToNAVD88Text.setEditable(bl);
        this.mLocalShiftToNAVD88Text.setEnabled(bl);
        this.mLocalDatumNameText.setEditable(bl);
        this.mLocalDatumNameText.setEnabled(bl);
    }

    private void setNGV29DatamState(boolean bl) {
        this.mNGVD29ShiftToNAVD88Text.setEditable(bl);
        this.mNGVD29ShiftToNAVD88Text.setEnabled(bl);
    }

    public void fillPanel(VerticalDatumSettings object) {
        this.mLocalDatumNameText.setText(((VerticalDatumSettings)object).getLocalName());
        int n = RSS.Workspace().getUnitSystem();
        double d = ((VerticalDatumSettings)object).getLocalShiftToNAVD88();
        ParamDouble paramDouble = new ParamDouble(d, Parameter.PARAMID_ELEV, n);
        this.mLocalShiftToNAVD88Text.setValue(paramDouble);
        double d2 = ((VerticalDatumSettings)object).getNGVDShiftToNAVD88();
        ParamDouble paramDouble2 = new ParamDouble(d2, Parameter.PARAMID_ELEV, n);
        this.mNGVD29ShiftToNAVD88Text.setValue(paramDouble2);
        object = ((VerticalDatumSettings)object).getType();
        if (object != null) {
            switch (VerticalDatumPanel$2.a[((Enum)object).ordinal()]) {
                case 1: {
                    this.mNAVD88RadioButton.setSelected(true);
                    return;
                }
                case 2: {
                    this.mNGVD29RadioButton.setSelected(true);
                    return;
                }
                case 3: {
                    this.mLocalRadioButton.setSelected(true);
                    return;
                }
                case 4: {
                    this.mUnspecifiedRadioButton.setSelected(true);
                }
            }
        }
    }

    public VerticalDatumSettings savePanel() {
        VerticalDatumSettings verticalDatumSettings = new VerticalDatumSettings();
        String string = this.mLocalDatumNameText.getText();
        verticalDatumSettings.setLocalName(string == null || string.isEmpty() ? "Local" : string);
        string = this.mLocalShiftToNAVD88Text.getParamValue();
        verticalDatumSettings.setLocalShiftToNAVD88(string.getValue());
        string = this.mNGVD29ShiftToNAVD88Text.getParamValue();
        verticalDatumSettings.setNGVDShiftToNAVD88(string.getValue());
        if (this.mNAVD88RadioButton.isSelected()) {
            verticalDatumSettings.setType(VerticalDatumType.NAVD88);
        } else if (this.mNGVD29RadioButton.isSelected()) {
            verticalDatumSettings.setType(VerticalDatumType.NGVD29);
        } else if (this.mLocalRadioButton.isSelected()) {
            verticalDatumSettings.setType(VerticalDatumType.LOCAL);
        } else if (this.mUnspecifiedRadioButton.isSelected()) {
            verticalDatumSettings.setType(VerticalDatumType.UNSPECIFIED);
        }
        return verticalDatumSettings;
    }

    public static void a(String[] stringArray) {
        SwingUtilities.invokeLater(new VerticalDatumPanel$1());
    }
}

