/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.diversion;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.gui.NameDescriptionPanel;
import hec.rss.client.DiversionRulePanel;
import hec.rss.client.RuleDlg;
import hec.rss.client.diversion.ConstantReleasePanel;
import hec.rss.client.diversion.DiversionDemandPanel$1;
import hec.rss.client.diversion.DiversionPanel;
import hec.rss.client.diversion.FlowPanel;
import hec.rss.client.diversion.MinMaxPanel;
import hec.rss.client.diversion.MonthlyReleasePanel;
import hec.rss.client.diversion.PoolPanel;
import hec.rss.client.diversion.SpecifiedReleasePanel;
import hec.rss.client.diversion.TimeSeriesPanel;
import hec.rss.model.ConstantRelease;
import hec.rss.model.Controller;
import hec.rss.model.DiversionConstants;
import hec.rss.model.DiversionDemandOpRule;
import hec.rss.model.DiversionElement;
import hec.rss.model.DiversionRule;
import hec.rss.model.Element;
import hec.rss.model.FlowFunction;
import hec.rss.model.MinMax;
import hec.rss.model.MonthlyRelease;
import hec.rss.model.OpRuleRef;
import hec.rss.model.Operations;
import hec.rss.model.PoolElevation;
import hec.rss.model.Rule;
import hec.rss.model.RuleFactory;
import hec.rss.model.SpecifiedRelease;
import hec.rss.model.TimeSeries;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.util.RMAIO;

public class DiversionDemandPanel
extends DefaultJPanel
implements DiversionConstants {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private static final String[] b = new String[]{"Minimum", "Maximum", "Specified"};
    private DiversionElement _diversion;
    private NameDescriptionPanel _nameDescPanel;
    private Vector<String> _rules = new Vector();
    private RmaJComboBox<String> _opsMthdCombo;
    private JPanel _cardPanel;
    private Operations _operations;
    private Controller _control = null;
    private Vector<String> _ruleListVector = new Vector(10);
    private RuleDlg _ruleDlg;
    private Hashtable<String, Rule> _ruleHTable = new Hashtable(10);
    JPanel _emptyPanel;
    private ConstantReleasePanel _constantPanel;
    private MonthlyReleasePanel _monthlyPanel;
    private SpecifiedReleasePanel _seasonalPanel;
    private FlowPanel _flowPanel;
    private PoolPanel _poolPanel;
    private TimeSeriesPanel _timeSeriesPanel;
    private MinMaxPanel _minMaxPanel;
    private DiversionRulePanel _diversionRulePanel = new DiversionRulePanel();
    protected boolean _fillingForm;
    private String _modelName;
    private DiversionDemandOpRule _opRule;
    private RmaJComboBox<String> _limitTypeCombo;

    public DiversionDemandPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        this._nameDescPanel = new NameDescriptionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5000;
        DiversionDemandPanel diversionDemandPanel = this;
        diversionDemandPanel.add((Component)diversionDemandPanel._nameDescPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5050;
        this.add(jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel("Demand Specified As:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._rules.add("Constant");
        this._rules.add("Monthly Varying");
        this._rules.add("Seasonal");
        this._rules.add("Function of Flow");
        this._rules.add("Function of Pool Elevation");
        this._rules.add("Time-Series");
        this._rules.add("Flexible Diversion Rule");
        this._opsMthdCombo = new RmaJComboBox(this._rules);
        jLabel.setLabelFor((Component)this._opsMthdCombo);
        this._opsMthdCombo.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._opsMthdCombo, gridBagConstraints);
        jLabel = new JLabel("Limit Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._limitTypeCombo = new RmaJComboBox((Object[])b);
        jLabel.setLabelFor((Component)this._limitTypeCombo);
        this._limitTypeCombo.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        jPanel.add((Component)this._limitTypeCombo, gridBagConstraints);
        this._cardPanel = new JPanel(new CardLayout());
        this._cardPanel.setBorder(new BevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        DiversionDemandPanel diversionDemandPanel2 = this;
        diversionDemandPanel2.add(diversionDemandPanel2._cardPanel, gridBagConstraints);
        this._emptyPanel = this.buildEmptyPanel();
        this._constantPanel = new ConstantReleasePanel();
        this._monthlyPanel = new MonthlyReleasePanel();
        this._seasonalPanel = new SpecifiedReleasePanel();
        this._flowPanel = new FlowPanel();
        this._poolPanel = new PoolPanel();
        this._timeSeriesPanel = new TimeSeriesPanel();
        this._minMaxPanel = new MinMaxPanel();
        this._cardPanel.add("empty", this._emptyPanel);
        this._cardPanel.add("Constant", this._constantPanel);
        this._cardPanel.add("Monthly Varying", this._monthlyPanel);
        this._cardPanel.add("Seasonal", this._seasonalPanel);
        this._cardPanel.add("Function of Flow", this._flowPanel);
        this._cardPanel.add("Function of Pool Elevation", this._poolPanel);
        this._cardPanel.add("Time-Series", this._timeSeriesPanel);
        this._cardPanel.add("MinMax", this._minMaxPanel);
        this._cardPanel.add("Flexible Diversion Rule", (Component)((Object)this._diversionRulePanel));
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "Constant");
    }

    protected void addListeners() {
        this._opsMthdCombo.addItemListener((ItemListener)new DiversionDemandPanel$1(this));
    }

    JPanel buildEmptyPanel() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    public void clearPanel() {
        this._ruleListVector.removeAllElements();
        this._ruleHTable.clear();
    }

    public void fillForm(DiversionElement object) {
        this.clearPanel();
        if (object == null) {
            return;
        }
        this._poolPanel.setSystem(((Element)object).getSystem());
        this._diversion = object;
        this._control = this._operations == null ? this._diversion.getController() : this._operations.getController(this._diversion.getControllerName());
        if (this._control == null && this._operations != null) {
            this._control = this._operations.createController(this._diversion.getControlElement(), this._diversion);
        }
        if (this._control == null) {
            return;
        }
        object = this._control.getRuleVector();
        if (((Vector)object).size() <= 0) {
            this._opsMthdCombo.setSelectedIndex(0);
            if (this._ruleHTable.size() == 0) {
                this.addRule("Constant");
            }
        } else if (this._rules.contains((object = (Rule)((Vector)object).elementAt(0)).getName())) {
            this._fillingForm = true;
            this._ruleListVector.addElement(object.getName());
            this._ruleHTable.put(object.getName(), (Rule)object);
            this.fillPanel((Rule)object);
            this._opsMthdCombo.setSelectedItem((Object)this._ruleListVector.elementAt(0));
        } else {
            ((FluentLogger.Api)a.atInfo()).log("fillForm: unknown rule type %s", (Object)object.getName());
            this._opsMthdCombo.setSelectedIndex(0);
        }
        this._fillingForm = false;
    }

    private void fillPanel(DiversionRule diversionRule) {
    }

    private void fillPanel(Rule rule) {
        if (rule == null) {
            this._opsMthdCombo.setSelectedIndex(-1);
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "empty");
            return;
        }
        this._opsMthdCombo.setSelectedItem((Object)rule.getRuleType());
        if (rule instanceof ConstantRelease) {
            this._constantPanel.fillPanel((ConstantRelease)rule);
        } else if (rule instanceof MonthlyRelease) {
            this._monthlyPanel.fillPanel((MonthlyRelease)rule);
        } else if (rule instanceof SpecifiedRelease) {
            this._seasonalPanel.fillPanel((SpecifiedRelease)rule);
        } else if (!(rule instanceof TimeSeries)) {
            if (rule instanceof FlowFunction) {
                this._flowPanel.setSystem(this._diversion.getSystem());
                this._flowPanel.fillPanel((FlowFunction)rule);
            } else if (rule instanceof PoolElevation) {
                this._poolPanel.fillPanel((PoolElevation)rule);
            } else if (rule instanceof MinMax) {
                this._minMaxPanel.fillPanel((MinMax)rule);
            } else if (rule instanceof DiversionRule) {
                this._diversionRulePanel.fillPanel((DiversionRule)rule);
            }
        }
        this.setModified(false);
    }

    public boolean savePanel() {
        if (this._opRule == null) {
            return true;
        }
        Object object = (String)this._limitTypeCombo.getSelectedItem();
        if ("Minimum".equals(object)) {
            this._opRule.setLimitType(0);
        } else if ("Maximum".equals(object)) {
            this._opRule.setLimitType(2);
        } else if ("Specified".equals(object)) {
            this._opRule.setLimitType(1);
        } else if ("Demand".equals(object)) {
            this._opRule.setLimitType(3);
        } else {
            DiversionDemandPanel diversionDemandPanel = this;
            RMAIO.postError((Component)((Object)diversionDemandPanel), (String)("Rule, " + diversionDemandPanel._opRule.getName() + ", cannot have an empty Limit Type!"));
        }
        this._opRule.setDescription(this._nameDescPanel.getDescription());
        object = (String)this._opsMthdCombo.getSelectedItem();
        Object object2 = null;
        DiversionElement diversionElement = (DiversionElement)this._opRule.getOperationsElement();
        if (object != null) {
            int n = -1;
            switch (((String)object).hashCode()) {
                case -503167036: {
                    if (!((String)object).equals("Constant")) break;
                    n = 0;
                    break;
                }
                case -55274723: {
                    if (!((String)object).equals("Monthly Varying")) break;
                    n = 1;
                    break;
                }
                case 954576494: {
                    if (!((String)object).equals("Seasonal")) break;
                    n = 2;
                    break;
                }
                case 167991671: {
                    if (!((String)object).equals("Time-Series")) break;
                    n = 3;
                    break;
                }
                case -728079921: {
                    if (!((String)object).equals("Function of Flow")) break;
                    n = 4;
                    break;
                }
                case -1585552742: {
                    if (!((String)object).equals("Function of Pool Elevation")) break;
                    n = 5;
                    break;
                }
                case -1990198830: {
                    if (!((String)object).equals("MinMax")) break;
                    n = 6;
                    break;
                }
                case 999455582: {
                    if (!((String)object).equals("Flexible Diversion Rule")) break;
                    n = 7;
                }
            }
            switch (n) {
                case 0: {
                    object = new ConstantRelease(diversionElement.getController());
                    this._constantPanel.savePanel((ConstantRelease)object);
                    object2 = object;
                    break;
                }
                case 1: {
                    object = new MonthlyRelease(diversionElement.getController());
                    this._monthlyPanel.savePanel((MonthlyRelease)object);
                    object2 = object;
                    break;
                }
                case 2: {
                    object = new SpecifiedRelease(diversionElement.getController());
                    this._seasonalPanel.savePanel((SpecifiedRelease)object);
                    object2 = object;
                    break;
                }
                case 3: {
                    object = new TimeSeries();
                    ((TimeSeries)object).setDiversionName(this._diversion.getName());
                    object2 = object;
                    break;
                }
                case 4: {
                    object = new FlowFunction(diversionElement.getController());
                    this._flowPanel.savePanel((FlowFunction)object);
                    object2 = object;
                    break;
                }
                case 5: {
                    object = new PoolElevation(diversionElement.getController());
                    this._poolPanel.savePanel((PoolElevation)object);
                    object2 = object;
                    break;
                }
                case 6: {
                    object = new MinMax(diversionElement.getController());
                    this._minMaxPanel.savePanel((MinMax)object);
                    object2 = object;
                    break;
                }
                case 7: {
                    object = this._diversionRulePanel.getRule();
                    this._diversionRulePanel.savePanel();
                    object2 = object;
                }
            }
            this._opRule.setRule((Rule)object2);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "A Demand Specification Type must be selected", "Error", 0);
        }
        return object2 != null;
    }

    protected void addRule() {
        if (this._ruleDlg == null) {
            this._ruleDlg = new RuleDlg((Frame)ClientApp.frame(), true);
            if (this._modelName.equalsIgnoreCase("RssLp")) {
                this._ruleDlg.setDiversionRules("RssLp");
            } else {
                this._ruleDlg.setDiversionRules();
            }
        }
        this._ruleDlg.setVisible(true);
        if (this._ruleDlg.isCanceled()) {
            return;
        }
        String string = this._ruleDlg.getName().trim();
        if (string.equals("") || string == null) {
            int n = JOptionPane.showConfirmDialog(null, "The blank rule name is not allowed.\nPlease enter a new name.", "Error", 0, 0);
            if (n == 0) {
                this.addRule();
            }
            return;
        }
        for (int i = 0; i < this._ruleListVector.size(); ++i) {
            if (!string.equals(this._ruleListVector.elementAt(i))) continue;
            int n = JOptionPane.showConfirmDialog(null, "The rule name has to be unique.\nPlease enter a new name.", "Error", 0, 0);
            if (n == 0) {
                this.addRule();
            }
            return;
        }
        String string2 = this._ruleDlg.getRuleType();
        if (string2.equals("Constant")) {
            string2 = "Constant";
        } else if (string2.equals("Monthly Varying")) {
            string2 = "Monthly Varying";
        } else if (string2.equals("Seasonal")) {
            string2 = "Seasonal";
        } else if (string2.equals("Function of Flow")) {
            string2 = "Function of Flow";
        } else if (string2.equals("Function of Pool Elevation")) {
            string2 = "Function of Pool Elevation";
        } else if (string2.equals("Time-Series")) {
            string2 = "Time-Series";
        } else if (string2.equals("Min Max")) {
            string2 = "MinMax";
        }
        this.addRule(string2);
    }

    private void addRule(String object) {
        ((FluentLogger.Api)a.atFine()).log("addRule(): adding rule %s", object);
        String string = object;
        if (this._diversion.getDiversionOps().getController() != null) {
            object = RuleFactory.a(this._diversion.getDiversionOps().getController(), (String)object);
            object.setName(string);
            if (object instanceof TimeSeries) {
                ((TimeSeries)object).setDiversionName(this._diversion.getName());
            }
            this.insertIntoRuleHTable((Rule)object);
            this._ruleListVector.addElement(string);
            this.fillPanel((Rule)object);
        }
    }

    public void insertIntoRuleHTable(Rule rule) {
        String string = rule.getName();
        this._ruleHTable.put(string, rule);
    }

    public void setRuleRef(OpRuleRef namedType) {
        if (this.isModified()) {
            this.savePanel();
        }
        this._nameDescPanel.setName(namedType.getName());
        this._nameDescPanel.setDescription(namedType.getDescription());
        namedType = (DiversionDemandOpRule)namedType.getRule();
        this._opRule = namedType;
        this._diversion = (DiversionElement)this._opRule.getOperationsElement();
        this._poolPanel.setSystem(this._diversion.getSystem());
        Rule rule = namedType.getRule();
        int n = namedType.getLimitType();
        if (n == 0) {
            this._limitTypeCombo.setSelectedItem((Object)"Minimum");
        } else if (n == 2) {
            this._limitTypeCombo.setSelectedItem((Object)"Maximum");
        } else if (n == 1) {
            this._limitTypeCombo.setSelectedItem((Object)"Specified");
        } else if (n == 3) {
            this._limitTypeCombo.setSelectedItem((Object)"Demand");
        } else {
            this._limitTypeCombo.setSelectedIndex(-1);
        }
        this.fillPanel(rule);
    }

    public void setParent(DiversionPanel diversionPanel) {
    }
}

