/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.diversion;

import hec.gui.NameDialog;
import hec.gui.RenameDlg;
import hec.lang.NamedType;
import hec.model.Conditional;
import hec.model.ConditionalBlock;
import hec.rss.client.ConditionalBlockTreeNode;
import hec.rss.client.ConditionalPanel;
import hec.rss.client.ConditionalRefTreeNode;
import hec.rss.client.ConditionalTreeNode;
import hec.rss.client.DownstreamRulePanel;
import hec.rss.client.ElementOpsEditorPanel;
import hec.rss.client.ExistingRuleDlg;
import hec.rss.client.IfBlockPanel;
import hec.rss.client.JNameSelectDialog;
import hec.rss.client.JVariableRateChangeFlowPanel;
import hec.rss.client.ResTreeCellRenderer;
import hec.rss.client.ReservoirJFrame;
import hec.rss.client.RuleDlg;
import hec.rss.client.RulePanel;
import hec.rss.client.ScriptOpRulePanel;
import hec.rss.client.SelectObjectDialog;
import hec.rss.client.diversion.DiversionDemandPanel;
import hec.rss.client.diversion.DiversionPanel$1;
import hec.rss.client.diversion.DiversionPanel$2;
import hec.rss.client.diversion.DiversionPanelPopupMenuHandler;
import hec.rss.model.ConditionalBlockRef;
import hec.rss.model.ConstantRelease;
import hec.rss.model.DiversionConstants;
import hec.rss.model.DiversionDemandOpRule;
import hec.rss.model.DiversionElement;
import hec.rss.model.DiversionOp;
import hec.rss.model.DownstreamCntrlOpRule;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementOp;
import hec.rss.model.JunctionElement;
import hec.rss.model.OpController;
import hec.rss.model.OpRule;
import hec.rss.model.OpRuleRef;
import hec.rss.model.OpSet;
import hec.rss.model.RateChangeLimitOpRule;
import hec.rss.model.ReleaseFuncOpRule;
import hec.rss.model.RssAlt;
import hec.rss.model.RssConditional;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.ScriptOpRule;
import hec.rss.model.StorageZone;
import hec.rss.model.SystemHydropowerOpRule;
import hec.rss.model.TandemSysOpRule;
import hec.rss.model.TreeNodeStateListener;
import hec.rss.model.ZoneObject;
import hec.rss.server.DiversionEditorDlg;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.lang.Modifiable;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJFrame;
import rma.swing.list.RmaListModel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;
import rma.util.RMASort;

public class DiversionPanel
extends DefaultJPanel
implements ElementOpsEditorPanel,
DiversionConstants {
    private boolean _fillingForm = false;
    Vector _rules = new Vector();
    RssSystem _system;
    Vector _ruleListVector = new Vector(10);
    RuleDlg _ruleDlg;
    DiversionElement _diversion;
    Hashtable _ruleHTable = new Hashtable(10);
    JDialog _parent;
    private String _modelName = "Rss";
    private RmaJComboBox<OpSet> _opSetCombo;
    private RmaJDescriptionField _opDescFld;
    private JTree _ruleTree;
    private DefaultMutableTreeNode _root;
    private JButton addRuleButton;
    private JButton removeRuleButton;
    private JButton raisePriorityButton;
    private JButton lowerPriorityButton;
    private JPanel _cardPanel;
    private RmaJCheckBox _computeInUnRegLoopCBox;
    private List<JMenu> _menus;
    private JMenuItem _newOpsMenu;
    private JMenuItem _renameOpsMenu;
    private JMenuItem _deleteOpsMenu;
    private JMenuItem _duplicateOpsMenu;
    private JMenuItem _newRuleMenu;
    private JMenuItem _renameRuleMenu;
    private JMenuItem _useExistingRuleMenu;
    private JMenuItem _removeRuleMenu;
    private JMenuItem _removeAllRulesMenu;
    private JMenuItem _deleteRuleMenu;
    private JMenuItem _newBlockMenu;
    private JMenuItem _renameBlockMenu;
    private JMenuItem _useExistingBlockMenu;
    private JMenuItem _deleteBlockMenu;
    private JMenuItem _removeBlockMenu;
    private JMenuItem _duplicateBlockMenu;
    private DiversionOp _divOps;
    private JMenu _ruleMenu;
    private JMenu _operationsMenu;
    private JMenu _blockMenu;
    private ItemListener _opsComboListener;
    private OpSet _currentOpSet;
    private OpRuleRef _currentRuleRef = null;
    private OpRule _currentRule = null;
    private Conditional _currentConditional = null;
    private ConditionalBlock _currentIfBlock = null;
    private DefaultJPanel _currentPanel = null;
    private TreeSelectionListener _ruleTreeSelectionListener;
    private StorageZone _currentZone;
    int[] _intarray = new int[1];
    private DefaultJPanel _emptyPanel;
    private ConditionalPanel _conditionalPanel;
    private IfBlockPanel _ifBlockPanel;
    private DiversionDemandPanel _divDemandPanel;
    private JVariableRateChangeFlowPanel _rateChangeLimitRulePanel;
    private ScriptOpRulePanel _scriptOpRulePanel;
    private RulePanel _releaseFuncRulePanel;
    private DownstreamRulePanel _downstreamCntrlRulePanel;
    private RssAlt _rssAlt;

    public DiversionPanel(JDialog jDialog) {
        this._parent = jDialog;
        this.setLayout(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jPanel, gridBagConstraints);
        JComponent jComponent = new JLabel("Operations Set:");
        jComponent.setDisplayedMnemonic('O');
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._opSetCombo = new RmaJComboBox();
        jComponent.setLabelFor((Component)this._opSetCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._opSetCombo, gridBagConstraints);
        jComponent = new JLabel("Description:");
        jComponent.setDisplayedMnemonic('D');
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._opDescFld = new RmaJDescriptionField();
        jComponent.setLabelFor((Component)this._opDescFld);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)this._opDescFld, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add(jPanel, gridBagConstraints);
        this._root = new DefaultMutableTreeNode("root");
        DiversionPanel diversionPanel = this;
        this._ruleTree = new DiversionPanel$1(diversionPanel, diversionPanel._root);
        this._ruleTree.setCellRenderer(new ResTreeCellRenderer());
        this._ruleTree.setToolTipText("");
        if (!Boolean.getBoolean("DiversionPanel.ShowRootNode")) {
            this._ruleTree.setRootVisible(false);
        }
        this._cardPanel = new JPanel(new CardLayout());
        jComponent = new JSplitPane(1, new JScrollPane(this._ruleTree), this._cardPanel);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._emptyPanel = new DiversionPanel$2(this);
        this._conditionalPanel = new ConditionalPanel();
        this._ifBlockPanel = new IfBlockPanel();
        this._rateChangeLimitRulePanel = new JVariableRateChangeFlowPanel(false);
        this._scriptOpRulePanel = new ScriptOpRulePanel();
        this._releaseFuncRulePanel = new RulePanel();
        this._divDemandPanel = new DiversionDemandPanel();
        this._cardPanel.add("empty", (Component)this._emptyPanel);
        this._cardPanel.add("ConditionalPanel", (Component)((Object)this._conditionalPanel));
        this._cardPanel.add("IfBlockPanel", (Component)((Object)this._ifBlockPanel));
        this._cardPanel.add("RateChangeRule", (Component)((Object)this._rateChangeLimitRulePanel));
        this._cardPanel.add("ScriptOpRule", (Component)((Object)this._scriptOpRulePanel));
        this._cardPanel.add("ReleaseFuncOpRule", (Component)((Object)this._releaseFuncRulePanel));
        this._cardPanel.add("DemandPanel", (Component)((Object)this._divDemandPanel));
        this._conditionalPanel.setParent(this);
        this._ifBlockPanel.setParent((JPanel)((Object)this));
        this._rateChangeLimitRulePanel.setParent((JPanel)((Object)this));
        this._scriptOpRulePanel.setParent((JPanel)((Object)this));
        this._releaseFuncRulePanel.setParent((JPanel)((Object)this));
        this._divDemandPanel.setParent(this);
        this._computeInUnRegLoopCBox = new RmaJCheckBox("Computed during UnReg");
        this._computeInUnRegLoopCBox.setDisplayedMnemonicIndex(0);
        this._computeInUnRegLoopCBox.setMnemonic('C');
        this._computeInUnRegLoopCBox.setModifiable(false);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        DiversionPanel diversionPanel2 = this;
        diversionPanel2.add((Component)diversionPanel2._computeInUnRegLoopCBox, gridBagConstraints);
        this.buildMenus();
        new DiversionPanelPopupMenuHandler(this);
        EventQueue.invokeLater(() -> DiversionPanel.a((JSplitPane)jComponent));
    }

    private void buildMenus() {
        this._menus = new ArrayList<JMenu>();
        this._operationsMenu = new JMenu("Operations");
        this._menus.add(this._operationsMenu);
        this._newOpsMenu = new JMenuItem("New...");
        this._operationsMenu.add(this._newOpsMenu);
        this._renameOpsMenu = new JMenuItem("Rename...");
        this._operationsMenu.add(this._renameOpsMenu);
        this._deleteOpsMenu = new JMenuItem("Delete...");
        this._operationsMenu.add(this._deleteOpsMenu);
        this._duplicateOpsMenu = new JMenuItem("Duplicate...");
        this._operationsMenu.add(this._duplicateOpsMenu);
        this._ruleMenu = new JMenu("Rule");
        this._menus.add(this._ruleMenu);
        this._newRuleMenu = new JMenuItem("New...");
        this._ruleMenu.add(this._newRuleMenu);
        this._renameRuleMenu = new JMenuItem("Rename...");
        this._ruleMenu.add(this._renameRuleMenu);
        this._useExistingRuleMenu = new JMenuItem("Use Existing...");
        this._ruleMenu.add(this._useExistingRuleMenu);
        this._removeRuleMenu = new JMenuItem("Remove...");
        this._ruleMenu.add(this._removeRuleMenu);
        this._removeAllRulesMenu = new JMenuItem("Remove All Rules...");
        this._ruleMenu.add(this._removeAllRulesMenu);
        this._deleteRuleMenu = new JMenuItem("Delete...");
        this._ruleMenu.add(this._deleteRuleMenu);
        this._blockMenu = new JMenu("Block");
        this._menus.add(this._blockMenu);
        this._newBlockMenu = new JMenuItem("New...");
        this._blockMenu.add(this._newBlockMenu);
        this._renameBlockMenu = new JMenuItem("Rename...");
        this._blockMenu.add(this._renameBlockMenu);
        this._useExistingBlockMenu = new JMenuItem("Use Existing...");
        this._blockMenu.add(this._useExistingBlockMenu);
        this._removeBlockMenu = new JMenuItem("Remove...");
        this._blockMenu.add(this._removeBlockMenu);
        this._deleteBlockMenu = new JMenuItem("Delete...");
        this._blockMenu.add(this._deleteBlockMenu);
        this._duplicateBlockMenu = new JMenuItem("Duplicate...");
        this._blockMenu.add(this._duplicateBlockMenu);
    }

    public List<JMenu> getMenus() {
        return this._menus;
    }

    protected void addListeners() {
        this._newOpsMenu.addActionListener(actionEvent -> this.newOpsAction());
        this._renameOpsMenu.addActionListener(actionEvent -> this.renameOpsAction());
        this._deleteOpsMenu.addActionListener(actionEvent -> this.deleteOpsAction());
        this._duplicateOpsMenu.addActionListener(actionEvent -> this.duplicateOpsAction());
        this._newRuleMenu.addActionListener(actionEvent -> this.newRuleAction());
        this._renameRuleMenu.addActionListener(actionEvent -> this.renameRuleAction());
        this._useExistingRuleMenu.addActionListener(actionEvent -> this.useExistingRuleAction());
        this._removeRuleMenu.addActionListener(actionEvent -> this.removeRuleAction());
        this._deleteRuleMenu.addActionListener(actionEvent -> this.deleteRuleAction());
        this._newBlockMenu.addActionListener(actionEvent -> this.newConditionalAction());
        this._renameBlockMenu.addActionListener(actionEvent -> this.renameConditionalAction());
        this._useExistingBlockMenu.addActionListener(actionEvent -> this.useExistingConditionalAction());
        this._removeBlockMenu.addActionListener(actionEvent -> this.removeConditionalAction());
        this._deleteBlockMenu.addActionListener(actionEvent -> this.deleteConditionalAction());
        this._duplicateBlockMenu.addActionListener(actionEvent -> this.duplicateConditionalAction());
        this._opsComboListener = itemEvent -> {
            if (2 == itemEvent.getStateChange()) {
                return;
            }
            this.opsComboSelected();
        };
        this._opSetCombo.addItemListener(this._opsComboListener);
        this._ruleTreeSelectionListener = treeSelectionEvent -> this.ruleTreeSelectionChanged(treeSelectionEvent);
        this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
    }

    protected void ruleTreeSelectionChanged(TreeSelectionEvent object) {
        this._currentOpSet = (OpSet)this._opSetCombo.getSelectedItem();
        if (((TreeSelectionEvent)object).getNewLeadSelectionPath() == null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "empty");
            this._currentPanel = this._emptyPanel;
            return;
        }
        this._currentIfBlock = null;
        Object object2 = ((TreeSelectionEvent)object).getNewLeadSelectionPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent();
        if (defaultMutableTreeNode != null) {
            Object object3;
            boolean bl = ((Modifiable)this._parent).isModified();
            if (this._currentPanel != null) {
                object = ((TreeSelectionEvent)object).getOldLeadSelectionPath();
                this._currentPanel.deselectPanel();
                if (object != null && (object2 = ((TreePath)object).getLastPathComponent()) != null) {
                    ((DefaultTreeModel)this._ruleTree.getModel()).nodeChanged((TreeNode)object2);
                }
                if ((object2 = this._ruleTree.getSelectionPath()) != null) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent();
                }
            }
            object = null;
            object2 = null;
            if (defaultMutableTreeNode != null) {
                object2 = defaultMutableTreeNode.getUserObject();
            }
            this._newBlockMenu.setEnabled(false);
            this._deleteBlockMenu.setEnabled(false);
            this._renameBlockMenu.setEnabled(false);
            this._duplicateBlockMenu.setEnabled(false);
            this._removeBlockMenu.setEnabled(false);
            this._useExistingBlockMenu.setEnabled(false);
            if (object2 instanceof StorageZone) {
                this._currentZone = (StorageZone)object2;
                this._newBlockMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                this._duplicateBlockMenu.setEnabled(true);
                this._useExistingRuleMenu.setEnabled(true);
                this._removeAllRulesMenu.setEnabled(true);
                this._currentRuleRef = null;
                this._currentRule = null;
                if (this._parent instanceof DiversionEditorDlg) {
                    this._newRuleMenu.setEnabled(true);
                    this._removeRuleMenu.setEnabled(false);
                    this._renameRuleMenu.setEnabled(false);
                }
            } else if (object2 instanceof OpRuleRef) {
                this._newBlockMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                this._duplicateBlockMenu.setEnabled(true);
                this._useExistingRuleMenu.setEnabled(true);
                this._removeAllRulesMenu.setEnabled(true);
                this._useExistingRuleMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                this._removeRuleMenu.setEnabled(true);
                this._newRuleMenu.setEnabled(true);
                this._currentRuleRef = (OpRuleRef)object2;
                object3 = this._currentRuleRef;
                this._currentRule = object = this._currentRuleRef.getRule();
                object2 = this.getZoneNodeForNode(defaultMutableTreeNode);
                this._currentZone = (StorageZone)((DefaultMutableTreeNode)object2).getUserObject();
                if (object instanceof DiversionDemandOpRule) {
                    this._divDemandPanel.setRuleRef((OpRuleRef)object3);
                    object = "DemandPanel";
                    this._currentPanel = this._divDemandPanel;
                } else if (object instanceof RateChangeLimitOpRule) {
                    this._rateChangeLimitRulePanel.setRuleRef((OpRuleRef)object3);
                    object = "RateChangeRule";
                    this._currentPanel = this._rateChangeLimitRulePanel;
                } else if (object instanceof ReleaseFuncOpRule) {
                    this._releaseFuncRulePanel.setRuleRef((OpRuleRef)object3);
                    object = "ReleaseFuncOpRule";
                    this._currentPanel = this._releaseFuncRulePanel;
                } else if (object instanceof ScriptOpRule) {
                    this._scriptOpRulePanel.setRuleRef((OpRuleRef)object3);
                    object = "ScriptOpRule";
                    this._currentPanel = this._scriptOpRulePanel;
                } else if (object instanceof DownstreamCntrlOpRule) {
                    object = this._currentOpSet.getSortedZoneVector();
                    this._downstreamCntrlRulePanel.fillZones((Vector<StorageZone>)object);
                    this._downstreamCntrlRulePanel.setRuleRef((OpRuleRef)object3);
                    object = "DowstreamCntrlOpRule";
                    this._currentPanel = this._downstreamCntrlRulePanel;
                } else {
                    object = "empty";
                    this._currentPanel = this._emptyPanel;
                }
                this._removeRuleMenu.setEnabled(true);
                this._renameRuleMenu.setEnabled(true);
                if (defaultMutableTreeNode.getParent() instanceof ConditionalTreeNode) {
                    this._removeRuleMenu.setEnabled(false);
                    this._removeAllRulesMenu.setEnabled(false);
                }
            } else if (object2 instanceof Conditional) {
                this._newRuleMenu.setEnabled(true);
                this._removeRuleMenu.setEnabled(false);
                this._removeAllRulesMenu.setEnabled(false);
                this._newBlockMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                this._duplicateBlockMenu.setEnabled(true);
                this._useExistingRuleMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                defaultMutableTreeNode = this.getZoneNodeForNode(defaultMutableTreeNode);
                if (defaultMutableTreeNode != null) {
                    object3 = defaultMutableTreeNode.getUserObject();
                    this._currentZone = (StorageZone)object3;
                }
                this._currentRuleRef = null;
                this._currentRule = null;
                this._currentConditional = (Conditional)object2;
                this._currentIfBlock = null;
                this._renameBlockMenu.setEnabled(false);
                this._deleteBlockMenu.setEnabled(false);
                this._removeBlockMenu.setEnabled(false);
                object = "ConditionalPanel";
                this._currentPanel = this._conditionalPanel;
                this._conditionalPanel.setConditional(this._currentConditional);
            } else if (object2 instanceof ConditionalBlockRef || object2 instanceof ConditionalBlock) {
                this._newRuleMenu.setEnabled(false);
                this._currentIfBlock = ((ConditionalBlockTreeNode)defaultMutableTreeNode).getConditionalBlock();
                this._renameBlockMenu.setEnabled(true);
                this._duplicateBlockMenu.setEnabled(true);
                this._deleteBlockMenu.setEnabled(true);
                this._removeBlockMenu.setEnabled(true);
                this._useExistingRuleMenu.setEnabled(true);
                this._useExistingBlockMenu.setEnabled(true);
                if (object2 instanceof ConditionalBlockRef) {
                    ((ConditionalBlockRef)object2).getParent();
                } else {
                    ((ConditionalBlock)object2).getParent();
                }
                defaultMutableTreeNode = this.getZoneNodeForNode(defaultMutableTreeNode);
                if (defaultMutableTreeNode != null) {
                    object = defaultMutableTreeNode.getUserObject();
                    this._currentZone = (StorageZone)object;
                }
                this._currentRuleRef = null;
                this._currentRule = null;
                this._currentConditional = null;
                object = "IfBlockPanel";
                this._currentPanel = this._ifBlockPanel;
                this._ifBlockPanel.setConditionalBlock(this._currentIfBlock);
            }
            if (object != null) {
                object3 = SwingUtilities.windowForComponent((Component)((Object)this));
                if (object3 instanceof RmaJDialog) {
                    ((RmaJDialog)object3).updateUnitSystem((Container)this._currentPanel);
                } else {
                    ((RmaJFrame)object3).updateUnitSystem((Container)this._currentPanel);
                }
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, (String)object);
            } else {
                ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "empty");
            }
            if (!bl) {
                ((Modifiable)this._parent).setModified(false);
            }
        }
    }

    protected void opsComboSelected() {
        OpSet opSet = (OpSet)this._opSetCombo.getSelectedItem();
        this.fillPanel(opSet);
    }

    public void duplicateConditionalAction() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object = this._ruleTree.getSelectionPath();
        if (object == null) {
            RMAIO.postError((Component)((Object)this), (String)"Please Select a zone!");
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.getLastPathComponent();
        if (defaultMutableTreeNode2 == null || defaultMutableTreeNode2.getLevel() <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"Please Select a zone!");
            return;
        }
        Object object2 = defaultMutableTreeNode2.getUserObject();
        StorageZone storageZone = this.getZoneForNode(defaultMutableTreeNode2);
        if (object2 instanceof StorageZone || object2 instanceof Conditional) {
            defaultMutableTreeNode = defaultMutableTreeNode2;
        } else {
            if (object2 instanceof ConditionalBlock) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = this.getZoneNodeForNode(defaultMutableTreeNode2);
                this.duplicateConditionalBlockAction((ConditionalBlock)object2, defaultMutableTreeNode2, defaultMutableTreeNode3, storageZone);
                return;
            }
            if (object2 instanceof ConditionalBlockRef) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = this.getZoneNodeForNode(defaultMutableTreeNode2);
                object = ((ConditionalBlockRef)object2).getConditionalBlock();
                this.duplicateConditionalBlockAction((ConditionalBlock)object, defaultMutableTreeNode2, defaultMutableTreeNode4, storageZone);
                return;
            }
            defaultMutableTreeNode = this.getZoneNodeForNode(defaultMutableTreeNode2);
            object.getParentPath();
        }
        object = this._divOps.getConditionalBlocks();
        object2 = new SelectObjectDialog(this._parent, "Duplicate IF Block", true);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(object);
        ((SelectObjectDialog)((Object)object2)).setSelectableObjects(arrayList, new int[0]);
        object2.setLocationRelativeTo((Component)((Object)this));
        object2.setVisible(true);
        if (((SelectObjectDialog)((Object)object2)).isCanceled()) {
            return;
        }
        object = ((SelectObjectDialog)((Object)object2)).getSelectedObjects();
        if (object == null || object.isEmpty()) {
            return;
        }
        object = (ConditionalBlock)object.get(0);
        this.duplicateConditionalBlockAction((ConditionalBlock)object, defaultMutableTreeNode2, defaultMutableTreeNode, storageZone);
    }

    private void duplicateConditionalBlockAction(ConditionalBlock object, DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode object2, StorageZone storageZone) {
        if (object != null) {
            ConditionalBlock conditionalBlock;
            object2 = object.getName() + " - Copy";
            int n = 1;
            Object object3 = object2;
            do {
                if ((conditionalBlock = this._divOps.getConditionalBlock((String)object3)) == null) continue;
                object3 = ((String)object2).concat("(").concat(String.valueOf(++n)).concat(")");
            } while (conditionalBlock != null);
            object2 = new NameDialog((Dialog)this._parent, "Name Duplicate Conditional", true);
            object2.setName((String)object3);
            object2.setVisible(true);
            if (object2.isCanceled()) {
                return;
            }
            object3 = object2.getName();
            object2 = this._divOps.createNewConditionalBlock((String)object3);
            object2.setDescription("Copy of " + object2.getDescription());
            object.duplicateConditionals((ConditionalBlock)object2);
            this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
            object = null;
            if (defaultMutableTreeNode.getUserObject() instanceof StorageZone) {
                object = storageZone.addConditionalBlock((ConditionalBlock)object2);
                object = new ConditionalRefTreeNode(this._ruleTree, (ConditionalBlockRef)object);
            } else if (defaultMutableTreeNode.getUserObject() instanceof RssConditional) {
                object = object2.clone();
                object.setName(object2.getName() + " (copy)");
                ((RssConditional)defaultMutableTreeNode.getUserObject()).addConditionalBlock((ConditionalBlock)object);
                object = new ConditionalBlockTreeNode(this._ruleTree, (ConditionalBlock)object);
            }
            if (object != null) {
                object2 = this.getZoneNodeForNode(defaultMutableTreeNode);
                ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object);
                ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged((TreeNode)object2);
                this.expandAllTreeNodes();
                this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
                object = new TreePath(((DefaultMutableTreeNode)object).getPath());
                this._ruleTree.setSelectionPath((TreePath)object);
                return;
            }
            this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
        }
    }

    public void deleteConditionalAction() {
        Object object;
        List<Object> list = this._divOps.getConditionalBlocks();
        Object object2 = new SelectObjectDialog(this._parent, "", true);
        object2.setTitle("Select Conditional Block to Permanently Delete");
        ((SelectObjectDialog)((Object)object2)).setSelectableObjects(list);
        object2.setLocationRelativeTo((Component)((Object)this));
        object2.setVisible(true);
        if (((SelectObjectDialog)((Object)object2)).isCanceled()) {
            return;
        }
        list = ((SelectObjectDialog)((Object)object2)).getSelectedObjects();
        if (list == null || list.isEmpty()) {
            return;
        }
        if (JOptionPane.showConfirmDialog((Component)((Object)this), "Deleting the conditional block will permanently delete \"" + (list = (ConditionalBlock)list.get(0)).getName() + "\" from the Diversion.\n   Are you sure you want to delete " + list.getName() + "? ", "Confirm Delete Rule", 0) != 0) {
            return;
        }
        this._divOps.deleteConditionalBlock((ConditionalBlock)list);
        object2 = this._divOps.getOperationSets();
        if (object2 != null) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = (OpSet)((Vector)object2).elementAt(i);
                ((OpSet)object).removeAllConditionalBlockRefs(list.getIndex());
            }
        }
        Enumeration<TreeNode> enumeration = this._root.breadthFirstEnumeration();
        object = new ArrayList();
        while (enumeration.hasMoreElements()) {
            object2 = (DefaultMutableTreeNode)enumeration.nextElement();
            Object object3 = ((DefaultMutableTreeNode)object2).getUserObject();
            if ((!(object3 instanceof ConditionalBlockRef) || ((ConditionalBlockRef)object3).getConditionalBlock() != list) && (!(object3 instanceof ConditionalBlock) || object3 != list)) continue;
            object.add(object2);
            if (object2 == null || this._currentIfBlock == null || !((DefaultMutableTreeNode)object2).getUserObject().toString().equals(this._currentIfBlock.getName())) continue;
            object3 = this._ruleTree.getPathForRow(0);
            object2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            object3 = ((TreePath)object3).pathByAddingChild(object2);
            this._ruleTree.setSelectionPath((TreePath)object3);
        }
        for (int i = 0; i < object.size(); ++i) {
            object2 = (DefaultMutableTreeNode)object.get(i);
            ((DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent()).remove((MutableTreeNode)object2);
        }
        ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
        this.expandAllTreeNodes();
        this.setModified(true);
    }

    public void removeConditionalAction() {
        if (this._currentIfBlock == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No IF Block Selected.", "ResSim - Remove IF BLOCK Error", 0);
            return;
        }
        DiversionPanel diversionPanel = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)diversionPanel), "<html>Remove IF Block <b>" + diversionPanel._currentIfBlock.getName() + "<b>", "ResSim - Remove IF Block", 2, 2);
        if (n != 0) {
            return;
        }
        Serializable serializable = this._ruleTree.getSelectionPath();
        if ((serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent()) == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
        if (defaultMutableTreeNode.getUserObject() instanceof StorageZone) {
            this._currentZone.removeConditionalBlock(this._currentIfBlock);
        } else if (defaultMutableTreeNode.getUserObject() instanceof RssConditional) {
            ((RssConditional)defaultMutableTreeNode.getUserObject()).removeCondtionalObject(this._currentIfBlock);
        }
        this._intarray[0] = defaultMutableTreeNode.getIndex((TreeNode)((Object)serializable));
        defaultMutableTreeNode.remove((MutableTreeNode)((Object)serializable));
        ((DefaultTreeModel)this._ruleTree.getModel()).nodesWereRemoved(defaultMutableTreeNode, this._intarray, new Object[]{serializable});
        this._currentIfBlock = null;
        this._renameBlockMenu.setEnabled(false);
        this._duplicateBlockMenu.setEnabled(false);
        this._deleteBlockMenu.setEnabled(false);
        this._removeBlockMenu.setEnabled(false);
        serializable = new TreePath(defaultMutableTreeNode.getPath());
        this._ruleTree.setSelectionPath((TreePath)serializable);
        DiversionPanel diversionPanel2 = this;
        diversionPanel2.fillPanel(diversionPanel2._currentOpSet);
        this.setModified(true);
    }

    public void useExistingConditionalAction() {
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[1];
        StorageZone[] storageZoneArray = new StorageZone[1];
        ConditionalBlock conditionalBlock = this.selectIfBlock("Use Existing Conditional Block", false, defaultMutableTreeNodeArray, storageZoneArray);
        if (conditionalBlock != null) {
            Object object;
            this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
            ConditionalRefTreeNode conditionalRefTreeNode = null;
            if (defaultMutableTreeNodeArray[0].getUserObject() instanceof StorageZone) {
                object = storageZoneArray[0].addConditionalBlock(conditionalBlock);
                conditionalRefTreeNode = new ConditionalRefTreeNode(this._ruleTree, (ConditionalBlockRef)object);
            } else if (defaultMutableTreeNodeArray[0].getUserObject() instanceof RssConditional) {
                object = storageZoneArray[0].getConditionalBlockRef(conditionalBlock);
                if (object == null) {
                    object = new ConditionalBlockRef(storageZoneArray[0], conditionalBlock);
                }
                ((RssConditional)defaultMutableTreeNodeArray[0].getUserObject()).addConditionalBlock((ConditionalBlockRef)object);
            }
            if (conditionalRefTreeNode != null) {
                defaultMutableTreeNodeArray[0].add(conditionalRefTreeNode);
                ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(defaultMutableTreeNodeArray[0]);
                this.expandAllTreeNodes();
                this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
                object = new TreePath(conditionalRefTreeNode.getPath());
                this._ruleTree.setSelectionPath((TreePath)object);
            } else {
                this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
                this.expandAllTreeNodes();
            }
            this.setModified(true);
        }
    }

    private ConditionalBlock selectIfBlock(String object, boolean bl, DefaultMutableTreeNode[] object2, StorageZone[] storageZoneArray) {
        int n;
        Object object3;
        Object object4;
        int n2;
        ArrayList<Object> arrayList;
        object2[0] = this.getTreeNode();
        if (object2[0] == null || object2[0].getLevel() <= 0) {
            RMAIO.postError((Component)((Object)this), (String)"Please Select a zone!");
            return null;
        }
        Object object5 = object2[0].getUserObject();
        if (object5 instanceof StorageZone || object5 instanceof Conditional) {
            DefaultMutableTreeNode cfr_ignored_0 = object2[0];
        } else {
            this.getZoneNodeForNode(object2[0]);
        }
        storageZoneArray[0] = this.getZoneForNode(object2[0]);
        if (storageZoneArray[0].getIndex() == this._currentOpSet.getInactiveZoneIndex()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Cannot add existing IF to Inactive Zone.", "ResSim - Use Existing IF Error", 0);
            return null;
        }
        object2 = this._divOps.getConditionalBlocks();
        List<ConditionalBlock> list = null;
        ConditionalBlock conditionalBlock = null;
        if (object5 instanceof StorageZone) {
            list = new ArrayList();
            arrayList = storageZoneArray[0].getConditionalBlockRefs(null);
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object4 = (ConditionalBlockRef)arrayList.get(n2);
                if (object4 == null) continue;
                list.add(((ConditionalBlockRef)object4).getConditionalBlock());
            }
        } else if (object5 instanceof RssConditional) {
            arrayList = (RssConditional)object5;
            list = arrayList.getContitionalBlocks();
            conditionalBlock = arrayList.getParent();
        } else if (object5 instanceof ConditionalBlockRef) {
            arrayList = (ConditionalBlockRef)object5;
            list = new ArrayList<ConditionalBlock>();
            list.add(((ConditionalBlockRef)((Object)arrayList)).getConditionalBlock());
        }
        arrayList = new ArrayList<Object>();
        object4 = new ArrayList();
        for (n2 = 0; n2 < object2.size(); ++n2) {
            object3 = (ConditionalBlock)object2.get(n2);
            n = this.conditionalUsed((ConditionalBlock)object3, list, object5, storageZoneArray[0]);
            if (object3 == conditionalBlock) {
                n = 1;
            }
            if (n == 0) {
                arrayList.add(object3);
                continue;
            }
            object4.add(object3);
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No other existing Conditional Blocks available to add to this Diversion.", "Use Existing IF", 1);
            return null;
        }
        SelectObjectDialog selectObjectDialog = new SelectObjectDialog(this._parent, (String)object, true);
        object3 = new ArrayList<Object>();
        object3.addAll(arrayList);
        RMASort.quickSort((List)object3);
        n = arrayList.size();
        RMASort.quickSort((List)object4);
        object3.addAll(object4);
        object = new int[object4.size()];
        int n3 = 0;
        while (n3 < ((Object)object).length) {
            int n4 = n3++;
            object[n4] = n4 + n;
        }
        selectObjectDialog.setSelectableObjects(object3, (int[])object);
        selectObjectDialog.setLocationRelativeTo((Component)((Object)this));
        selectObjectDialog.setVisible(true);
        if (selectObjectDialog.isCanceled()) {
            return null;
        }
        List list2 = selectObjectDialog.getSelectedObjects();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        object = (ConditionalBlock)list2.get(0);
        return object;
    }

    private boolean conditionalUsed(ConditionalBlock conditionalBlock, List<ConditionalBlock> list, Object object, StorageZone storageZone) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                storageZone = list.get(i);
                if (storageZone == null || conditionalBlock.getIndex() != storageZone.getIndex()) continue;
                return true;
            }
        }
        return false;
    }

    private void renameConditionalAction() {
        if (this._currentIfBlock == null) {
            RMAIO.postError((Component)((Object)this), (String)"Must select a valid IF Block!");
            this._renameBlockMenu.setEnabled(false);
            return;
        }
        Object object = new RenameDlg((Dialog)this._parent, "Rename IF Block", true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.removeFileComponents();
        object.setName(this._currentIfBlock.getName());
        object.setDescription(this._currentIfBlock.getDescription());
        List<ConditionalBlock> list = this._divOps.getConditionalBlocks();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            ConditionalBlock conditionalBlock = list.get(i);
            arrayList.add(conditionalBlock.getName());
        }
        object.setExistingNames(arrayList);
        object.setVisible(true);
        if (object.getCanceled()) {
            return;
        }
        this._currentIfBlock.setName(object.getName());
        this._currentIfBlock.setDescription(object.getDescription());
        TreePath treePath = this._ruleTree.getSelectionPath();
        object = (TreeNode)treePath.getLastPathComponent();
        ((DefaultTreeModel)this._ruleTree.getModel()).nodeChanged((TreeNode)object);
        this.setModified(true);
    }

    private void newConditionalAction() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        Object object2 = this._ruleTree.getSelectionPath();
        if (object2 == null || (object2 = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent()) == null) {
            object2 = this._root;
        }
        if (object2 == null) {
            return;
        }
        Object object3 = ((DefaultMutableTreeNode)object2).getUserObject();
        Object object4 = object3 instanceof ConditionalBlockRef ? "New IF Conditional" : "New IF Block";
        object4 = new NameDialog((Dialog)this._parent, (String)object4, true, 2);
        object4.setVisible(true);
        if (object4.isCanceled()) {
            return;
        }
        ConditionalBlockRef conditionalBlockRef = null;
        RssConditional rssConditional = new RssConditional(0);
        this._currentZone = this.getZoneForNode((DefaultMutableTreeNode)object2);
        if (object3 instanceof ConditionalBlockRef) {
            object = ((ConditionalBlockRef)object3).getConditionalBlock();
            rssConditional.setName(object4.getName());
            rssConditional.setDescription(object4.getDescription());
            object4 = object2;
            defaultMutableTreeNode = new ConditionalTreeNode(this._ruleTree, rssConditional);
            ((DefaultMutableTreeNode)object4).add(defaultMutableTreeNode);
            object.addConditional((Conditional)rssConditional);
        } else {
            object = this._divOps.getConditionalBlock(object4.getName());
            if (object != null) {
                RMAIO.postError((Component)((Object)this), (String)("A Conditional Block with the name\n" + object4.getName() + " already exists!\n"));
                this.addIfCondition();
                return;
            }
            object = this._divOps.createNewConditionalBlock(object4.getName());
            object.setDescription(object4.getDescription());
            object.addConditional((Conditional)rssConditional);
            if (!(object3 instanceof Conditional)) {
                conditionalBlockRef = this._currentZone.addConditionalBlock((ConditionalBlock)object);
                object4 = new ConditionalRefTreeNode(this._ruleTree, conditionalBlockRef);
            } else {
                conditionalBlockRef = new ConditionalBlockRef(this._currentZone, (ConditionalBlock)object);
                object4 = new ConditionalRefTreeNode(this._ruleTree, conditionalBlockRef);
            }
        }
        Object object5 = object4;
        defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object5).getChildAt(((DefaultMutableTreeNode)object5).getChildCount() - 1);
        object = (DefaultTreeModel)this._ruleTree.getModel();
        if (object3 instanceof OpRuleRef) {
            object3 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            this._intarray[0] = ((DefaultMutableTreeNode)object3).getIndex((TreeNode)object2);
            this._intarray[0] = this._intarray[0] + 1;
            ((DefaultMutableTreeNode)object3).insert((MutableTreeNode)object4, this._intarray[0]);
            object2 = object3;
        } else if (object3 instanceof RssConditional) {
            ((RssConditional)object3).addConditionalBlock(conditionalBlockRef);
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex((TreeNode)object4);
        } else if (object3 instanceof ConditionalBlockRef) {
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex(defaultMutableTreeNode);
        } else {
            ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object4);
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex((TreeNode)object4);
        }
        if (this._intarray[0] != -1) {
            ((DefaultTreeModel)object).nodesWereInserted((TreeNode)object2, this._intarray);
        }
        this.setModified(true);
        this.expandAllTreeNodes();
        object3 = new TreePath(defaultMutableTreeNode.getPath());
        this._ruleTree.setSelectionPath((TreePath)object3);
        this._ruleTree.scrollPathToVisible((TreePath)object3);
    }

    public void addConditional(int n) {
        Object object;
        Serializable serializable = this._ruleTree.getSelectionPath();
        if (serializable == null) {
            return;
        }
        serializable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = serializable;
        if (serializable == null) {
            return;
        }
        while (!((object = defaultMutableTreeNode.getUserObject()) instanceof ConditionalBlockRef) && !(object instanceof ConditionalBlock) && (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) != null) {
        }
        if (defaultMutableTreeNode == null) {
            return;
        }
        RssConditional rssConditional = new RssConditional(n);
        ConditionalTreeNode conditionalTreeNode = new ConditionalTreeNode(this._ruleTree, rssConditional);
        Object object2 = object = object instanceof ConditionalBlock ? (ConditionalBlock)object : ((ConditionalBlockRef)object).getConditionalBlock();
        if (n == 1 && serializable instanceof ConditionalTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
            int n2 = defaultMutableTreeNode2.getIndex((TreeNode)((Object)serializable));
            object.addConditional(++n2, (Conditional)rssConditional);
        } else {
            object.addConditional((Conditional)rssConditional);
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._ruleTree.getModel();
        Object object3 = defaultMutableTreeNode.getUserObject();
        if (object3 instanceof OpRuleRef) {
            object3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            this._intarray[0] = ((DefaultMutableTreeNode)object3).getIndex(defaultMutableTreeNode);
            this._intarray[0] = this._intarray[0] + 1;
            ((DefaultMutableTreeNode)object3).insert(conditionalTreeNode, this._intarray[0]);
            defaultTreeModel.nodesWereInserted((TreeNode)object3, this._intarray);
            this.setModified(true);
        } else {
            ((ConditionalBlockTreeNode)defaultMutableTreeNode).update();
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
            this.setModified(true);
        }
        this.expandAllTreeNodes();
        object3 = new TreePath(conditionalTreeNode.getPath());
        this._ruleTree.setSelectionPath((TreePath)object3);
    }

    public void addIfCondition() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        Object object2 = this._ruleTree.getSelectionPath();
        if (object2 == null) {
            return;
        }
        if ((object2 = (DefaultMutableTreeNode)((TreePath)object2).getLastPathComponent()) == null) {
            return;
        }
        Object object3 = ((DefaultMutableTreeNode)object2).getUserObject();
        Object object4 = object3 instanceof ConditionalBlockRef ? "New IF Conditional" : "New IF Block";
        object4 = new NameDialog((Dialog)this._parent, (String)object4, true, 2);
        object4.setVisible(true);
        if (object4.isCanceled()) {
            return;
        }
        ConditionalBlockRef conditionalBlockRef = null;
        RssConditional rssConditional = new RssConditional(0);
        this._currentZone = this.getZoneForNode((DefaultMutableTreeNode)object2);
        if (object3 instanceof ConditionalBlockRef) {
            object = ((ConditionalBlockRef)object3).getConditionalBlock();
            rssConditional.setName(object4.getName());
            rssConditional.setDescription(object4.getDescription());
            object4 = object2;
            defaultMutableTreeNode = new ConditionalTreeNode(this._ruleTree, rssConditional);
            ((DefaultMutableTreeNode)object4).add(defaultMutableTreeNode);
            object.addConditional((Conditional)rssConditional);
        } else {
            object = this._divOps.getConditionalBlock(object4.getName());
            if (object != null) {
                RMAIO.postError((Component)((Object)this), (String)("A Conditional Block with the name\n" + object4.getName() + " already exists!\n"));
                this.addIfCondition();
                return;
            }
            object = this._divOps.createNewConditionalBlock(object4.getName());
            object.setDescription(object4.getDescription());
            object.addConditional((Conditional)rssConditional);
            if (!(object3 instanceof Conditional)) {
                conditionalBlockRef = this._currentZone.addConditionalBlock((ConditionalBlock)object);
                object4 = new ConditionalRefTreeNode(this._ruleTree, conditionalBlockRef);
            } else {
                conditionalBlockRef = new ConditionalBlockRef(this._currentZone, (ConditionalBlock)object);
                object4 = new ConditionalRefTreeNode(this._ruleTree, conditionalBlockRef);
            }
        }
        Object object5 = object4;
        defaultMutableTreeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object5).getChildAt(((DefaultMutableTreeNode)object5).getChildCount() - 1);
        object = (DefaultTreeModel)this._ruleTree.getModel();
        if (object3 instanceof OpRuleRef) {
            object3 = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object2).getParent();
            this._intarray[0] = ((DefaultMutableTreeNode)object3).getIndex((TreeNode)object2);
            this._intarray[0] = this._intarray[0] + 1;
            ((DefaultMutableTreeNode)object3).insert((MutableTreeNode)object4, this._intarray[0]);
            object2 = object3;
        } else if (object3 instanceof RssConditional) {
            ((RssConditional)object3).addConditionalBlock(conditionalBlockRef);
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex((TreeNode)object4);
        } else if (object3 instanceof ConditionalBlockRef) {
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex(defaultMutableTreeNode);
        } else {
            ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object4);
            this._intarray[0] = ((DefaultMutableTreeNode)object2).getIndex((TreeNode)object4);
        }
        if (this._intarray[0] != -1) {
            ((DefaultTreeModel)object).nodesWereInserted((TreeNode)object2, this._intarray);
        }
        this.setModified(true);
        this.expandAllTreeNodes();
        object3 = new TreePath(defaultMutableTreeNode.getPath());
        this._ruleTree.setSelectionPath((TreePath)object3);
        this._ruleTree.scrollPathToVisible((TreePath)object3);
    }

    public void addElseIfCondition() {
        this.addConditional(1);
    }

    public void addElseCondition() {
        this.addConditional(2);
    }

    public StorageZone getZoneForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if ((defaultMutableTreeNode = this.getZoneNodeForNode(defaultMutableTreeNode)) != null) {
            return (StorageZone)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    protected DefaultMutableTreeNode getZoneNodeForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode == null) {
            return this._root;
        }
        if (defaultMutableTreeNode.getUserObject() instanceof StorageZone) {
            return defaultMutableTreeNode;
        }
        return this.getZoneNodeForNode((DefaultMutableTreeNode)defaultMutableTreeNode.getParent());
    }

    private void removeRuleAction() {
        if (this._currentRule == null && this._currentRuleRef == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Rule Selected.", "ResSim - Remove Rule Error", 0);
            return;
        }
        Serializable serializable = this._ruleTree.getSelectionPath();
        String string = this._currentRule != null ? this._currentRule.getName() : this._currentRuleRef.getName();
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Remove Rule \"" + string + "\" from \"" + ((DefaultMutableTreeNode)(serializable = (DefaultMutableTreeNode)((TreePath)serializable).getParentPath().getLastPathComponent())).getUserObject().toString() + "\"", "ResSim - Remove Rule", 2, 2);
        if (n != 0) {
            return;
        }
        if (((DefaultMutableTreeNode)serializable).getUserObject() instanceof StorageZone) {
            if (this._currentRule != null) {
                this._currentZone.removeRule(this._currentRule);
            } else {
                this._currentZone.removeRule(this._currentRuleRef);
            }
        } else if (((DefaultMutableTreeNode)serializable).getUserObject() instanceof RssConditional) {
            if (this._currentRule != null) {
                ((RssConditional)((DefaultMutableTreeNode)serializable).getUserObject()).removeRule(this._currentRule);
            } else {
                ((RssConditional)((DefaultMutableTreeNode)serializable).getUserObject()).removeRule(this._currentRuleRef);
            }
        }
        this._currentRuleRef = null;
        this._currentRule = null;
        DiversionPanel diversionPanel = this;
        diversionPanel.fillPanel(diversionPanel._currentOpSet);
        this.setModified(true);
    }

    private void deleteRuleAction() {
        AbstractList abstractList = this.getLocalAndDownstreamRules();
        Object object = new ExistingRuleDlg(this._parent, true);
        object.setTitle("Select Rule(s) to Permanently Delete from all Zones");
        ((ExistingRuleDlg)object).setMultipleDelete();
        ((ExistingRuleDlg)object).setRules(abstractList, null);
        ((ExistingRuleDlg)object).setAddRuleToAllZonesChckbx(false);
        ((ExistingRuleDlg)object).setDefaultController(this._divOps.getController());
        object.setLocation();
        ((ExistingRuleDlg)object).setVisible(true);
        if (((ExistingRuleDlg)object).isCanceled()) {
            return;
        }
        abstractList = ((ExistingRuleDlg)object).getSelectedRules();
        if (((ArrayList)abstractList).isEmpty()) {
            return;
        }
        Object object2 = "";
        for (int i = 0; i < ((ArrayList)abstractList).size(); ++i) {
            object = (OpRule)((ArrayList)abstractList).get(i);
            object2 = (String)object2 + object.getName() + "\n";
        }
        if (((String)object2).length() > 0) {
            if (JOptionPane.showConfirmDialog((Component)((Object)this), "Deleting operating rules will permanently delete them from this Diversion\n\nAre you sure you want to delete:\n " + (String)object2, "Confirm Delete Rule", 0) != 0) {
                return;
            }
            DiversionPanel diversionPanel = this;
            diversionPanel.deleteRules(diversionPanel._divOps, abstractList, true);
        }
    }

    public void deleteRules(DiversionOp diversionOp, List<OpRule> list, boolean n) {
        for (n = 0; n < list.size(); ++n) {
            this.mDeleteRule(diversionOp, list.get(n), true);
        }
    }

    public void mDeleteRule(DiversionOp diversionOp, OpRule opRule, boolean bl) {
        Vector<OpSet> vector;
        int n = opRule.getIndex();
        Object object = opRule.getController();
        diversionOp.deleteOpRule(opRule);
        if (!(opRule instanceof DownstreamOpRule) || opRule instanceof DownstreamCntrlOpRule) {
            Object object2;
            vector = diversionOp.getOperationSets();
            if (vector == null) {
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                object2 = (OpSet)vector.elementAt(i);
                ((OpSet)object2).removeAllRuleRef(object.getIndex(), n);
            }
            ((OpController)object).deleteRule(n);
            Enumeration<TreeNode> enumeration = this._root.breadthFirstEnumeration();
            object2 = new Vector();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                object = defaultMutableTreeNode.getUserObject();
                if (!(object instanceof OpRuleRef) || ((OpRuleRef)object).getRule() != opRule) continue;
                ((Vector)object2).add(defaultMutableTreeNode);
                if (defaultMutableTreeNode == null || this._currentRule == null || !defaultMutableTreeNode.getUserObject().toString().equals(this._currentRule.getName())) continue;
                object = this._ruleTree.getPathForRow(0);
                defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                object = ((TreePath)object).pathByAddingChild(defaultMutableTreeNode);
                this._ruleTree.setSelectionPath((TreePath)object);
            }
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((Vector)object2).elementAt(i);
                ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).remove(defaultMutableTreeNode);
            }
        }
        vector = diversionOp.getDiversionElement().getSystem();
        if (opRule instanceof DownstreamOpRule) {
            int n2 = opRule.getIndex();
            if (opRule instanceof DownstreamCntrlOpRule) {
                n2 = ((DownstreamCntrlOpRule)opRule).getParentRuleIndex();
            }
            int n3 = ((DownstreamOpRule)opRule).getDownstreamControlLocationID();
            ((RssSystem)((Object)vector)).deleteDownstreamOpRule(n3, n2);
        } else if (opRule instanceof SystemHydropowerOpRule) {
            ((RssSystem)((Object)vector)).deleteSystemHydropowerRule(((SystemHydropowerOpRule)opRule).getParentRuleIndex());
        } else if (opRule instanceof TandemSysOpRule) {
            ((RssSystem)((Object)vector)).deleteTandemOpParent(((TandemSysOpRule)opRule).getParentIndex());
        }
        if (bl && this._ruleTree != null) {
            ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
            this.expandAllTreeNodes();
        }
        this.setModified(true);
    }

    public void useExistingRuleAction() {
        int n;
        NamedType namedType;
        Object object;
        Serializable serializable = this.getTreeNode();
        Object object2 = ((DefaultMutableTreeNode)serializable).getUserObject();
        if (object2 instanceof ConditionalBlock || object2 instanceof ConditionalBlockRef) {
            serializable = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
        } else if (object2 instanceof OpRuleRef) {
            serializable = (DefaultMutableTreeNode)((DefaultMutableTreeNode)serializable).getParent();
        }
        object2 = ((DefaultMutableTreeNode)serializable).getUserObject();
        Serializable serializable2 = object2 instanceof StorageZone || object2 instanceof Conditional ? serializable : this.getZoneNodeForNode((DefaultMutableTreeNode)serializable);
        Object object3 = this.getZoneForNode((DefaultMutableTreeNode)serializable);
        Vector<OpRule> vector = this.getLocalAndDownstreamRules();
        object3 = object2 instanceof StorageZone ? ((StorageZone)object2).getPrimaryRules(null) : (object2 instanceof RssConditional ? ((RssConditional)object2).getPrimaryRules(null) : ((StorageZone)object3).getPrimaryRules(null));
        int n2 = object3.size();
        ArrayList<OpRule> arrayList = new ArrayList<OpRule>();
        ArrayList<OpRule> arrayList2 = new ArrayList<OpRule>();
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.get(i);
            if (object instanceof DownstreamOpRule && !(object instanceof DownstreamCntrlOpRule)) {
                arrayList.add((DownstreamOpRule)object);
                continue;
            }
            namedType = (OpRule)object;
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                object = (OpRule)object3.get(n);
                if (object == null || namedType.getIndex() != object.getIndex() || namedType.getController() != ((OpRule)object).getController()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add((OpRule)namedType);
                continue;
            }
            arrayList2.add((OpRule)namedType);
        }
        if (arrayList.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No other existing rules available to add to this Diversion.", "Use Existing Rule", 1);
            return;
        }
        ExistingRuleDlg existingRuleDlg = object2 instanceof ConditionalBlockRef || object2 instanceof RssConditional ? new ExistingRuleDlg(this._parent, true, false) : new ExistingRuleDlg(this._parent, true);
        existingRuleDlg.setAddRuleToAllZonesChckbx(false);
        existingRuleDlg.setRules(arrayList, arrayList2);
        existingRuleDlg.setDefaultController(this._divOps.getController());
        existingRuleDlg.setLocation();
        existingRuleDlg.setVisible(true);
        if (existingRuleDlg.isCanceled()) {
            return;
        }
        object = existingRuleDlg.getSelectedRule();
        if (object == null) {
            return;
        }
        if (object instanceof DownstreamOpRule && !(object instanceof DownstreamCntrlOpRule)) {
            namedType = (DownstreamCntrlOpRule)this._divOps.getController().newRule("Downstream Control Function", object.getName(), ((DownstreamOpRule)object).getDownstreamControlLocationID());
            ((DownstreamCntrlOpRule)namedType).copyParentInto((DownstreamOpRule)object);
            object = namedType;
        }
        if (object != null) {
            int n3;
            namedType = null;
            Object object4 = ((DefaultMutableTreeNode)serializable).getUserObject();
            n = 0;
            if (object4 instanceof StorageZone) {
                namedType = this._currentZone.addRule((OpRule)object);
            } else if (object4 instanceof RssConditional) {
                namedType = ((RssConditional)object4).addRule((OpRule)object);
                n = 1;
            }
            if (existingRuleDlg.addToAllZones()) {
                this._currentRule = object;
                existingRuleDlg.dispose();
                return;
            }
            if (n == 0) {
                this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
                DiversionPanel diversionPanel = this;
                diversionPanel.ruleChangedUpdateParent((DefaultTreeModel)diversionPanel._ruleTree.getModel(), this._root, serializable2.getUserObject(), (OpRuleRef)namedType);
                this.expandAllTreeNodes();
                this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
            }
            if ((n3 = serializable2.getChildCount() - 1) >= 0) {
                serializable = (DefaultMutableTreeNode)serializable2.getChildAt(n3);
                serializable = new TreePath(((DefaultMutableTreeNode)serializable).getPath());
                this._ruleTree.setSelectionPath((TreePath)serializable);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to associate rule.", "New Rule Error", 0);
            return;
        }
        this.setModified(true);
    }

    public void ruleChangedUpdateParent(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode defaultMutableTreeNode, Object object, OpRuleRef opRuleRef) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        int n = defaultMutableTreeNode.getChildCount();
        if (defaultMutableTreeNode.getUserObject() == object) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(opRuleRef);
            defaultMutableTreeNode2.setAllowsChildren(false);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.getIndex(defaultMutableTreeNode2);
            defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (!(defaultMutableTreeNode3 instanceof ConditionalTreeNode) && (object2 = defaultMutableTreeNode3.getUserObject()) == object) {
                object = new DefaultMutableTreeNode(opRuleRef);
                ((DefaultMutableTreeNode)object).setAllowsChildren(false);
                defaultMutableTreeNode3.add((MutableTreeNode)object);
                defaultTreeModel.nodeStructureChanged(defaultMutableTreeNode);
                return;
            }
            this.ruleChangedUpdateParent(defaultTreeModel, defaultMutableTreeNode3, object, opRuleRef);
        }
    }

    private void renameRuleAction() {
        if (this._currentRule == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Rule Selected.", "ResSim - Rule Error", 0);
            return;
        }
        NameDialog nameDialog = new NameDialog((Dialog)this._parent, "Rename Rule", true);
        nameDialog.setNameFieldDocument((Document)new DssPathnamePartDocument());
        nameDialog.setName(this._currentRule.getName());
        nameDialog.setDescription(this._currentRule.getDescription());
        Vector<OpRule> vector = this.getLocalAndDownstreamRules();
        int n = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(vector.get(i).getName());
        }
        nameDialog.setExistingNames(arrayList);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        this._currentRule.setName(nameDialog.getName());
        this._currentRule.setDescription(nameDialog.getDescription());
        TreePath treePath = this._ruleTree.getSelectionPath();
        ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
        this.expandAllTreeNodes();
        this.setModified(true);
        this._ruleTree.setSelectionPath(treePath);
    }

    public Vector<OpRule> getLocalAndDownstreamRules() {
        Vector<OpRule> vector = this._divOps.getRules();
        return vector;
    }

    private void newRuleAction() {
        OpRule opRule;
        NamedType namedType;
        Object object;
        Serializable serializable;
        block18: {
            int n;
            do {
                this._currentOpSet = (OpSet)this._opSetCombo.getSelectedItem();
                if (this._currentOpSet == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Create Operation Set before creating rules.", "ResSim - New Rule Error", 0);
                    return;
                }
                serializable = this.getTreeNode();
                if (this._ruleDlg == null) {
                    this._ruleDlg = new RuleDlg((Dialog)this._parent, true, this._divOps);
                }
                this._ruleDlg.setResOpSetRules(this._divOps);
                if (this._parent instanceof ReservoirJFrame) {
                    this._ruleDlg.setDownstreamLocationVec(((ReservoirJFrame)((Object)this._parent)).getDownStreamLocationVec());
                }
                this._ruleDlg.setVisible(true);
                object = this._ruleDlg.getName().trim();
                if (this._ruleDlg.isCanceled()) {
                    return;
                }
                namedType = this._ruleDlg.getSelectedController();
                if (namedType == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No Release Location selected for Rule.", "ResSim - New Rule Error", 0);
                    return;
                }
                if (this._parent != null) {
                    this._parent.toFront();
                }
                if ((opRule = namedType.getRule((String)object)) == null) break block18;
            } while ((n = JOptionPane.showConfirmDialog((Component)((Object)this), "The rule name has to be unique.\nPlease enter a new name.", "", 2, 1)) == 0);
            return;
        }
        opRule = namedType.newRule(this._ruleDlg.getRuleType(), (String)object, this._ruleDlg.getDnstrmNodeIndex());
        if (opRule != null) {
            if (serializable.getUserObject() instanceof ConditionalBlock) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (serializable.getUserObject() instanceof OpRuleRef) {
                serializable = (DefaultMutableTreeNode)serializable.getParent();
            }
            if (opRule instanceof DiversionDemandOpRule) {
                ((DiversionDemandOpRule)opRule).setRule(new ConstantRelease((OpController)namedType));
            }
            object = serializable.getUserObject();
            namedType = null;
            boolean bl = false;
            if (object instanceof StorageZone) {
                namedType = this._currentZone.addRule(opRule);
            } else if (object instanceof RssConditional) {
                namedType = ((RssConditional)object).addRule(opRule);
                bl = true;
            }
            if (namedType == null) {
                return;
            }
            this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
            if (!bl) {
                DiversionPanel diversionPanel = this;
                DefaultMutableTreeNode defaultMutableTreeNode = serializable;
                diversionPanel.ruleChangedUpdateParent((DefaultTreeModel)diversionPanel._ruleTree.getModel(), defaultMutableTreeNode, defaultMutableTreeNode.getUserObject(), (OpRuleRef)namedType);
            }
            this.expandAllTreeNodes();
            this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
            int n = serializable.getChildCount() - 1;
            if (n >= 0) {
                serializable = (DefaultMutableTreeNode)serializable.getChildAt(n);
                serializable = new TreePath(serializable.getPath());
                this._ruleTree.setSelectionPath((TreePath)serializable);
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to create rule.", "ResSim - New Rule Error", 0);
            return;
        }
        this.setModified(true);
    }

    private DefaultMutableTreeNode getTreeNode() {
        Serializable serializable = this._ruleTree.getSelectionPath();
        if (serializable == null || (serializable = (DefaultMutableTreeNode)serializable.getLastPathComponent()) == null) {
            serializable = this._root;
        }
        return serializable;
    }

    private void duplicateOpsAction() {
        if (this._currentOpSet == null) {
            RMAIO.postError((Component)((Object)this), (String)"No Operation set to duplicate");
            return;
        }
        Object object = new NameDialog((Dialog)this._parent, "Duplicate Operation Set", true);
        object.setTitle("Duplicate Operation Set");
        object.setExistingNames(this._divOps.getOperationSetNames());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        Object object2 = object.getName();
        object = object.getDescription();
        if ("".equals(object2)) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have blank name");
            return;
        }
        object2 = this._divOps.addDuplicateOpSet(this._currentOpSet.getIndex(), (String)object2);
        object2.setDescription((String)object);
        this._opSetCombo.removeItemListener(this._opsComboListener);
        this._opSetCombo.addItem(object2);
        this._opSetCombo.setSelectedItem(object2);
        this._opSetCombo.addItemListener(this._opsComboListener);
        this._currentOpSet = object2;
        this.fillPanel((OpSet)object2);
        this.setModified(true);
    }

    private void deleteOpsAction() {
        Vector<OpSet> vector = this._divOps.getOperationSets();
        if (vector == null || vector.isEmpty()) {
            RMAIO.postWarning((Component)((Object)this), (String)"No Operation Sets Exist");
            return;
        }
        Object[] objectArray = new OpSet[vector.size()];
        vector.copyInto(objectArray);
        vector = new JNameSelectDialog(this._parent, true);
        vector.setTitle("Select Operation Set to Delete");
        ((JNameSelectDialog)((Object)vector)).setData(objectArray);
        ((JNameSelectDialog)((Object)vector)).setVisible(true);
        if (((JNameSelectDialog)((Object)vector)).isCanceled()) {
            return;
        }
        int n = RMAIO.postYesNoWarning((Component)((Object)this), (String)("Do you really want to delete " + (vector = (OpSet)((JNameSelectDialog)((Object)vector)).getSelectedName()).getName()));
        if (n == 1) {
            return;
        }
        this._opSetCombo.removeItemListener(this._opsComboListener);
        n = ((RmaListModel)this._opSetCombo.getModel()).getIndexOf((Object)vector);
        int n2 = this._opSetCombo.getSelectedIndex();
        this._opSetCombo.removeItem((Object)vector);
        this._divOps.removeOpSet((OpSet)((Object)vector));
        if (this._opSetCombo.getItemCount() <= 0) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "empty");
            this._root.removeAllChildren();
            ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
            this.setOperationsMenuEnabled(false);
        } else if (n == n2) {
            this._opDescFld.setText("");
            this._root.removeAllChildren();
            ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
            this.expandAllTreeNodes();
            this._opSetCombo.setSelectedIndex(0);
            vector = (OpSet)this._opSetCombo.getSelectedItem();
            this.fillPanel((OpSet)((Object)vector));
        }
        this._opSetCombo.addItemListener(this._opsComboListener);
        this.setModified(true);
    }

    private void renameOpsAction() {
        RenameDlg renameDlg = new RenameDlg((Dialog)this._parent, "Rename Operation Set", true);
        renameDlg.setNameFieldDocument((Document)new DssPathnamePartDocument());
        OpSet opSet = (OpSet)this._opSetCombo.getSelectedItem();
        if (opSet == null) {
            RMAIO.postError((Component)((Object)this), (String)"Must select a valid Operation Set!");
            return;
        }
        renameDlg.removeFileComponents();
        renameDlg.setName(opSet.getName());
        renameDlg.setDescription(opSet.getDescription());
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        this._opSetCombo.removeItemListener(this._opsComboListener);
        this._opSetCombo.removeItem((Object)opSet);
        opSet.setName(renameDlg.getName());
        opSet.setDescription(renameDlg.getDescription());
        opSet.setModified(true);
        this._opSetCombo.addItem((Object)opSet);
        this._opSetCombo.setSelectedItem((Object)opSet);
        this._opSetCombo.addItemListener(this._opsComboListener);
        this._opDescFld.setText(renameDlg.getDescription());
        this.setModified(true);
    }

    private void newOpsAction() {
        Object object = new NameDialog((Dialog)this._parent, "New Operation Set", true);
        object.setNameFieldDocument((Document)new DssPathnamePartDocument());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        Object object2 = object.getName();
        object = object.getDescription();
        if ("".equals(object2)) {
            RMAIO.postError((Component)((Object)this), (String)"Cannot have blank name");
            return;
        }
        if (this._divOps == null) {
            RMAIO.postError((Component)((Object)this), (String)"Unable to create new operation set. NULL Reservoir Op Object");
            return;
        }
        if (this._divOps.doesOpSetExist((String)object2)) {
            RMAIO.postError((Component)((Object)this), (String)"This Operation Set already exists!");
            return;
        }
        object2 = this._divOps.addNewOpSet((String)object2);
        object2.setDescription((String)object);
        this._opSetCombo.removeItemListener(this._opsComboListener);
        this._opSetCombo.addItem(object2);
        this._opSetCombo.setSelectedItem(object2);
        this._opSetCombo.addItemListener(this._opsComboListener);
        this.fillPanel((OpSet)object2);
        this.setOperationsMenuEnabled(true);
        this.setModified(true);
    }

    public void expandAllTreeNodes() {
        for (int i = 0; i < this._ruleTree.getRowCount(); ++i) {
            Object object = this._ruleTree.getPathForRow(i);
            if (object != null && (object = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent()) instanceof TreeNodeStateListener && !(object = (TreeNodeStateListener)object).shouldTreeNodeExpand()) continue;
            this._ruleTree.expandRow(i);
        }
    }

    public void setOperationsMenuEnabled(boolean bl) {
        this._ruleMenu.setEnabled(bl);
        this._blockMenu.setEnabled(bl);
    }

    public void fillPanel(OpSet objectArray) {
        this._opDescFld.setText("");
        if (objectArray == null) {
            this._ruleMenu.setEnabled(false);
            this._blockMenu.setEnabled(false);
            this._renameOpsMenu.setEnabled(false);
            this._deleteOpsMenu.setEnabled(false);
            this._duplicateOpsMenu.setEnabled(false);
            return;
        }
        this._ruleMenu.setEnabled(true);
        this._blockMenu.setEnabled(true);
        this._renameOpsMenu.setEnabled(true);
        this._deleteOpsMenu.setEnabled(true);
        this._duplicateOpsMenu.setEnabled(true);
        this._currentOpSet = objectArray;
        objectArray = objectArray.getDescription();
        if (objectArray != null) {
            this._opDescFld.setText((String)objectArray);
        }
        objectArray = this._currentOpSet.getSortedZoneVector();
        this._root.removeAllChildren();
        this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
        try {
            this.buildTreeNodes((List<StorageZone>)objectArray);
        }
        finally {
            this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
        }
        if (this._root.getChildCount() > 0) {
            objectArray = (DefaultMutableTreeNode)this._root.getChildAt(0);
            objectArray = objectArray.getPath();
            this._ruleTree.setSelectionPath(new TreePath(objectArray));
            return;
        }
        ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, "empty");
        this._currentPanel = this._emptyPanel;
    }

    private void buildTreeNodes(List<StorageZone> list) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                TreePath treePath = new TreePath(this._root);
                Object object = list.get(i);
                this._currentZone = object;
                this._root = defaultMutableTreeNode = new DefaultMutableTreeNode(object);
                ((DefaultTreeModel)this._ruleTree.getModel()).setRoot(this._root);
                treePath = treePath.pathByAddingChild(defaultMutableTreeNode);
                object = ((StorageZone)object).getZoneObjectsList();
                for (int j = 0; j < object.size(); ++j) {
                    Object object2 = (ZoneObject)object.get(j);
                    object2 = object2 instanceof OpRuleRef ? new DefaultMutableTreeNode(object2) : new ConditionalRefTreeNode(this._ruleTree, (ConditionalBlockRef)object2);
                    defaultMutableTreeNode.add((MutableTreeNode)object2);
                }
                this._ruleTree.setSelectionPath(treePath);
            }
            ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(this._root);
            this.expandAllTreeNodes();
        }
    }

    public void setRssSystem(RssSystem object) {
        this._system = object;
        if (this._system != null) {
            object = this._system.getElementVectorByClass(JunctionElement.class);
            Vector vector = new Vector();
            for (int i = 0; i < object.size(); ++i) {
                Element element = (Element)object.get(i);
                element.getDownstreamNodes(vector);
            }
        }
    }

    public void fillForm(DiversionElement object) {
        int n;
        OpSet opSet;
        this.clearPanel();
        if (object == null) {
            return;
        }
        this._diversion = object;
        this._divOps = this._diversion.getDiversionOps().clone();
        object = this._divOps.getOperationSets();
        RmaListModel rmaListModel = new RmaListModel(true, (Collection)object);
        this._opSetCombo.setModel((ComboBoxModel)rmaListModel);
        String string = null;
        if (this._rssAlt != null && (opSet = this._divOps.getOperationSet(n = this._rssAlt.getDivOpSetSelection(this._diversion.getIndex()))) != null) {
            string = opSet.getName();
        }
        if (!rmaListModel.isEmpty() && string == null) {
            this._opSetCombo.setSelectedIndex(0);
        } else if (string != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                OpSet opSet2 = (OpSet)((Vector)object).get(i);
                if (!string.equals(opSet2.toString())) continue;
                this._opSetCombo.setSelectedItem((Object)opSet2);
                break;
            }
        } else {
            this._ruleMenu.setEnabled(false);
            this._blockMenu.setEnabled(false);
            this._renameOpsMenu.setEnabled(false);
            this._deleteOpsMenu.setEnabled(false);
            this._duplicateOpsMenu.setEnabled(false);
        }
        RssNode rssNode = ((Element)this._diversion).getUpstreamNode();
        if (this._diversion.getSystem().findJunction(rssNode.getLocation(), 5.0) != null) {
            this._computeInUnRegLoopCBox.setEnabled(true);
            this._computeInUnRegLoopCBox.setSelected(this._diversion.getComputeDuringUnReg());
        } else {
            this._computeInUnRegLoopCBox.setEnabled(false);
            this._computeInUnRegLoopCBox.setSelected(false);
        }
        this._fillingForm = false;
    }

    public boolean saveForm(DiversionElement diversionElement) {
        if (diversionElement == null) {
            return true;
        }
        boolean bl = true;
        if (this._currentOpSet == null) {
            return true;
        }
        this._currentOpSet.setDescription(this._opDescFld.getText());
        if (this._rateChangeLimitRulePanel.isVisible()) {
            bl = true & this._rateChangeLimitRulePanel.savePanel();
        }
        if (this._scriptOpRulePanel.isVisible()) {
            bl &= this._scriptOpRulePanel.savePanel();
        }
        if (this._releaseFuncRulePanel.isVisible()) {
            bl &= this._releaseFuncRulePanel.savePanel();
        }
        if (this._divDemandPanel.isVisible()) {
            bl &= this._divDemandPanel.savePanel();
        }
        if (this._conditionalPanel.isVisible()) {
            bl &= this._conditionalPanel.savePanel();
        }
        if (this._ifBlockPanel.isVisible()) {
            bl &= this._ifBlockPanel.savePanel();
        }
        if (bl && this._divOps != null) {
            DiversionOp diversionOp = this._diversion.getDiversionOps();
            diversionOp.copyInto(this._divOps);
            diversionOp.setModified(true);
        }
        if (bl) {
            if (this._computeInUnRegLoopCBox.isEnabled()) {
                this._diversion.setComputeDuringUnReg(this._computeInUnRegLoopCBox.isSelected());
            } else {
                this._diversion.setComputeDuringUnReg(false);
            }
            this._system.setModified(true);
        }
        return bl;
    }

    public void clearPanel() {
        this._ruleListVector.removeAllElements();
        this._ruleHTable.clear();
        this._opSetCombo.removeAllItems();
        this._opDescFld.clearPerformed();
        this._root.setUserObject(null);
        this._root.removeAllChildren();
        ((DefaultTreeModel)this._ruleTree.getModel()).setRoot(this._root);
    }

    OpRule getCurrentRule() {
        return this._currentRule;
    }

    OpRuleRef getCurrentRuleRef() {
        return this._currentRuleRef;
    }

    JTree getRuleTree() {
        return this._ruleTree;
    }

    StorageZone getCurrentZone() {
        return this._currentZone;
    }

    void setCurrentRule(OpRule opRule) {
        this._currentRule = opRule;
    }

    void setCurrentRuleRef(OpRuleRef opRuleRef) {
        this._currentRuleRef = opRuleRef;
    }

    @Override
    public OpSet getCurrentOpSet() {
        return this._currentOpSet;
    }

    @Override
    public JDialog getParentDialog() {
        return this._parent;
    }

    public DiversionOp getDiversionOp() {
        return this._divOps;
    }

    void removeTreeSelectionListener() {
        this._ruleTree.removeTreeSelectionListener(this._ruleTreeSelectionListener);
    }

    void addTreeSelectionListener() {
        this._ruleTree.addTreeSelectionListener(this._ruleTreeSelectionListener);
    }

    ConditionalBlock getCurrentIfBlock() {
        return this._currentIfBlock;
    }

    void setCurrentConditional(Conditional conditional) {
        this._currentConditional = conditional;
    }

    Conditional getCurrentConditional() {
        return this._currentConditional;
    }

    ConditionalPanel getConditionalPanel() {
        return this._conditionalPanel;
    }

    IfBlockPanel getIfBlockPanel() {
        return this._ifBlockPanel;
    }

    @Override
    public RssSystem getSystem() {
        return this._diversion.getSystem();
    }

    @Override
    public Element getElement() {
        return this._diversion;
    }

    @Override
    public ElementOp getElementOp() {
        return this._diversion.getElementOp();
    }

    @Override
    public void treeDataChanged(int n, String string, String string2) {
        this.removeTreeSelectionListener();
        try {
            Object object = this._ruleTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)((TreePath)object).getLastPathComponent();
            if (defaultMutableTreeNode == null) {
                return;
            }
            if (n == 0) {
                Enumeration<TreeNode> enumeration = this._root.breadthFirstEnumeration();
                while (enumeration.hasMoreElements()) {
                    object = (DefaultMutableTreeNode)enumeration.nextElement();
                    Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                    if (!(object2 instanceof OpRuleRef) || !object2.toString().equals(string)) continue;
                    ((OpRuleRef)object2).setName(string2);
                }
                ((DefaultTreeModel)this._ruleTree.getModel()).nodeChanged(defaultMutableTreeNode);
                this.expandAllTreeNodes();
            } else if (defaultMutableTreeNode.getLevel() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                object = (StorageZone)defaultMutableTreeNode2.getUserObject();
                defaultMutableTreeNode2.removeAllChildren();
                List<ZoneObject> list = ((StorageZone)object).getZoneObjectsList();
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    object = list.get(i);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object);
                    if (object instanceof OpRuleRef) {
                        defaultMutableTreeNode3.setAllowsChildren(false);
                    }
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
                ((DefaultTreeModel)this._ruleTree.getModel()).nodeStructureChanged(defaultMutableTreeNode2);
                object = new TreePath(this._root);
                object = ((TreePath)object).pathByAddingChild(defaultMutableTreeNode2);
                object = ((TreePath)object).pathByAddingChild(defaultMutableTreeNode2.getChildAt(list.indexOf(defaultMutableTreeNode.getUserObject())));
                this._ruleTree.setSelectionPath((TreePath)object);
                this.expandAllTreeNodes();
            }
            return;
        }
        finally {
            this.addTreeSelectionListener();
        }
    }

    public void setAlternative(RssAlt rssAlt) {
        this._rssAlt = rssAlt;
    }

    private static /* synthetic */ void a(JSplitPane jSplitPane) {
        jSplitPane.setDividerLocation(0.2);
    }

    static {
        Boolean.getBoolean("DEBUG");
    }
}

