/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.diversion;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.diversion.FlowPanel$1;
import hec.rss.client.diversion.FlowPanel$2;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.Element;
import hec.rss.model.FlowFunction;
import hec.rss.model.JunctionElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class FlowPanel
extends JPanel {
    private RmaJComboBox<RssNode> _flowCombo;
    private RmaJTable _flowTable;
    private G2dPanel _flowPlot;
    private SimpleJTableData _flowData = this.getFlowData();
    private RssSystem _system;

    public FlowPanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        Object object = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)object, gridBagConstraints);
        JLabel jLabel = new JLabel("Flow Location : ");
        jLabel.setDisplayedMnemonic('F');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        object.add((Component)jLabel, gridBagConstraints);
        this._flowCombo = new RmaJComboBox();
        this._flowCombo.setModifiable(true);
        jLabel.setLabelFor((Component)this._flowCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 0, 5);
        object.add((Component)this._flowCombo, gridBagConstraints);
        object = new String[]{"Flow(%S)", "Diversion(%S)"};
        this._flowTable = new RmaJTable((Component)this);
        this._flowTable.setModel((TableModel)new PairedValuesTableModel(object, new boolean[]{true, true}));
        ((PairedValuesTableModel)this._flowTable.getModel()).setShouldAddBlankRows(true);
        this._flowTable.setUnitsHeaderRenderer();
        this._flowTable.setDoubleCellEditor(0);
        this._flowTable.setDoubleCellEditor(1);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        FlowPanel flowPanel = this;
        flowPanel.add((Component)flowPanel._flowTable.getScrollPane(), gridBagConstraints);
        this._flowPlot = new FlowPanel$1(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        FlowPanel flowPanel2 = this;
        flowPanel2.add((Component)flowPanel2._flowPlot, gridBagConstraints);
        FlowPanel flowPanel3 = this;
        flowPanel3.configureFlowPlot(flowPanel3._flowPlot);
        object = new Vector<SimpleJTableData>();
        object.addElement(this._flowData);
        this._flowPlot.setPlotObjects((List)object);
        this._flowPlot.setLabelFontSizes(11, 8, 11, 11);
        this._flowPlot.setTicFontSizes(10, 8, 10, 10);
        this._flowTable.addCellEditorListener((CellEditorListener)new FlowPanel$2(this));
    }

    private void configureFlowPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Flow(%S)";
        g2dPlotProp.y1AxisProp.name = "Diversion(%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void replotFlowTable() {
        this._flowData.setData(this._flowTable, 0, 1);
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        vector.addElement(this._flowData);
        this._flowPlot.setPlotObjects(vector);
        this._flowPlot.paintGfx();
        this._flowPlot.revalidate();
    }

    SimpleJTableData getFlowData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Flow(%S)";
        simpleJTableData.yunits = "Diversion(%S)";
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    void setSystem(RssSystem object) {
        this._system = object;
        object = this._system.getElementVectorByClass(JunctionElement.class);
        Vector vector = new Vector();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            Element element = (Element)((Vector)object).elementAt(i);
            element.getDownstreamNodes(vector);
        }
        RmaListModel rmaListModel = new RmaListModel(false);
        for (int i = 0; i < vector.size(); ++i) {
            object = (RssNode)vector.elementAt(i);
            rmaListModel.addElement(object);
        }
        this._flowCombo.setModel((ComboBoxModel)rmaListModel);
    }

    void fillPanel(FlowFunction flowFunction) {
        int n = flowFunction.getFlowLocationIndex();
        RssNode rssNode = this._system.getNode(n);
        if (rssNode != null) {
            this._flowCombo.setSelectedItem((Object)rssNode);
        }
        FlowPanel flowPanel = this;
        flowPanel.setTable(flowPanel._flowTable, flowFunction.getFlowValues());
        this.replotFlowTable();
    }

    void savePanel(FlowFunction flowFunction) {
        this._flowTable.commitEdit(true);
        Object object = new PairedValues();
        FlowPanel flowPanel = this;
        flowPanel.savePairedValues(flowPanel._flowTable, (PairedValues)object);
        flowFunction.setFlowValues((PairedValues)object);
        object = (RssNode)this._flowCombo.getSelectedItem();
        if (object != null) {
            flowFunction.setFlowLocationIndex(object.getIndex());
        }
    }

    public void clearPanel() {
        this._flowTable.clearCells();
    }

    void savePairedValues(RmaJTable object, PairedValues pairedValues) {
        object = object.getCells();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            if (((Vector)object).elementAt(i) == null || ((Vector)((Vector)object).elementAt(i)).size() < 2) continue;
            String string = ((Vector)((Vector)object).elementAt(i)).elementAt(0).toString();
            String string2 = ((Vector)((Vector)object).elementAt(i)).elementAt(1).toString();
            double d = RMAIO.parseDouble((String)string2);
            double d2 = RMAIO.parseDouble((String)string);
            if (d2 == Double.NEGATIVE_INFINITY && d == Double.NEGATIVE_INFINITY) continue;
            pairedValues.addPair(d2, d);
        }
    }

    private void setTable(RmaJTable rmaJTable, PairedValues pairedValues) {
        rmaJTable.clearCells();
        if (pairedValues != null) {
            ((PairedValuesTableModel)rmaJTable.getModel()).setPairedValues(pairedValues);
        }
    }
}

