/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.diversion;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.gfx2d.SimpleJTableStepData;
import hec.heclib.util.HecTime;
import hec.model.ParamDoubleTableModel;
import hec.rss.client.diversion.MonthlyReleasePanel$1;
import hec.rss.client.diversion.MonthlyReleasePanel$2;
import hec.rss.model.DiversionElement;
import hec.rss.model.MonthlyRelease;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class MonthlyReleasePanel
extends JPanel {
    private RmaJTable _monthTable;
    private G2dPanel _monthPlot;
    private SimpleJTableStepData _monthData = this.getMonthData();
    private DiversionElement _diversion;

    public MonthlyReleasePanel() {
        super(new GridBagLayout());
        this.buildControls();
    }

    protected void buildControls() {
        Object object = new String[]{"Month", "Diversion(%S)"};
        Object[][] objectArray = new Object[][]{{"Jan", ""}, {"Feb", ""}, {"Mar", ""}, {"Apr", ""}, {"May", ""}, {"Jun", ""}, {"Jul", ""}, {"Aug", ""}, {"Sep", ""}, {"Oct", ""}, {"Nov", ""}, {"Dec", ""}};
        this._monthTable = new RmaJTable((Component)this);
        object = new ParamDoubleTableModel(object, new int[]{-1, Parameter.PARAMID_FLOW}, new boolean[]{false, true});
        object.setData(objectArray);
        this._monthTable.setModel((TableModel)object);
        this._monthTable.setUnitsHeaderRenderer();
        this._monthTable.setColumnBackground(0, Color.lightGray);
        this._monthTable.setColumnEnabled(false, 0);
        this._monthTable.setHorizontalAlignment(0, 0);
        this._monthTable.setAddRemoveEnabled(false);
        this._monthTable.setDoubleCellEditor(1);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        object.gridy = 0;
        object.gridwidth = 1;
        object.gridheight = 2;
        object.weightx = 2.0;
        object.weighty = 1.0;
        object.anchor = 18;
        object.fill = 1;
        object.insets = new Insets(10, 5, 0, 0);
        MonthlyReleasePanel monthlyReleasePanel = this;
        monthlyReleasePanel.add((Component)monthlyReleasePanel._monthTable.getScrollPane(), object);
        this._monthPlot = new MonthlyReleasePanel$1(this);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        object.gridy = 0;
        object.gridwidth = 1;
        object.gridheight = 1;
        object.weightx = 0.0;
        object.weighty = 0.0;
        object.ipadx = 80;
        object.ipady = 80;
        object.anchor = 17;
        object.fill = 0;
        object.insets = new Insets(10, 10, 0, 0);
        MonthlyReleasePanel monthlyReleasePanel2 = this;
        monthlyReleasePanel2.add((Component)monthlyReleasePanel2._monthPlot, object);
        MonthlyReleasePanel monthlyReleasePanel3 = this;
        monthlyReleasePanel3.configureMonthPlot(monthlyReleasePanel3._monthPlot);
        object = new Vector<SimpleJTableStepData>();
        object.addElement(this._monthData);
        this._monthPlot.setPlotObjects((List)object);
        this._monthPlot.setLabelFontSizes(11, 8, 11, 11);
        this._monthPlot.setTicFontSizes(10, 8, 10, 10);
        this._monthTable.addCellEditorListener((CellEditorListener)new MonthlyReleasePanel$2(this));
    }

    private void configureMonthPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Minutes";
        g2dPlotProp.x1AxisProp.type = 1;
        g2dPlotProp.y1AxisProp.name = "Diversion(cfs)";
        g2dPlotProp.x1AxisProp.numTicLabelLayers = 1;
        g2dPlotProp.hasX1Label = false;
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPlotProp.x1AxisProp.isDefaultLimits = false;
        HecTime hecTime = new HecTime("01 January");
        g2dPlotProp.x1AxisProp.min = hecTime.value();
        hecTime = new HecTime("31 December");
        g2dPlotProp.x1AxisProp.max = hecTime.value();
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    private void replotMonthlyTable() {
        this._monthData.clearData();
        this._monthData.setData(this._monthTable, 0, 1);
        this._monthData.lineStyleName = "FLOW";
        this._monthData.name = "Diverted Flow";
    }

    SimpleJTableStepData getMonthData() {
        SimpleJTableStepData simpleJTableStepData = new SimpleJTableStepData();
        new SimpleJTableStepData().xunits = "Minutes";
        simpleJTableStepData.yunits = "Diversion(cfs)";
        simpleJTableStepData.setXAxisType(1);
        simpleJTableStepData.setData(null, -1, -1);
        return simpleJTableStepData;
    }

    void fillPanel(MonthlyRelease monthlyRelease) {
        double[] dArray = monthlyRelease.getMonthlyValues();
        for (int i = 0; i < dArray.length; ++i) {
            this._monthTable.setCell((Object)new ParamDouble(dArray[i], Parameter.PARAMID_FLOW, monthlyRelease.getUnitSystem()), i, 1);
        }
        this.replotMonthlyTable();
    }

    void savePanel(MonthlyRelease monthlyRelease) {
        this._monthTable.commitEdit(true);
        Vector vector = this._monthTable.getCells();
        double[] dArray = new double[12];
        for (int i = 0; i < dArray.length && i < vector.size(); ++i) {
            if (vector.elementAt(i) == null || ((Vector)vector.elementAt(i)).size() < 2) continue;
            Object e = ((Vector)vector.elementAt(i)).elementAt(1);
            dArray[i] = RMAIO.parseDouble((String)e.toString());
        }
        monthlyRelease.setValues(dArray);
    }

    public void clearPanel() {
        for (int i = 0; i < this._monthTable.getRowCount(); ++i) {
            this._monthTable.setCell((Object)"", i, 1);
        }
    }
}

