/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.diversion;

import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.G2dPlotProp;
import hec.gfx2d.HotPlotDefaults;
import hec.gfx2d.PlotDefaults;
import hec.gfx2d.PlotDefaultsManager;
import hec.model.PairedValues;
import hec.model.PairedValuesTableModel;
import hec.rss.client.diversion.PoolPanel$1;
import hec.rss.client.diversion.PoolPanel$2;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.model.PoolElevation;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableModel;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class PoolPanel
extends JPanel {
    private RmaJComboBox _reservoirCombo;
    private RmaJTable _poolTable;
    private G2dPanel _poolPlot;
    private SimpleJTableData _poolData = this.getPoolData();

    public PoolPanel() {
        super(new GridBagLayout());
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        Object object = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.add((Component)object, gridBagConstraints);
        JLabel jLabel = new JLabel("Reservoir");
        jLabel.setDisplayedMnemonic('R');
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        object.add((Component)jLabel, gridBagConstraints);
        this._reservoirCombo = new RmaJComboBox();
        this._reservoirCombo.setModifiable(true);
        jLabel.setLabelFor((Component)this._reservoirCombo);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 0, 5);
        object.add((Component)this._reservoirCombo, gridBagConstraints);
        object = new String[]{"Elevation(%S)", "Diversion(%S)"};
        this._poolTable = new RmaJTable((Component)this, object);
        this._poolTable.setModel((TableModel)new PairedValuesTableModel((String[])object, new boolean[]{true, true}));
        this._poolTable.setUnitsHeaderRenderer();
        this._poolTable.setDoubleCellEditor(0);
        this._poolTable.setDoubleCellEditor(1);
        ((PairedValuesTableModel)this._poolTable.getModel()).setShouldAddBlankRows(true);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        PoolPanel poolPanel = this;
        poolPanel.add((Component)poolPanel._poolTable.getScrollPane(), gridBagConstraints);
        this._poolPlot = new PoolPanel$1(this);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 80;
        gridBagConstraints.ipady = 80;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        PoolPanel poolPanel2 = this;
        poolPanel2.add((Component)poolPanel2._poolPlot, gridBagConstraints);
        PoolPanel poolPanel3 = this;
        poolPanel3.configurePoolPlot(poolPanel3._poolPlot);
        object = new Vector<SimpleJTableData>();
        object.addElement(this._poolData);
        this._poolPlot.setPlotObjects((List)object);
        this._poolPlot.setLabelFontSizes(11, 8, 11, 11);
        this._poolPlot.setTicFontSizes(10, 8, 10, 10);
    }

    protected void addListeners() {
        this._poolTable.addCellEditorListener((CellEditorListener)new PoolPanel$2(this));
    }

    private void configurePoolPlot(G2dPanel g2dPanel) {
        PlotDefaults plotDefaults = PlotDefaultsManager.getDefaults();
        PlotDefaultsManager.setDefaults((PlotDefaults)new HotPlotDefaults());
        G2dPanelProp g2dPanelProp = new G2dPanelProp();
        new G2dPanelProp().hasTitle = false;
        g2dPanelProp.hasToolbar = false;
        g2dPanelProp.hasLegend = false;
        G2dPlotProp g2dPlotProp = new G2dPlotProp();
        new G2dPlotProp().hasXScroll = false;
        g2dPlotProp.hasYScroll = false;
        g2dPlotProp.x1AxisProp.name = "Diversion(%S)";
        g2dPlotProp.y1AxisProp.name = "Elevation(%S)";
        g2dPlotProp.y1AxisProp.isReversed = true;
        g2dPanelProp.addPlotProp(g2dPlotProp);
        g2dPanel.configurePanel(g2dPanelProp);
        PlotDefaultsManager.setDefaults((PlotDefaults)plotDefaults);
    }

    SimpleJTableData getPoolData() {
        SimpleJTableData simpleJTableData = new SimpleJTableData();
        new SimpleJTableData().xunits = "Diversion(%S)";
        simpleJTableData.yunits = "Elevation(%S)";
        simpleJTableData.setData(null, -1, -1);
        return simpleJTableData;
    }

    private void replotPoolTable() {
        this._poolData.setData(this._poolTable, 0, 1);
        Vector<SimpleJTableData> vector = new Vector<SimpleJTableData>();
        vector.addElement(this._poolData);
        this._poolPlot.setPlotObjects(vector);
        this._poolPlot.paintGfx();
        this._poolPlot.revalidate();
    }

    void setSystem(RssSystem rmaListModel) {
        rmaListModel = rmaListModel.getReservoirNames();
        rmaListModel = new RmaListModel(true, (Object[])rmaListModel);
        this._reservoirCombo.setModel((ComboBoxModel)rmaListModel);
    }

    void fillPanel(PoolElevation poolElevation) {
        this._reservoirCombo.setSelectedItem((Object)poolElevation.getReservoirName());
        PoolPanel poolPanel = this;
        poolPanel.setTable(poolPanel._poolTable, poolElevation.getPoolValues());
        this.replotPoolTable();
    }

    void savePanel(PoolElevation poolElevation) {
        this._poolTable.commitEdit(true);
        PairedValues pairedValues = new PairedValues();
        PoolPanel poolPanel = this;
        poolPanel.savePairedValues(poolPanel._poolTable, pairedValues);
        poolElevation.setPoolValues(pairedValues);
        poolElevation.setReservoirName((String)this._reservoirCombo.getSelectedItem());
    }

    private void setTable(RmaJTable rmaJTable, PairedValues pairedValues) {
        rmaJTable.clearCells();
        if (pairedValues != null) {
            ((PairedValuesTableModel)rmaJTable.getModel()).setPairedValues(pairedValues);
        }
    }

    void savePairedValues(RmaJTable object, PairedValues pairedValues) {
        object = object.getCells();
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            if (((Vector)object).elementAt(i) == null || ((Vector)((Vector)object).elementAt(i)).size() < 2) continue;
            String string = ((Vector)((Vector)object).elementAt(i)).elementAt(0).toString();
            String string2 = ((Vector)((Vector)object).elementAt(i)).elementAt(1).toString();
            double d = RMAIO.parseDouble((String)string2);
            double d2 = RMAIO.parseDouble((String)string);
            if (d2 == Double.NEGATIVE_INFINITY && d == Double.NEGATIVE_INFINITY) continue;
            pairedValues.addPair(d2, d);
        }
    }

    public void clearPanel() {
        this._poolTable.clearCells();
    }
}

