/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.gui.AbstractEditorPanel;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSPathname;
import hec.io.DSSIdentifier;
import hec.io.Identifier;
import hec.io.PairedDataContainer;
import hec.rss.client.AltTimeSeriesPanel;
import hec.rss.client.globalvariable.GlobalVariableTableRef;
import hec.rss.model.GVDataSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import rma.util.RMAIO;

public abstract class AbstractGlobalVariablePanel
extends AbstractEditorPanel {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private TsVariant _tsVariant = AltTimeSeriesPanel.l;

    public AbstractGlobalVariablePanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public void setTSVariant(TsVariant tsVariant) {
        this._tsVariant = tsVariant;
    }

    public TsVariant getTSVariant() {
        return this._tsVariant;
    }

    public GVDataSet getGlobalVariableDataSet(RssAlt manager) {
        if (this._tsVariant == null) {
            this._tsVariant = AltTimeSeriesPanel.l;
        }
        if (manager.getInputGVDataSet() == null && this.createInputGVDataSet((RssAlt)manager) == null) {
            this.setIgnoreModifiedEvents(false);
            return null;
        }
        manager = this._tsVariant == AltTimeSeriesPanel.l ? manager.getInputGVDataSet() : manager.getInputGVDataSet(this._tsVariant);
        return manager;
    }

    List<GlobalVariableTableRef> buildTableComboValues(RssSystem rssSystem, GVDataSet object, TableGlobalVariable tableGlobalVariable) {
        List<Object> list = new ArrayList();
        if ((object = object.getGlobalVariableData(tableGlobalVariable.getIndex(), tableGlobalVariable.getType())) instanceof AltTableGlobalData) {
            object = rssSystem.getGlobalVariableTablesFile();
            try {
                Object object2 = new ArrayList(rssSystem.getDSSFileManager().getCondensedCatalog((String)object));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    CondensedReference condensedReference = (CondensedReference)object2.next();
                    condensedReference = new DSSPathname(condensedReference.getFirstPathname());
                    Object object3 = new DSSIdentifier((String)object, condensedReference.getPathname());
                    int n = rssSystem.getDSSFileManager().recordType(object3);
                    if (n != 200 && n != 205 || (object3 = rssSystem.getDSSFileManager().readPairedDataContainer(object3)) == null || !this.parametersMatch((PairedDataContainer)object3, tableGlobalVariable) || (object3 = condensedReference.getBPart()) == null) continue;
                    list.add(new GlobalVariableTableRef((String)object3, condensedReference.getPathname(), (String)object));
                }
            }
            catch (RemoteException remoteException) {
                ((FluentLogger.Api)((FluentLogger.Api)a.atWarning()).withCause((Throwable)remoteException)).log("Failed to read pathnames for " + (String)object);
            }
        }
        list = list.stream().distinct().collect(Collectors.toList());
        return list;
    }

    private boolean parametersMatch(PairedDataContainer stringArray, TableGlobalVariable tableGlobalVariable) {
        if (tableGlobalVariable.getIndependentList() == null || tableGlobalVariable.getIndependentList().isEmpty()) {
            return false;
        }
        String string = tableGlobalVariable.getIndependentList().get(0).getValue();
        if (!stringArray.xparameter.equalsIgnoreCase(string)) {
            return false;
        }
        stringArray = stringArray.yparameter.split("-");
        if (stringArray.length == 2) {
            if (tableGlobalVariable.getIndependentList().size() != 2 || !stringArray[0].equalsIgnoreCase(tableGlobalVariable.getIndependentList().get(1).getValue()) || !stringArray[1].equalsIgnoreCase(tableGlobalVariable.getDependentList().get(0).getValue())) {
                return false;
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(tableGlobalVariable.getDependentList().get(i).getValue())) continue;
                return false;
            }
        }
        return true;
    }

    protected GVDataSet createInputGVDataSet(RssAlt rssAlt) {
        if (rssAlt != null) {
            ManagerProxyListContainer managerProxyListContainer = rssAlt.getProxyList().getContainer();
            RmiWorkspace rmiWorkspace = managerProxyListContainer.getChildWorkspace("");
            Object object = "";
            try {
                object = rmiWorkspace.getWorkspacePath();
            }
            catch (RemoteException remoteException) {
                System.out.println("createInputGVDataSet:failed to get Workspace path " + String.valueOf(remoteException));
            }
            rmiWorkspace = this.getManagerIdentifier((String)object, "rss", GVDataSet.class.getName(), rssAlt.getName(), "igv");
            object = (GVDataSet)managerProxyListContainer.newManager("rss", GVDataSet.class.getName());
            object.setName(rssAlt.getName());
            object.setDescription(rssAlt.getDescription() + " (Global Variable Data Set)");
            if (!managerProxyListContainer.saveManagerAs("rss", (Manager)object, (Identifier)rmiWorkspace)) {
                System.out.println("----------------------------------------------------------------------------------------");
                System.out.println(((Object)((Object)this)).getClass().getName() + ".createInputGVDataSet: ERROR  Unable to create a new Global Variable Data Set");
                System.out.println("----------------------------------------------------------------------------------------");
                return null;
            }
            rssAlt.setGVDataSetPath(object.getIdentifier().getPath());
            return object;
        }
        return null;
    }

    public Identifier getManagerIdentifier(String object, String string, String string2, String string3, String string4) {
        String string5 = RMAIO.userNameToFileName((String)string3.trim());
        String string6 = "/";
        object = (String)object + string6 + string + string6 + string5 + (String)(string4.length() > 0 && string4.charAt(0) == '.' ? string4 : "." + string4);
        object = new Identifier((String)object);
        object.setName(string3);
        object.setClassName(string2);
        return object;
    }

    protected String formDssPathname(RssAlt rssAlt, GlobalVariable globalVariable, DSSPathname dSSPathname) {
        if (dSSPathname == null) {
            dSSPathname = new DSSPathname();
        }
        dSSPathname.setBPart(globalVariable.getName());
        dSSPathname.setDPart(globalVariable.getType().toString());
        dSSPathname.setFPart(rssAlt.getName());
        return dSSPathname.getPathname();
    }
}

