/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.clientapp.client.ClientApp;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.dssgui.DSSListSelector;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.lang.NamedType;
import hec.model.SeasonalRecord;
import hec.model.SeasonalRecordTableModel;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.EditTableHeadersJDialog;
import hec.rss.client.PairedValuesTablePanel;
import hec.rss.client.SeasonalVariationJDialog;
import hec.rss.client.globalvariable.AbstractGlobalVariablePanel;
import hec.rss.client.globalvariable.AltGlobalTablePanel$1;
import hec.rss.client.globalvariable.AltGlobalTablePanel$2;
import hec.rss.client.globalvariable.DSSFilePanel;
import hec.rss.client.globalvariable.EditTableGlobalVariableDlg;
import hec.rss.client.globalvariable.GlobalVariableTableRef;
import hec.rss.client.globalvariable.NewTableNameDialog;
import hec.rss.client.globalvariable.NoManualTableSelectedException;
import hec.rss.model.GVDataSet;
import hec.rss.model.NameValuePair;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.GlobalVariableUtils;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.model.globalvariable.TableType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaTableModel;
import rma.swing.table.UnitsHeaderRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.RMAUtil;

public class AltGlobalTablePanel
extends AbstractGlobalVariablePanel
implements AlternativePanel {
    private final EditTableGlobalVariableDlg _parent;
    private final AlternativeEditor _editor;
    private DSSFilePanel _dssFilePanel;
    private RmaJPanel _simpleTablePanel;
    private RmaJRadioButton _dssRadioButton;
    private RmaJRadioButton _manualRadioButton;
    private ButtonGroup _radioButtonGroup;
    private RssAlt _alternative;
    private RssSystem _system;
    private RmaJTable _manualEntryTable;
    private int _colCount;
    private GVDataSet _dataset;
    private TableGlobalVariable _tgv;
    private PairedValuesTablePanel _complexTablePanel;
    private RmaJPanel _tableCardPanel;
    private RmaJPanel _tablePanel;
    private final RmaJComboBox<TableGlobalVariable> _selectedTableGvCombo = new RmaJComboBox();
    private RmaJDescriptionField _descriptionTextField;
    private boolean _ignoreSelection = false;
    private RmaJPanel _cardPanel;
    private RmaJComboBox<GlobalVariableTableRef> _tableNameComboBox;
    private RmaJButton _newTableButton;
    private JCheckBox _allowEditsCheckbox;
    private JButton _editTableHeadersBtn;

    public AltGlobalTablePanel(EditTableGlobalVariableDlg editTableGlobalVariableDlg, AlternativeEditor alternativeEditor) {
        super(new GridBagLayout());
        this._parent = editTableGlobalVariableDlg;
        this._editor = alternativeEditor;
        this.buildControls();
        this.addListeners();
    }

    public void addListeners() {
        this._selectedTableGvCombo.addItemListener(this::selectionChanged);
        this._dssRadioButton.addActionListener(actionEvent -> this.handleRadioButtons());
        this._manualRadioButton.addActionListener(actionEvent -> this.handleRadioButtons());
        this._tableNameComboBox.addActionListener(actionEvent -> this.tableSelected());
        this._newTableButton.addActionListener(actionEvent -> this.newTableAction());
        this._allowEditsCheckbox.addActionListener(actionEvent -> this.allowEditsAction());
        this._editTableHeadersBtn.addActionListener(actionEvent -> this.editTableHeadersAction());
    }

    private void allowEditsAction() {
        this._manualEntryTable.commitEdit(true);
        this._complexTablePanel.commitEdit(true);
        this.handleEnablingManualTable();
    }

    private void newTableAction() {
        AltGlobalTablePanel altGlobalTablePanel = this;
        Object object = altGlobalTablePanel.buildTableComboValues(altGlobalTablePanel._system, this._dataset, this._tgv).stream().map(GlobalVariableTableRef::a).collect(Collectors.toList());
        object = new NewTableNameDialog((Window)((Object)this._parent), true, (List<String>)object, this::newTableNameCreated);
        object.setVisible(true);
    }

    private void newTableNameCreated(String string) {
        Object object = this._dataset.getGlobalVariableData(this._tgv.getIndex(), this._tgv.getType());
        if (object instanceof AltTableGlobalData) {
            ((AltTableGlobalData)object).setPairedData(null);
        }
        AltGlobalTablePanel altGlobalTablePanel = this;
        object = altGlobalTablePanel.buildTableComboValues(altGlobalTablePanel._system, this._dataset, this._tgv);
        object.add(0, (GlobalVariableTableRef)new GlobalVariableTableRef(string, GlobalVariableUtils.a(this._tgv, string), this._system.getGlobalVariableTablesFile()));
        string = new RmaListModel();
        string.addAll((Collection)object);
        this._tableNameComboBox.setModel((ComboBoxModel)((Object)string));
        this._tableNameComboBox.setSelectedIndex(0);
        this._allowEditsCheckbox.setSelected(true);
        this.allowEditsAction();
    }

    private void tableSelected() {
        Object object = this._tableNameComboBox.getSelectedItem();
        if (object != null) {
            this._allowEditsCheckbox.setEnabled(true);
            object = this._dataset.getGlobalVariableData(this._tgv.getIndex(), this._tgv.getType());
            if (object instanceof AltTableGlobalData) {
                AltGlobalTablePanel altGlobalTablePanel = this;
                altGlobalTablePanel.fillManualTable(altGlobalTablePanel._tgv, (AltTableGlobalData)object);
            }
        }
        this._allowEditsCheckbox.setSelected(false);
        this.handleEnablingManualTable();
        this._tableNameComboBox.setToolTipText(this.getTableNameToolTipText());
    }

    private String getTableNameToolTipText() {
        Object object = this._tableNameComboBox.getSelectedItem();
        if (object instanceof GlobalVariableTableRef) {
            String string = ((GlobalVariableTableRef)object).b();
            object = ((GlobalVariableTableRef)object).c();
            object = this._system.getRelativePath((String)object);
            return "<html>" + (String)object + "<br>" + string + "</html>";
        }
        return null;
    }

    private void selectionChanged(ItemEvent object) {
        Object object2 = this._selectedTableGvCombo.getSelectedItem();
        if (!this._ignoreSelection && ((ItemEvent)object).getStateChange() == 1 && object2 instanceof TableGlobalVariable && this._tgv != null && this._tgv != object2) {
            object = this._tgv;
            if (this.isModified()) {
                SwingUtilities.invokeLater(() -> this.lambda$selectionChanged$6(object2, (TableGlobalVariable)object));
                return;
            }
            this.fillPanel((TableGlobalVariable)object2);
        }
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            RMAUtil.setParentModified((Component)((Object)this));
        }
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this._dssFilePanel = new DSSFilePanel((JDialog)((Object)this._parent), this, GlobalVariableType.TABLE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._simpleTablePanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._complexTablePanel = new PairedValuesTablePanel();
        this._complexTablePanel.setAddRemoveButtonsVisible(false);
        this._tablePanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._cardPanel.setBorder((Border)new TitledBorder("Manual Entry"));
        this.addManualEntry();
        this._tableCardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        Object object = new RmaJPanel((LayoutManager)new GridBagLayout());
        JLabel jLabel = new JLabel("Table Name:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        object.add((Component)jLabel, (Object)gridBagConstraints);
        this._tableNameComboBox = new RmaJComboBox();
        this._tableNameComboBox.setModel((ComboBoxModel)new RmaListModel());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        object.add(this._tableNameComboBox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0505;
        this._tablePanel.add((Component)object, (Object)gridBagConstraints);
        this._newTableButton = new RmaJButton("New...");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        this._tablePanel.add((Component)this._newTableButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        this._tablePanel.add((Component)this._tableCardPanel, (Object)gridBagConstraints);
        this._allowEditsCheckbox = new JCheckBox("Allow Edits");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)2, (int)0, (int)5);
        this._tablePanel.add((Component)this._allowEditsCheckbox, (Object)gridBagConstraints);
        this._editTableHeadersBtn = new JButton("Edit ...");
        this._editTableHeadersBtn.setToolTipText("Edit Table Header Values");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._tablePanel.add((Component)this._editTableHeadersBtn, (Object)gridBagConstraints);
        object = new JLabel("");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)object, gridBagConstraints);
        this._tableCardPanel.add((Component)this._simpleTablePanel, (Object)"simpleTablePanel");
        this._tableCardPanel.add((Component)((Object)this._complexTablePanel), (Object)"complexTablePanel");
        object = new JLabel("Table Global Variable:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)object, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add(this._selectedTableGvCombo, (Object)gridBagConstraints);
        object = new JLabel("Description:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)object, (Object)gridBagConstraints);
        this._descriptionTextField = new AltGlobalTablePanel$1(this);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._descriptionTextField, (Object)gridBagConstraints);
        this.addRadioButtons((JPanel)rmaJPanel);
        this._cardPanel.add((Component)this._tablePanel, (Object)"ShowTablePanel");
        this._cardPanel.add((Component)((Object)this._dssFilePanel), (Object)"ShowDSSPanel");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5000;
        rmaJPanel.add((Component)this._cardPanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)rmaJPanel, gridBagConstraints);
    }

    private void addManualEntry() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._manualEntryTable = new AltGlobalTablePanel$2(this);
        this._manualEntryTable.setTableHeader((JTableHeader)new GroupableTableHeader(this._manualEntryTable.getColumnModel()));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0E-4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._simpleTablePanel.add((Component)this._manualEntryTable.getScrollPane(), (Object)gridBagConstraints);
    }

    private void addRadioButtons(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._dssRadioButton = new RmaJRadioButton("DSS");
        this._manualRadioButton = new RmaJRadioButton("Manual Entry");
        this._radioButtonGroup = new ButtonGroup();
        this._radioButtonGroup.add((AbstractButton)this._dssRadioButton);
        this._radioButtonGroup.add((AbstractButton)this._manualRadioButton);
        this._radioButtonGroup.setSelected(this._dssRadioButton.getModel(), true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        jPanel.add((Component)this._manualRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        jPanel.add((Component)this._dssRadioButton, gridBagConstraints);
    }

    @Override
    public boolean savePanel(RssAlt object) {
        boolean bl = false;
        if (object == null) {
            object = this._alternative;
        }
        this._manualEntryTable.commitEdit(true);
        if (object != null) {
            object = this._selectedTableGvCombo.getSelectedItem();
            if (object instanceof TableGlobalVariable) {
                try {
                    bl = this.saveTableGv((TableGlobalVariable)object);
                }
                catch (NoManualTableSelectedException | IllegalArgumentException exception) {
                    JOptionPane.showMessageDialog((Component)((Object)this), exception.getMessage(), "Save Failed", 0);
                    bl = false;
                }
            }
            this.setModified(false);
        }
        return bl;
    }

    boolean saveTableGv(TableGlobalVariable tableGlobalVariable) throws NoManualTableSelectedException, IllegalArgumentException {
        AltTableGlobalData altTableGlobalData = (AltTableGlobalData)this._dataset.getGlobalVariableData(tableGlobalVariable.getIndex(), tableGlobalVariable.getType());
        if (altTableGlobalData == null) {
            altTableGlobalData = (AltTableGlobalData)this._dataset.createGVRecord(GlobalVariableType.TABLE, tableGlobalVariable.getIndex());
        }
        this.setDssFilePath(tableGlobalVariable, altTableGlobalData);
        tableGlobalVariable.setIsDSS(this._dssRadioButton.isSelected());
        boolean bl = this._manualRadioButton.isSelected() ? this.saveManual(tableGlobalVariable, altTableGlobalData) : this._dssFilePanel.savePanel(this._alternative);
        return bl;
    }

    private boolean saveManual(TableGlobalVariable object, AltTableGlobalData altTableGlobalData) throws NoManualTableSelectedException, IllegalArgumentException {
        PairedDataContainer pairedDataContainer;
        if (this._tableNameComboBox.getSelectedItem() == null) {
            throw new NoManualTableSelectedException();
        }
        if (altTableGlobalData == null) {
            altTableGlobalData = (AltTableGlobalData)this._dataset.createGVRecord(GlobalVariableType.TABLE, object.getIndex());
        }
        if ((pairedDataContainer = this.getPairedData()) != null && pairedDataContainer.numberOrdinates == 0) {
            throw new IllegalArgumentException("At least 1 row of data is required to save table");
        }
        if (altTableGlobalData != null) {
            altTableGlobalData.setPairedData(pairedDataContainer);
            altTableGlobalData.setPairedData(this.getPairedData());
            this.setDssFilePath((TableGlobalVariable)object, altTableGlobalData);
            altTableGlobalData.setDescription(this._descriptionTextField.getText().trim());
            object = this._system.getGlobalVariableTablesFile();
            pairedDataContainer = new DSSPathname(altTableGlobalData.getDSSPathname());
            Object object2 = this._tableNameComboBox.getSelectedItem();
            if (object2 instanceof GlobalVariableTableRef) {
                pairedDataContainer.setBPart(((GlobalVariableTableRef)object2).a());
                pairedDataContainer.setFPart(this._tgv.getTableType().toString());
                altTableGlobalData.setValue(((GlobalVariableTableRef)object2).a());
            }
            altTableGlobalData.getPairedData().fullName = pairedDataContainer.getPathname();
            altTableGlobalData.getPairedData().fileName = object;
            altTableGlobalData.setIsDss(false);
        }
        return this._dataset.saveManager();
    }

    protected void setDssFilePath(TableGlobalVariable object, AltTableGlobalData altTableGlobalData) {
        DSSPathname dSSPathname = new DSSPathname();
        String string = this._system.getGlobalVariableTablesFile();
        altTableGlobalData.setDSSFilename(string);
        string = object.getName();
        dSSPathname.setBPart(string);
        dSSPathname.setCPart(GlobalVariableUtils.a((TableGlobalVariable)object));
        dSSPathname.setFPart(this._alternative.getName() + "-" + this.getTSVariant().getName());
        altTableGlobalData.setName(object.getName());
        object = dSSPathname.getPathname();
        altTableGlobalData.setDSSPathname((String)object);
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        this._dssFilePanel.setSystem(rssSystem);
    }

    @Override
    public void clearPanel() {
        RmaTableModel rmaTableModel = (RmaTableModel)this._manualEntryTable.getModel();
        String[] stringArray = new String[this._colCount];
        for (int i = 0; i < this._colCount; ++i) {
            stringArray[i] = "";
        }
        rmaTableModel.setColumnNames(stringArray);
        rmaTableModel.fireTableStructureChanged();
        rmaTableModel.clearAll();
        rmaTableModel.fireTableDataChanged();
        this._dssFilePanel.clearPanel();
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        this._alternative = (RssAlt)namedType;
        Object object = this._alternative.getSystem();
        if (object == null) {
            return;
        }
        this.setSystem((RssSystem)object);
        this._dataset = this.getGlobalVariableDataSet(this._alternative);
        object = ((RssSystem)object).getInputGlobalVariables(GlobalVariableType.TABLE).stream().map(TableGlobalVariable.class::cast).collect(Collectors.toList());
        RmaListModel rmaListModel = new RmaListModel();
        rmaListModel.addAll((Collection)object);
        this._selectedTableGvCombo.setModel((ComboBoxModel)rmaListModel);
        this._dssFilePanel.fillPanel(namedType);
        this.setModified(false);
    }

    private void handleRadioButtons() {
        Object object = this._selectedTableGvCombo.getSelectedItem();
        if (object instanceof TableGlobalVariable) {
            object = (TableGlobalVariable)object;
            ((TableGlobalVariable)object).setIsDSS(this._dssRadioButton.isSelected());
            if (this._dssRadioButton.isSelected()) {
                ((TitledBorder)this._cardPanel.getBorder()).setTitle("DSS");
                this._dssFilePanel.setEnabled(true);
                ((CardLayout)this._cardPanel.getLayout()).show((Container)this._cardPanel, "ShowDSSPanel");
            } else {
                ((TitledBorder)this._cardPanel.getBorder()).setTitle("Manual Entry");
                this._dssFilePanel.setEnabled(false);
                ((CardLayout)this._cardPanel.getLayout()).show((Container)this._cardPanel, "ShowTablePanel");
            }
            this._cardPanel.repaint();
            this._dssFilePanel.repaint();
            this._dssFilePanel.revalidate();
        }
        this.handleEnablingManualTable();
        this._manualEntryTable.commitEdit(true);
        this._manualEntryTable.repaint();
    }

    private PairedDataContainer getPairedData() {
        switch (this._tgv.getTableType()) {
            case SIMPLELOOKUPTABLE: 
            case REPORT: {
                return this.getSimplePairedData();
            }
            case TWOVARIABLELOOKUP: {
                return this.getComplexPairedData();
            }
        }
        return null;
    }

    private PairedDataContainer getComplexPairedData() {
        return this._complexTablePanel.savePanel();
    }

    private PairedDataContainer getSimplePairedData() {
        int n;
        this._manualEntryTable.commitEdit(true);
        AltGlobalTablePanel altGlobalTablePanel = this;
        if (altGlobalTablePanel.isDateData(altGlobalTablePanel._tgv) && this._manualEntryTable.getModel() instanceof SeasonalRecordTableModel) {
            SeasonalRecord seasonalRecord = new SeasonalRecord();
            seasonalRecord.setUnitSystem(ClientApp.Workspace().getUnitSystem());
            SeasonalRecordTableModel seasonalRecordTableModel = (SeasonalRecordTableModel)this._manualEntryTable.getModel();
            seasonalRecordTableModel.storeData(seasonalRecord);
            this.checkIfMonotonicallyIncreasingDates(seasonalRecord);
            return this.saveToPairedData(seasonalRecord);
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().numberOrdinates = this.findNumberValidRows();
        pairedDataContainer.numberCurves = this._manualEntryTable.getColumnCount() - 1;
        double[] dArray = new double[pairedDataContainer.numberOrdinates];
        for (int i = 0; i < pairedDataContainer.numberOrdinates; ++i) {
            double d;
            dArray[i] = d = RMAIO.parseDouble((Object)this._manualEntryTable.getValueAt(i, 0));
        }
        pairedDataContainer.xOrdinates = dArray;
        Object object = this._manualEntryTable.getColumnLabel(0);
        if (!"<Undefined>".equals(object)) {
            pairedDataContainer.xunits = object;
        }
        if ((n = this._manualEntryTable.getColumnCount() - 1) < 0) {
            return null;
        }
        double[][] dArray2 = new double[n][pairedDataContainer.numberOrdinates];
        int n2 = 0;
        for (int i = 1; i < this._manualEntryTable.getColumnCount(); ++i) {
            object = new double[pairedDataContainer.numberOrdinates];
            for (int j = 0; j < ((Object)object).length; ++j) {
                object[j] = RMAIO.parseDouble((Object)this._manualEntryTable.getValueAt(j, i));
            }
            if (n2 < dArray2.length) {
                dArray2[n2] = (double[])object;
            }
            ++n2;
        }
        pairedDataContainer.yOrdinates = dArray2;
        if (this._tgv != null) {
            AltGlobalTablePanel altGlobalTablePanel2 = this;
            altGlobalTablePanel2.saveLabels(altGlobalTablePanel2._tgv, pairedDataContainer);
        }
        return pairedDataContainer;
    }

    private void checkIfMonotonicallyIncreasingDates(SeasonalRecord object) {
        if (object == null || object.getTimeArray() == null || object.getTimeArray().length <= 0) {
            return;
        }
        int[] nArray = object.getTimeArray();
        object = nArray;
        Object object2 = nArray[0];
        HecTime hecTime = new HecTime();
        HecTime hecTime2 = new HecTime();
        hecTime.set(object2);
        for (int i = 1; i < ((SeasonalRecord)object).length; ++i) {
            hecTime2.set((int)object[i]);
            if (object2 > object[i] || hecTime2.year() - hecTime.year() > 1) {
                throw new IllegalArgumentException("Dates must be monotonically increasing");
            }
            object2 = object[i];
        }
    }

    private void saveLabels(TableGlobalVariable object, PairedDataContainer pairedDataContainer) {
        pairedDataContainer.labels = new String[this._manualEntryTable.getModel().getColumnCount() - 1];
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.numberCurves = pairedDataContainer.labels.length;
        object = ((TableGlobalVariable)object).getDependentList();
        pairedDataContainer.units = new String[object.size()];
        pairedDataContainer.yunits = (String)((NameValuePair)object.get(0)).getValue();
        for (int i = 0; i < object.size(); ++i) {
            String string = ((NameValuePair)object.get(i)).getName();
            String string2 = (String)((NameValuePair)object.get(i)).getValue();
            pairedDataContainer.labels[i] = string != null ? string : "";
            pairedDataContainer.units[i] = string2 != null ? string2 : "";
        }
    }

    private PairedDataContainer saveToPairedData(SeasonalRecord seasonalRecord) {
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        AltGlobalTablePanel altGlobalTablePanel = this;
        altGlobalTablePanel.saveLabels(altGlobalTablePanel._tgv, pairedDataContainer);
        Object object = this._manualEntryTable.getColumnLabel(0);
        if (!"<Undefined>".equals(object)) {
            pairedDataContainer.xunits = object;
        }
        object = seasonalRecord.getTimeArray();
        double[] dArray = seasonalRecord.getDataArray();
        pairedDataContainer.xOrdinates = new double[((Object)object).length];
        pairedDataContainer.numberOrdinates = ((Object)object).length;
        pairedDataContainer.transformType = seasonalRecord.getInterpolationType();
        for (int i = 0; i < ((Object)object).length; ++i) {
            pairedDataContainer.xOrdinates[i] = (double)object[i];
        }
        pairedDataContainer.yOrdinates = new double[1][dArray.length];
        System.arraycopy(dArray, 0, pairedDataContainer.yOrdinates[0], 0, dArray.length);
        return pairedDataContainer;
    }

    private int findNumberValidRows() {
        double d;
        int n = 0;
        if (this._manualEntryTable.getColumnCount() == 0) {
            return 0;
        }
        for (int i = 0; i < this._manualEntryTable.getNumRows() && !RMAConst.isUndefinedValue((double)(d = RMAIO.parseDouble((Object)this._manualEntryTable.getValueAt(i, 1)))); ++i) {
            ++n;
        }
        return n;
    }

    public void fillPanel(TableGlobalVariable tableGlobalVariable) {
        if (tableGlobalVariable == null) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        this.setEnabled(true);
        this._parent.setOkApplyButtonsEnabled(true);
        try {
            GlobalVariableData globalVariableData = this._dataset.getGlobalVariableData(tableGlobalVariable.getIndex(), tableGlobalVariable.getType());
            if (globalVariableData == null) {
                globalVariableData = this._dataset.createGVRecord(GlobalVariableType.TABLE, tableGlobalVariable.getIndex());
                ((AltTableGlobalData)globalVariableData).setIsDss(false);
            }
            if (globalVariableData instanceof AltTableGlobalData) {
                AltTableGlobalData altTableGlobalData = (AltTableGlobalData)globalVariableData;
                if (globalVariableData.getValue() != null && altTableGlobalData.getDSSPathname() != null && !altTableGlobalData.getDSSPathname().isEmpty()) {
                    altTableGlobalData.readPairedDataRecord(globalVariableData.getValue());
                }
                if (!altTableGlobalData.isDSS() && altTableGlobalData.getValue() != null && !altTableGlobalData.getValue().isEmpty()) {
                    ((RmaListModel)this._tableNameComboBox.getModel()).getVector().stream().filter(globalVariableTableRef -> globalVariableTableRef.toString().equalsIgnoreCase(altTableGlobalData.getValue())).findFirst().ifPresent(globalVariableTableRef -> this._tableNameComboBox.setSelectedItem(globalVariableTableRef));
                }
                tableGlobalVariable.setGlobalVariableData(globalVariableData);
                this._tgv = tableGlobalVariable;
                this._ignoreSelection = true;
                this._selectedTableGvCombo.setSelectedItem((Object)tableGlobalVariable);
                globalVariableData = new RmaListModel();
                AltGlobalTablePanel altGlobalTablePanel = this;
                List<GlobalVariableTableRef> list = altGlobalTablePanel.buildTableComboValues(altGlobalTablePanel._system, this._dataset, tableGlobalVariable);
                globalVariableData.addAll(list);
                this._tableNameComboBox.setModel((ComboBoxModel)((Object)globalVariableData));
                list.stream().filter(globalVariableTableRef -> globalVariableTableRef.toString().equalsIgnoreCase(altTableGlobalData.getValue())).findFirst().ifPresent(globalVariableTableRef -> this._tableNameComboBox.setSelectedItem(globalVariableTableRef));
                this._ignoreSelection = false;
                this._dssFilePanel.fillPanel(tableGlobalVariable);
                this._radioButtonGroup.clearSelection();
                if (altTableGlobalData.isDSS()) {
                    this._dssRadioButton.doClick(0);
                } else {
                    this._manualRadioButton.doClick(0);
                }
                if (!altTableGlobalData.isDSS()) {
                    this._dssFilePanel.clearPanel();
                }
                this.handleRadioButtons();
                this.displayManualTablePanel(tableGlobalVariable);
                this._allowEditsCheckbox.setSelected(false);
                this.allowEditsAction();
                this.handleEnablingManualTable();
                this._descriptionTextField.setText(tableGlobalVariable.getDescription());
                this._descriptionTextField.setEditable(false);
                this.repaint();
            }
            return;
        }
        finally {
            SwingUtilities.invokeLater(() -> {
                this.setModified(false);
                if (this._parent != null) {
                    this._parent.setModified(false);
                }
            });
            this.setIgnoreModifiedEvents(false);
        }
    }

    void handleEnablingManualTable() {
        boolean bl = this._tableNameComboBox.getSelectedIndex() >= 0;
        if (!bl) {
            this._complexTablePanel.setDataTableDependentHeader("");
            this._complexTablePanel.setDataTableIndependentHeader("");
            this._complexTablePanel.setHeaderTableHeader("");
            this._complexTablePanel.clear();
            this._manualEntryTable.setModel((TableModel)new RmaTableModel(new String[]{"", ""}));
            this._manualEntryTable.appendRows(10);
        }
        boolean bl2 = this._allowEditsCheckbox.isSelected();
        this._complexTablePanel.setEnabled(bl && bl2);
        this._simpleTablePanel.setEnabled(bl && bl2);
        this._editTableHeadersBtn.setEnabled(bl2);
        this._allowEditsCheckbox.setEnabled(bl);
    }

    private void fillManualTable(TableGlobalVariable tableGlobalVariable, AltTableGlobalData object) {
        object = this._tableNameComboBox.getSelectedItem();
        if (!(object instanceof GlobalVariableTableRef)) {
            return;
        }
        if (tableGlobalVariable.getTableType() == TableType.TWOVARIABLELOOKUP) {
            AltGlobalTablePanel altGlobalTablePanel = this;
            altGlobalTablePanel.fillComplexManualEntryTable(altGlobalTablePanel.getPairedDataContainer((GlobalVariableTableRef)object), tableGlobalVariable);
            this.configureComplexManualEntryTable(tableGlobalVariable);
            return;
        }
        Object object2 = this.getPairedDataContainer((GlobalVariableTableRef)object);
        if (this.isDateData(tableGlobalVariable)) {
            Object object3;
            object = new SeasonalRecord();
            object.setUnitSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
            if (object2 != null) {
                Object[] objectArray;
                object3 = object2.getXOridnates();
                object2 = object2.getYOridnates()[0];
                if (tableGlobalVariable.isSeasonalData() && ((double[])object3).length > 0 && RMAConst.isUndefinedValue((double)object3[0])) {
                    if (((double[])object3).length == 1) {
                        object3 = new double[2];
                        objectArray = new double[2];
                        if (((PairedDataContainer)object2).length > 0) {
                            objectArray[0] = (int)object2[0];
                            objectArray[1] = (int)object2[0];
                        }
                    }
                    object3[0] = new HecTime("01Jan1900 0000").value();
                    object3[1] = new HecTime("01Jan1900 0000").value();
                }
                objectArray = new int[((double[])object3).length];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = (int)object3[i];
                }
                object.setArrays(objectArray, (double[])object2);
            }
            TableModel tableModel = this._manualEntryTable.getModel();
            object3 = tableModel;
            if (!(tableModel instanceof SeasonalRecordTableModel)) {
                object2 = new SeasonalRecordTableModel();
                this._manualEntryTable.setModel((TableModel)object2);
                object3 = object2;
            }
            ((SeasonalRecordTableModel)object3).setSeasonalRecord((SeasonalRecord)object, "");
            this.configureSimpleManualEntryTable(tableGlobalVariable);
            return;
        }
        AltGlobalTablePanel altGlobalTablePanel = this;
        altGlobalTablePanel.fillSimpleManualEntryTable(altGlobalTablePanel.getPairedDataContainer((GlobalVariableTableRef)object));
        this.configureSimpleManualEntryTable(tableGlobalVariable);
    }

    public PairedDataContainer getPairedDataContainer(GlobalVariableTableRef object) {
        String string = null;
        try {
            if (this._manualRadioButton.isSelected() && object != null && this._tgv != null) {
                string = ((GlobalVariableTableRef)object).b();
                if ((object = ((GlobalVariableTableRef)object).c()) == null || string.isEmpty()) {
                    return null;
                }
                object = new DSSIdentifier((String)object, string);
                string = this._dataset.getDSSFileManager().readPairedDataContainer((DSSIdentifier)object);
                if (string != null && ((PairedDataContainer)string).numberCurves == 0) {
                    string = null;
                }
            }
            return string;
        }
        catch (RemoteException remoteException) {
            object = remoteException;
            remoteException.printStackTrace();
            return null;
        }
    }

    private void displayManualTablePanel(TableGlobalVariable tableGlobalVariable) {
        CardLayout cardLayout = (CardLayout)this._tableCardPanel.getLayout();
        if (tableGlobalVariable.getTableType() == TableType.TWOVARIABLELOOKUP) {
            cardLayout.show((Container)this._tableCardPanel, "complexTablePanel");
            this._editTableHeadersBtn.setEnabled(this._tableCardPanel.isEnabled());
            this._editTableHeadersBtn.setVisible(true);
        } else {
            cardLayout.show((Container)this._tableCardPanel, "simpleTablePanel");
            this._editTableHeadersBtn.setVisible(false);
        }
        ((RmaTableModel)this._manualEntryTable.getModel()).fireTableDataChanged();
    }

    private void configureSimpleManualEntryTable(TableGlobalVariable tableGlobalVariable) {
        int n;
        List<NameValuePair<String>> list = tableGlobalVariable.getIndependentList();
        if (list.isEmpty()) {
            EventQueue.invokeLater(() -> this.noParametersDefinedAction(tableGlobalVariable));
        }
        List<NameValuePair<String>> list2 = tableGlobalVariable.getDependentList();
        Object object = new ArrayList<String>();
        object.addAll(this.getListHeaders(list));
        object.addAll(this.getListHeaders(list2));
        this._colCount = object.size();
        list = list.stream().map(NameValuePair::getValue).collect(Collectors.toList());
        list.addAll(list2.stream().map(NameValuePair::getValue).collect(Collectors.toList()));
        list = (List<NameValuePair<String>>)list.stream().map(AltGlobalTablePanel::a).collect(Collectors.toList()).stream().mapToInt(Integer::intValue).toArray();
        this._manualEntryTable.setNumColumns(object.size());
        if (this._manualEntryTable.getRowCount() < 10) {
            this._manualEntryTable.setNumRows(10);
        }
        this._manualEntryTable.getPreferredScrollableViewportSize().setSize(this._manualEntryTable.getPreferredScrollableViewportSize().width - 5, 10 * this._manualEntryTable.getRowHeight());
        int n2 = 0;
        RmaTableModel rmaTableModel = (RmaTableModel)this._manualEntryTable.getModel();
        rmaTableModel.setUnitSystem(ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem());
        rmaTableModel.setColumnNames(this.getStringArray((List<String>)object));
        rmaTableModel.fireTableStructureChanged();
        object = this._manualEntryTable.getColumnModel();
        if (object.getColumnCount() <= 0) {
            return;
        }
        rmaTableModel = (GroupableTableHeader)this._manualEntryTable.getTableHeader();
        ColumnGroup columnGroup = new ColumnGroup((TableCellRenderer)new UnitsHeaderRenderer(), "Independent");
        ColumnGroup columnGroup2 = new ColumnGroup((TableCellRenderer)new UnitsHeaderRenderer(), "Dependent");
        TableType tableType = tableGlobalVariable.getTableType();
        TableColumn tableColumn = object.getColumn(0);
        tableColumn.setHeaderRenderer((TableCellRenderer)new UnitsHeaderRenderer());
        TableColumn tableColumn2 = object.getColumn(1);
        for (n = 0; n < list2.size(); ++n) {
            object.getColumn(n + 1).setHeaderRenderer((TableCellRenderer)new UnitsHeaderRenderer());
        }
        switch (tableType) {
            case SIMPLELOOKUPTABLE: {
                columnGroup.add((Object)tableColumn);
                columnGroup2.add((Object)tableColumn2);
                break;
            }
            case TWOVARIABLELOOKUP: {
                columnGroup.add((Object)tableColumn);
                columnGroup.add((Object)tableColumn2);
                columnGroup2.add((Object)object.getColumn(2));
                break;
            }
            case REPORT: {
                columnGroup.add((Object)tableColumn);
                for (n = 0; n < list2.size(); ++n) {
                    columnGroup2.add((Object)object.getColumn(n + 1));
                }
                break;
            }
        }
        rmaTableModel.addColumnGroup(columnGroup);
        rmaTableModel.addColumnGroup(columnGroup2);
        if (this.isDateData(tableGlobalVariable)) {
            this._manualEntryTable.setDateCellEditor(0, "DDMMM");
            n2 = 1;
        }
        for (n = n2; n < this._manualEntryTable.getColumnCount(); ++n) {
            this._manualEntryTable.setDoubleCellEditor(n);
        }
        this._manualEntryTable.setColumnParameters((int[])list);
    }

    private boolean isDateData(TableGlobalVariable tableGlobalVariable) {
        List<NameValuePair<String>> list = tableGlobalVariable.getIndependentList();
        if ((list = list.stream().map(NameValuePair::getValue).collect(Collectors.toList())) == null || list.isEmpty()) {
            return false;
        }
        return tableGlobalVariable.isSeasonalData() || "Date".equals(list.get(0));
    }

    private void fillComplexManualEntryTable(PairedDataContainer pairedDataContainer, TableGlobalVariable tableGlobalVariable) {
        NameValuePair<String> nameValuePair;
        List<NameValuePair<String>> list = tableGlobalVariable.getIndependentList();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (!list.isEmpty()) {
            nameValuePair = list.get(0);
            n = AltGlobalTablePanel.a(nameValuePair.getValue());
        }
        if (list.size() > 1) {
            nameValuePair = list.get(1);
            n2 = AltGlobalTablePanel.a(nameValuePair.getValue());
        }
        if (!(nameValuePair = tableGlobalVariable.getDependentList()).isEmpty()) {
            NameValuePair nameValuePair2 = (NameValuePair)nameValuePair.get(0);
            n3 = AltGlobalTablePanel.a((String)nameValuePair2.getValue());
        }
        if (tableGlobalVariable.isSeasonalData()) {
            this._editTableHeadersBtn.setText("Edit Dates...");
        } else {
            this._editTableHeadersBtn.setText("Edit " + list.get(0).getName() + " Values...");
            this._editTableHeadersBtn.setName(list.get(0).getName());
        }
        this._complexTablePanel.setIsSeasonal(tableGlobalVariable.isSeasonalData());
        this._complexTablePanel.fillPanel(pairedDataContainer, n, n2, n3);
    }

    private void configureComplexManualEntryTable(TableGlobalVariable object) {
        Object object2;
        Object object3;
        List<NameValuePair<String>> list = ((TableGlobalVariable)object).getIndependentList();
        if (!list.isEmpty()) {
            object3 = list.get(0);
            int[] nArray = new int[1];
            object2 = nArray;
            nArray[0] = -1;
            object3 = this.getHeaderText((NameValuePair<String>)object3, (int[])object2);
            this._complexTablePanel.setHeaderTableHeader((String)object3);
            this._complexTablePanel.setHeaderTableParamId(object2[0]);
        } else {
            EventQueue.invokeLater(() -> this.lambda$configureComplexManualEntryTable$13((TableGlobalVariable)object));
        }
        if (list.size() > 1) {
            object3 = list.get(1);
            int[] nArray = new int[1];
            object2 = nArray;
            nArray[0] = -1;
            object3 = this.getHeaderText((NameValuePair<String>)object3, (int[])object2);
            this._complexTablePanel.setDataTableIndependentHeader((String)object3);
            this._complexTablePanel.setDataTableIndependentParamId(object2[0]);
        }
        if (!(object3 = ((TableGlobalVariable)object).getDependentList()).isEmpty()) {
            object2 = (NameValuePair)object3.get(0);
            int[] nArray = new int[1];
            object3 = nArray;
            nArray[0] = -1;
            object = this.getHeaderText((NameValuePair<String>)object2, (int[])object3);
            this._complexTablePanel.setDataTableDependentHeader((String)object);
            this._complexTablePanel.setDataTableDependentParamId((int)object3[0]);
        }
    }

    private void noParametersDefinedAction(TableGlobalVariable tableGlobalVariable) {
        JOptionPane.showMessageDialog((Component)((Object)this), "No Parameters defined for Table " + tableGlobalVariable.getName(), "No Parameters", 1);
        this._parent.setOkApplyButtonsEnabled(false);
        this.setEnabled(false);
        this._parent.setModified(false);
    }

    private String getHeaderText(NameValuePair<String> object, int[] nArray) {
        String string = ((NameValuePair)object).getName();
        if ("Seasonal Date".equals(object = ((NameValuePair)object).getValue())) {
            string = string.concat(" (Season Start Day)");
        } else if ("Date".equals(object)) {
            string = string.concat(" (Date)");
        } else {
            nArray[0] = AltGlobalTablePanel.a((String)object);
            string = nArray[0] == -2 ? string.concat(" (" + (String)object + ")") : string.concat(" (%S)");
        }
        return string;
    }

    private static int a(String string) {
        try {
            string = new Parameter(string);
            int n = string.getParameterId();
            return n;
        }
        catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
            return -2;
        }
    }

    private List<String> getListHeaders(List<NameValuePair<String>> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        object = object.iterator();
        while (object.hasNext()) {
            NameValuePair<String> nameValuePair = (NameValuePair<String>)object.next();
            if (nameValuePair == null) {
                nameValuePair = new NameValuePair<String>("", "");
            }
            int[] nArray = new int[1];
            int[] nArray2 = nArray;
            nArray[0] = -1;
            arrayList.add(this.getHeaderText(nameValuePair, nArray2));
        }
        return arrayList;
    }

    private void fillSimpleManualEntryTable(PairedDataContainer object) {
        this._manualEntryTable.deleteCells();
        if (object == null || object.numberOrdinates == 0) {
            if (this._tgv.isSeasonalData()) {
                this._manualEntryTable.setValueAt((Object)"01Jan", 0, 0);
            }
            return;
        }
        double[] dArray = object.xOrdinates;
        object = object.yOrdinates;
        for (int i = 0; i < dArray.length; ++i) {
            Vector<Object> vector = new Vector<Object>();
            if (dArray[i] == Double.NEGATIVE_INFINITY) {
                vector.add("");
            } else {
                vector.add(dArray[i]);
            }
            for (int j = 0; j < ((PairedDataContainer)object).length; ++j) {
                if (object[j][i] == Double.NEGATIVE_INFINITY) {
                    vector.add("");
                    continue;
                }
                vector.add((double)object[j][i]);
            }
            this._manualEntryTable.appendRow(vector);
        }
        this._manualEntryTable.commitEdit(true);
    }

    private String[] getStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    @Override
    public String getTabname() {
        return "Table";
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    TableGlobalVariable getSelectedTableGv() {
        return this._tgv;
    }

    String getDescription() {
        return this._descriptionTextField.getText();
    }

    void updateColWidths() {
        this._complexTablePanel.updateColumnWidths();
    }

    DSSListSelector getSelector() {
        return this._dssFilePanel.getSelector();
    }

    void editTableHeadersAction() {
        if (!this._complexTablePanel.isVisible()) {
            return;
        }
        if (this._tgv.isSeasonalData()) {
            this.editSeasonalDates();
            return;
        }
        this.editTableHeaders();
    }

    private void editTableHeaders() {
        double[] dArray = this._complexTablePanel.getHeaderValues();
        if (dArray == null || dArray.length == 0) {
            dArray = new double[]{0.0};
        }
        Window window = SwingUtilities.windowForComponent((Component)this._cardPanel);
        EditTableHeadersJDialog editTableHeadersJDialog = new EditTableHeadersJDialog((Dialog)window, true, this._editTableHeadersBtn.getName());
        editTableHeadersJDialog.setAllowsUndefinedValues(true);
        int n = this._complexTablePanel.getTimeInterpolation();
        editTableHeadersJDialog.setLocationRelativeTo(window);
        int n2 = this._complexTablePanel.getHeaderParameterId();
        editTableHeadersJDialog.fillForm(dArray, n, n2);
        editTableHeadersJDialog.setInterpolationVisible(false);
        editTableHeadersJDialog.setVisible(true);
        if (editTableHeadersJDialog.isCanceled()) {
            return;
        }
        dArray = editTableHeadersJDialog.getValues();
        int[] nArray = editTableHeadersJDialog.getIndices();
        this._complexTablePanel.resetHeaderValues(dArray, nArray);
        this._complexTablePanel.setTimeInterpolation(editTableHeadersJDialog.getInterpolationType());
        this.setModified(true);
    }

    protected void editSeasonalDates() {
        int[] nArray = this._complexTablePanel.getTimes();
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{1440};
        }
        Window window = SwingUtilities.windowForComponent((Component)this._cardPanel);
        SeasonalVariationJDialog seasonalVariationJDialog = new SeasonalVariationJDialog((Dialog)window, true);
        seasonalVariationJDialog.setAllowsRowInsert(false);
        int n = this._complexTablePanel.getTimeInterpolation();
        seasonalVariationJDialog.setLocationRelativeTo(window);
        seasonalVariationJDialog.fillForm(nArray, n);
        seasonalVariationJDialog.setInterpolationVisible(false);
        seasonalVariationJDialog.setVisible(true);
        if (seasonalVariationJDialog.isCanceled()) {
            return;
        }
        nArray = seasonalVariationJDialog.getDateTimes();
        this._complexTablePanel.resetTimes(nArray, seasonalVariationJDialog.getIndices());
        this._complexTablePanel.setTimeInterpolation(seasonalVariationJDialog.getInterpolationType());
        this.setModified(true);
    }

    private /* synthetic */ void lambda$configureComplexManualEntryTable$13(TableGlobalVariable tableGlobalVariable) {
        this.noParametersDefinedAction(tableGlobalVariable);
    }

    private /* synthetic */ void lambda$selectionChanged$6(Object object, TableGlobalVariable tableGlobalVariable) {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), new JLabel(this._tgv.getName() + " was modified. Save changes?"), "Save Changes", 1);
        if (n == 0) {
            try {
                AltGlobalTablePanel altGlobalTablePanel = this;
                altGlobalTablePanel.saveTableGv(altGlobalTablePanel._tgv);
                this.fillPanel((TableGlobalVariable)object);
                return;
            }
            catch (NoManualTableSelectedException | IllegalArgumentException exception) {
                JOptionPane.showMessageDialog((Component)((Object)this), exception.getMessage(), "Save Failed", 0);
                return;
            }
        }
        if (n == 1) {
            this.fillPanel((TableGlobalVariable)object);
            return;
        }
        this._ignoreSelection = true;
        this._selectedTableGvCombo.setSelectedItem((Object)tableGlobalVariable);
        this._ignoreSelection = false;
    }
}

