/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.gui.AbstractEditorPanel;
import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AltEditorVariantMenuBuilder;
import hec.rss.client.AltTimeSeriesPanel;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.AlternativePanel;
import hec.rss.client.globalvariable.AltGlobalVariablePanel;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rma.swing.RmaInsets;

public class AltGlobalVarPanel
extends AbstractEditorPanel
implements AlternativePanel,
ChangeListener {
    public static final String TAB_NAME = "Global Variables";
    private final AlternativeEditor _editor;
    private final Map<String, AltGlobalVariablePanel> _gvPanels = new HashMap<String, AltGlobalVariablePanel>();
    private RssAlt _alternative;
    private JTabbedPane _tabbedPane;
    private RssSystem _system;
    private Set<String> _msgDisplayedSet = new HashSet<String>();
    private AltGlobalVariablePanel _defaultPanel;
    private JMenu _variantMenu;
    private final List<String> _variantsWithNewGvs = new ArrayList<String>();

    public AltGlobalVarPanel(AlternativeEditor alternativeEditor) {
        super((LayoutManager)new GridBagLayout());
        this._editor = alternativeEditor;
    }

    @Override
    public boolean savePanel(RssAlt rssAlt) {
        Object object = this._gvPanels.values();
        object = object.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            if (((AltGlobalVariablePanel)((Object)object.next())).savePanel((NamedType)rssAlt)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
        Object object = this._gvPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltGlobalVariablePanel)((Object)object.next())).setSystem(rssSystem);
        }
    }

    @Override
    public void clearPanel() {
        Object object = this._gvPanels.values();
        Iterator<AltGlobalVariablePanel> iterator = object.iterator();
        while (iterator.hasNext()) {
            iterator.next().clearPanel();
        }
        iterator = object.iterator();
        iterator.hasNext();
        if (iterator.hasNext()) {
            object = iterator.next().getTSVariant();
            this.removeVariantTab((TsVariant)((Object)object));
        }
        if (this._variantMenu != null) {
            int n = this._variantMenu.getMenuComponentCount();
            for (int i = 0; i < n; ++i) {
                if (!(this._variantMenu.getMenuComponent(i) instanceof JMenu)) continue;
                JMenu jMenu = (JMenu)this._variantMenu.getMenuComponent(i);
                jMenu.removeAll();
            }
        }
        this._system = null;
        this._alternative = null;
        AltEditorVariantMenuBuilder.a();
    }

    @Override
    public void fillPanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return;
        }
        if (namedType == this._alternative) {
            return;
        }
        this.removeAll();
        this._gvPanels.clear();
        this._tabbedPane = null;
        this._alternative = (RssAlt)namedType;
        this._alternative.getInputTSVariantNames();
        this._defaultPanel = new AltGlobalVariablePanel(this._editor, this);
        namedType = AltTimeSeriesPanel.l;
        this._defaultPanel.setSystem(this._system);
        this._defaultPanel.setTSVariant((TsVariant)namedType);
        this._defaultPanel.fillPanel((NamedType)this._alternative);
        this._gvPanels.put(namedType.getName(), this._defaultPanel);
        this.addStandAlonePanel();
        boolean bl = this.shouldDisplayMsg();
        this.setDisplayedNewTsMsg();
        if (bl && !this._editor.isNewAlt()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>There are one or more new Global Variable entries that need input.<br>");
            stringBuilder.append("Please use the Global Variable tab to complete the new entries and Save the alternative.");
            if (!this._alternative.getInputTSVariantNames().isEmpty()) {
                stringBuilder.append("<br>The Following Variants have new Global Variables:<br>");
                for (int i = 0; i < this._variantsWithNewGvs.size(); ++i) {
                    stringBuilder.append(this._variantsWithNewGvs.get(i));
                    stringBuilder.append("<br>");
                }
            }
            if (!this._alternative.getInputTSVariantNames().isEmpty()) {
                stringBuilder.append("<br><br>You will need to edit and save each Global Variable Variant to fully manage the new entries.");
            }
            stringBuilder.append("<html>");
            EventQueue.invokeLater(() -> {
                JOptionPane.showMessageDialog((Component)((Object)this._editor), stringBuilder.toString(), "New Global Variable", 1);
                EventQueue.invokeLater(() -> ((AbstractAlternativeEditor)this._editor).setModified(true));
            });
        } else {
            this.setModified(false);
        }
        String string = System.getProperty("InputTimeSeries.variantEditorPrefix");
        if (string != null && this._tabbedPane != null) {
            EventQueue.invokeLater(() -> {
                for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
                    String string2 = this._tabbedPane.getTitleAt(i);
                    if (!string2.startsWith(string)) continue;
                    this._tabbedPane.setSelectedIndex(i);
                    return;
                }
            });
        }
    }

    private void addStandAlonePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        AltGlobalVarPanel altGlobalVarPanel = this;
        altGlobalVarPanel.add((Component)((Object)altGlobalVarPanel._defaultPanel), gridBagConstraints);
    }

    private void addTabbedPane() {
        AltGlobalVarPanel altGlobalVarPanel = this;
        altGlobalVarPanel.remove((Component)((Object)altGlobalVarPanel._defaultPanel));
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        AltGlobalVarPanel altGlobalVarPanel2 = this;
        altGlobalVarPanel2.add(altGlobalVarPanel2._tabbedPane, gridBagConstraints);
        this._tabbedPane.addTab(AltTimeSeriesPanel.l.getName(), (Component)((Object)this._defaultPanel));
        this._tabbedPane.setToolTipTextAt(0, "Global Variables Input linking for ResSim in standalone");
    }

    @Override
    public String getTabname() {
        return TAB_NAME;
    }

    public boolean savePanel(NamedType namedType) {
        if (!(namedType instanceof RssAlt)) {
            return false;
        }
        return this.savePanel((RssAlt)namedType);
    }

    public void setTSVariant(TsVariant tsVariant) {
        Object object = this._gvPanels.values();
        object = object.iterator();
        while (object.hasNext()) {
            ((AltGlobalVariablePanel)((Object)object.next())).setTSVariant(tsVariant);
        }
    }

    @Override
    public void stateChanged(ChangeEvent iterator) {
        iterator = this._gvPanels.values();
        iterator = iterator.iterator();
        if (this._alternative != null) {
            while (iterator.hasNext()) {
                iterator.next().fillPanel((NamedType)this._alternative);
            }
        }
    }

    private boolean shouldDisplayMsg() {
        this._variantsWithNewGvs.clear();
        boolean bl = false;
        if (this.shouldDisplayNewTsMsg()) {
            Object object = this._gvPanels.values();
            object = object.iterator();
            while (object.hasNext()) {
                AltGlobalVariablePanel altGlobalVariablePanel = (AltGlobalVariablePanel)((Object)object.next());
                if (!altGlobalVariablePanel.hasNewLocation()) continue;
                bl = true;
                this._variantsWithNewGvs.add(altGlobalVariablePanel.getTSVariant().getName());
            }
        }
        return bl;
    }

    protected void setDisplayedNewTsMsg() {
        this._msgDisplayedSet.add(this._alternative.getName());
    }

    private boolean shouldDisplayNewTsMsg() {
        return !this._msgDisplayedSet.contains(this._alternative.getName());
    }

    public boolean windowClosing() {
        for (AltGlobalVariablePanel altGlobalVariablePanel : this._gvPanels.values()) {
            if (altGlobalVariablePanel.windowClosing()) continue;
            return false;
        }
        this._msgDisplayedSet.clear();
        return true;
    }

    public void updateGlobalVariable(TsVariant object, TableGlobalVariable tableGlobalVariable) {
        if ((object = this._gvPanels.get(object.getName())) != null) {
            ((AltGlobalVariablePanel)((Object)object)).updateGlobalVariable(tableGlobalVariable);
        }
    }

    public void commitEdits() {
        for (AltGlobalVariablePanel altGlobalVariablePanel : this._gvPanels.values()) {
            altGlobalVariablePanel.commitEdit();
        }
    }

    public void addVariant(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        if (this._tabbedPane == null) {
            this.addTabbedPane();
        }
        String string = tsVariant.getName();
        AltGlobalVariablePanel altGlobalVariablePanel = new AltGlobalVariablePanel(this._editor, this);
        this._gvPanels.put(string, altGlobalVariablePanel);
        altGlobalVariablePanel.setSystem(this._system);
        altGlobalVariablePanel.setTSVariant(tsVariant);
        altGlobalVariablePanel.fillPanel((NamedType)this._alternative);
        this._tabbedPane.addTab(string, (Component)((Object)altGlobalVariablePanel));
        int n = string.indexOf(45);
        int n2 = this._tabbedPane.getTabCount() - 1;
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            this._tabbedPane.setToolTipTextAt(n2, "Global Variable Input linking for ResSim in " + string2 + " in Program Order " + string3);
        } else {
            this._tabbedPane.setToolTipTextAt(n2, "Global Variable Entries for Variant " + string);
        }
        this._tabbedPane.setSelectedIndex(n2);
        this.revalidate();
    }

    public Vector getPanelMenus() {
        if (this._alternative == null || this._alternative.getInputTSVariants().isEmpty()) {
            return null;
        }
        this._variantMenu = new JMenu("Variants");
        Vector<JMenuItem> vector = AltEditorVariantMenuBuilder.a(this._editor);
        for (int i = 0; i < vector.size(); ++i) {
            this._variantMenu.add((JMenuItem)vector.get(i));
        }
        Vector<JMenu> vector2 = new Vector<JMenu>(1);
        vector2.add(this._variantMenu);
        return vector2;
    }

    private int findTabIndexFor(TsVariant object) {
        int n;
        if (this._tabbedPane != null && (n = this._tabbedPane.getTabCount()) > 1) {
            object = object.getName();
            for (int i = 1; i < n; ++i) {
                String string = this._tabbedPane.getTitleAt(i);
                if (!string.equals(object)) continue;
                return i;
            }
        }
        return -1;
    }

    public void removeVariantTab(TsVariant tsVariant) {
        if (tsVariant == null) {
            return;
        }
        int n = this.findTabIndexFor(tsVariant);
        if (n >= 0) {
            AltGlobalVariablePanel altGlobalVariablePanel = (AltGlobalVariablePanel)((Object)this._tabbedPane.getComponentAt(n));
            this._gvPanels.remove(altGlobalVariablePanel.getTabname());
            this._tabbedPane.removeTabAt(n);
            if (this._tabbedPane.getTabCount() == 1) {
                AltGlobalVarPanel altGlobalVarPanel = this;
                altGlobalVarPanel.remove(altGlobalVarPanel._tabbedPane);
                this._tabbedPane = null;
                this.addStandAlonePanel();
            }
        }
    }
}

