/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.SimulationPeriod;
import hec.externalplugin.ExternalDataPluginManager;
import hec.externalplugin.ExternalDataType;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.globalvariable.AbstractGlobalVariablePanel;
import hec.rss.client.globalvariable.AltGlobalScalarValueCellFactory;
import hec.rss.client.globalvariable.AltGlobalVarPanel;
import hec.rss.client.globalvariable.AltGlobalVariablePanel$1;
import hec.rss.client.globalvariable.AltGlobalVariablePanel$2;
import hec.rss.client.globalvariable.EditTableGlobalVariableDlg;
import hec.rss.client.globalvariable.GlobalVariableTableRef;
import hec.rss.client.globalvariable.ScalarVariableValidator;
import hec.rss.model.DaysOfWeek;
import hec.rss.model.GVDataSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltExternalGlobalData;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.BaseGlobalVariable;
import hec.rss.model.globalvariable.ExternalGlobalVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.GlobalVariableUtils;
import hec.rss.model.globalvariable.MonthsOfYear;
import hec.rss.model.globalvariable.ScalarDataType;
import hec.rss.model.globalvariable.ScalarGlobalVariable;
import hec.rss.model.globalvariable.StringGlobalVariable;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import org.apache.commons.lang3.time.DateUtils;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJTable;
import rma.swing.table.ComboBoxRenderer;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaTableModelInterface;
import rma.swing.table.RowCellEditor;
import rma.swing.table.RowCellRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class AltGlobalVariablePanel
extends AbstractGlobalVariablePanel {
    private static final FluentLogger c = FluentLogger.forEnclosingClass();
    static final String[] a = DaysOfWeek.DAYS;
    static final String[] b = MonthsOfYear.MONTHS;
    private final AlternativeEditor _editor;
    private final AltGlobalVarPanel _parentPanel;
    private RmaJTable _gvTable;
    private RssSystem _system;
    private RssAlt _alternative;
    private boolean _hasNewLocation;
    private GVDataSet _dataset;
    private final JButton _editTableButton = new RmaJButton();
    private final JButton _editPluginButton = new RmaJButton();
    private EditTableGlobalVariableDlg _tableGlobalVariableDlg;
    private boolean _ignoreScalarSet;
    private boolean _invalidState;
    private String _invalidCellMsg;
    private boolean _missingValue;

    public AltGlobalVariablePanel(AlternativeEditor alternativeEditor, AltGlobalVarPanel altGlobalVarPanel) {
        super(new GridBagLayout());
        this._editor = alternativeEditor;
        this._parentPanel = altGlobalVarPanel;
        this.buildControls();
        this.addListeners();
    }

    protected void buildControls() {
        Object object = new String[]{"Variable", "Data Type", "Value", "Edit"};
        AltGlobalVariablePanel altGlobalVariablePanel = this;
        this._gvTable = new AltGlobalVariablePanel$1(altGlobalVariablePanel, (Component)((Object)altGlobalVariablePanel), (Object[])object);
        this._gvTable.setRowHeight(this._gvTable.getRowHeight() + 5);
        object = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        object.gridy = -1;
        object.gridwidth = 0;
        object.weightx = 1.0;
        object.weighty = 1.0;
        object.anchor = 17;
        object.fill = 1;
        object.insets = RmaInsets.INSETS5505;
        this._gvTable.setHorizontalAlignment(4, 2);
        AltGlobalVariablePanel altGlobalVariablePanel2 = this;
        altGlobalVariablePanel2.add(altGlobalVariablePanel2._gvTable.getScrollPane(), object);
    }

    private void setScalarValue(Object object, int n, int n2) {
        Object object2 = (ScalarGlobalVariable)this._gvTable.getValueAt(n, 0);
        ScalarGlobalVariable scalarGlobalVariable = null;
        if (object2 != null) {
            scalarGlobalVariable = this._system.getInputGlobalVariables(GlobalVariableType.SCALAR).stream().filter(arg_0 -> AltGlobalVariablePanel.a((ScalarGlobalVariable)object2, arg_0)).findFirst().orElse(null);
        }
        if (scalarGlobalVariable != null) {
            object2 = this.getScalarObject(scalarGlobalVariable.getMinLimitAsString(), scalarGlobalVariable.getDataType());
            Object object3 = this.getScalarObject(scalarGlobalVariable.getMaxLimitAsString(), scalarGlobalVariable.getDataType());
            ScalarDataType scalarDataType = scalarGlobalVariable.getDataType();
            boolean bl = scalarGlobalVariable.isMinSelected();
            boolean bl2 = scalarGlobalVariable.isMaxSelected();
            try {
                this._ignoreScalarSet = true;
                if (object != null && !object.toString().isEmpty()) {
                    object2 = new ScalarVariableValidator((JDialog)((Object)this._editor), object.toString(), object2, object3, scalarDataType, bl, bl2);
                    if (((ScalarVariableValidator)object2).a()) {
                        this._invalidCellMsg = null;
                        this._invalidState = false;
                        this._gvTable.setValueAt((Object)object.toString(), n, n2);
                        this.setModified(true);
                    } else {
                        if (scalarDataType == ScalarDataType.TIME) {
                            this._gvTable.setValueAt((Object)object.toString(), n, n2);
                        }
                        EventQueue.invokeLater(() -> this._gvTable.editCellAt(n, n2));
                        this._invalidState = true;
                        this._invalidCellMsg = String.valueOf(this._gvTable.getValueAt(n, 1)) + " Global Variable " + String.valueOf(this._gvTable.getValueAt(n, 0)) + " has an invalid entry";
                    }
                } else {
                    this._gvTable.setValueAt((Object)"", n, n2);
                    this.setModified(true);
                    this._invalidState = false;
                    this._invalidCellMsg = null;
                }
                return;
            }
            finally {
                this._ignoreScalarSet = false;
            }
        }
    }

    private Object getScalarObject(String string, ScalarDataType scalarDataType) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        switch (scalarDataType) {
            case INTEGER: 
            case DAYOFWEEK: 
            case MONTHOFYEAR: 
            case TIME: {
                return RMAIO.parseInt((String)string);
            }
            case DOUBLE: {
                return RMAIO.parseDouble((String)string);
            }
            case BOOLEAN: {
                return null;
            }
            case DATE: 
            case SEASONAL_DATE: {
                return LocalDate.parse(string);
            }
            case DATEANDTIME: {
                return new HecTime(string);
            }
        }
        return null;
    }

    private boolean isEditColumnEditable(GlobalVariable globalVariable) {
        return globalVariable instanceof TableGlobalVariable || globalVariable instanceof ExternalGlobalVariable;
    }

    private boolean isValueColumnEditable(GlobalVariable globalVariable) {
        return !(globalVariable instanceof ExternalGlobalVariable);
    }

    private void editPluginGv() {
        int n = this._gvTable.getSelectedRow();
        Object object = this._gvTable.getValueAt(n, 0);
        if (object != null) {
            GlobalVariableData globalVariableData = this._dataset.getGlobalVariableData((object = this._system.getGlobalVariable(object.toString())).getIndex(), object.getType());
            if (globalVariableData == null) {
                globalVariableData = this._dataset.createGVRecord(GlobalVariableType.EXTERNAL, object.getIndex());
            }
            if (object instanceof ExternalGlobalVariable && globalVariableData instanceof AltExternalGlobalData) {
                object = (ExternalGlobalVariable)object;
                globalVariableData = (AltExternalGlobalData)globalVariableData;
                if ((object = ((ExternalGlobalVariable)object).getExternalDataDefinition()) == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "No plugin source definition found", "Failed To Load Plugin Data", 0);
                    return;
                }
                String string = object.getPluginName();
                string = ExternalDataPluginManager.getExternalDataPlugin((String)string);
                string.selectSourceAndDataLocation((ExternalDataType)object, ((AltExternalGlobalData)globalVariableData).getExternalDataLocation());
            }
        }
    }

    private void editTableGv() {
        int n = this._gvTable.getSelectedRow();
        Object object = this._gvTable.getValueAt(n, 0);
        Object object2 = this._gvTable.getValueAt(n, 2);
        if (object != null) {
            GlobalVariableData globalVariableData = this._dataset.getGlobalVariableData((object = this._system.getGlobalVariable(object.toString())).getIndex(), object.getType());
            if (globalVariableData == null) {
                globalVariableData = this._dataset.createGVRecord(GlobalVariableType.TABLE, object.getIndex());
            }
            if (object2 != null) {
                ((AltTableGlobalData)globalVariableData).setIsDss("<External DSS File>".equalsIgnoreCase(object2.toString()));
                globalVariableData.setValue(object2.toString());
            } else {
                ((AltTableGlobalData)globalVariableData).setIsDss(false);
                globalVariableData.setValue(null);
            }
            if (object instanceof TableGlobalVariable) {
                object2 = (TableGlobalVariable)object;
                ((BaseGlobalVariable)object2).setGlobalVariableData(globalVariableData);
                if (this._tableGlobalVariableDlg == null) {
                    this._tableGlobalVariableDlg = new EditTableGlobalVariableDlg(this._editor, this._alternative, this.getTSVariant(), true);
                    this._tableGlobalVariableDlg.fillPanel((TableGlobalVariable)object2);
                }
                this.fillTableEditor((TableGlobalVariable)object2);
            }
        }
    }

    protected void addListeners() {
        this._editTableButton.addActionListener(actionEvent -> this.editTableGv());
        this._editPluginButton.addActionListener(actionEvent -> this.editPluginGv());
    }

    public String getTabname() {
        if (this.getTSVariant() != null) {
            return this.getTSVariant().getName();
        }
        return "Global Variables";
    }

    public void setSystem(RssSystem rssSystem) {
        if (rssSystem != this._system) {
            this._gvTable.clearSelection();
            this._gvTable.deleteCells();
            this._system = rssSystem;
        }
    }

    public void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            this.setEnabled(false);
            return;
        }
        this._alternative = (RssAlt)object;
        this._hasNewLocation = false;
        object = this._alternative.getSystem();
        if (object == null) {
            return;
        }
        this.setSystem((RssSystem)object);
        AltGlobalVariablePanel altGlobalVariablePanel = this;
        object = altGlobalVariablePanel.getGlobalVariableDataSet(altGlobalVariablePanel._alternative);
        this.checkNewLocation((GVDataSet)((Object)object));
        this.markDeletedGlobalVariables((GVDataSet)((Object)object));
        this.fillTable((GVDataSet)((Object)object));
    }

    private void markDeletedGlobalVariables(GVDataSet object) {
        for (GlobalVariableData globalVariableData : ((GVDataSet)((Object)object)).getGVRecords()) {
            if (!globalVariableData.isMarkedForDeletion()) {
                boolean bl = this._system.globalVariableExists(globalVariableData.getIndex(), globalVariableData.getType());
                globalVariableData.markForDelete(!bl);
            }
            if (!globalVariableData.isMarkedForDeletion()) continue;
            SwingUtilities.invokeLater(() -> ((AbstractAlternativeEditor)this._editor).setModified(true));
        }
    }

    private void fillTableEditor(TableGlobalVariable tableGlobalVariable) {
        this._tableGlobalVariableDlg.fillPanel(tableGlobalVariable);
        this._tableGlobalVariableDlg.setVisible(true);
    }

    private void checkNewLocation(GVDataSet object) {
        List<GlobalVariable> list = this._alternative.getSystem().getInputGlobalVariables(GlobalVariableType.SCALAR);
        List<GlobalVariableData> list2 = object.getGVRecords(GlobalVariableType.SCALAR);
        List<GlobalVariable> list3 = this._alternative.getSystem().getInputGlobalVariables(GlobalVariableType.STRING);
        List<GlobalVariableData> list4 = object.getGVRecords(GlobalVariableType.STRING);
        List<GlobalVariable> list5 = this._alternative.getSystem().getInputGlobalVariables(GlobalVariableType.TABLE);
        List<GlobalVariableData> list6 = object.getGVRecords(GlobalVariableType.TABLE);
        List<GlobalVariable> list7 = this._alternative.getSystem().getInputGlobalVariables(GlobalVariableType.EXTERNAL);
        object = object.getGVRecords(GlobalVariableType.EXTERNAL);
        this._hasNewLocation = !this.hasMatchingIndexes(list, list2) || !this.hasMatchingIndexes(list3, list4) || !this.hasMatchingIndexes(list5, list6) || !this.hasMatchingIndexes(list7, (List<GlobalVariableData>)object);
    }

    private boolean hasMatchingIndexes(List<GlobalVariable> object, List<GlobalVariableData> list) {
        boolean bl = true;
        if (object.size() > list.size()) {
            bl = false;
        }
        if (bl) {
            object = object.iterator();
            while (object.hasNext()) {
                GlobalVariable globalVariable = (GlobalVariable)object.next();
                boolean bl2 = list.stream().anyMatch(globalVariableData -> globalVariableData.getIndex() == globalVariable.getIndex());
                if (bl2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void fillTable(GVDataSet object) {
        this._gvTable.deleteCells();
        this._dataset = object;
        this._missingValue = false;
        object = this._system.getGlobalVariableList();
        Iterator<GlobalVariable> iterator = object.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object object3 = iterator.next();
            object = new Vector();
            if (object3.getType() == GlobalVariableType.TIME_SERIES || !object3.isInput()) continue;
            ((Vector)object).add(object3);
            GlobalVariableData globalVariableData = this._dataset.getGVRecords().stream().filter(arg_0 -> AltGlobalVariablePanel.a((GlobalVariable)object3, arg_0)).findFirst().orElse(null);
            if (globalVariableData == null && (globalVariableData = this._dataset.createGVRecord(object3.getType(), object3.getIndex())) instanceof AltTableGlobalData) {
                ((AltTableGlobalData)globalVariableData).markAsNewData(true);
            }
            if (globalVariableData.isMarkedForDeletion()) continue;
            globalVariableData.setGlobalVariable((GlobalVariable)object3);
            globalVariableData.setName(object3.getName());
            String string = globalVariableData.getValue();
            String string2 = object3.getType().toString();
            if (object3.getType() == GlobalVariableType.SCALAR) {
                object2 = (ScalarGlobalVariable)object3;
                string2 = string2.concat("-").concat(object2.getDataType().toString());
                string = this.getScalarValue(string, object2.getDataType());
                string = this.checkScalarSelection(string, (ScalarGlobalVariable)object2);
            } else if (object3 instanceof TableGlobalVariable) {
                if ((string2 = string2.concat("-").concat(((TableGlobalVariable)object3).getTableType().toString())).endsWith("Table")) {
                    string2 = string2.substring(0, string2.length() - 5);
                }
            } else if (object3 instanceof ExternalGlobalVariable) {
                object2 = ((ExternalGlobalVariable)object3).getExternalDataDefinition();
                if (object2 != null) {
                    string2 = string2.concat("-").concat(object2.toString());
                }
            } else if (object3 instanceof StringGlobalVariable) {
                object2 = (StringGlobalVariable)object3;
                if (object2.isSelection()) {
                    string2 = string2.concat("-").concat("Selection");
                } else if (object2.isFilePath()) {
                    string2 = string2.concat("-").concat("File Path");
                }
            }
            ((Vector)object).add(string2);
            if (object3 instanceof TableGlobalVariable) {
                if (globalVariableData.getDSSPathname() == null || globalVariableData.getDSSPathname().isEmpty()) {
                    globalVariableData.setDSSPathname(this.getDSSPathname((GlobalVariable)object3));
                    globalVariableData.setDSSFilename(this._dataset.getDSSFilename());
                    globalVariableData.setName(object3.getName());
                }
                if (!((AltTableGlobalData)globalVariableData).isNewData()) {
                    ((AltTableGlobalData)globalVariableData).readPairedDataRecord(globalVariableData.getValue());
                }
                if ((object2 = globalVariableData.getValue()) == null) {
                    ((Vector)object).add(null);
                } else {
                    object2 = GlobalVariableUtils.a((String)object2);
                    ((Vector)object).add(new GlobalVariableTableRef((String)object2, GlobalVariableUtils.a((TableGlobalVariable)object3, (String)object2), this._system.getGlobalVariableTablesFile()));
                }
                ((Vector)object).add("Edit " + object3.getName() + "...");
            } else if (object3 instanceof ExternalGlobalVariable) {
                ((Vector)object).add("");
                ((Vector)object).add("Edit " + object3.getName() + "...");
            } else {
                if (object3 instanceof StringGlobalVariable && ((StringGlobalVariable)object3).isFilePath()) {
                    string = this.getRelativePath(string);
                }
                ((Vector)object).add(string);
                ((Vector)object).add("");
            }
            this._gvTable.appendRow((Vector)object);
            if (object3 instanceof ScalarGlobalVariable) {
                object2 = (ScalarGlobalVariable)object3;
                AltGlobalScalarValueCellFactory.a((ScalarGlobalVariable)object2, this._gvTable, this._gvTable.getRowCount() - 1);
                continue;
            }
            if (object3 instanceof StringGlobalVariable) {
                object2 = (StringGlobalVariable)object3;
                if (object2.isSelection()) {
                    object = ((StringGlobalVariable)object3).getSelectionList();
                    object3 = this._gvTable.setComboBoxRowEditor(this._gvTable.getRowCount() - 1, 2, new Vector(object));
                    object3.setSelectedItem((Object)string);
                    continue;
                }
                if (!object2.isFilePath()) continue;
                AltGlobalVariablePanel altGlobalVariablePanel = this;
                altGlobalVariablePanel.setFileChooserField(altGlobalVariablePanel._gvTable, this._gvTable.getRowCount() - 1, 2);
                continue;
            }
            if (!(object3 instanceof TableGlobalVariable)) continue;
            AltGlobalVariablePanel altGlobalVariablePanel = this;
            object2 = altGlobalVariablePanel.buildTableComboValues(altGlobalVariablePanel._system, this._dataset, (TableGlobalVariable)object3);
            if (((AltTableGlobalData)globalVariableData).isDSS()) {
                object2.clear();
                object2.add((GlobalVariableTableRef)new GlobalVariableTableRef("<External DSS File>", null, null));
                globalVariableData.setValue("<External DSS File>");
            }
            object = this._gvTable.setComboBoxRowEditor(this._gvTable.getRowCount() - 1, 2, new Vector<GlobalVariableTableRef>((Collection<GlobalVariableTableRef>)object2));
            object3 = globalVariableData.getValue();
            object2.stream().filter(arg_0 -> AltGlobalVariablePanel.a((String)object3, arg_0)).findFirst().ifPresent(arg_0 -> ((RmaJComboBox)object).setSelectedItem(arg_0));
            if (((AltTableGlobalData)globalVariableData).isNewData()) {
                object.setSelectedIndex(-1);
            }
            if (!((AltTableGlobalData)globalVariableData).isDSS()) continue;
            object.setEnabled(false);
        }
    }

    private String getAbsolutePath(String string) {
        ManagerProxyListContainer managerProxyListContainer = this._editor.getWorkspace();
        if (managerProxyListContainer instanceof ClientWorkspace) {
            return ((ClientWorkspace)managerProxyListContainer).makeAbsolutePath(string);
        }
        if (managerProxyListContainer instanceof SimulationPeriod) {
            return ((SimulationPeriod)managerProxyListContainer).makeAbsolutePath(string);
        }
        return string;
    }

    private String getRelativePath(String string) {
        ManagerProxyListContainer managerProxyListContainer = this._editor.getWorkspace();
        if (managerProxyListContainer instanceof ClientWorkspace) {
            return ((ClientWorkspace)managerProxyListContainer).getRelativePath(string);
        }
        if (managerProxyListContainer instanceof SimulationPeriod) {
            return ((SimulationPeriod)managerProxyListContainer).getRelativePath(string);
        }
        return string;
    }

    private RmiFileChooserField setFileChooserField(RmaJTable rmaJTable, int n, int n2) {
        Object object = rmaJTable.getColumnModel();
        if (n2 >= object.getColumnCount() || n2 < 0) {
            return null;
        }
        object = rmaJTable.getColumnModel().getColumn(n2);
        if (object == null) {
            return null;
        }
        AltGlobalVariablePanel$2 altGlobalVariablePanel$2 = new AltGlobalVariablePanel$2(this);
        altGlobalVariablePanel$2.setDefaultPath(ClientApp.Workspace().getWorkspacePath());
        altGlobalVariablePanel$2.addMouseListener((MouseListener)rmaJTable);
        RmaCellEditor rmaCellEditor = new RmaCellEditor((JTextField)((Object)altGlobalVariablePanel$2));
        TableCellEditor tableCellEditor = ((TableColumn)object).getCellEditor();
        if (tableCellEditor instanceof RowCellEditor) {
            ((RowCellEditor)tableCellEditor).add(n, (TableCellEditor)rmaCellEditor);
        } else {
            tableCellEditor = new RowCellEditor(tableCellEditor);
            ((TableColumn)object).setCellEditor(tableCellEditor);
            tableCellEditor.add(n, (TableCellEditor)rmaCellEditor);
            tableCellEditor.setClickCountToStart(1);
        }
        tableCellEditor = new ComboBoxRenderer();
        TableCellRenderer tableCellRenderer = ((TableColumn)object).getCellRenderer();
        if (tableCellRenderer instanceof RowCellRenderer) {
            tableCellRenderer = (RowCellRenderer)tableCellRenderer;
            tableCellRenderer.add(n, (TableCellRenderer)((Object)tableCellEditor));
        } else {
            tableCellRenderer = new RowCellRenderer(tableCellRenderer);
            ((TableColumn)object).setCellRenderer(tableCellRenderer);
            tableCellRenderer.add(n, (TableCellRenderer)((Object)tableCellEditor));
        }
        rmaCellEditor.setClickCountToStart(1);
        if (rmaJTable.getModel() instanceof RmaTableModelInterface) {
            ((RmaTableModelInterface)rmaJTable.getModel()).setColumnClass(n2, Number.class);
        }
        rmaJTable.setHorizontalAlignment(2, n2);
        return altGlobalVariablePanel$2;
    }

    private String checkScalarSelection(String string, ScalarGlobalVariable object) {
        if (((ScalarGlobalVariable)object).isSelectionList() && (object = ((ScalarGlobalVariable)object).getSelectionList()) != null && !object.contains(string)) {
            this._missingValue = true;
            return null;
        }
        return string;
    }

    private String getScalarValue(String string, ScalarDataType scalarDataType) {
        if (string == null || scalarDataType == null) {
            return string;
        }
        if (ScalarDataType.TIME == scalarDataType) {
            string = string.replace(":", "");
        } else if (ScalarDataType.SEASONAL_DATE == scalarDataType) {
            string = this.formatDate(string, "ddMMM");
        } else if (ScalarDataType.DATE == scalarDataType) {
            string = this.formatDate(string, "ddMMMyyyy");
        } else if (ScalarDataType.DATEANDTIME == scalarDataType) {
            string = this.formatDate(string, "ddMMMyyyy HHmm");
        } else if (ScalarDataType.BOOLEAN == scalarDataType) {
            if (!"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) {
                string = null;
                this._missingValue = true;
            }
        } else if (ScalarDataType.INTEGER == scalarDataType) {
            if (RMAConst.isUndefinedValue((int)RMAIO.parseInt((String)string))) {
                string = null;
                this._missingValue = true;
            }
        } else if (ScalarDataType.DOUBLE == scalarDataType && RMAConst.isUndefinedValue((double)RMAIO.parseDouble((String)string))) {
            string = null;
            this._missingValue = true;
        }
        return string;
    }

    private String formatDate(String string, String object) {
        try {
            Date date = DateUtils.parseDate((String)string, (String[])new String[]{object, "dd MMM yyyy", "dd MMMM yyyy", "dd MMMM yyyy, HH:mm"});
            object = new SimpleDateFormat((String)object);
            object = ((DateFormat)object).format(date);
        }
        catch (Exception exception) {
            ((FluentLogger.Api)c.atWarning()).log("Error parsing seasonal date %s. Error:%s" + string, (Object)exception.getMessage());
            return null;
        }
        return object;
    }

    public boolean savePanel(NamedType object) {
        this._gvTable.commitEdit(true);
        if (this._invalidState) {
            SwingUtilities.invokeLater(() -> this.setModified(true));
            this._invalidState = false;
            if (this._invalidCellMsg != null) {
                AltGlobalVariablePanel altGlobalVariablePanel = this;
                int n = JOptionPane.showConfirmDialog((Component)((Object)altGlobalVariablePanel), altGlobalVariablePanel._invalidCellMsg + "\nWould you like to fix the entry?", "Invalid Table entry", 0);
                if (n == 0) {
                    int n2 = this._editor.getTabbedPane().indexOfComponent((Component)((Object)this._parentPanel));
                    if (n2 >= 0) {
                        EventQueue.invokeLater(() -> this._editor.getTabbedPane().setSelectedIndex(n2));
                    }
                    return false;
                }
            }
            return true;
        }
        if (!(object instanceof RssAlt)) {
            return false;
        }
        object = this.getGlobalVariableDataSet((RssAlt)object);
        try {
            for (int i = 0; i < this._gvTable.getRowCount(); ++i) {
                Object object2 = this._gvTable.getValueAt(i, 0);
                if (!(object2 instanceof GlobalVariable)) continue;
                object2 = (GlobalVariable)object2;
                Object object3 = this._gvTable.getValueAt(i, 2);
                GlobalVariableData globalVariableData = ((GVDataSet)((Object)object)).getGlobalVariableData(object2.getIndex(), object2.getType());
                if (globalVariableData == null) {
                    globalVariableData = ((GVDataSet)((Object)object)).createGVRecord(object2.getType(), object2.getIndex());
                }
                if (object3 instanceof GlobalVariableTableRef) {
                    object3 = ((GlobalVariableTableRef)object3).a();
                }
                if (globalVariableData instanceof AltTableGlobalData) {
                    ((AltTableGlobalData)globalVariableData).markAsNewData(false);
                }
                if (object2 instanceof StringGlobalVariable && ((StringGlobalVariable)object2).isFilePath()) {
                    object3 = this.getAbsolutePath((String)object3);
                }
                globalVariableData.setValue(object3);
                globalVariableData.setName(object2.getName());
                if (!(globalVariableData instanceof AltTableGlobalData) || !((AltTableGlobalData)globalVariableData).isDSS()) {
                    globalVariableData.setDSSFilename(((GVDataSet)((Object)object)).getDSSFilename());
                    globalVariableData.setDSSPathname(this.getDSSPathname((GlobalVariable)object2));
                }
                if (!(globalVariableData instanceof AltTableGlobalData) || object3 == null) continue;
                ((AltTableGlobalData)globalVariableData).readPairedDataRecord(object3.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            ((FluentLogger.Api)((FluentLogger.Api)c.atWarning()).withCause((Throwable)runtimeException)).log("Save failed");
            JOptionPane.showMessageDialog((Component)((Object)this), "Save failed! See log for details.", "Save Failed", 0);
            return false;
        }
        return object.saveManager();
    }

    private String getDSSPathname(GlobalVariable globalVariable) {
        DSSPathname dSSPathname = new DSSPathname();
        String string = "";
        if (globalVariable instanceof StringGlobalVariable) {
            string = GlobalVariableUtils.a((StringGlobalVariable)globalVariable);
        } else if (globalVariable instanceof ScalarGlobalVariable) {
            string = GlobalVariableUtils.a((ScalarGlobalVariable)globalVariable);
        }
        if (globalVariable instanceof TableGlobalVariable) {
            dSSPathname.setCPart(GlobalVariableUtils.a((TableGlobalVariable)globalVariable));
        }
        dSSPathname.setEPart(string);
        dSSPathname.setBPart(globalVariable.getName());
        dSSPathname.setFPart(this._alternative.getName() + "-" + this.getTSVariant().getName());
        return dSSPathname.toString();
    }

    public boolean hasNewLocation() {
        return this._hasNewLocation;
    }

    public boolean hasMissingValue() {
        return this._missingValue;
    }

    public void clearPanel() {
        this._gvTable.deleteCells();
    }

    boolean windowClosing() {
        return true;
    }

    void updateGlobalVariable(TableGlobalVariable tableGlobalVariable) {
        for (int i = 0; i < this._gvTable.getRowCount(); ++i) {
            Object object = this._gvTable.getValueAt(i, 0);
            if (object != tableGlobalVariable || !((object = this._dataset.getGlobalVariableData(tableGlobalVariable.getIndex(), tableGlobalVariable.getType())) instanceof AltTableGlobalData)) continue;
            if (((AltTableGlobalData)object).isDSS()) {
                object = this._gvTable.setComboBoxRowEditor(i, 2, new Vector<String>(Collections.singletonList("<External DSS File>")));
                this._gvTable.setValueAt((Object)"<External DSS File>", i, 2);
                object.setEnabled(false);
                continue;
            }
            AltGlobalVariablePanel altGlobalVariablePanel = this;
            this._gvTable.setComboBoxRowEditor(i, 2, new Vector<GlobalVariableTableRef>(altGlobalVariablePanel.buildTableComboValues(altGlobalVariablePanel._system, this._dataset, tableGlobalVariable)));
            object = GlobalVariableUtils.a(object.getValue());
            this._gvTable.setValueAt(object, i, 2);
        }
    }

    void commitEdit() {
        this._gvTable.commitEdit(true);
    }

    private static /* synthetic */ boolean a(String string, GlobalVariableTableRef globalVariableTableRef) {
        return globalVariableTableRef.a().equalsIgnoreCase(string);
    }

    private static /* synthetic */ boolean a(GlobalVariable globalVariable, GlobalVariableData globalVariableData) {
        return globalVariableData.getIndex() == globalVariable.getIndex() && globalVariableData.getName().equalsIgnoreCase(globalVariable.getName());
    }

    private static /* synthetic */ boolean a(ScalarGlobalVariable scalarGlobalVariable, GlobalVariable globalVariable) {
        return globalVariable.getIndex() == scalarGlobalVariable.getIndex() && globalVariable.getName().equalsIgnoreCase(scalarGlobalVariable.getName());
    }
}

