/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.clientapp.client.ClientApp;
import hec.io.DSSIdentifier;
import hec.io.PairedDataContainer;
import hec.lang.NamedType;
import hec.rss.client.AlternativePanel;
import hec.rss.client.PairedDataPanel;
import hec.rss.client.globalvariable.AbstractGlobalVariablePanel;
import hec.rss.client.globalvariable.AltGlobalTablePanel;
import hec.rss.model.GVDataSet;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.AltTableGlobalData;
import hec.rss.model.globalvariable.BaseAltGlobalData;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.awt.Component;
import javax.swing.JDialog;
import rma.util.RMAUtil;

public final class DSSFilePanel
extends PairedDataPanel
implements AlternativePanel {
    private final AbstractGlobalVariablePanel _parent;
    private final GlobalVariableType _type;
    private boolean _hasNewLocation;
    private RssAlt _alternative;
    private RssSystem _system;
    private TableGlobalVariable _tgv;
    private AltTableGlobalData _altGvData;
    private boolean _modified;
    private GVDataSet _dataSet;

    public DSSFilePanel(JDialog jDialog, AbstractGlobalVariablePanel abstractGlobalVariablePanel, GlobalVariableType globalVariableType) {
        super(jDialog);
        this._parent = abstractGlobalVariablePanel;
        this._type = globalVariableType;
    }

    @Override
    public final String getTabname() {
        return "DSS File";
    }

    @Override
    public final void clearPanel() {
        super.clearPanel();
    }

    @Override
    public final void fillPanel(NamedType object) {
        if (!(object instanceof RssAlt)) {
            return;
        }
        this._hasNewLocation = false;
        this._alternative = (RssAlt)object;
        object = this._alternative.getSystem();
        this._dataSet = this._parent.getGlobalVariableDataSet(this._alternative);
        if (object == null) {
            return;
        }
        this.setSystem((RssSystem)object);
    }

    public final void fillPanel(TableGlobalVariable tableGlobalVariable) {
        this._tgv = tableGlobalVariable;
        GlobalVariableData globalVariableData = this._dataSet.getGlobalVariableData(tableGlobalVariable.getIndex(), tableGlobalVariable.getType());
        if (globalVariableData == null) {
            globalVariableData = this._dataSet.createGVRecord(GlobalVariableType.TABLE, tableGlobalVariable.getIndex());
        }
        tableGlobalVariable = new DSSIdentifier();
        tableGlobalVariable.setFileName(ClientApp.Workspace().getRelativePath(globalVariableData.getDSSFilename()));
        tableGlobalVariable.setDSSPath(globalVariableData.getDSSPathname());
        this.fillPanel((DSSIdentifier)tableGlobalVariable);
    }

    @Override
    public final String getDefaultDirectory() {
        return this._dataSet.getWorkspacePath();
    }

    @Override
    public final boolean savePanel(RssAlt rssAlt) {
        if (rssAlt == null) {
            rssAlt = this._alternative;
        }
        if (rssAlt != null) {
            return this.saveDSSFields(rssAlt);
        }
        return true;
    }

    private boolean saveDSSFields(RssAlt manager) {
        if (manager == null || manager.getInputGVDataSet() == null) {
            return false;
        }
        Object object = this.getPairedDataContainer();
        GlobalVariableData globalVariableData = (manager = manager.getInputGVDataSet()).getGlobalVariableData(this._tgv.getIndex(), this._tgv.getType());
        if (globalVariableData == null) {
            globalVariableData = manager.createGVRecord(GlobalVariableType.TABLE, this._tgv.getIndex());
        }
        if (globalVariableData instanceof AltTableGlobalData) {
            globalVariableData = (AltTableGlobalData)globalVariableData;
            object.setFullName(this.getDssPath());
            ((AltTableGlobalData)globalVariableData).setPairedData((PairedDataContainer)object);
            object = "";
            if (this._parent instanceof AltGlobalTablePanel) {
                object = ((AltGlobalTablePanel)this._parent).getDescription();
            }
            globalVariableData.setDescription((String)object);
            ((BaseAltGlobalData)globalVariableData).setDSSFilename(this._alternative.getRelativePath(this.getDssFilePath()));
            ((BaseAltGlobalData)globalVariableData).setDSSPathname(this.getDssPath());
            ((AltTableGlobalData)globalVariableData).setIsDss(true);
        }
        return manager.saveManager();
    }

    @Override
    public final void setSystem(RssSystem rssSystem) {
        this._system = rssSystem;
    }

    public final boolean savePanel(NamedType namedType) {
        if (namedType instanceof RssAlt) {
            return this.savePanel((RssAlt)namedType);
        }
        return true;
    }

    @Override
    public final boolean isModified() {
        return this._modified;
    }

    @Override
    public final void setModified(boolean bl) {
        this._modified = bl;
        if (bl) {
            RMAUtil.setParentModified((Component)((Object)this));
        }
    }
}

