/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.lang.NamedType;
import hec.rss.client.AbstractAlternativeEditor;
import hec.rss.client.AlternativeEditor;
import hec.rss.client.globalvariable.AltGlobalTablePanel;
import hec.rss.client.globalvariable.EditTableGlobalVariableDlg$1;
import hec.rss.client.globalvariable.EditTableGlobalVariableDlg$2;
import hec.rss.client.globalvariable.NoManualTableSelectedException;
import hec.rss.model.RssAlt;
import hec.rss.model.RssSystem;
import hec.rss.model.TsVariant;
import hec.rss.model.globalvariable.TableGlobalVariable;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

final class EditTableGlobalVariableDlg
extends RmaJDialog {
    private final AlternativeEditor _parent;
    private AltGlobalTablePanel _tablePanel;
    private ButtonCmdPanel _okCancelPanel;

    EditTableGlobalVariableDlg(AlternativeEditor alternativeEditor, RssAlt rssAlt, TsVariant tsVariant, boolean bl) {
        super((Dialog)((Object)alternativeEditor), "Edit Table Global Variable", bl);
        this._parent = alternativeEditor;
        this.setLayout(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.setSize(600, 500);
        this.setMinimumSize(new Dimension(550, 450));
        this.setLocationRelativeTo((Component)((Object)alternativeEditor));
        this.setDefaultCloseOperation(0);
        this._tablePanel.setSystem(rssAlt.getSystem());
        this.setTsVariant(tsVariant);
        this.fillPanel((NamedType)rssAlt);
    }

    private void addListeners() {
        EditTableGlobalVariableDlg editTableGlobalVariableDlg = this;
        editTableGlobalVariableDlg.addFocusListener(editTableGlobalVariableDlg.getFocusAdapter());
        this._okCancelPanel.getButton(8).addActionListener(actionEvent -> this.okAction());
        this._okCancelPanel.getButton(2).addActionListener(actionEvent -> this.applyPressed());
        this._okCancelPanel.getButton(4).addActionListener(actionEvent -> this.cancelAction());
        this.addWindowListener(new EditTableGlobalVariableDlg$1(this));
    }

    private void applyPressed() {
        try {
            this.applyAction();
            return;
        }
        catch (NoManualTableSelectedException noManualTableSelectedException) {
            this.displayNoManualTableSelectedError(noManualTableSelectedException);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog((Component)((Object)this), illegalArgumentException.getMessage(), "Save Failed", 0);
            return;
        }
    }

    private FocusListener getFocusAdapter() {
        return new EditTableGlobalVariableDlg$2(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancelAction() {
        if (!this.isModified()) {
            this.setVisible(false);
            return;
        }
        TableGlobalVariable tableGlobalVariable = this._tablePanel.getSelectedTableGv();
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), tableGlobalVariable.getName() + " has changed. Save Changes?", "Confirm Save", 1);
        if (n == 0) {
            this.okAction();
            return;
        }
        if (n != 1) return;
        this.setVisible(false);
    }

    private void okAction() {
        try {
            if (this.applyAction()) {
                this.setVisible(false);
            }
            return;
        }
        catch (NoManualTableSelectedException noManualTableSelectedException) {
            this.displayNoManualTableSelectedError(noManualTableSelectedException);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>" + illegalArgumentException.getMessage() + "<br>Do you want to close the editor?", "Save Failed", 0);
            if (n == 0) {
                this.setVisible(false);
            }
            return;
        }
    }

    private void displayNoManualTableSelectedError(NoManualTableSelectedException noManualTableSelectedException) {
        JOptionPane.showMessageDialog((Component)((Object)this), noManualTableSelectedException.getMessage(), "Save Failed", 0);
    }

    private boolean applyAction() throws NoManualTableSelectedException, IllegalArgumentException {
        boolean bl;
        TableGlobalVariable tableGlobalVariable = this._tablePanel.getSelectedTableGv();
        try {
            bl = this._tablePanel.saveTableGv(tableGlobalVariable);
        }
        catch (NoManualTableSelectedException noManualTableSelectedException) {
            JOptionPane.showMessageDialog((Component)((Object)this), noManualTableSelectedException.getMessage(), "Save Failed", 1);
            return false;
        }
        if (bl) {
            ((AbstractAlternativeEditor)this._parent).setModified(true);
            this._parent.updateGlobalVariable(this._tablePanel.getTSVariant(), tableGlobalVariable);
            this.setModified(false);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to save " + tableGlobalVariable.getName(), "Save Failed", 0);
        }
        return true;
    }

    public final void setModified(boolean bl) {
        super.setModified(bl);
        String string = this.getTitle();
        if (bl) {
            if (!string.endsWith("*")) {
                this.setTitle(string + "*");
                return;
            }
        } else if (string.endsWith("*")) {
            this.setTitle(string.substring(0, string.length() - 1));
        }
    }

    private void buildControls() {
        EditTableGlobalVariableDlg editTableGlobalVariableDlg = this;
        this._tablePanel = new AltGlobalTablePanel(editTableGlobalVariableDlg, editTableGlobalVariableDlg._parent);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5500;
        EditTableGlobalVariableDlg editTableGlobalVariableDlg2 = this;
        editTableGlobalVariableDlg2.add((Component)((Object)editTableGlobalVariableDlg2._tablePanel), gridBagConstraints);
        this._okCancelPanel = new ButtonCmdPanel(14);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)10);
        EditTableGlobalVariableDlg editTableGlobalVariableDlg3 = this;
        editTableGlobalVariableDlg3.add((Component)editTableGlobalVariableDlg3._okCancelPanel, gridBagConstraints);
    }

    public final void fillPanel(NamedType namedType) {
        this._tablePanel.fillPanel(namedType);
        this.setModified(false);
    }

    public final void fillPanel(TableGlobalVariable tableGlobalVariable) {
        this._tablePanel.fillPanel(tableGlobalVariable);
        SwingUtilities.invokeLater(() -> this.setModified(false));
    }

    public final void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            EventQueue.invokeLater(() -> {
                EditTableGlobalVariableDlg editTableGlobalVariableDlg = this;
                editTableGlobalVariableDlg.setSize(editTableGlobalVariableDlg.getSize().width, this.getSize().height);
                this._tablePanel.updateColWidths();
            });
        }
    }

    public final void setSystem(RssSystem rssSystem) {
        this._tablePanel.setSystem(rssSystem);
    }

    final void setTsVariant(TsVariant tsVariant) {
        this._tablePanel.setTSVariant(tsVariant);
    }

    public final void setOkApplyButtonsEnabled(boolean bl) {
        this._okCancelPanel.getButton(8).setEnabled(bl);
        this._okCancelPanel.getButton(2).setEnabled(bl);
    }
}

