/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.data.Parameter;
import hec.externalplugin.ExternalDataPluginManager;
import hec.externalplugin.ExternalDataType;
import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.ExternalGlobalVariablePanel$1;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.model.globalvariable.ExternalGlobalVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.list.RmaListModel;

public class ExternalGlobalVariablePanel
extends BaseGlobalVarPanel {
    private ExternalGlobalVariable _globalExternal;
    private RmaJComboBox<ExternalDataType> _combo;
    private RmaJComboBox<String> _paramCombo;
    private ExternalDataType _emptyExternalType;
    private JLabel _missingPluginLabel;

    public ExternalGlobalVariablePanel(GlobalVariableEditor globalVariableEditor) {
        super(globalVariableEditor);
    }

    @Override
    protected int usageTypeRemainder() {
        return -1;
    }

    @Override
    public double usageTypeWeightX() {
        return 0.001;
    }

    @Override
    protected void addTopPanelComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)-40, (int)0, (int)5);
        this.getPanel().add((Component)this._isDataLocationCheckBox, (Object)gridBagConstraints);
        RmaJLabel rmaJLabel = new RmaJLabel("Primary Parameter:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add((Component)rmaJLabel, (Object)gridBagConstraints);
        Object[] objectArray = Parameter.getAvailableParameters();
        Arrays.parallelSort((Comparable[])objectArray);
        this._paramCombo = new RmaJComboBox(objectArray);
        this._paramCombo.setModifiable(true);
        this._paramCombo.setToolTipText("The fundamental Parameter of the data or the first Parameter of a multi-parameter set.");
        rmaJLabel.setLabelFor(this._paramCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add(this._paramCombo, (Object)gridBagConstraints);
        rmaJLabel = new RmaJLabel("Source and Data Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add((Component)rmaJLabel, (Object)gridBagConstraints);
        this._emptyExternalType = new ExternalGlobalVariablePanel$1(this);
        objectArray = this.getAvailableExternalDataTypes();
        Arrays.parallelSort(objectArray, Comparator.comparing(ExternalDataType::toString));
        this._combo = new RmaJComboBox((ComboBoxModel)new RmaListModel(false, objectArray));
        this._combo.setPreferredSize(this._paramCombo.getPreferredSize());
        this._combo.setModifiable(true);
        rmaJLabel.setLabelFor(this._combo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add(this._combo, (Object)gridBagConstraints);
        this._missingPluginLabel = new JLabel("aaaa");
        this._missingPluginLabel.setToolTipText("The selected Plugin is missing from the install or failed to load");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add((Component)this._missingPluginLabel, (Object)gridBagConstraints);
        rmaJLabel = new RmaJLabel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getPanel().add((Component)rmaJLabel, (Object)gridBagConstraints);
    }

    private ExternalDataType[] getAvailableExternalDataTypes() {
        ArrayList<ExternalDataType> arrayList = new ArrayList<ExternalDataType>();
        for (String string : ExternalDataPluginManager.getAvailablePluginNames()) {
            arrayList.addAll(ExternalDataPluginManager.getExternalDataPlugin((String)string).getSupportedDataTypes());
        }
        arrayList.add(this._emptyExternalType);
        return arrayList.toArray(new ExternalDataType[0]);
    }

    @Override
    protected void fillPanel(GlobalVariable globalVariable) {
        if (globalVariable instanceof ExternalGlobalVariable) {
            RmaListModel rmaListModel = this.getAvailableExternalDataTypes();
            Arrays.parallelSort(rmaListModel, Comparator.comparing(ExternalDataType::toString));
            this._combo.setModel((ComboBoxModel)new RmaListModel(false, (Object[])rmaListModel));
            this._globalExternal = (ExternalGlobalVariable)globalVariable;
            this._isDataLocationCheckBox.setSelected(this._globalExternal.getIsDataLocation());
            ExternalGlobalVariablePanel externalGlobalVariablePanel = this;
            externalGlobalVariablePanel.setInput(externalGlobalVariablePanel._globalExternal.isInput());
            this.setDescriptionPanel(globalVariable.getName(), globalVariable.getDescription());
            globalVariable = this._globalExternal.getExternalDataDefinition();
            rmaListModel = (RmaListModel)this._combo.getModel();
            if (globalVariable == null) {
                this._combo.setSelectedItem((Object)this._emptyExternalType);
                this._missingPluginLabel.setText("");
            } else if (rmaListModel.contains((Object)globalVariable)) {
                this._combo.setSelectedItem((Object)globalVariable);
                this._missingPluginLabel.setText("");
            } else {
                this._combo.addItem((Object)globalVariable);
                this._combo.setSelectedItem((Object)globalVariable);
                this._missingPluginLabel.setText("Selected Plugin Is Missing");
            }
            if (this._globalExternal.getParameterType() != null) {
                this._paramCombo.setSelectedItem((Object)this._globalExternal.getParameterType());
            } else {
                this._paramCombo.setSelectedIndex(-1);
            }
        }
        this.setModified(false);
    }

    @Override
    protected void savePanel() {
        if (this._globalExternal != null) {
            this._globalExternal.setName(this.getDescriptionPanel().getName());
            this._globalExternal.setDescription(this.getDescriptionPanel().getDescription());
            this._globalExternal.setInput(this.isInput());
            this._globalExternal.setIsDataLocation(this.isDataLocationSelected());
            ExternalDataType externalDataType = (ExternalDataType)this._combo.getSelectedItem();
            if (externalDataType == this._emptyExternalType) {
                this._globalExternal.setExternalDataDefinition(null);
            } else {
                this._globalExternal.setExternalDataDefinition(externalDataType);
            }
            if (this._paramCombo.getSelectedItem() != null) {
                this._globalExternal.setParameterType(this._paramCombo.getSelectedItem().toString());
            }
        }
        this.setModified(false);
    }

    @Override
    protected boolean isValidPanel() {
        if ("Output".equals(this.getUsageTypeCombo().getSelectedItem())) {
            String string = null;
            if (this._paramCombo.getSelectedIndex() == -1) {
                string = "Please select a Parameter Type";
            }
            if (string != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), string, "Missing Data", 1);
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getTypeString() {
        return GlobalVariableType.EXTERNAL.toString();
    }
}

