/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.DeleteGlobalVariableAction;
import hec.rss.client.globalvariable.ExternalGlobalVariablePanel;
import hec.rss.client.globalvariable.GlobalVarTreeFolder;
import hec.rss.client.globalvariable.GlobalVariableEditor$1;
import hec.rss.client.globalvariable.GlobalVariableEditor$2;
import hec.rss.client.globalvariable.GlobalVariableEditor$3;
import hec.rss.client.globalvariable.GlobalVariableEditor$TreeCellRenderer;
import hec.rss.client.globalvariable.GlobalVariableTreeNode;
import hec.rss.client.globalvariable.GlobalVariableTreeNodeInterface;
import hec.rss.client.globalvariable.NewGlobalVariableAction;
import hec.rss.client.globalvariable.RenameGlobalVariableAction;
import hec.rss.client.globalvariable.ScalarVariablePanel;
import hec.rss.client.globalvariable.StringVariablePanel;
import hec.rss.client.globalvariable.TableVariablePanel;
import hec.rss.client.globalvariable.TimeSeriesVariablePanel;
import hec.rss.model.RssSystem;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.tree.RmaJTree;
import rma.swing.tree.RmaTreeModel;

public class GlobalVariableEditor
extends RmaJDialog {
    public static final String PLUGIN_GV_PROP = "ResSim.HasPluginGlobalVariables";
    private RmaJPanel _cardPanel;
    private JMenuItem _renameMenu;
    private JMenuItem _deleteMenu;
    private JMenuItem _closeMenu;
    private GlobalVarTreeFolder _timeSeriesFolder;
    private GlobalVarTreeFolder _scalarFolder;
    private GlobalVarTreeFolder _stringFolder;
    private GlobalVarTreeFolder _tableFolder;
    private GlobalVarTreeFolder _externalFolder;
    private RmaJTree _variablesTree;
    private ButtonCmdPanel _buttonCmdPanel;
    private JMenu _menu;
    private ScalarVariablePanel _scalarvp;
    private StringVariablePanel _stringvp;
    private TableVariablePanel _tablevp;
    private TimeSeriesVariablePanel _tsvp;
    private ExternalGlobalVariablePanel _extvp;
    private List<String> _variableNameList = new ArrayList<String>();
    private RssSystem _network;
    private List<GlobalVariable> _globalVariablesList = new ArrayList<GlobalVariable>();
    private List<GlobalVariable> _newlyCreatedGlobalVarList = new ArrayList<GlobalVariable>();
    private List<GlobalVariable> _deletedVariables = new ArrayList<GlobalVariable>();
    private boolean _networkModified;
    private List<GlobalVariableTreeNode> _nodeList = new ArrayList<GlobalVariableTreeNode>();
    private String _title;
    private Icon _tsIcon;
    private Icon _scalarIcon;
    private Icon _stringIcon;
    private Icon _tableIcon;
    private Icon _externalIcon;

    public GlobalVariableEditor(Frame frame) {
        super(frame);
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(1020, 740);
        this.setLocationRelativeTo(frame);
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._title = "Global Variable Editor - ";
        GlobalVariableEditor globalVariableEditor = this;
        globalVariableEditor.setTitle(globalVariableEditor._title);
        this.setDefaultCloseOperation(0);
        this.buildMenuBar();
        this.buildGlobalVarPanel();
        this.buildTree();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane((Component)this._variablesTree), gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)new JScrollPane((Component)this._cardPanel), gridBagConstraints);
        this._buttonCmdPanel = new ButtonCmdPanel(14);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        GlobalVariableEditor globalVariableEditor2 = this;
        globalVariableEditor2.add((Component)globalVariableEditor2._buttonCmdPanel, gridBagConstraints);
    }

    private void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this._menu = new JMenu("Global Variable");
        this._menu.setMnemonic('G');
        jMenuBar.add(this._menu);
        JMenuItem jMenuItem = new JMenuItem(new NewGlobalVariableAction(this, null));
        this._menu.add(jMenuItem);
        this._renameMenu = new JMenuItem(new RenameGlobalVariableAction(this, null));
        this._renameMenu.setEnabled(false);
        this._menu.add(this._renameMenu);
        this._deleteMenu = new JMenuItem(new DeleteGlobalVariableAction(this, null));
        this._deleteMenu.setEnabled(false);
        this._menu.add(this._deleteMenu);
        this._menu.addSeparator();
        this._closeMenu = new JMenuItem("Close", 67);
        this._menu.add(this._closeMenu);
        this.setJMenuBar(jMenuBar);
    }

    private void buildTree() {
        RmaTreeModel rmaTreeModel = this.createTreeModel();
        this._variablesTree = new GlobalVariableEditor$1(this, rmaTreeModel);
        this._variablesTree.setCellRenderer((TreeCellRenderer)new GlobalVariableEditor$TreeCellRenderer());
        this._variablesTree.setToolTipText("");
        this._variablesTree.setRootVisible(false);
        this._variablesTree.setRowHeight(this._variablesTree.getRowHeight() + 5);
    }

    private RmaTreeModel createTreeModel() {
        this._tsIcon = RmaImage.getImageIcon((String)"Images/HecDssVue18.png");
        this._scalarIcon = RmaImage.getImageIcon((String)"Images/123.gif");
        this._stringIcon = RmaImage.getImageIcon((String)"Images/abc.gif");
        this._tableIcon = RmaImage.getImageIcon((String)"Images/table.gif");
        this._externalIcon = RmaImage.getImageIcon((String)"Images/External_Distribution.gif");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Variables");
        if (Boolean.getBoolean("GvEditor.hasFolders")) {
            this._timeSeriesFolder = new GlobalVarTreeFolder(this, GlobalVariableType.TIME_SERIES);
            this._timeSeriesFolder.setIcon(this._tsIcon);
            this._scalarFolder = new GlobalVarTreeFolder(this, GlobalVariableType.SCALAR);
            this._scalarFolder.setIcon(this._scalarIcon);
            this._stringFolder = new GlobalVarTreeFolder(this, GlobalVariableType.STRING);
            this._stringFolder.setIcon(this._stringIcon);
            this._tableFolder = new GlobalVarTreeFolder(this, GlobalVariableType.TABLE);
            this._tableFolder.setIcon(this._tableIcon);
            this._externalFolder = new GlobalVarTreeFolder(this, GlobalVariableType.EXTERNAL);
            this._externalFolder.setIcon(this._externalIcon);
            defaultMutableTreeNode.add(this._timeSeriesFolder);
            defaultMutableTreeNode.add(this._scalarFolder);
            defaultMutableTreeNode.add(this._stringFolder);
            defaultMutableTreeNode.add(this._tableFolder);
            defaultMutableTreeNode.add(this._externalFolder);
        }
        return new RmaTreeModel((TreeNode)defaultMutableTreeNode);
    }

    private void buildGlobalVarPanel() {
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._scalarvp = new ScalarVariablePanel(this);
        this._stringvp = new StringVariablePanel(this);
        this._tablevp = new TableVariablePanel(this);
        this._tsvp = new TimeSeriesVariablePanel(this);
        this._extvp = new ExternalGlobalVariablePanel(this);
        Object object = new RmaJPanel();
        this._cardPanel.add((Component)((Object)this._scalarvp), (Object)GlobalVariableType.SCALAR.toString());
        this._cardPanel.add((Component)((Object)this._stringvp), (Object)GlobalVariableType.STRING.toString());
        this._cardPanel.add((Component)((Object)this._tablevp), (Object)GlobalVariableType.TABLE.toString());
        this._cardPanel.add((Component)((Object)this._tsvp), (Object)GlobalVariableType.TIME_SERIES.toString());
        this._cardPanel.add((Component)((Object)this._extvp), (Object)GlobalVariableType.EXTERNAL.toString());
        this._cardPanel.add((Component)object, (Object)"empty");
        object = (CardLayout)this._cardPanel.getLayout();
        object.show((Container)this._cardPanel, "empty");
    }

    private void handleButtonCmdClick(ActionEvent actionEvent) {
        RmaJPanel rmaJPanel = this.getSelectedPanel();
        switch (actionEvent.getID()) {
            case 2: {
                if (rmaJPanel instanceof BaseGlobalVarPanel) {
                    this.validatePanel((BaseGlobalVarPanel)rmaJPanel, false);
                    return;
                }
                this.saveNodes();
                return;
            }
            case 8: {
                if (rmaJPanel instanceof BaseGlobalVarPanel) {
                    this.validatePanel((BaseGlobalVarPanel)rmaJPanel, true);
                    return;
                }
                this.saveNodes();
                this.setVisible(false);
                return;
            }
            case 4: {
                this.closeEditor();
            }
        }
    }

    public boolean saveCurrentPanel() {
        RmaJPanel rmaJPanel = this.getSelectedPanel();
        if (rmaJPanel instanceof BaseGlobalVarPanel && (rmaJPanel = (BaseGlobalVarPanel)rmaJPanel).isValidPanel()) {
            rmaJPanel.savePanel();
            return true;
        }
        return false;
    }

    private void validatePanel(BaseGlobalVarPanel baseGlobalVarPanel, boolean bl) {
        if (!baseGlobalVarPanel.isValidPanel()) {
            return;
        }
        this.saveNodes();
        if (bl) {
            this.setVisible(false);
        }
    }

    private void saveNodes() {
        for (GlobalVariableTreeNode globalVariableTreeNode : this._nodeList) {
            this.saveToNetwork(globalVariableTreeNode);
        }
    }

    private void saveToNetwork(GlobalVariableTreeNodeInterface globalVariableTreeNodeInterface) {
        this.updateVariable(globalVariableTreeNodeInterface);
        Object object = null;
        if (globalVariableTreeNodeInterface instanceof GlobalVariableTreeNode) {
            object = (GlobalVariableTreeNode)globalVariableTreeNodeInterface;
        }
        this.deleteVariablesFromNetwork();
        if (object == null) {
            return;
        }
        int n = ((GlobalVariableTreeNode)object).getVariable().getIndex();
        if ((object = this.getGlobalVariable(n)) != null) {
            for (GlobalVariable globalVariable : this._network.getGlobalVariableList()) {
                if (globalVariable.getIndex() != object.getIndex()) continue;
                this._network.updateGlobalVariable(n, object.clone());
            }
        }
        this.setModified(false);
        this._network.setModified(true);
    }

    private GlobalVariable getGlobalVariable(int n) {
        for (GlobalVariable globalVariable : this._globalVariablesList) {
            if (globalVariable.getIndex() != n) continue;
            return globalVariable;
        }
        return null;
    }

    private void deleteVariablesFromNetwork() {
        Iterator<GlobalVariable> iterator = this._deletedVariables.iterator();
        while (iterator.hasNext()) {
            GlobalVariable globalVariable = iterator.next();
            this._network.deleteGlobalVariable(globalVariable);
            iterator.remove();
        }
    }

    private void updateVariable(GlobalVariableTreeNodeInterface globalVariableTreeNodeInterface) {
        if (globalVariableTreeNodeInterface == null) {
            return;
        }
        if (globalVariableTreeNodeInterface instanceof GlobalVariableTreeNode) {
            globalVariableTreeNodeInterface = (GlobalVariableTreeNode)globalVariableTreeNodeInterface;
            GlobalVariableType globalVariableType = ((GlobalVariableTreeNode)globalVariableTreeNodeInterface).getVariable().getType();
            BaseGlobalVarPanel baseGlobalVarPanel = null;
            switch (globalVariableType) {
                case TIME_SERIES: {
                    this._tsvp.savePanel();
                    baseGlobalVarPanel = this._tsvp;
                    break;
                }
                case SCALAR: {
                    this._scalarvp.savePanel();
                    baseGlobalVarPanel = this._scalarvp;
                    break;
                }
                case STRING: {
                    this._stringvp.savePanel();
                    baseGlobalVarPanel = this._stringvp;
                    break;
                }
                case TABLE: {
                    this._tablevp.savePanel();
                    baseGlobalVarPanel = this._tablevp;
                    break;
                }
                case EXTERNAL: {
                    this._extvp.savePanel();
                    baseGlobalVarPanel = this._extvp;
                }
            }
            if (baseGlobalVarPanel != null) {
                this.updateNameInTree((GlobalVariableTreeNode)globalVariableTreeNodeInterface, baseGlobalVarPanel.getName());
                this.setModified(false);
            }
        }
    }

    private void enableDisableRenameDelete(TreeNode treeNode) {
        if (treeNode instanceof GlobalVariableTreeNode) {
            treeNode = (GlobalVariableTreeNode)treeNode;
            this._renameMenu.setEnabled(true);
            this._deleteMenu.setEnabled(true);
            this._menu.remove(this._renameMenu);
            this._menu.remove(this._deleteMenu);
            this._renameMenu = new JMenuItem(new RenameGlobalVariableAction(this, (GlobalVariableTreeNode)treeNode));
            this._deleteMenu = new JMenuItem(new DeleteGlobalVariableAction(this, (GlobalVariableTreeNode)treeNode));
            this._menu.add((Component)this._renameMenu, 1);
            this._menu.add((Component)this._deleteMenu, 2);
            return;
        }
        this._renameMenu.setEnabled(false);
        this._deleteMenu.setEnabled(false);
    }

    public void displayVariablePanel(TreeNode treeNode) {
        this.setIgnoreModifiedEvents(true);
        try {
            CardLayout cardLayout = (CardLayout)this._cardPanel.getLayout();
            if (treeNode instanceof GlobalVariableTreeNode) {
                GlobalVariableType globalVariableType = ((GlobalVariableTreeNode)treeNode).getVariable().getType();
                if (globalVariableType != null) {
                    treeNode = (GlobalVariableTreeNode)treeNode;
                    switch (globalVariableType) {
                        case TIME_SERIES: {
                            this._tsvp.fillPanel(((GlobalVariableTreeNode)treeNode).getVariable());
                            cardLayout.show((Container)this._cardPanel, GlobalVariableType.TIME_SERIES.toString());
                            break;
                        }
                        case SCALAR: {
                            this._scalarvp.fillPanel(((GlobalVariableTreeNode)treeNode).getVariable());
                            cardLayout.show((Container)this._cardPanel, GlobalVariableType.SCALAR.toString());
                            break;
                        }
                        case STRING: {
                            this._stringvp.fillPanel(((GlobalVariableTreeNode)treeNode).getVariable());
                            cardLayout.show((Container)this._cardPanel, GlobalVariableType.STRING.toString());
                            break;
                        }
                        case TABLE: {
                            this._tablevp.fillPanel(((GlobalVariableTreeNode)treeNode).getVariable());
                            cardLayout.show((Container)this._cardPanel, GlobalVariableType.TABLE.toString());
                            break;
                        }
                        case EXTERNAL: {
                            this._extvp.fillPanel(((GlobalVariableTreeNode)treeNode).getVariable());
                            cardLayout.show((Container)this._cardPanel, GlobalVariableType.EXTERNAL.toString());
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (treeNode instanceof GlobalVarTreeFolder) {
                cardLayout.show((Container)this._cardPanel, "empty");
            }
            return;
        }
        finally {
            this.setIgnoreModifiedEvents(false);
        }
    }

    public GlobalVariable getSelectedGlobalVariable() {
        Object object = this._variablesTree.getSelectionPath();
        if (object == null) {
            return null;
        }
        if ((object = ((TreePath)object).getLastPathComponent()) instanceof GlobalVariableTreeNode) {
            return ((GlobalVariableTreeNode)object).getVariable();
        }
        return null;
    }

    public void addGlobalVariableNode(GlobalVariableTreeNode globalVariableTreeNode, boolean bl) {
        if (globalVariableTreeNode == null) {
            return;
        }
        GlobalVariableType globalVariableType = globalVariableTreeNode.getVariable().getType();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._variablesTree.getModel();
        MutableTreeNode mutableTreeNode = null;
        switch (globalVariableType) {
            case TIME_SERIES: {
                mutableTreeNode = this._timeSeriesFolder;
                break;
            }
            case SCALAR: {
                mutableTreeNode = this._scalarFolder;
                break;
            }
            case STRING: {
                mutableTreeNode = this._stringFolder;
                break;
            }
            case TABLE: {
                mutableTreeNode = this._tableFolder;
                break;
            }
            case EXTERNAL: {
                mutableTreeNode = this._externalFolder;
            }
        }
        if (mutableTreeNode == null) {
            mutableTreeNode = (MutableTreeNode)defaultTreeModel.getRoot();
        }
        if (mutableTreeNode != null) {
            int n = mutableTreeNode.getChildCount();
            globalVariableTreeNode.setIcon(this.getIconForType(globalVariableTreeNode.getType()));
            defaultTreeModel.insertNodeInto(globalVariableTreeNode, mutableTreeNode, n);
            if (bl) {
                Object object = defaultTreeModel.getPathToRoot(globalVariableTreeNode);
                object = new TreePath((Object[])object);
                this._variablesTree.setSelectionPath((TreePath)object);
            }
            this._variableNameList.add(globalVariableTreeNode.getVariable().getName());
            this._globalVariablesList.add(globalVariableTreeNode.getVariable());
            this._nodeList.add(globalVariableTreeNode);
        }
    }

    private Icon getIconForType(GlobalVariableType globalVariableType) {
        switch (globalVariableType) {
            case TIME_SERIES: {
                return this._tsIcon;
            }
            case EXTERNAL: {
                return this._externalIcon;
            }
            case SCALAR: {
                return this._scalarIcon;
            }
            case STRING: {
                return this._stringIcon;
            }
            case TABLE: {
                return this._tableIcon;
            }
        }
        return null;
    }

    public boolean updateNameInTree(GlobalVariableTreeNode globalVariableTreeNode, String string) {
        if (string == null) {
            return false;
        }
        if (string.length() <= 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Name cannot be empty!", "Invalid Name", 1);
            this.revertName(globalVariableTreeNode);
            return false;
        }
        if (this.nameInUse(string) && !string.equals(globalVariableTreeNode.getName())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Name already in use", "Invalid Name", 1);
            this.revertName(globalVariableTreeNode);
            return false;
        }
        Object object = globalVariableTreeNode.getName();
        this._variableNameList.remove(object);
        globalVariableTreeNode.changeName(string);
        object = (DefaultTreeModel)this._variablesTree.getModel();
        ((DefaultTreeModel)object).nodeChanged(globalVariableTreeNode);
        this._variableNameList.add(string);
        return true;
    }

    private void revertName(GlobalVariableTreeNode globalVariableTreeNode) {
        BaseGlobalVarPanel baseGlobalVarPanel = (BaseGlobalVarPanel)this.getSelectedPanel();
        baseGlobalVarPanel.setDescriptionPanel(globalVariableTreeNode.getName(), globalVariableTreeNode.getDescription());
        baseGlobalVarPanel.savePanel();
    }

    private String formToolTipText(MouseEvent object) {
        if ((object = this._variablesTree.getPathForLocation(((MouseEvent)object).getX(), ((MouseEvent)object).getY())) == null) {
            return null;
        }
        if ((object = ((TreePath)object).getLastPathComponent()) instanceof GlobalVariableTreeNodeInterface) {
            Object object2 = object = (GlobalVariableTreeNodeInterface)object;
            Object object3 = object instanceof GlobalVarTreeFolder ? object2.getDescription() : ("".equals(object2.getDescription()) || "".equals(object2.getName()) ? "" : "Description: " + object2.getDescription() + "<br>");
            object2 = object;
            object = object2.getUsageType();
            return "<html>" + (String)object3 + (String)("".contentEquals((CharSequence)object) ? object2.getUsageType() : "Usage Type: " + object2.getUsageType()) + "</html>";
        }
        return null;
    }

    private boolean consume(MouseEvent mouseEvent) {
        RmaJPanel rmaJPanel = this.getSelectedPanel();
        if (rmaJPanel instanceof BaseGlobalVarPanel && !((BaseGlobalVarPanel)this.getSelectedPanel()).isValidPanel()) {
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public RmaJPanel getSelectedPanel() {
        Component[] componentArray = this._cardPanel.getComponents();
        Component[] componentArray2 = componentArray;
        componentArray2 = componentArray;
        int n = componentArray.length;
        for (int i = 0; i < n; ++i) {
            Component component = componentArray2[i];
            if (!component.isVisible()) continue;
            return (RmaJPanel)component;
        }
        return null;
    }

    public void deleteNode(GlobalVariableTreeNode globalVariableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._variablesTree.getModel();
        this._deletedVariables.add(globalVariableTreeNode.getVariable());
        this._variableNameList.remove(globalVariableTreeNode.getName());
        defaultTreeModel.removeNodeFromParent(globalVariableTreeNode);
    }

    public boolean nameInUse(String string) {
        return this._variableNameList.contains(string);
    }

    private void addListeners() {
        this._buttonCmdPanel.addCmdPanelListener(this::handleButtonCmdClick);
        this._closeMenu.addActionListener(actionEvent -> this.closeEditor());
        this._variablesTree.addTreeSelectionListener(this::treeSelectionChanged);
        this._variablesTree.addMouseListener((MouseListener)new GlobalVariableEditor$2(this));
        this.addWindowListener(new GlobalVariableEditor$3(this));
    }

    private void treeSelectionChanged(TreeSelectionEvent object) {
        if (((TreeSelectionEvent)object).getNewLeadSelectionPath() == null) {
            CardLayout cardLayout = (CardLayout)this._cardPanel.getLayout();
            cardLayout.show((Container)this._cardPanel, "empty");
            return;
        }
        Object object2 = ((TreeSelectionEvent)object).getNewLeadSelectionPath();
        if ((object2 = ((TreePath)object2).getLastPathComponent()) instanceof TreeNode) {
            int n;
            object2 = (TreeNode)object2;
            RmaJPanel rmaJPanel = this.getSelectedPanel();
            if (rmaJPanel != null && rmaJPanel.isModified() && (object = ((TreeSelectionEvent)object).getOldLeadSelectionPath().getLastPathComponent()) instanceof GlobalVariableTreeNode && (n = JOptionPane.showConfirmDialog((Component)((Object)this), "Would you like to save " + ((GlobalVariableTreeNode)(object = (GlobalVariableTreeNode)object)).getName() + "?", "Save Variable", 0)) == 0) {
                BaseGlobalVarPanel baseGlobalVarPanel = (BaseGlobalVarPanel)rmaJPanel;
                baseGlobalVarPanel.savePanel();
                this.updateNameInTree((GlobalVariableTreeNode)object, rmaJPanel.getName());
                rmaJPanel.setModified(false);
            }
            this.enableDisableRenameDelete((TreeNode)object2);
            object = this.getSelectedPanel();
            if (object instanceof ScalarVariablePanel) {
                ((ScalarVariablePanel)((Object)object)).clearMinMax();
                ((ScalarVariablePanel)((Object)object)).resetMinMax();
            }
            this.displayVariablePanel((TreeNode)object2);
        }
    }

    public boolean closeEditor() {
        if (this.isModified()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save Changes?", "Save Changes", 1);
            if (n == 0) {
                RmaJPanel rmaJPanel = this.getSelectedPanel();
                if (rmaJPanel instanceof BaseGlobalVarPanel && !((BaseGlobalVarPanel)this.getSelectedPanel()).isValidPanel()) {
                    return false;
                }
                this.saveNodes();
            } else if (n == 1) {
                for (GlobalVariable globalVariable : this._newlyCreatedGlobalVarList) {
                    this._network.deleteGlobalVariable(globalVariable);
                }
                if (!this._networkModified) {
                    this._network.setModified(false);
                }
            } else {
                return false;
            }
        }
        this.setVisible(false);
        return true;
    }

    public void fillForm(RssSystem rssSystem) {
        this._network = rssSystem;
        this._networkModified = this._network.isModified();
        this._globalVariablesList.clear();
        this._variableNameList.clear();
        this._newlyCreatedGlobalVarList.clear();
        this._deletedVariables.clear();
        Object object = this.createTreeModel();
        this._variablesTree.setModel((TreeModel)object);
        for (GlobalVariable globalVariable : this._network.getGlobalVariableList()) {
            GlobalVariable globalVariable2 = globalVariable.clone();
            GlobalVariableTreeNode object2 = new GlobalVariableTreeNode(this, globalVariable2.getType(), globalVariable2);
            this.addGlobalVariableNode(object2, false);
        }
        object = (CardLayout)this._cardPanel.getLayout();
        ((CardLayout)object).show((Container)this._cardPanel, "empty");
        this._variablesTree.expandAll(true);
        this._variablesTree.setSelectionPath(null);
        this._deleteMenu.setEnabled(false);
        this._renameMenu.setEnabled(false);
        this.setModified(false);
        this._title = "Global Variable Editor - " + rssSystem.getName();
        GlobalVariableEditor globalVariableEditor = this;
        globalVariableEditor.setTitle(globalVariableEditor._title);
    }

    public List<String> getVariableNamesList() {
        return this._variableNameList;
    }

    public RssSystem getNetwork() {
        return this._network;
    }

    public void addToCreatedVarList(GlobalVariable globalVariable) {
        this._newlyCreatedGlobalVarList.add(globalVariable);
    }

    public void setModified(boolean bl) {
        if (bl) {
            GlobalVariableEditor globalVariableEditor = this;
            globalVariableEditor.setTitle(globalVariableEditor._title + "*");
        } else {
            GlobalVariableEditor globalVariableEditor = this;
            globalVariableEditor.setTitle(globalVariableEditor._title);
        }
        super.setModified(bl);
    }

    public void resetMinMax(GlobalVariableTreeNode globalVariableTreeNode) {
        this.displayVariablePanel(globalVariableTreeNode);
        globalVariableTreeNode = this.getSelectedPanel();
        if (globalVariableTreeNode instanceof ScalarVariablePanel) {
            ((ScalarVariablePanel)((Object)globalVariableTreeNode)).resetMinMax();
        }
    }
}

