/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.rss.client.globalvariable.DeleteGlobalVariableAction;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.globalvariable.GlobalVariableTreeNodeInterface;
import hec.rss.client.globalvariable.RenameGlobalVariableAction;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;

public class GlobalVariableTreeNode
extends DefaultMutableTreeNode
implements GlobalVariableTreeNodeInterface {
    private GlobalVariableType _type;
    private GlobalVariableEditor _gve;
    private JPopupMenu _popUpMenu;
    private GlobalVariable _gv;
    private String _newName;
    private String _newDescription;
    private Icon _icon;

    public GlobalVariableTreeNode(GlobalVariableEditor globalVariableEditor, GlobalVariableType globalVariableType, GlobalVariable globalVariable) {
        super(globalVariable);
        this._gv = globalVariable;
        this._gve = globalVariableEditor;
        this._type = globalVariableType;
    }

    private void buildMenuItems() {
        JMenuItem jMenuItem = new JMenuItem(new RenameGlobalVariableAction(this._gve, this));
        JMenuItem jMenuItem2 = new JMenuItem(new DeleteGlobalVariableAction(this._gve, this));
        this._popUpMenu.add(jMenuItem);
        this._popUpMenu.add(jMenuItem2);
    }

    private void createPopupMenu() {
        this._popUpMenu = new JPopupMenu();
        this.buildMenuItems();
    }

    @Override
    public GlobalVariableType getType() {
        return this._type;
    }

    @Override
    public String getName() {
        if (this._newName != null) {
            return this._newName;
        }
        return this._gv.getName();
    }

    @Override
    public String toString() {
        if (this._newName != null) {
            return this._newName;
        }
        return super.toString();
    }

    @Override
    public void displayPopupMenu(MouseEvent mouseEvent) {
        this.createPopupMenu();
        this._popUpMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public String getDescription() {
        if (this._newDescription != null) {
            return this._newDescription;
        }
        return this._gv.getDescription();
    }

    public void changeName(String string) {
        this._newName = string;
        this.setUserObject(string);
    }

    public void changeDescription(String string) {
        this._newDescription = string;
    }

    public GlobalVariable getVariable() {
        return this._gv;
    }

    @Override
    public String getUsageType() {
        if (this.getVariable().isInput()) {
            return "Input";
        }
        return "Output";
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }
}

