/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.gui.NameDescriptionPanel;
import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.globalvariable.GlobalVariableTreeNode;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;

public class NewGlobalVariableDialog
extends RmaJDialog {
    private NameDescriptionPanel _descriptionPanel;
    private RmaJComboBox<GlobalVariableType> _variableTypeCombo;
    private ButtonCmdPanel _buttonCmdPanel;
    private GlobalVariableEditor _gve;
    private GlobalVariable _newGlobalVar;
    private GlobalVariableType _type;

    public NewGlobalVariableDialog(GlobalVariableEditor globalVariableEditor) {
        super((Dialog)((Object)globalVariableEditor), true);
        this._gve = globalVariableEditor;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(300, 195);
        NewGlobalVariableDialog newGlobalVariableDialog = this;
        newGlobalVariableDialog.setLocationRelativeTo(newGlobalVariableDialog.getParent());
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("New Global Variable");
        this.addDescriptionPanel();
        this.addVariableType();
        this.addButtonCmdPanels();
    }

    private void addDescriptionPanel() {
        this._descriptionPanel = new NameDescriptionPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        NewGlobalVariableDialog newGlobalVariableDialog = this;
        newGlobalVariableDialog.add((Component)newGlobalVariableDialog._descriptionPanel, gridBagConstraints);
    }

    private void addVariableType() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GlobalVariableType[] globalVariableTypeArray = new RmaJLabel("Variable Type: ");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)globalVariableTypeArray, gridBagConstraints);
        globalVariableTypeArray = GlobalVariableType.values();
        Vector<GlobalVariableType> vector = new Vector<GlobalVariableType>();
        vector.addAll(Arrays.asList(globalVariableTypeArray));
        if (!Boolean.getBoolean("ResSim.HasPluginGlobalVariables")) {
            vector.remove((Object)GlobalVariableType.EXTERNAL);
        }
        this._variableTypeCombo = new RmaJComboBox(vector);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        NewGlobalVariableDialog newGlobalVariableDialog = this;
        newGlobalVariableDialog.add((Component)newGlobalVariableDialog._variableTypeCombo, gridBagConstraints);
    }

    private void addButtonCmdPanels() {
        this._buttonCmdPanel = new ButtonCmdPanel(12);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        NewGlobalVariableDialog newGlobalVariableDialog = this;
        newGlobalVariableDialog.add((Component)newGlobalVariableDialog._buttonCmdPanel, gridBagConstraints);
    }

    private void handleButtonCmdClick(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            String string = this._descriptionPanel.getName();
            if ((string = string.trim()).length() <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Name cannot be empty!", "Invalid Name", 1);
            } else if (this._gve.nameInUse(string)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "<html>" + string + " already exists<br>Please enter a new name</html>", "Duplicate Name", 2);
            } else {
                this.addNewVariable();
            }
        }
        if (actionEvent.getID() == 4) {
            this.setVisible(false);
        }
    }

    private void addNewVariable() {
        GlobalVariableType globalVariableType = (GlobalVariableType)((Object)this._variableTypeCombo.getSelectedItem());
        this._newGlobalVar = this._gve.getNetwork().newGlobalVariable(this._descriptionPanel.getName(), globalVariableType);
        this._gve.addToCreatedVarList(this._newGlobalVar);
        this.setDescriptionPanel();
        this.createAndAddNode();
        this._gve.setModified(true);
        this.setVisible(false);
    }

    private void createAndAddNode() {
        Object object = (GlobalVariableType)((Object)this._variableTypeCombo.getSelectedItem());
        object = new GlobalVariableTreeNode(this._gve, (GlobalVariableType)((Object)object), this._newGlobalVar);
        ((GlobalVariableTreeNode)object).changeName(this._descriptionPanel.getName());
        this._gve.addGlobalVariableNode((GlobalVariableTreeNode)object, true);
        this._gve.resetMinMax((GlobalVariableTreeNode)object);
        object = this._gve.getSelectedPanel();
        if (object instanceof BaseGlobalVarPanel) {
            object.setModified(true);
        }
    }

    private void setDescriptionPanel() {
        this._newGlobalVar.setDescription(this._descriptionPanel.getDescription());
    }

    public void setGlobalVariableType(GlobalVariableType globalVariableType) {
        if (globalVariableType != null) {
            this._variableTypeCombo.setSelectedItem((Object)globalVariableType);
            this._variableTypeCombo.setEnabled(false);
        }
    }

    private void addListeners() {
        this._buttonCmdPanel.addCmdPanelListener(this::handleButtonCmdClick);
    }
}

