/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.rss.client.globalvariable.NewTableNameDialog$1;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTextField;

final class NewTableNameDialog
extends RmaJDialog {
    private final Consumer<String> _nameConsumer;
    private final List<String> _existingNames;
    private ButtonCmdPanel _okCancelPanel;
    private RmaJTextField _nameField;

    NewTableNameDialog(Window window, boolean bl, List<String> list, Consumer<String> consumer) {
        super(window, "New Table", bl);
        this._nameConsumer = consumer;
        this._existingNames = list;
        this.setLayout(new GridBagLayout());
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(300, this.getHeight());
        this.setLocationRelativeTo(window);
    }

    private void addListeners() {
        this._nameField.addKeyListener((KeyListener)new NewTableNameDialog$1(this));
        this._okCancelPanel.getButton(8).addActionListener(actionEvent -> this.okAction());
        this._okCancelPanel.getButton(4).addActionListener(actionEvent -> this.cancelAction());
    }

    private void cancelAction() {
        this.dispose();
    }

    private void validateOkButton() {
        this._okCancelPanel.getButton(8).setEnabled(this._nameField.getText().trim().length() > 0);
    }

    private void okAction() {
        String string = this._nameField.getText().trim();
        boolean bl = this._existingNames.stream().anyMatch(string2 -> string2.equalsIgnoreCase(string));
        if (bl) {
            JOptionPane.showMessageDialog((Component)((Object)this), string + " already exists. Please enter a unique table name.", "Duplicate Name", 0);
            return;
        }
        this._nameConsumer.accept(string);
        this.dispose();
    }

    private void buildControls() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Name:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.add((Component)rmaJLabel, gridBagConstraints);
        this._nameField = new RmaJTextField();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        NewTableNameDialog newTableNameDialog = this;
        newTableNameDialog.add((Component)newTableNameDialog._nameField, gridBagConstraints);
        this._okCancelPanel = new ButtonCmdPanel();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        NewTableNameDialog newTableNameDialog2 = this;
        newTableNameDialog2.add((Component)newTableNameDialog2._okCancelPanel, gridBagConstraints);
    }
}

