/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.heclib.util.HecTime;
import hec.rss.client.globalvariable.ScalarVariablePanel;
import hec.rss.model.globalvariable.ScalarDataType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.logging.Level;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDateField;
import rma.swing.RmaJDateTimeField;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class ScalarVariablePanel$MinMaxPanel
extends RmaJPanel {
    private String _type;
    final /* synthetic */ ScalarVariablePanel this$0;

    public ScalarVariablePanel$MinMaxPanel(ScalarVariablePanel scalarVariablePanel, String string) {
        this.this$0 = scalarVariablePanel;
        super((LayoutManager)new CardLayout());
        this._type = string;
        this.buildControls();
        this.setEnabled(false);
    }

    public void reset() {
        for (Component component : this.getComponents()) {
            this.fillField(component, "");
        }
    }

    public void setValue(String string) {
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            this.fillField(component, string);
        }
    }

    private void fillField(Component component, String object) {
        if (object == null || ((String)object).isEmpty()) {
            if (component instanceof RmaJComboBox) {
                ((RmaJComboBox)component).setSelectedIndex(-1);
                return;
            }
            ((RmaJTextField)component).setText("");
            return;
        }
        if (component instanceof RmaJIntegerField) {
            ((RmaJIntegerField)component).setValue(Integer.parseInt((String)object));
            return;
        }
        if (component instanceof RmaJDecimalField) {
            ((RmaJDecimalField)component).setValue(Double.parseDouble((String)object));
            return;
        }
        if (component instanceof RmaJDateTimeField) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("d MMMM yyyy, HH:mm");
            try {
                object = LocalDateTime.parse((CharSequence)object, dateTimeFormatter);
                object = Date.from(((LocalDateTime)object).atZone(ZoneId.systemDefault()).toInstant());
                ((RmaJDateTimeField)component).setDate((Date)object);
            }
            catch (DateTimeParseException dateTimeParseException) {
                ScalarVariablePanel.c.log(Level.WARNING, dateTimeParseException.getMessage(), dateTimeParseException);
                ((RmaJDateTimeField)component).setDate(null);
                return;
            }
        } else {
            if (component instanceof RmaJDateField) {
                String string = "ddMMMyyyy";
                if (ScalarDataType.SEASONAL_DATE == this.this$0._dataTypeCombo.getSelectedItem()) {
                    string = "ddMMM";
                }
                object = LocalDate.parse((CharSequence)object);
                object = ((LocalDate)object).format(DateTimeFormatter.ofPattern(string));
                ((RmaJDateField)component).setText((String)object);
                return;
            }
            if (component instanceof RmaJTextField) {
                ((RmaJTextField)component).setText((String)object);
                return;
            }
            if (component instanceof RmaJComboBox) {
                if ("".equals(object)) {
                    ((RmaJComboBox)component).setSelectedIndex(-1);
                    return;
                }
                ((RmaJComboBox)component).setSelectedIndex(RMAIO.parseInt((String)object));
            }
        }
    }

    private void buildControls() {
        RmaJIntegerField rmaJIntegerField = new RmaJIntegerField();
        RmaJDecimalField rmaJDecimalField = new RmaJDecimalField();
        RmaJCalendarField rmaJCalendarField = new RmaJCalendarField("ddMMMyyyy", "");
        RmaJTextField rmaJTextField = new RmaJTextField();
        RmaJ24HourTimeField rmaJ24HourTimeField = new RmaJ24HourTimeField();
        RmaJDateTimeField rmaJDateTimeField = new RmaJDateTimeField();
        RmaJComboBox rmaJComboBox = new RmaJComboBox((Object[])ScalarVariablePanel.a);
        rmaJComboBox.setSelectedIndex(-1);
        RmaJCalendarField rmaJCalendarField2 = new RmaJCalendarField("ddMMM", "");
        RmaJComboBox rmaJComboBox2 = new RmaJComboBox((Object[])ScalarVariablePanel.b);
        rmaJComboBox2.setSelectedIndex(-1);
        this.add((Component)rmaJIntegerField, this._type + "Int");
        this.add((Component)rmaJTextField, this._type + "Bool");
        this.add((Component)rmaJDecimalField, this._type + "Dec");
        this.add((Component)rmaJCalendarField, this._type + "Date");
        this.add((Component)rmaJ24HourTimeField, this._type + "Time");
        this.add((Component)rmaJDateTimeField, this._type + "DateTime");
        this.add((Component)rmaJComboBox, this._type + "DayWeek");
        this.add((Component)rmaJCalendarField2, this._type + "DayYear");
        this.add((Component)rmaJComboBox2, this._type + "Month");
    }

    public Object getValue() {
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return this.getComponentObject(component);
        }
        return null;
    }

    public Object clearComponent() {
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            if (component instanceof RmaJTextField) {
                ((RmaJTextField)component).setText("");
                continue;
            }
            if (!(component instanceof RmaJComboBox)) continue;
            ((RmaJComboBox)component).setSelectedIndex(0);
        }
        return null;
    }

    public boolean isComboBox() {
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component instanceof RmaJComboBox;
        }
        return false;
    }

    private Object getComponentObject(Component serializable) {
        if (serializable instanceof RmaJTextField && (((RmaJTextField)serializable).getText() == null || ((RmaJTextField)serializable).getText().isEmpty())) {
            return null;
        }
        if (serializable instanceof RmaJIntegerField) {
            int n = ((RmaJIntegerField)serializable).getValue();
            if (RMAConst.isValidValue((int)n)) {
                return n;
            }
        } else if (serializable instanceof RmaJDecimalField) {
            double d = ((RmaJDecimalField)serializable).getValue();
            if (RMAConst.isValidValue((double)d)) {
                return d;
            }
        } else if (serializable instanceof RmaJ24HourTimeField) {
            String string = ((RmaJ24HourTimeField)serializable).getText();
            if (!string.trim().isEmpty()) {
                return RMAIO.parseInt((String)string);
            }
        } else {
            if (serializable instanceof RmaJDateTimeField) {
                String string = ((RmaJDateTimeField)serializable).getText();
                HecTime hecTime = new HecTime(string);
                return hecTime;
            }
            if (serializable instanceof RmaJDateField) {
                if (((RmaJDateField)serializable).getDate() != null) {
                    Instant instant = ((RmaJDateField)serializable).getDate().toInstant();
                    ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
                    serializable = zonedDateTime.toLocalDate();
                    return serializable;
                }
                return null;
            }
            if (serializable instanceof RmaJComboBox) {
                return ((RmaJComboBox)serializable).getSelectedIndex();
            }
            if (serializable instanceof RmaJTextField) {
                return ((RmaJTextField)serializable).getText();
            }
        }
        return null;
    }

    public void showMinMaxField() {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        ScalarDataType scalarDataType = (ScalarDataType)((Object)this.this$0._dataTypeCombo.getSelectedItem());
        switch (scalarDataType) {
            case INTEGER: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Int");
                return;
            }
            case DOUBLE: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Dec");
                return;
            }
            case BOOLEAN: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Bool");
                return;
            }
            case DATE: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Date");
                return;
            }
            case TIME: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Time");
                return;
            }
            case DATEANDTIME: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "DateTime");
                return;
            }
            case DAYOFWEEK: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "DayWeek");
                return;
            }
            case SEASONAL_DATE: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "DayYear");
                return;
            }
            case MONTHOFYEAR: {
                ScalarVariablePanel$MinMaxPanel scalarVariablePanel$MinMaxPanel = this;
                cardLayout.show((Container)((Object)scalarVariablePanel$MinMaxPanel), scalarVariablePanel$MinMaxPanel._type + "Month");
            }
        }
    }
}

