/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.rss.client.globalvariable.AppendRowAction;
import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.globalvariable.MoveDownAction;
import hec.rss.client.globalvariable.MoveUpAction;
import hec.rss.client.globalvariable.RemoveRowsAction;
import hec.rss.client.globalvariable.StringVariablePanel$1;
import hec.rss.client.globalvariable.StringVariablePanel$2;
import hec.rss.model.globalvariable.CharacterSetType;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.StringGlobalVariable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.table.RmaCellEditor;

public class StringVariablePanel
extends BaseGlobalVarPanel {
    private RmaJCheckBox _caseCheckBox;
    private RmaJCheckBox _filePathCheckbox;
    private RmaJPanel _invalidCharactersPanel;
    private RmaJComboBox<CharacterSetType> _characterComboBox;
    private RmaJTable _selectionTable;
    private RmaJTable _invalidCharactersTable;
    private JPanel _cardPanel;
    private RmaJPanel _selectionListPanel;
    private RmaJPanel _characterCardPanel;
    private StringGlobalVariable _globalString;
    private RmaJPanel _selectionCardPanel;
    private RmaJCheckBox _selectionCheckBox;
    private RmaJComboBox<String> _usageType;

    public StringVariablePanel(GlobalVariableEditor globalVariableEditor) {
        super(globalVariableEditor);
        this.addListeners();
    }

    @Override
    protected int usageTypeRemainder() {
        return 1;
    }

    @Override
    protected void addTopPanelComponents() {
        RmaJPanel rmaJPanel = this.getPanel();
        this._usageType = this.getUsageTypeCombo();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._selectionCardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._selectionCheckBox = new RmaJCheckBox("Selection List");
        this._selectionCardPanel.add((Component)this._selectionCheckBox, (Object)"hideSelection");
        this._selectionCardPanel.add((Component)new JPanel(), (Object)"showSelection");
        this.addCharacterCombo();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS0500;
        rmaJPanel.add((Component)this._selectionCardPanel, gridBagConstraints);
        this.addSelectionPanel();
        this.showSelectionPanel();
    }

    private void addCharacterCombo() {
        RmaJPanel rmaJPanel = this.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._characterCardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._caseCheckBox = new RmaJCheckBox("Case Sensitive");
        JComponent jComponent = new JLabel("Character Set: ");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel2.add((Component)jComponent, (Object)gridBagConstraints);
        this._characterComboBox = new RmaJComboBox((Object[])CharacterSetType.values());
        this._characterComboBox.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel2.add(this._characterComboBox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel2.add((Component)this._caseCheckBox, (Object)gridBagConstraints);
        this._filePathCheckbox = new RmaJCheckBox("File Path");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel2.add((Component)this._filePathCheckbox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0E-4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel2.add((Component)this._isDataLocationCheckBox, (Object)gridBagConstraints);
        jComponent = new JPanel();
        this._characterCardPanel.add((Component)rmaJPanel2, (Object)"Character Panel");
        this._characterCardPanel.add((Component)jComponent, (Object)"Empty");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)this._characterCardPanel, gridBagConstraints);
    }

    private void addSelectionPanel() {
        RmaJPanel rmaJPanel = this.getPanel();
        this._cardPanel = new JPanel(new CardLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._invalidCharactersPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        this._selectionListPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        JPanel jPanel = new JPanel();
        String string = "Selection";
        this._selectionListPanel.setBorder((Border)BorderFactory.createTitledBorder(string));
        this._invalidCharactersPanel.setBorder((Border)BorderFactory.createTitledBorder(string));
        this.fillInvalidCharactersPanel();
        this.fillSelectionListPanel();
        this._cardPanel.add((Component)jPanel, "Empty");
        this._cardPanel.add((Component)this._invalidCharactersPanel, "Invalid Characters");
        this._cardPanel.add((Component)this._selectionListPanel, "Selection List");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._cardPanel, gridBagConstraints);
    }

    private void fillInvalidCharactersPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJTextField rmaJTextField = new JLabel("Enter list of invalid characters");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._invalidCharactersPanel.add((Component)rmaJTextField, (Object)gridBagConstraints);
        rmaJTextField = new String[]{"Invalid Characters"};
        StringVariablePanel stringVariablePanel = this;
        this._invalidCharactersTable = new StringVariablePanel$1(stringVariablePanel, (Component)((Object)stringVariablePanel), (Object[])rmaJTextField);
        rmaJTextField = this._invalidCharactersTable.getColumnModel().getColumn(0);
        rmaJTextField = (RmaJTextField)((RmaCellEditor)rmaJTextField.getCellEditor()).getComponent();
        rmaJTextField.setMaxLength(1);
        this._invalidCharactersTable.setPopupMenuEnabled(false);
        this._invalidCharactersTable.setRowHeight(this._invalidCharactersTable.getRowHeight() + 5);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._invalidCharactersPanel.add((Component)this._invalidCharactersTable.getScrollPane(), (Object)gridBagConstraints);
    }

    private void fillSelectionListPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Object[] objectArray = new JLabel("Enter list of items in the desired selection order");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._selectionListPanel.add((Component)objectArray, (Object)gridBagConstraints);
        objectArray = new String[]{"Selection List"};
        StringVariablePanel stringVariablePanel = this;
        this._selectionTable = new StringVariablePanel$2(stringVariablePanel, (Component)((Object)stringVariablePanel), objectArray);
        this._selectionTable.setPopupMenuEnabled(false);
        this._selectionTable.setRowHeight(this._selectionTable.getRowHeight() + 5);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        this._selectionListPanel.add((Component)this._selectionTable.getScrollPane(), (Object)gridBagConstraints);
        this.buildUpDownButtons();
        this.buildAppendRemoveButtons();
    }

    private void buildAppendRemoveButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJButton rmaJButton = new RmaJButton((Action)new AppendRowAction(this._selectionTable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)rmaJButton);
        rmaJButton = new RmaJButton((Action)new RemoveRowsAction(this._selectionTable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)rmaJButton);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._selectionListPanel.add((Component)rmaJPanel);
    }

    private void buildUpDownButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton jButton = new JButton(new MoveUpAction(this._selectionTable));
        JButton jButton2 = new JButton(new MoveDownAction(this._selectionTable));
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jButton2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._selectionListPanel.add((Component)rmaJPanel, (Object)gridBagConstraints);
    }

    public void showSelectionPanel() {
        CardLayout cardLayout = (CardLayout)this._cardPanel.getLayout();
        CardLayout cardLayout2 = (CardLayout)this._characterCardPanel.getLayout();
        if (this._characterComboBox.getSelectedItem() == null) {
            return;
        }
        CharacterSetType characterSetType = (CharacterSetType)((Object)this._characterComboBox.getSelectedItem());
        if (this._selectionCheckBox.isSelected()) {
            cardLayout.show(this._cardPanel, "Selection List");
            cardLayout2.show((Container)this._characterCardPanel, "Empty");
            return;
        }
        cardLayout2.show((Container)this._characterCardPanel, "Character Panel");
        if (CharacterSetType.ASCII == characterSetType) {
            if (Boolean.getBoolean("GvEditor.StringGV.hasInvalidChars")) {
                cardLayout.show(this._cardPanel, "Invalid Characters");
                return;
            }
            cardLayout.show(this._cardPanel, "Empty");
            return;
        }
        cardLayout.show(this._cardPanel, "Empty");
    }

    @Override
    protected void fillPanel(GlobalVariable vector) {
        this.setFowardModifiedEvents(false);
        try {
            if (vector instanceof StringGlobalVariable) {
                this._globalString = (StringGlobalVariable)((Object)vector);
                this._isDataLocationCheckBox.setSelected(this._globalString.getIsDataLocation());
                StringVariablePanel stringVariablePanel = this;
                stringVariablePanel.setInput(stringVariablePanel._globalString.isInput());
                this.setDescriptionPanel(vector.getName(), vector.getDescription());
                StringVariablePanel stringVariablePanel2 = this;
                stringVariablePanel2.setFreeform(stringVariablePanel2._globalString.isFreeform());
                StringVariablePanel stringVariablePanel3 = this;
                stringVariablePanel3.setCaseSensitive(stringVariablePanel3._globalString.isCaseSensitive());
                StringVariablePanel stringVariablePanel4 = this;
                stringVariablePanel4.setFilePath(stringVariablePanel4._globalString.isFilePath());
                StringVariablePanel stringVariablePanel5 = this;
                stringVariablePanel5.setCharacterComboBox(stringVariablePanel5._globalString.getCharacterSetType());
                this._selectionTable.deleteCells();
                vector = this._globalString.getSelectionList();
                if (vector == null || vector.isEmpty()) {
                    this._selectionTable.appendRow();
                } else {
                    for (int i = 0; i < vector.size(); ++i) {
                        Vector<String> vector2 = new Vector<String>();
                        vector2.add((String)vector.get(i));
                        this._selectionTable.appendRow(vector2);
                    }
                }
                this._invalidCharactersTable.deleteCells();
                List<Character> list = this._globalString.getInvalidCharacters();
                if (list == null || list.isEmpty()) {
                    this._invalidCharactersTable.appendRow();
                    this._invalidCharactersTable.appendRow();
                    this._invalidCharactersTable.appendRow();
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        vector = new Vector<Character>();
                        vector.add(list.get(i));
                        this._invalidCharactersTable.appendRow(vector);
                    }
                }
            }
        }
        finally {
            this.setFowardModifiedEvents(true);
        }
        this.showSelectionPanel();
        this.setModified(false);
    }

    private void setCharacterComboBox(CharacterSetType characterSetType) {
        this._characterComboBox.setSelectedItem((Object)characterSetType);
    }

    @Override
    public void savePanel() {
        if (this._globalString != null) {
            Object object;
            this._globalString.setName(this.getDescriptionPanel().getName());
            this._globalString.setDescription(this.getDescriptionPanel().getDescription());
            this._globalString.setInput(this.isInput());
            this._globalString.setFreeForm(this.isFreeForm());
            this._globalString.setFilePath(this._filePathCheckbox.isSelected());
            this._globalString.setCaseSensitive(this._caseCheckBox.isSelected());
            this._globalString.setCharacterSetType((CharacterSetType)((Object)this._characterComboBox.getSelectedItem()));
            this._globalString.setIsDataLocation(this.isDataLocationSelected());
            Object object2 = new ArrayList<String>();
            this._selectionTable.commitEdit(true);
            for (int i = 0; i < this._selectionTable.getRowCount(); ++i) {
                Object object3 = this._selectionTable.getValueAt(i, 0);
                if (object3 == null) continue;
                object = object3.toString();
                if (((String)(object = ((String)object).trim())).length() <= 0) continue;
                object2.add((String)object);
            }
            this._globalString.setSelectionList((List<String>)object2);
            ArrayList<Character> arrayList = new ArrayList<Character>();
            this._invalidCharactersTable.commitEdit(true);
            for (int i = 0; i < this._invalidCharactersTable.getRowCount(); ++i) {
                object = this._invalidCharactersTable.getValueAt(i, 0);
                if (object == null || (object2 = object.toString()) == null || ((String)object2).length() <= 0) continue;
                arrayList.add(Character.valueOf(((String)object2).charAt(0)));
            }
            this._globalString.setInvalidCharacters(arrayList);
        }
        this.setModified(false);
    }

    public void setGlobalVar(StringGlobalVariable stringGlobalVariable) {
        if (this._globalString != stringGlobalVariable) {
            this._globalString = stringGlobalVariable;
        }
    }

    private void setCaseSensitive(boolean bl) {
        this._caseCheckBox.setSelected(bl);
    }

    private void setFilePath(boolean bl) {
        this._filePathCheckbox.setSelected(bl);
    }

    private void setFreeform(boolean bl) {
        this._selectionCheckBox.setSelected(!bl);
    }

    private boolean isFreeForm() {
        return !this._selectionCheckBox.isSelected();
    }

    private void addListeners() {
        this._selectionCheckBox.addActionListener(actionEvent -> this.showSelectionPanel());
        this._characterComboBox.addActionListener(actionEvent -> this.showSelectionPanel());
        this._usageType.addActionListener(actionEvent -> this.toggleSelection());
        this._filePathCheckbox.addActionListener(actionEvent -> this.toggleFilePath());
    }

    private void toggleFilePath() {
        boolean bl = this._filePathCheckbox.isSelected();
        this._caseCheckBox.setEnabled(!bl);
        this._characterComboBox.setEnabled(!bl);
        this._selectionCheckBox.setEnabled(!bl);
    }

    private void toggleSelection() {
        CardLayout cardLayout = (CardLayout)this._selectionCardPanel.getLayout();
        if ("Input".equals(this._usageType.getSelectedItem())) {
            cardLayout.show((Container)this._selectionCardPanel, "hideSelection");
            return;
        }
        cardLayout.show((Container)this._selectionCardPanel, "showSelection");
    }

    @Override
    protected boolean isValidPanel() {
        return true;
    }

    @Override
    protected String getTypeString() {
        return GlobalVariableType.STRING.toString();
    }
}

