/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.data.Parameter;
import hec.rss.client.globalvariable.AppendRowAction;
import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.client.globalvariable.MoveDownAction;
import hec.rss.client.globalvariable.MoveUpAction;
import hec.rss.client.globalvariable.RemoveRowsAction;
import hec.rss.client.globalvariable.TableVariablePanel$1;
import hec.rss.model.NameValuePair;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TableGlobalVariable;
import hec.rss.model.globalvariable.TableType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.list.RmaListModel;
import rma.swing.table.RmaCellEditor;

public class TableVariablePanel
extends BaseGlobalVarPanel {
    public static final String DEPENDENT_VARIABLE_TITLE = "Define Dependent Variable(s)";
    public static final String INDEPENDENT_VARIABLE_TITLE = "Define Independent Variable(s)";
    private RmaJComboBox<TableType> _tableTypeCombo;
    private RmaJIntegerField _integerField;
    private RmaJTable _simpleIndepTable;
    private RmaJTable _simpleDepTable;
    private RmaJTable _twoVarIndepTable;
    private RmaJTable _twoVarDepTable;
    private RmaJTable _reportIndepTable;
    private RmaJTable _reportDepTable;
    private TableGlobalVariable _globalTable;
    private RmaJComboBox<String> _usageType;
    private RmaJPanel _cardPanel;
    private RmaJPanel _simpleVarPanel;
    private RmaJPanel _twoVarPanel;
    private RmaJPanel _reportVarPanel;
    private ArrayList<NameValuePair<String>> _independentList;
    private ArrayList<NameValuePair<String>> _dependentList;
    private RmaJPanel _panel;
    private RmaJCheckBox _seasonalCheckBox;

    public TableVariablePanel(GlobalVariableEditor globalVariableEditor) {
        super(globalVariableEditor);
        this.addListeners();
    }

    @Override
    protected int usageTypeRemainder() {
        return 1;
    }

    @Override
    protected void addTopPanelComponents() {
        this._panel = this.getPanel();
        this._usageType = this.getUsageTypeCombo();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addTableComponents();
        this._cardPanel = new RmaJPanel((LayoutManager)new CardLayout());
        this._simpleVarPanel = new RmaJPanel();
        this._twoVarPanel = new RmaJPanel();
        this._reportVarPanel = new RmaJPanel();
        this._simpleDepTable = this.buildTable(1, -1, -1, false);
        this._simpleDepTable.setPopupMenuEnabled(false);
        this._simpleIndepTable = this.buildTable(1, 0, 1, true);
        Serializable serializable = this._simpleIndepTable.getScrollPane();
        int n = this._simpleIndepTable.getRowHeight() * 3 + 9;
        serializable = new Dimension(serializable.getPreferredSize().width, n);
        this._simpleIndepTable.getScrollPane().setPreferredSize((Dimension)serializable);
        this._simpleIndepTable.setPopupMenuEnabled(false);
        this._twoVarIndepTable = this.buildTable(2, 0, 1, false);
        this._twoVarIndepTable.getScrollPane().setPreferredSize((Dimension)serializable);
        this._twoVarIndepTable.setPopupMenuEnabled(false);
        this._twoVarDepTable = this.buildTable(1, -1, -1, false);
        this._twoVarDepTable.setPopupMenuEnabled(false);
        this._reportIndepTable = this.buildTable(1, -1, -1, true);
        this._reportIndepTable.getScrollPane().setPreferredSize((Dimension)serializable);
        this._reportIndepTable.setPopupMenuEnabled(false);
        this._reportDepTable = this.buildTable(1, -1, -1, true);
        this._reportDepTable.setPopupMenuEnabled(false);
        this.buildSimpleVarPanel();
        this.buildTwoVarPanel();
        this.buildReportVarPanel();
        this._cardPanel.add((Component)this._simpleVarPanel, (Object)TableType.SIMPLELOOKUPTABLE.toString());
        this._cardPanel.add((Component)this._twoVarPanel, (Object)TableType.TWOVARIABLELOOKUP.toString());
        this._cardPanel.add((Component)this._reportVarPanel, (Object)TableType.REPORT.toString());
        serializable = (CardLayout)this._cardPanel.getLayout();
        ((CardLayout)serializable).show((Container)this._cardPanel, "simple");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._panel.add((Component)this._cardPanel, (Object)gridBagConstraints);
    }

    private void addTableComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Table Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._panel.add((Component)jLabel, (Object)gridBagConstraints);
        this._tableTypeCombo = new RmaJComboBox((Object[])TableType.values());
        this._tableTypeCombo.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._panel.add(this._tableTypeCombo, (Object)gridBagConstraints);
        this._seasonalCheckBox = new RmaJCheckBox("Seasonal Data");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._panel.add((Component)this._seasonalCheckBox, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._panel.add((Component)this._isDataLocationCheckBox, (Object)gridBagConstraints);
    }

    private void buildSimpleVarPanel() {
        this._simpleVarPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder(INDEPENDENT_VARIABLE_TITLE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)60);
        rmaJPanel.add((Component)this._simpleIndepTable.getScrollPane(), (Object)gridBagConstraints);
        rmaJPanel2.setBorder((Border)BorderFactory.createTitledBorder(DEPENDENT_VARIABLE_TITLE));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)60);
        rmaJPanel2.add((Component)this._simpleDepTable.getScrollPane(), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._simpleVarPanel.add((Component)rmaJPanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._simpleVarPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
    }

    private void buildReportVarPanel() {
        this._reportVarPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel2.setBorder((Border)BorderFactory.createTitledBorder(INDEPENDENT_VARIABLE_TITLE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)60);
        rmaJPanel2.add((Component)this._reportIndepTable.getScrollPane(), (Object)gridBagConstraints);
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder(DEPENDENT_VARIABLE_TITLE));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5550;
        rmaJPanel.add((Component)this._reportDepTable.getScrollPane(), (Object)gridBagConstraints);
        this.addTableButtons(rmaJPanel);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._reportVarPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._reportVarPanel.add((Component)rmaJPanel, (Object)gridBagConstraints);
    }

    private void buildTwoVarPanel() {
        this._twoVarPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        rmaJPanel.setBorder((Border)BorderFactory.createTitledBorder(INDEPENDENT_VARIABLE_TITLE));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)60);
        rmaJPanel.add((Component)this._twoVarIndepTable.getScrollPane(), (Object)gridBagConstraints);
        rmaJPanel2.setBorder((Border)BorderFactory.createTitledBorder(DEPENDENT_VARIABLE_TITLE));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)60);
        rmaJPanel2.add((Component)this._twoVarDepTable.getScrollPane(), (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._twoVarPanel.add((Component)rmaJPanel, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._twoVarPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
    }

    private void addTableButtons(RmaJPanel rmaJPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton jButton = new JButton(new MoveUpAction(this._reportDepTable));
        JButton jButton2 = new JButton(new MoveDownAction(this._reportDepTable));
        RmaJPanel rmaJPanel2 = new RmaJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        rmaJPanel2.add((Component)jButton, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5005;
        rmaJPanel2.add((Component)jButton2, (Object)gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)rmaJPanel2, (Object)gridBagConstraints);
        jButton = new RmaJPanel((LayoutManager)new GridBagLayout());
        jButton2 = new RmaJButton((Action)new AppendRowAction(this._reportDepTable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jButton.add(jButton2);
        jButton2 = new RmaJButton((Action)new RemoveRowsAction(this._reportDepTable));
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        jButton.add(jButton2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)jButton);
    }

    private RmaJTable buildTable(int n, int n2, int n3, boolean bl) {
        Object object = new String[]{"Parameter Name", "Parameter Type"};
        TableVariablePanel tableVariablePanel = this;
        TableVariablePanel$1 tableVariablePanel$1 = new TableVariablePanel$1(tableVariablePanel, (Component)((Object)tableVariablePanel), (Object[])object, n2, n3);
        Object object2 = Parameter.getAvailableParameters();
        object = new Vector<String>();
        ((Vector)object).addAll(Arrays.asList(object2));
        if (bl) {
            ((Vector)object).add("Date");
        }
        Collections.sort(object);
        object2 = tableVariablePanel$1.setComboBoxEditor(1, new Vector());
        RmaListModel rmaListModel = new RmaListModel(false, (Collection)object);
        rmaListModel.setEnableSort(true);
        ((JComboBox)object2).setModel(rmaListModel);
        for (int i = 1; i < n; ++i) {
            tableVariablePanel$1.appendRow();
        }
        TableVariablePanel$1 tableVariablePanel$12 = tableVariablePanel$1;
        tableVariablePanel$12.setRowHeight(tableVariablePanel$12.getRowHeight() + 5);
        return tableVariablePanel$1;
    }

    protected void updateReportTableRows() {
        int n;
        int n2 = this._integerField.getValue();
        int n3 = n2 - (n = this._reportDepTable.getRowCount());
        if (n3 > 0) {
            for (n = 0; n < n3; ++n) {
                this._reportDepTable.appendRow();
            }
            return;
        }
        if (n3 < 0) {
            while (n > n2) {
                this._reportDepTable.deleteRow(n);
                --n;
            }
        }
    }

    private void handleUsageType() {
    }

    private void showSelectedTable() {
        if (this._tableTypeCombo.getSelectedItem() == null) {
            return;
        }
        TableType tableType = (TableType)((Object)this._tableTypeCombo.getSelectedItem());
        if (tableType != null) {
            CardLayout cardLayout = (CardLayout)this._cardPanel.getLayout();
            cardLayout.show((Container)this._cardPanel, tableType.toString());
            this.seasonalCheckboxAction();
            if (tableType == TableType.REPORT) {
                this._seasonalCheckBox.setSelected(false);
                this._seasonalCheckBox.setEnabled(false);
                return;
            }
            this._seasonalCheckBox.setEnabled(true);
        }
    }

    @Override
    protected void fillPanel(GlobalVariable globalVariable) {
        if (globalVariable instanceof TableGlobalVariable) {
            this._globalTable = (TableGlobalVariable)globalVariable;
            this._isDataLocationCheckBox.setSelected(this._globalTable.getIsDataLocation());
            TableVariablePanel tableVariablePanel = this;
            tableVariablePanel.setInput(tableVariablePanel._globalTable.isInput());
            this.setDescriptionPanel(globalVariable.getName(), globalVariable.getDescription());
            this._tableTypeCombo.setSelectedItem((Object)this._globalTable.getTableType());
            this._seasonalCheckBox.setSelected(this._globalTable.isSeasonalData());
            this.fillTables();
            this.seasonalCheckboxAction();
        }
        this.setModified(false);
    }

    @Override
    public void savePanel() {
        if (this._globalTable != null) {
            this.saveBaseAttributes();
            this._independentList = new ArrayList();
            this._dependentList = new ArrayList();
            this._simpleIndepTable.commitEdit(true);
            this._simpleDepTable.commitEdit(true);
            this._reportDepTable.commitEdit(true);
            this._reportIndepTable.commitEdit(true);
            this._twoVarIndepTable.commitEdit(true);
            this._twoVarDepTable.commitEdit(true);
            this._globalTable.setIsDataLocation(this.isDataLocationSelected());
            TableType tableType = (TableType)((Object)this._tableTypeCombo.getSelectedItem());
            switch (tableType) {
                case SIMPLELOOKUPTABLE: {
                    this.saveSimpleTableData();
                    break;
                }
                case TWOVARIABLELOOKUP: {
                    this.saveTwoVarTableData();
                    break;
                }
                case REPORT: {
                    this.saveReportTable();
                }
            }
            this._globalTable.setIndependentList(this._independentList);
            this._globalTable.setDependentList(this._dependentList);
            this._globalTable.setSeasonalData(this._seasonalCheckBox.isSelected());
            this._globalTable.setModifiedTime(System.currentTimeMillis());
        }
        this.setModified(false);
    }

    private void saveBaseAttributes() {
        this._globalTable.setName(this.getDescriptionPanel().getName());
        this._globalTable.setDescription(this.getDescriptionPanel().getDescription());
        this._globalTable.setInput(this.isInput());
        this._globalTable.setTableType((TableType)((Object)this._tableTypeCombo.getSelectedItem()));
    }

    public void setGlobalVar(TableGlobalVariable tableGlobalVariable) {
        if (this._globalTable != tableGlobalVariable) {
            this._globalTable = tableGlobalVariable;
        }
    }

    private void saveSimpleTableData() {
        NameValuePair<String> nameValuePair = (String)this._simpleIndepTable.getValueAt(0, 0);
        String string = (String)this._simpleIndepTable.getValueAt(0, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._independentList.add(nameValuePair);
        nameValuePair = (String)this._simpleDepTable.getValueAt(0, 0);
        string = (String)this._simpleDepTable.getValueAt(0, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._dependentList.add(nameValuePair);
    }

    private void saveTwoVarTableData() {
        NameValuePair<String> nameValuePair = (String)this._twoVarIndepTable.getValueAt(0, 0);
        String string = (String)this._twoVarIndepTable.getValueAt(0, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._independentList.add(nameValuePair);
        nameValuePair = (String)this._twoVarIndepTable.getValueAt(1, 0);
        string = (String)this._twoVarIndepTable.getValueAt(1, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._independentList.add(nameValuePair);
        nameValuePair = (String)this._twoVarDepTable.getValueAt(0, 0);
        string = (String)this._twoVarDepTable.getValueAt(0, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._dependentList.add(nameValuePair);
    }

    private void saveReportTable() {
        NameValuePair<String> nameValuePair = (String)this._reportIndepTable.getValueAt(0, 0);
        String string = (String)this._reportIndepTable.getValueAt(0, 1);
        if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
            nameValuePair = "";
        }
        if (string == null || string.isEmpty()) {
            string = "";
        }
        nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
        this._independentList.add(nameValuePair);
        for (int i = 0; i < this._reportDepTable.getRowCount(); ++i) {
            nameValuePair = (String)this._reportDepTable.getValueAt(i, 0);
            string = (String)this._reportDepTable.getValueAt(i, 1);
            if (nameValuePair == null || ((String)((Object)nameValuePair)).isEmpty()) {
                nameValuePair = "";
            }
            if (string == null || string.isEmpty()) {
                string = "";
            }
            nameValuePair = new NameValuePair<String>((String)((Object)nameValuePair), string);
            this._dependentList.add(nameValuePair);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillTables() {
        this._simpleIndepTable.clearCells();
        this._simpleDepTable.clearCells();
        this._twoVarIndepTable.clearCells();
        this._twoVarDepTable.clearCells();
        this._reportDepTable.clearCells();
        this._reportIndepTable.clearCells();
        TableVariablePanel tableVariablePanel = this;
        tableVariablePanel.clearTableCombo(tableVariablePanel._twoVarIndepTable, 0, 1);
        TableVariablePanel tableVariablePanel2 = this;
        tableVariablePanel2.clearTableCombo(tableVariablePanel2._twoVarIndepTable, 1, 1);
        TableVariablePanel tableVariablePanel3 = this;
        tableVariablePanel3.clearTableCombo(tableVariablePanel3._twoVarDepTable, 0, 1);
        TableVariablePanel tableVariablePanel4 = this;
        tableVariablePanel4.clearTableCombo(tableVariablePanel4._simpleDepTable, 0, 1);
        TableVariablePanel tableVariablePanel5 = this;
        tableVariablePanel5.clearTableCombo(tableVariablePanel5._simpleIndepTable, 0, 1);
        TableVariablePanel tableVariablePanel6 = this;
        tableVariablePanel6.clearTableCombo(tableVariablePanel6._reportDepTable, 0, 1);
        TableVariablePanel tableVariablePanel7 = this;
        tableVariablePanel7.clearTableCombo(tableVariablePanel7._reportIndepTable, 0, 1);
        this.setFowardModifiedEvents(false);
        try {
            List<NameValuePair<String>> list = this._globalTable.getIndependentList();
            List<NameValuePair<String>> list2 = this._globalTable.getDependentList();
            if (list == null) {
                list = new ArrayList<NameValuePair<String>>();
                list.add(new NameValuePair<String>("", ""));
            }
            if (list2 == null) {
                list2 = new ArrayList<NameValuePair<String>>();
                list2.add(new NameValuePair<String>("", ""));
            }
            if (this._tableTypeCombo.getSelectedItem() == null) {
                return;
            }
            TableType tableType = (TableType)((Object)this._tableTypeCombo.getSelectedItem());
            switch (tableType) {
                case SIMPLELOOKUPTABLE: {
                    this.fillSimpleLookupTable(list, list2);
                    return;
                }
                case TWOVARIABLELOOKUP: {
                    this.fillTwoVarTable(list, list2);
                    return;
                }
                case REPORT: {
                    this.fillReportTable(list, list2);
                    return;
                }
            }
            return;
        }
        finally {
            this.setFowardModifiedEvents(true);
        }
    }

    private void clearTableCombo(RmaJTable object, int n, int n2) {
        if ((object = object.getCellEditor(n, n2)) instanceof RmaCellEditor) {
            object = (RmaCellEditor)object;
            if ((object = object.getEditorComponent()) instanceof JComboBox) {
                ((JComboBox)object).setSelectedIndex(0);
                ((JComboBox)object).setSelectedIndex(-1);
            }
        }
    }

    private void fillTwoVarTable(List<NameValuePair<String>> list, List<NameValuePair<String>> list2) {
        this._twoVarIndepTable.deleteCells();
        this._twoVarDepTable.deleteCells();
        Vector<String> vector = new Vector<String>();
        if (!list.isEmpty()) {
            vector.add(list.get(0).getName());
            vector.add(list.get(0).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._twoVarIndepTable.appendRow(vector);
        vector = new Vector();
        if (list.size() > 1) {
            vector.add(list.get(1).getName());
            vector.add(list.get(1).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._twoVarIndepTable.appendRow(vector);
        vector = new Vector();
        if (!list2.isEmpty()) {
            vector.add(list2.get(0).getName());
            vector.add(list2.get(0).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._twoVarDepTable.appendRow(vector);
    }

    private void fillReportTable(List<NameValuePair<String>> list, List<NameValuePair<String>> list2) {
        this._reportDepTable.deleteCells();
        this._reportIndepTable.deleteCells();
        Vector<String> vector = new Vector<String>();
        if (!list.isEmpty()) {
            vector.add(list.get(0).getName());
            vector.add(list.get(0).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._reportIndepTable.appendRow(vector);
        for (int i = 0; i < list2.size(); ++i) {
            vector = new Vector<String>();
            vector.add(list2.get(i).getName());
            vector.add(list2.get(i).getValue());
            this._reportDepTable.appendRow(vector);
        }
    }

    private void fillSimpleLookupTable(List<NameValuePair<String>> list, List<NameValuePair<String>> list2) {
        this._simpleIndepTable.deleteCells();
        this._simpleDepTable.deleteCells();
        Vector<String> vector = new Vector<String>();
        if (!list.isEmpty()) {
            vector.add(list.get(0).getName());
            vector.add(list.get(0).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._simpleIndepTable.appendRow(vector);
        vector = new Vector();
        if (!list2.isEmpty()) {
            vector.add(list2.get(0).getName());
            vector.add(list2.get(0).getValue());
        } else {
            vector.add("");
            vector.add("");
        }
        this._simpleDepTable.appendRow(vector);
    }

    private void addListeners() {
        this._usageType.addActionListener(actionEvent -> this.handleUsageType());
        this._tableTypeCombo.addActionListener(actionEvent -> this.showSelectedTable());
        this._seasonalCheckBox.addActionListener(actionEvent -> this.seasonalCheckboxAction());
    }

    private void seasonalCheckboxAction() {
        boolean bl = this._seasonalCheckBox.isSelected();
        TableType tableType = (TableType)((Object)this._tableTypeCombo.getSelectedItem());
        switch (tableType) {
            case SIMPLELOOKUPTABLE: {
                TableVariablePanel tableVariablePanel = this;
                tableVariablePanel.updateTableForSeasonalDate(tableVariablePanel._simpleIndepTable, bl, 0, 1, true);
                return;
            }
            case TWOVARIABLELOOKUP: {
                TableVariablePanel tableVariablePanel = this;
                tableVariablePanel.updateTableForSeasonalDate(tableVariablePanel._twoVarIndepTable, bl, 0, 1, true);
                TableVariablePanel tableVariablePanel2 = this;
                tableVariablePanel2.updateTableForSeasonalDate(tableVariablePanel2._twoVarIndepTable, bl, 1, 1, false);
            }
        }
    }

    private void updateTableForSeasonalDate(RmaJTable rmaJTable, boolean bl, int n, int n2, boolean bl2) {
        Object object = rmaJTable.getValueAt(n, n2);
        RmaCellEditor rmaCellEditor = (RmaCellEditor)rmaJTable.getCellEditor(n, n2);
        rmaCellEditor = (RmaJComboBox)rmaCellEditor.getComponent();
        RmaListModel rmaListModel = (RmaListModel)rmaCellEditor.getModel();
        if (bl) {
            if (!rmaListModel.contains((Object)"Seasonal Date")) {
                rmaListModel.addElement((Object)"Seasonal Date");
                rmaCellEditor.revalidate();
            }
            if (bl2) {
                rmaJTable.setValueAt((Object)"Seasonal Date", n, n2);
            }
        } else if (!bl) {
            rmaListModel.removeElement((Object)"Seasonal Date");
            if ("Seasonal Date".equals(object)) {
                rmaJTable.setValueAt((Object)"", n, n2);
            }
        }
        rmaJTable.repaint();
    }

    @Override
    protected boolean isValidPanel() {
        switch ((TableType)((Object)this._tableTypeCombo.getSelectedItem())) {
            case SIMPLELOOKUPTABLE: {
                this._simpleIndepTable.commitEdit(true);
                this._simpleDepTable.commitEdit(true);
                String string = (String)this._simpleIndepTable.getValueAt(0, 0);
                String string2 = (String)this._simpleIndepTable.getValueAt(0, 1);
                String string3 = (String)this._simpleDepTable.getValueAt(0, 0);
                String string4 = (String)this._simpleDepTable.getValueAt(0, 1);
                if (!this.checkParam(string, "Please enter an Independent Parameter Name")) {
                    return false;
                }
                if (!this.checkParam(string2, "Please enter an Independent Parameter Type")) {
                    return false;
                }
                if (!this.checkParam(string3, "Please enter an Dependent Parameter Name")) {
                    return false;
                }
                if (this.checkParam(string4, "Please enter an Dependent Parameter Type")) break;
                return false;
            }
            case TWOVARIABLELOOKUP: {
                this._twoVarIndepTable.commitEdit(true);
                this._twoVarDepTable.commitEdit(true);
                String string = (String)this._twoVarIndepTable.getValueAt(0, 0);
                String string5 = (String)this._twoVarIndepTable.getValueAt(0, 1);
                String string6 = (String)this._twoVarIndepTable.getValueAt(1, 0);
                String string7 = (String)this._twoVarIndepTable.getValueAt(1, 1);
                String string8 = (String)this._twoVarDepTable.getValueAt(0, 0);
                String string9 = (String)this._twoVarDepTable.getValueAt(0, 1);
                if (!this.checkParam(string, "Please enter an Independent Parameter Name")) {
                    return false;
                }
                if (!this.checkParam(string5, "Please select an Independent Parameter Type")) {
                    return false;
                }
                if (!this.checkParam(string6, "Please enter an Independent Parameter Name")) {
                    return false;
                }
                if (!this.checkParam(string7, "Please select an Independent Parameter Type")) {
                    return false;
                }
                if (!this.checkParam(string8, "Please enter an Dependent Parameter Name")) {
                    return false;
                }
                if (!this.checkParam(string9, "Please select an Dependent Parameter Type")) {
                    return false;
                }
                if (!this._seasonalCheckBox.isSelected() || !"Date".equalsIgnoreCase((String)this._twoVarIndepTable.getValueAt(1, 1))) break;
                string = "'Date' is not a valid selection for the second independent variable with Seasonal Data";
                JOptionPane.showMessageDialog((Component)((Object)this), string, "Invalid Selection", 1);
                return false;
            }
            case REPORT: {
                this._reportIndepTable.commitEdit(true);
                this._reportDepTable.commitEdit(true);
                String string = (String)this._reportIndepTable.getValueAt(0, 0);
                String string10 = (String)this._reportIndepTable.getValueAt(0, 1);
                if (!this.checkParam(string, "Please enter an Independent Parameter Name")) {
                    return false;
                }
                if (!this.checkParam(string10, "Please select an Independent Parameter Type")) {
                    return false;
                }
                for (int i = 0; i < this._reportDepTable.getRowCount(); ++i) {
                    String string11 = (String)this._reportDepTable.getValueAt(i, 0);
                    String string12 = (String)this._reportDepTable.getValueAt(i, 1);
                    if (!this.checkParam(string11, "Please enter an Dependent Parameter Name on Row " + (i + 1))) {
                        return false;
                    }
                    if (this.checkParam(string12, "Please select an Dependent Parameter Type on Row" + (i + 1))) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    private boolean checkParam(String string, String string2) {
        if (string == null || string.trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), string2, "Missing Data", 1);
            return false;
        }
        return true;
    }

    @Override
    protected String getTypeString() {
        return GlobalVariableType.TABLE.toString();
    }
}

