/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.globalvariable;

import hec.data.Parameter;
import hec.rss.client.globalvariable.BaseGlobalVarPanel;
import hec.rss.client.globalvariable.GlobalVariableEditor;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.model.globalvariable.TimeSeriesGlobalVariable;
import hec.rss.model.globalvariable.TimeStepType;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public class TimeSeriesVariablePanel
extends BaseGlobalVarPanel {
    private JPanel _parameterNamePanel;
    private RmaJComboBox<String> _parameterCombo;
    private JPanel _paramOutputPanel;
    private RmaJTextField _outputParamField;
    private RmaJComboBox<String> _usageTypeCombo;
    private RmaJComboBox<TimeStepType> _timeStepSelectionCombo;
    private TimeSeriesGlobalVariable _globalTS;
    private JPanel _timeStepCardPanel;

    public TimeSeriesVariablePanel(GlobalVariableEditor globalVariableEditor) {
        super(globalVariableEditor);
        this.addActionListeners();
    }

    @Override
    protected int usageTypeRemainder() {
        return -1;
    }

    @Override
    protected void addTopPanelComponents() {
        RmaJPanel rmaJPanel = this.getPanel();
        this._usageTypeCombo = this.getUsageTypeCombo();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._isDataLocationCheckBox, gridBagConstraints);
        this._parameterNamePanel = new JPanel(new CardLayout());
        Object[] objectArray = new JPanel();
        this._paramOutputPanel = new JPanel(new GridBagLayout());
        this.addOutputParamComponents();
        gridBagConstraints = new GridBagConstraints();
        this._parameterNamePanel.add((Component)objectArray, "Input");
        this._parameterNamePanel.add((Component)this._paramOutputPanel, "Output");
        objectArray = new RmaJLabel("Parameter Type:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)objectArray, gridBagConstraints);
        objectArray = Parameter.getAvailableParameters();
        Arrays.parallelSort((Comparable[])objectArray);
        this._parameterCombo = new RmaJComboBox(objectArray);
        this._parameterCombo.setModifiable(true);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.001;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)this._parameterCombo, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)this._parameterNamePanel, gridBagConstraints);
        this.buildTimeStepComponents();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        rmaJPanel.add((Component)this._timeStepCardPanel, gridBagConstraints);
    }

    private void buildTimeStepComponents() {
        Serializable serializable = new GridBagConstraints();
        this._timeStepCardPanel = new JPanel(new CardLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        RmaJLabel rmaJLabel = new RmaJLabel("Time Step Selection: ");
        serializable.gridx = -1;
        serializable.gridy = -1;
        serializable.gridwidth = 1;
        serializable.weightx = 0.0;
        serializable.weighty = 0.0;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.INSETS5505;
        rmaJPanel.add((Component)rmaJLabel, (Object)serializable);
        this._timeStepSelectionCombo = new RmaJComboBox((Object[])TimeStepType.values());
        this._timeStepSelectionCombo.setModifiable(true);
        serializable.gridx = -1;
        serializable.gridy = -1;
        serializable.gridwidth = 0;
        serializable.weightx = 0.001;
        serializable.weighty = 0.0;
        serializable.anchor = 17;
        serializable.fill = 0;
        serializable.insets = RmaInsets.INSETS5505;
        rmaJPanel.add(this._timeStepSelectionCombo, (Object)serializable);
        serializable = new JPanel();
        this._timeStepCardPanel.add((Component)rmaJPanel, "timeStep");
        this._timeStepCardPanel.add((Component)serializable, "emptyTimeStep");
    }

    private void addOutputParamComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        RmaJLabel rmaJLabel = new RmaJLabel("Parameter Name:");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._paramOutputPanel.add((Component)rmaJLabel, gridBagConstraints);
        this._outputParamField = new RmaJTextField("", 20);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._paramOutputPanel.add((Component)this._outputParamField, gridBagConstraints);
    }

    protected void handleUsageType() {
        CardLayout cardLayout = (CardLayout)this._parameterNamePanel.getLayout();
        CardLayout cardLayout2 = (CardLayout)this._timeStepCardPanel.getLayout();
        if (this._usageTypeCombo.getSelectedItem() != null) {
            if ("Input".equals(this._usageTypeCombo.getSelectedItem().toString())) {
                cardLayout.show(this._parameterNamePanel, "Input");
                cardLayout2.show(this._timeStepCardPanel, "emptyTimeStep");
                return;
            }
            cardLayout.show(this._parameterNamePanel, "Output");
            cardLayout2.show(this._timeStepCardPanel, "timeStep");
        }
    }

    @Override
    protected void fillPanel(GlobalVariable globalVariable) {
        if (globalVariable instanceof TimeSeriesGlobalVariable) {
            this._globalTS = (TimeSeriesGlobalVariable)globalVariable;
            this._isDataLocationCheckBox.setSelected(this._globalTS.getIsDataLocation());
            TimeSeriesVariablePanel timeSeriesVariablePanel = this;
            timeSeriesVariablePanel.setInput(timeSeriesVariablePanel._globalTS.isInput());
            this.setDescriptionPanel(globalVariable.getName(), globalVariable.getDescription());
            this._outputParamField.setText(this._globalTS.getParameter());
            this._parameterCombo.setSelectedIndex(-1);
            this._parameterCombo.setSelectedItem((Object)this._globalTS.getParameterType());
            this._timeStepSelectionCombo.setSelectedItem((Object)this._globalTS.getTimeStepType());
        }
        this.setModified(false);
    }

    @Override
    protected void savePanel() {
        if (this._globalTS != null) {
            this._globalTS.setName(this.getDescriptionPanel().getName());
            this._globalTS.setDescription(this.getDescriptionPanel().getDescription());
            this._globalTS.setInput(this.isInput());
            this._globalTS.setParameter(this._outputParamField.getText());
            if (this._parameterCombo.getSelectedItem() != null) {
                this._globalTS.setParameterType(this._parameterCombo.getSelectedItem().toString());
            }
            this._globalTS.setTimeStepType((TimeStepType)((Object)this._timeStepSelectionCombo.getSelectedItem()));
            this._globalTS.setIsDataLocation(this.isDataLocationSelected());
        }
        this.setModified(false);
    }

    public void setGlobalVar(TimeSeriesGlobalVariable timeSeriesGlobalVariable) {
        if (this._globalTS != timeSeriesGlobalVariable) {
            this._globalTS = timeSeriesGlobalVariable;
        }
    }

    private void addActionListeners() {
        this._usageTypeCombo.addActionListener(actionEvent -> this.handleUsageType());
    }

    @Override
    protected boolean isValidPanel() {
        if ("Output".equals(this._usageTypeCombo.getSelectedItem())) {
            String string = null;
            if (this._parameterCombo.getSelectedIndex() == -1) {
                string = "Please select a Parameter Type";
            } else if (this._outputParamField.getText().trim().isEmpty()) {
                string = "Please enter a Parameter Name";
            }
            if (string != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), string, "Missing Data", 1);
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getTypeString() {
        return GlobalVariableType.TIME_SERIES.toString();
    }
}

