/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.jfx;

import hec.heclib.util.HecTime;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.client.DiversionElementGraphNodeFilter;
import hec.rss.client.JunctionElementConfluenceGraphNodeFilter;
import hec.rss.client.JunctionElementControlGraphNodeFilter;
import hec.rss.client.JunctionElementGraphNodeFilter;
import hec.rss.client.ReachElementGraphFilter;
import hec.rss.client.ReservoirElementGraphNodeFilter;
import hec.rss.client.graph.filter.OrNodeFilter;
import hec.rss.client.graph.hierarchical.HierarchicalLayout;
import hec.rss.client.jfx.PlotCanvas;
import hec.rss.client.jfx.ReservoirCanvas;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$1;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$2;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$3;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$4;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$5;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$6;
import hec.rss.client.jfx.ReservoirLayoutPlotDialog$ResPlotMode;
import hec.rss.client.jfx.RssSystemStoragePlotModel;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementGraph;
import hec.rss.model.OpRule;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssSystem;
import hec.rss.model.SystemHydropowerRule;
import hec.rss.model.SystemStorageDefinition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javax.swing.JFrame;
import rma.swing.RmaImage;
import rma.swing.RmaJFrame;

public class ReservoirLayoutPlotDialog
extends JFrame {
    public static final String SCHEMATIC_RESONLY = "Reservoirs Only";
    public static final String SCHEMATIC_KEYELEM = "Key Elements";
    public static final String SCHEMATIC_ALLELEM = "All Elements";
    public static final String SYSTEM_ALLIMPLICIT = "All Reservoirs";
    public static final String PLOTTYPE_STOR = "Storage";
    public static final String PLOTTYPE_ELEV = "Elevation";
    public static final String PLOTTYPE_PERCENTZONE = "Percent of Zone";
    final JFXPanel _fxPanel = new JFXPanel();
    final Slider _timeSlider = new Slider();
    final ReservoirCanvas _resCanvas = new ReservoirCanvas();
    final PlotCanvas _plotCanvas = new PlotCanvas();
    String _systemSelection = "All Reservoirs";
    String _plotType = "Storage";
    String _schematicType = "Key Elements";
    private RssSystem _system;
    private ReservoirSysOp _sysOp;
    private ResSystemOpSet _systemBalance;
    private RunTimeWindow _rtw;
    private ElementGraph _elemGraph;
    private ReservoirElement[] _resArray;
    private boolean _showResTree = true;
    private boolean _showTimeSlider = true;
    private Insets _labelInsets = new Insets(5.0, 5.0, 5.0, 5.0);
    private Map<String, Object> _systemSourceMap = new HashMap<String, Object>();
    private ReservoirLayoutPlotDialog$ResPlotMode _plotMode = ReservoirLayoutPlotDialog$ResPlotMode.DEFAULT;
    private Label _timeLabel;
    HierarchicalLayout mRoot = null;
    private final Label _systemComboLabel = new Label("Reservoir System Selection: ");
    private final Label _plotcomboLabel = new Label("Plot As: ");
    private Label _schematicComboLabel;
    private ComboBox<String> _schematicCombo;
    private ComboBox<String> _systemCombo;
    private ComboBox<String> _plotCombo;

    public ReservoirLayoutPlotDialog(Frame frame, String string) {
        super(string);
        this.initFrameSize(frame);
    }

    public ReservoirLayoutPlotDialog(Frame frame, String string, ReservoirLayoutPlotDialog$ResPlotMode reservoirLayoutPlotDialog$ResPlotMode) {
        super(string);
        this._plotMode = reservoirLayoutPlotDialog$ResPlotMode;
        if (this._plotMode == ReservoirLayoutPlotDialog$ResPlotMode.RES_ONLY_1YEAR) {
            this._showResTree = false;
        }
        this.initFrameSize(frame);
    }

    private void initFrameSize(Frame serializable) {
        this.initIcon();
        if (this._plotMode == ReservoirLayoutPlotDialog$ResPlotMode.RES_ONLY_1YEAR) {
            serializable = new Dimension(500, 500);
            this.setMinimumSize((Dimension)serializable);
            return;
        }
        serializable = new Dimension(650, 500);
        this.setMinimumSize((Dimension)serializable);
    }

    public void setSystemBalance(ResSystemOpSet resSystemOpSet) {
        this._systemBalance = resSystemOpSet;
    }

    private void initIcon() {
        Image image = RmaImage.loadURLImage((Component)this, (String)"Images/rss.gif");
        if (image != null) {
            this.setIconImage(image);
            RmaJFrame.setDefaultIconImage((Image)image);
        }
    }

    public void fillPanel(ReservoirSysOp hierarchicalLayout) {
        this._sysOp = hierarchicalLayout;
        this._system = ((ReservoirSysOp)((Object)hierarchicalLayout)).getSystem();
        hierarchicalLayout = this._sysOp.getReservoirList();
        this._resArray = new ReservoirElement[hierarchicalLayout.size()];
        hierarchicalLayout.toArray(this._resArray);
        this.buildElementGraph();
        ReservoirLayoutPlotDialog reservoirLayoutPlotDialog = this;
        hierarchicalLayout = reservoirLayoutPlotDialog.getLayout(reservoirLayoutPlotDialog._schematicType);
        this.setData(hierarchicalLayout);
    }

    public void setRunTimeWindow(RunTimeWindow runTimeWindow) {
        if (runTimeWindow != null) {
            this._rtw = runTimeWindow;
            return;
        }
        if (this._plotMode == ReservoirLayoutPlotDialog$ResPlotMode.RES_ONLY_1YEAR) {
            this.loadDefaultTimeWindow();
        }
    }

    private void loadDefaultTimeWindow() {
        Calendar calendar = GregorianCalendar.getInstance();
        int n = calendar.get(1);
        calendar.set(n, 0, 2, 0, 0, 0);
        HecTime hecTime = new HecTime(calendar);
        calendar.set(1, n + 1);
        calendar.add(6, -1);
        calendar = new HecTime(calendar);
        this._rtw = new RunTimeWindow(hecTime, (HecTime)calendar, null);
        this._rtw.setLookbackTime(hecTime);
        this._rtw.setTimeStep(1, 3);
        this._rtw.computeSteps();
    }

    public void setRssSystem(RssSystem object, RunTimeWindow runTimeWindow) {
        this._system = object;
        this.setRunTimeWindow(runTimeWindow);
        this.buildElementGraph();
        ReservoirLayoutPlotDialog reservoirLayoutPlotDialog = this;
        object = reservoirLayoutPlotDialog.getLayout(reservoirLayoutPlotDialog._schematicType);
        this.setData((HierarchicalLayout)object);
    }

    void buildElementGraph() {
        if (this._system == null) {
            this._elemGraph = null;
            return;
        }
        this._elemGraph = this._system.buildElementGraph(0, true, false);
        if (this._resArray == null || this._resArray.length == 0) {
            this.buildResArray();
        }
        if (this._systemSelection != SYSTEM_ALLIMPLICIT) {
            this._elemGraph.a(this._resArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void buildResArray() {
        if (this._systemSelection == SYSTEM_ALLIMPLICIT) {
            Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
            if (vector == null || vector.size() <= 0) {
                this._resArray = null;
                return;
            }
            this._resArray = new ReservoirElement[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                ReservoirElement reservoirElement = vector.get(n);
                if (reservoirElement != null) {
                    this._resArray[n] = vector.get(n);
                }
                ++n;
            }
            return;
        }
        Object object = this._systemSourceMap.get(this._systemSelection);
        if (object instanceof DownstreamOpRule) {
            DownstreamOpRule downstreamOpRule = (DownstreamOpRule)object;
            List<ReservoirElement> list = downstreamOpRule.getReservoirs(null);
            if (list == null || list.size() <= 0) {
                this._resArray = null;
                return;
            }
            this._resArray = new ReservoirElement[list.size()];
            int n = 0;
            while (n < list.size()) {
                this._resArray[n] = list.get(n);
                ++n;
            }
            return;
        }
        if (!(object instanceof SystemHydropowerRule)) {
            this._resArray = null;
            return;
        }
        SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)object;
        List<ReservoirElement> list = systemHydropowerRule.getReservoirs(null);
        if (list == null || list.size() <= 0) {
            this._resArray = null;
            return;
        }
        this._resArray = new ReservoirElement[list.size()];
        int n = 0;
        while (n < list.size()) {
            this._resArray[n] = list.get(n);
            ++n;
        }
    }

    public HierarchicalLayout<Element> getLayout(String string) {
        this._schematicType = string;
        if (this._elemGraph == null) {
            return null;
        }
        HierarchicalLayout<Element> hierarchicalLayout = new HierarchicalLayout<Element>(this._elemGraph, false, true, 0, 0);
        if (SCHEMATIC_ALLELEM.equals(string)) {
            hierarchicalLayout.a(new OrNodeFilter(new ReservoirElementGraphNodeFilter(), new ReachElementGraphFilter(), new JunctionElementGraphNodeFilter(), new DiversionElementGraphNodeFilter()));
        } else if (SCHEMATIC_KEYELEM.equals(string)) {
            hierarchicalLayout.a(new OrNodeFilter(new ReservoirElementGraphNodeFilter(), new JunctionElementConfluenceGraphNodeFilter(), new JunctionElementControlGraphNodeFilter(), new DiversionElementGraphNodeFilter()));
        } else {
            hierarchicalLayout.a(new OrNodeFilter(new ReservoirElementGraphNodeFilter()));
        }
        return hierarchicalLayout;
    }

    public void setData(HierarchicalLayout hierarchicalLayout) {
        this.mRoot = hierarchicalLayout;
        ReservoirLayoutPlotDialog reservoirLayoutPlotDialog = this;
        reservoirLayoutPlotDialog.add((Component)reservoirLayoutPlotDialog._fxPanel);
        this.setSize(1000, 500);
        this.setLocationByPlatform(true);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        Platform.runLater((Runnable)new ReservoirLayoutPlotDialog$1(this));
    }

    private void initFX(JFXPanel jFXPanel) {
        Scene scene = this.createScene();
        jFXPanel.setScene(scene);
    }

    private Scene createScene() {
        this.initOptionControls();
        if (this._rtw == null) {
            this.loadDefaultTimeWindow();
        }
        this.initPlotCanvas();
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        Scene scene = new Scene((Parent)vBox, (Paint)Color.ALICEBLUE);
        HBox hBox = this.buildTopBox();
        Accordion accordion = new Accordion();
        hBox = new TitledPane("System Plot Options", (Node)hBox);
        hBox.setExpanded(false);
        accordion.getPanes().add((Object)hBox);
        vBox.getChildren().add((Object)accordion);
        this.initTimeSlider();
        hBox = this.buildSplitPane();
        vBox.getChildren().add((Object)hBox);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        if (this._showTimeSlider) {
            hBox = new HBox();
            hBox.setPadding(new Insets(5.0, 0.0, 0.0, 75.0));
            HBox.setHgrow((Node)this._timeSlider, (Priority)Priority.ALWAYS);
            this._timeLabel.setMinSize(75.0, 25.0);
            hBox.getChildren().add((Object)this._timeSlider);
            hBox.getChildren().add((Object)this._timeLabel);
            vBox.getChildren().add((Object)hBox);
        }
        vBox.layout();
        return scene;
    }

    private void initPlotCanvas() {
        if (this._plotMode == ReservoirLayoutPlotDialog$ResPlotMode.RES_ONLY_1YEAR) {
            this._plotCanvas.a(false);
        } else {
            this._plotCanvas.a(true);
        }
        if (this._systemBalance != null) {
            SystemStorageDefinition systemStorageDefinition = this._systemBalance.getSystemStorageDefinition();
            this._plotCanvas.a(new RssSystemStoragePlotModel(this._system, this._elemGraph, this._rtw, this._plotType, this._resArray, systemStorageDefinition, false));
        } else {
            this._plotCanvas.a(new RssSystemStoragePlotModel(this._system, this._elemGraph, this._rtw, this._plotType, this._resArray));
        }
        this._resCanvas.a(this.mRoot);
    }

    private SplitPane buildSplitPane() {
        SplitPane splitPane = new SplitPane();
        StackPane stackPane = new StackPane();
        StackPane stackPane2 = new StackPane();
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setContent((Node)this._plotCanvas);
        stackPane.getChildren().add((Object)scrollPane);
        if (this._showResTree) {
            stackPane2.getChildren().add((Object)this._resCanvas);
            splitPane.getItems().addAll((Object[])new Node[]{stackPane, stackPane2});
            splitPane.setDividerPositions(new double[]{0.5});
        }
        if (!this._showResTree) {
            splitPane.getItems().add((Object)stackPane);
        }
        this._plotCanvas.layoutChildren();
        this._resCanvas.layoutChildren();
        return splitPane;
    }

    private HBox buildTopBox() {
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        if (this._systemBalance == null) {
            hBox.getChildren().add((Object)this._systemComboLabel);
            hBox.getChildren().add(this._systemCombo);
            hBox.getChildren().add((Object)this._plotcomboLabel);
            hBox.getChildren().add(this._plotCombo);
            hBox.getChildren().add((Object)this._schematicComboLabel);
            hBox.getChildren().add(this._schematicCombo);
        } else {
            hBox.getChildren().add((Object)this._plotcomboLabel);
            hBox.getChildren().add(this._plotCombo);
        }
        return hBox;
    }

    private void initOptionControls() {
        this.initSystemComboBox();
        this.initPlotComboBox();
        this.initSchematicComboBox();
    }

    private void initSchematicComboBox() {
        this._schematicComboLabel = new Label("Schematic Drawing Option: ");
        ObservableList observableList = FXCollections.observableArrayList((Object[])new String[]{SCHEMATIC_RESONLY, SCHEMATIC_KEYELEM, SCHEMATIC_ALLELEM});
        this._schematicCombo = new ComboBox(observableList);
        this._schematicCombo.setValue((Object)this._schematicType);
        this._schematicCombo.valueProperty().addListener((ChangeListener)new ReservoirLayoutPlotDialog$2(this));
        this._schematicComboLabel.setAlignment(Pos.CENTER);
        this._schematicComboLabel.setPadding(this._labelInsets);
    }

    private void initPlotComboBox() {
        ObservableList observableList = FXCollections.observableArrayList((Object[])new String[]{PLOTTYPE_STOR, PLOTTYPE_PERCENTZONE, PLOTTYPE_ELEV});
        this._plotCombo = new ComboBox(observableList);
        this._plotCombo.setValue((Object)this._plotType);
        this._plotCombo.valueProperty().addListener((ChangeListener)new ReservoirLayoutPlotDialog$3(this));
        this._plotcomboLabel.setAlignment(Pos.CENTER);
        this._plotcomboLabel.setPadding(this._labelInsets);
    }

    private void initSystemComboBox() {
        Object object = this._system.getSystemRules();
        ObservableList observableList = FXCollections.observableArrayList();
        this._systemSourceMap.clear();
        object = object.iterator();
        while (object.hasNext()) {
            OpRule opRule = (OpRule)object.next();
            this._systemSourceMap.put(opRule.getName(), opRule);
            observableList.add((Object)opRule.getName());
        }
        observableList.add((Object)SYSTEM_ALLIMPLICIT);
        this._systemCombo = new ComboBox(observableList);
        this._systemCombo.setValue((Object)this._systemSelection);
        this._systemCombo.valueProperty().addListener((ChangeListener)new ReservoirLayoutPlotDialog$4(this));
        this._systemComboLabel.setAlignment(Pos.CENTER);
        this._systemComboLabel.setPadding(this._labelInsets);
    }

    private void initTimeSlider() {
        if (this._rtw == null) {
            this.loadDefaultTimeWindow();
        }
        int n = this._rtw.getNumSteps();
        int n2 = this._rtw.getNumLookbackSteps();
        this._timeSlider.setMin(0.0);
        this._timeSlider.setMax((double)n);
        this._timeSlider.setValue((double)n2);
        this._timeSlider.setShowTickLabels(true);
        this._timeSlider.setShowTickMarks(true);
        this._timeSlider.setMajorTickUnit((double)(n / 30));
        this._timeSlider.setMinorTickCount(10);
        this._timeSlider.setBlockIncrement((double)(n / 10));
        this._timeSlider.setMinWidth((double)(this.getWidth() / 8));
        this._timeSlider.setPrefWidth((double)(this.getWidth() / 2));
        this._timeLabel = new Label(Double.toString(this._timeSlider.getValue()));
        Object object = new RunTimeStep(this._rtw);
        this._timeLabel.setText(object.dateTimeString(0));
        this._timeSlider.valueProperty().addListener((ChangeListener)new ReservoirLayoutPlotDialog$5(this));
        object = new ReservoirLayoutPlotDialog$6(this);
        this._timeSlider.setLabelFormatter((StringConverter)object);
    }
}

