/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.client.reports.AlternativeInputReportEditor$1;
import hec.rss.client.reports.AlternativeInputReportEditor$2;
import hec.rss.client.reports.AlternativeInputReportEditor$3;
import hec.rss.client.reports.AlternativeInputReportEditor$4;
import hec.rss.client.reports.AlternativeInputReportEditor$OutputDataNode;
import hec.rss.model.DiversionElement;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReachElement;
import hec.rss.model.ResSystemOpSet;
import hec.rss.model.ReservoirElement;
import hec.rss.model.ReservoirSysOp;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.StateVariable;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.reports.AltInputReportEnums;
import hec.rss.model.reports.AltInputReportItem;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.TextDialog;
import hec.util.XMLUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import mil.army.usace.hec.rmi.client.RmiFileChooserField;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.swing.tree.CheckBoxEditor;
import rma.swing.tree.CheckBoxTreeRenderer;
import rma.swing.tree.NodeSelectionListener;
import rma.swing.tree.RmaJTree;
import rma.util.RMAIO;

public class AlternativeInputReportEditor
extends RmaJDialog {
    private RmiFileChooserField _folderFld;
    private RmaJComboBox _outputOrderCombo;
    private RmaJComboBox _outputTypeCombo;
    private JCheckBox _displayReportCheckbox;
    private RmaJTree _outputDataTree;
    private AlternativeInputReport _report;
    private RssAlt _alt;
    private RssRun _run = null;
    JFrame _parent;
    private Map<AltInputReportEnums, AltInputReportItem> _nodeMap;

    public AlternativeInputReportEditor(JFrame jFrame, RssAlt rssAlt) {
        super((Frame)jFrame);
        this._parent = jFrame;
        this.setTitle("Alternative Input Report Editor");
        this.buildComponenets();
        this._alt = rssAlt;
        this.buildTreeAndFill();
    }

    public AlternativeInputReportEditor(JFrame jFrame, RssRun rssRun) {
        super((Frame)jFrame);
        this.setTitle("Alternative Input Report Editor");
        this.buildComponenets();
        this._run = rssRun;
        this._alt = rssRun.getAlternative();
        this.buildTreeAndFill();
    }

    private void buildComponenets() {
        this.getContentPane().setLayout(new GridBagLayout());
        Object object = new RmaJPanel((LayoutManager)new GridBagLayout());
        JComponent jComponent = new JLabel("File:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        object.add((Component)jComponent, (Object)gridBagConstraints);
        this._folderFld = new RmiFileChooserField();
        jComponent.setLabelFor((Component)this._folderFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        object.add((Component)this._folderFld, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.add((Component)object, gridBagConstraints);
        new JLabel("Output Order:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._outputOrderCombo = new RmaJComboBox((Object[])new String[]{AlternativeInputReport.o, AlternativeInputReport.p, AlternativeInputReport.q});
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent = new JLabel("Output Type:");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._outputTypeCombo = new RmaJComboBox((Object[])new String[]{AlternativeInputReport.t, AlternativeInputReport.s});
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._outputTypeCombo, gridBagConstraints);
        this._displayReportCheckbox = new JCheckBox("Display report in dialog when finished");
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._displayReportCheckbox, gridBagConstraints);
        this._outputDataTree = new AlternativeInputReportEditor$1(this);
        object = new JPopupMenu();
        jComponent = new JMenuItem("Expand Tree");
        ((AbstractButton)jComponent).addActionListener(actionEvent -> this._outputDataTree.expandAll(true));
        ((JPopupMenu)object).add((JMenuItem)jComponent);
        jComponent = new JMenuItem("Collapse Tree");
        ((AbstractButton)jComponent).addActionListener(actionEvent -> this.collapseTree());
        ((JPopupMenu)object).add((JMenuItem)jComponent);
        this._outputDataTree.setComponentPopupMenu((JPopupMenu)object);
        this._outputDataTree.setRowHeight(0);
        this._outputDataTree.getSelectionModel().setSelectionMode(1);
        this._outputDataTree.setCellRenderer((TreeCellRenderer)new CheckBoxTreeRenderer());
        this._outputDataTree.setCellEditor((TreeCellEditor)new CheckBoxEditor());
        this._outputDataTree.setToolTipText("");
        object = new NodeSelectionListener((JTree)this._outputDataTree);
        this._outputDataTree.addMouseListener((MouseListener)object);
        this._outputDataTree.getSelectionModel().addTreeSelectionListener(new AlternativeInputReportEditor$2(this));
        this._outputDataTree.addTreeExpansionListener((TreeExpansionListener)new AlternativeInputReportEditor$3(this));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add(new JScrollPane((Component)this._outputDataTree), gridBagConstraints);
        object = new ButtonCmdPanel(12);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)object, gridBagConstraints);
        object.addCmdPanelListener((ButtonCmdPanelListener)new AlternativeInputReportEditor$4(this));
        this.pack();
    }

    public void pathSelected(Object object) {
        if (object instanceof AlternativeInputReportEditor$OutputDataNode) {
            object = (AlternativeInputReportEditor$OutputDataNode)object;
            if (((AlternativeInputReportEditor$OutputDataNode)object)._item == null) {
                return;
            }
            this._nodeMap.get((Object)((AlternativeInputReportEditor$OutputDataNode)object)._item.e()).a(((AlternativeInputReportEditor$OutputDataNode)object).isSelected());
        }
    }

    /*
     * Loose catch block
     */
    private boolean displayReport() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String[] stringArray;
        Document document;
        Element element;
        block80: {
            block82: {
                Object object7;
                block81: {
                    element = new Element("Alternative_Input_Report");
                    document = new Document(element);
                    stringArray = RMAIO.getFileExtension((String)this._report.a());
                    if (!(this._report.a() == null || stringArray != null && stringArray.equalsIgnoreCase(".xml"))) {
                        this._report.a(this._report.a() + ".xml");
                    }
                    stringArray = RMAIO.makeAbsolutePath((String)this._alt.getWorkspacePath(), (String)this._report.a());
                    if (this._outputTypeCombo.getSelectedItem() != AlternativeInputReport.s) break block80;
                    if (stringArray == null) {
                        System.out.println("Failed to display Alternative Output Report because there is not file specified.");
                        JOptionPane.showMessageDialog((Component)((Object)this), "Failed to display Alternative Output Report because there is not file specified.", "Alternative Output Report Error", 0);
                        return false;
                    }
                    object6 = RMAIO.getDirectoryFromPath((String)stringArray);
                    object5 = new File((String)(object6 = (String)object6 + "/AlternativeInputReport.xslt"));
                    if (!((File)object5).exists()) {
                        object4 = new Identifier((String)object6);
                        try {
                            object3 = this._alt.getFileManager().newFile(UserId.getUserId(), (Identifier)object4);
                        }
                        catch (RemoteException remoteException) {
                            System.out.println("createDssOutFile: RemoteException " + String.valueOf(remoteException));
                            return false;
                        }
                        object2 = object3.getFile();
                        object3 = PreferencesManager.getBufferedReader((String)object6);
                        if (object3 == null) {
                            object7 = "hec/rss/client/reports/AlternativeInputReport.xslt";
                            object6 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)object7);
                            if (object6 == null) {
                                System.out.println("fillPanel: failed to find file " + (String)object7);
                                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to display Alternative Output Report as html because there is no style sheet.", "Alternative Output Report Error", 0);
                                return false;
                            }
                            object3 = new BufferedReader(new InputStreamReader((InputStream)object6));
                            object = object2.getBufferedWriter();
                            if (object == null) {
                                System.out.println("Unable to write or read style sheet to display alternative input report in html." + (String)object7);
                                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write or read style sheet to display alternative input report in html." + (String)object7, "Alternative Output Report Error", 0);
                                return false;
                            }
                            while ((object5 = ((BufferedReader)object3).readLine()) != null) {
                                ((Writer)object).write((String)object5);
                                ((BufferedWriter)object).newLine();
                            }
                            try {
                                ((BufferedReader)object3).close();
                            }
                            catch (IOException iOException) {}
                            try {
                                ((BufferedWriter)object).close();
                            }
                            catch (IOException iOException) {}
                            break block81;
                            catch (IOException iOException) {
                                try {
                                    System.out.println("Unable to write or read style sheet to display alternative input report in html." + (String)object7);
                                    JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write or read style sheet to display alternative input report in html." + (String)object7, "Alternative Output Report Error", 0);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        ((BufferedReader)object3).close();
                                    }
                                    catch (IOException iOException2) {}
                                    try {
                                        ((BufferedWriter)object).close();
                                    }
                                    catch (IOException iOException3) {}
                                    throw throwable;
                                }
                                try {
                                    ((BufferedReader)object3).close();
                                }
                                catch (IOException iOException4) {}
                                try {
                                    ((BufferedWriter)object).close();
                                }
                                catch (IOException iOException5) {}
                                return false;
                            }
                        }
                    }
                }
                object4 = RMAIO.getDirectoryFromPath((String)stringArray);
                object5 = new File((String)(object4 = (String)object4 + "/AlternativeInputReport.xsd"));
                if (!((File)object5).exists()) {
                    object3 = new Identifier((String)object4);
                    try {
                        object2 = this._alt.getFileManager().newFile(UserId.getUserId(), (Identifier)object3);
                    }
                    catch (RemoteException remoteException) {
                        System.out.println("createDssOutFile: RemoteException " + String.valueOf(remoteException));
                        return false;
                    }
                    object3 = object2.getFile();
                    object7 = PreferencesManager.getBufferedReader((String)object4);
                    if (object7 == null) {
                        object6 = "hec/rss/client/reports/AlternativeInputReport.xsd";
                        object = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)object6);
                        if (object == null) {
                            System.out.println("fillPanel: failed to find file " + (String)object6);
                            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to display Alternative Output Report as html because there is no schema sheet.", "Alternative Output Report Error", 0);
                            return false;
                        }
                        object7 = new BufferedReader(new InputStreamReader((InputStream)object));
                        object5 = object3.getBufferedWriter();
                        if (object5 == null) {
                            System.out.println("Unable to write or read schema sheet to display alternative input report in html." + (String)object6);
                            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write or read schema sheet to display alternative input report in html." + (String)object6, "Alternative Output Report Error", 0);
                            return false;
                        }
                        while ((object4 = ((BufferedReader)object7).readLine()) != null) {
                            ((Writer)object5).write((String)object4);
                            ((BufferedWriter)object5).newLine();
                        }
                        try {
                            ((BufferedReader)object7).close();
                        }
                        catch (IOException iOException) {}
                        try {
                            ((BufferedWriter)object5).close();
                        }
                        catch (IOException iOException) {}
                        break block82;
                        catch (IOException iOException) {
                            try {
                                System.out.println("Unable to write or read schema sheet to display alternative input report in html." + (String)object6);
                                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write or read schema sheet to display alternative input report in html." + (String)object6, "Alternative Output Report Error", 0);
                            }
                            catch (Throwable throwable) {
                                try {
                                    ((BufferedReader)object7).close();
                                }
                                catch (IOException iOException6) {}
                                try {
                                    ((BufferedWriter)object5).close();
                                }
                                catch (IOException iOException7) {}
                                throw throwable;
                            }
                            try {
                                ((BufferedReader)object7).close();
                            }
                            catch (IOException iOException8) {}
                            try {
                                ((BufferedWriter)object5).close();
                            }
                            catch (IOException iOException9) {}
                            return false;
                        }
                    }
                }
            }
            XMLUtilities.addXSLTLocation((Document)document, (String)"AlternativeInputReport.xslt");
            XMLUtilities.addXMLSchemaNamespaceDeclaration((Element)element);
            XMLUtilities.addXSDLocation((Element)element, (String)"AlternativeInputReport.xsd");
        }
        if (this._run != null && this._nodeMap.get((Object)AltInputReportEnums.SIMULATION_RUN).a()) {
            object6 = new Element("Simulation_Run_Data");
            element.addContent((Content)object6);
            this._run.outputReport(this._report, (Element)object6);
        }
        if (this._nodeMap.get((Object)AltInputReportEnums.ALTERNATIVE).a()) {
            object6 = new Element("Alternative_Data");
            element.addContent((Content)object6);
            this._alt.outputReport(this._report, (Element)object6);
        }
        if (this._nodeMap.get((Object)AltInputReportEnums.NETWORK).a()) {
            object6 = new Element("Network_Data");
            element.addContent((Content)object6);
            object6.setAttribute("Name", this._alt.getSystem()._name);
            object6.setAttribute("Description", this._alt.getSystem()._description);
            object6.setAttribute("DefaultPulseFlow", Double.toString(this._alt.getSystem().getDefaultPulseFlow()));
            if (this._report.c() == AlternativeInputReport.o) {
                if (this._nodeMap.get((Object)AltInputReportEnums.RESERVOIRS).a()) {
                    object5 = new Element("Reservoirs");
                    object6.addContent((Content)object5);
                    object2 = this._alt.getSystem().getReservoirNames();
                    if (object2 != null) {
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            object3 = this._alt.getSystem().findReservoir((String)object2[i]);
                            if (object3 == null) continue;
                            object4 = new Element("Reservoir");
                            object5.addContent((Content)object4);
                            ((ReservoirElement)object3).outputReport(this._report, (Element)object4);
                        }
                    }
                }
                if (this._nodeMap.get((Object)AltInputReportEnums.REACHES).a()) {
                    object5 = new Element("Reaches");
                    object6.addContent((Content)object5);
                    object2 = this._alt.getSystem().getReachNames();
                    if (object2 != null) {
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            object3 = this._alt.getSystem().findReach((String)object2[i]);
                            if (object3 == null) continue;
                            object4 = new Element("Reach");
                            object5.addContent((Content)object4);
                            ((ReachElement)object3).outputReport(this._report, (Element)object4);
                        }
                    }
                }
                if (this._nodeMap.get((Object)AltInputReportEnums.JUNCTIONS).a()) {
                    object5 = new Element("Junctions");
                    object6.addContent((Content)object5);
                    object2 = this._alt.getSystem().getJunctionNames();
                    if (object2 != null) {
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            object3 = this._alt.getSystem().findJunction((String)object2[i]);
                            if (object3 == null) continue;
                            object4 = new Element("Junction");
                            object5.addContent((Content)object4);
                            ((JunctionElement)object3).outputReport(this._report, (Element)object4);
                        }
                    }
                }
                if (this._nodeMap.get((Object)AltInputReportEnums.DIVERSIONS).a()) {
                    object5 = new Element("Diversions");
                    object6.addContent((Content)object5);
                    object2 = this._alt.getSystem().getDiversionNames();
                    if (object2 != null) {
                        for (int i = 0; i < ((Object)object2).length; ++i) {
                            object3 = this._alt.getSystem().findDiversion((String)object2[i]);
                            if (object3 == null) continue;
                            object4 = new Element("Diversion");
                            object5.addContent((Content)object4);
                            ((DiversionElement)object3).outputReport(this._report, (Element)object4);
                        }
                    }
                }
            }
            if (this._nodeMap.get((Object)AltInputReportEnums.STATE_VARIABLES).a()) {
                object5 = new Element("State_Variables");
                object6.addContent((Content)object5);
                object2 = this._alt.getSystem().getStateVariableList();
                if (object2 != null && !object2.isEmpty()) {
                    for (int i = 0; i < object2.size(); ++i) {
                        object3 = (StateVariable)object2.get(i);
                        object4 = new Element("State_Variable");
                        object5.addContent((Content)object4);
                        ((StateVariable)object3).outputReport(this._report, (Element)object4);
                    }
                }
            }
            if (this._nodeMap.get((Object)AltInputReportEnums.NET_GLOBAL_VARS).a()) {
                object5 = new Element("Global_Variables");
                object6.addContent((Content)object5);
                object2 = this._alt.getSystem().getGlobalVariableList();
                if (object2 != null && !object2.isEmpty()) {
                    for (int i = 0; i < object2.size(); ++i) {
                        object3 = (GlobalVariable)object2.get(i);
                        object4 = new Element("Global_Variable");
                        object5.addContent((Content)object4);
                        object3.outputReport(this._report, (Element)object4);
                    }
                }
            }
            if (this._nodeMap.get((Object)AltInputReportEnums.RESERVOIR_SYSTEMS).a() && (object2 = this._alt.getSystem().getReservoirSysOps()) != null && ((Object)object2).length > 0) {
                object5 = new Element("Reservoir_Systems");
                object6.addContent((Content)object5);
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object3 = object2[i];
                    if (object3 == null) continue;
                    object4 = new Element("Reservoir_System");
                    object5.addContent((Content)object4);
                    object4.setAttribute("Name", ((ReservoirSysOp)object3).getUserName());
                    object4.setAttribute("Description", object3.getDescription());
                    int n = this._alt.getResSysOpSetSelection(object3.getIndex());
                    object = ((ReservoirSysOp)object3).getSystemOpSet(n);
                    if (object == null) continue;
                    object3 = new Element("Reservoir_System_Op_Set");
                    object4.addContent((Content)object3);
                    ((ResSystemOpSet)object).outputReport(this._report, (Element)object3);
                }
            }
        }
        if (XMLUtilities.writeXMLFile((Document)document, (String)stringArray)) {
            if (this._outputTypeCombo.getSelectedItem() == AlternativeInputReport.s) {
                try {
                    object2 = stringArray;
                    object3 = new HecFile[]{"rundll32", "url.dll,FileProtocolHandler", "\"" + ((String)object2).toString() + "\""};
                    Runtime.getRuntime().exec((String[])object3);
                }
                catch (Exception exception) {
                    System.out.println("displayReport:Error running command " + String.valueOf(exception));
                    exception.printStackTrace();
                }
            } else {
                object2 = new TextDialog(this._parent, true);
                try {
                    object2.initialize((String)stringArray, false);
                    object2.setSize(600, 600);
                    object2.setLocationRelativeTo((Component)this._parent);
                    object2.setVisible(true);
                }
                catch (Exception exception) {
                    System.out.println("Failed to display Alternative Output Report: RemoteException " + String.valueOf(exception.getStackTrace()));
                    JOptionPane.showMessageDialog((Component)((Object)this), "Failed to create and display Alternative Output Report.  Check Console log for details.", "Alternative Output Report Error", 0);
                    return false;
                }
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Could not create Alternative Input Report file.  Please check file path.", "File Error", 0);
            return false;
        }
        return true;
    }

    private void buildTreeAndFill() {
        ClientWorkspace clientWorkspace = ClientApp.Workspace();
        this._report = new AlternativeInputReport();
        this._nodeMap = this._report.b();
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode = new AlternativeInputReportEditor$OutputDataNode(this, null);
        AlternativeInputReportEditor alternativeInputReportEditor = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode2 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor, alternativeInputReportEditor._nodeMap.get((Object)AltInputReportEnums.ALTERNATIVE));
        AlternativeInputReportEditor alternativeInputReportEditor2 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor2, alternativeInputReportEditor2._nodeMap.get((Object)AltInputReportEnums.INPUT_DATA));
        for (int i = 0; i < AlternativeInputReport.a.length; ++i) {
            if (AlternativeInputReport.b.length <= i) continue;
            AlternativeInputReportEditor alternativeInputReportEditor3 = this;
            AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode4 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor3, alternativeInputReportEditor3._nodeMap.get((Object)AlternativeInputReport.b[i]));
            alternativeInputReportEditor$OutputDataNode3.add(alternativeInputReportEditor$OutputDataNode4);
        }
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        AlternativeInputReportEditor alternativeInputReportEditor4 = this;
        alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor4, alternativeInputReportEditor4._nodeMap.get((Object)AltInputReportEnums.PLUGINS));
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        AlternativeInputReportEditor alternativeInputReportEditor5 = this;
        alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor5, alternativeInputReportEditor5._nodeMap.get((Object)AltInputReportEnums.ALT_GLOBAL_VARS));
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        alternativeInputReportEditor$OutputDataNode.add(alternativeInputReportEditor$OutputDataNode2);
        this.addNetworkNodes(alternativeInputReportEditor$OutputDataNode);
        this.addSimRunNodes(alternativeInputReportEditor$OutputDataNode);
        ((DefaultTreeModel)this._outputDataTree.getModel()).setRoot(alternativeInputReportEditor$OutputDataNode);
        this._outputDataTree.setRootVisible(false);
        this._outputDataTree.expandAll(true);
        if (this._report.a() == null || this._report.a().length() <= 0) {
            this._folderFld.setText(clientWorkspace.getWorkspacePath() + "/rss/" + this._alt.getName() + "_InputReport.xml");
        } else {
            this._folderFld.setText(RMAIO.makeAbsolutePath((String)this._alt.getWorkspacePath(), (String)this._report.a()));
        }
        this._displayReportCheckbox.setSelected(this._report.e());
        this._outputOrderCombo.setSelectedItem((Object)this._report.c());
        this._outputTypeCombo.setSelectedItem((Object)this._report.d());
    }

    private void collapseTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._outputDataTree.getModel().getRoot();
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getPath());
        this._outputDataTree.expandAll(treePath, false);
        treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(1)).getPath());
        this._outputDataTree.expandAll(treePath, false);
        treePath = new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(2)).getPath());
        this._outputDataTree.expandAll(treePath, false);
    }

    private void addNetworkNodes(AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode) {
        int n;
        int n2;
        AlternativeInputReportEditor alternativeInputReportEditor = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode2 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor, alternativeInputReportEditor._nodeMap.get((Object)AltInputReportEnums.NETWORK));
        AlternativeInputReportEditor alternativeInputReportEditor2 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor2, alternativeInputReportEditor2._nodeMap.get((Object)AltInputReportEnums.RESERVOIRS));
        AlternativeInputReportEditor alternativeInputReportEditor3 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode4 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor3, alternativeInputReportEditor3._nodeMap.get((Object)AltInputReportEnums.RES_PHYSICAL));
        for (n2 = 0; n2 < AlternativeInputReport.c.length; ++n2) {
            if (AlternativeInputReport.d.length <= n2) continue;
            AlternativeInputReportEditor alternativeInputReportEditor4 = this;
            AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode5 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor4, alternativeInputReportEditor4._nodeMap.get((Object)AlternativeInputReport.d[n2]));
            alternativeInputReportEditor$OutputDataNode4.add(alternativeInputReportEditor$OutputDataNode5);
        }
        alternativeInputReportEditor$OutputDataNode3.add(alternativeInputReportEditor$OutputDataNode4);
        AlternativeInputReportEditor alternativeInputReportEditor5 = this;
        alternativeInputReportEditor$OutputDataNode4 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor5, alternativeInputReportEditor5._nodeMap.get((Object)AltInputReportEnums.RES_OPERATIONAL));
        for (int i = 0; i < AlternativeInputReport.e.length; ++i) {
            if (AlternativeInputReport.f.length <= i) continue;
            AlternativeInputReportEditor alternativeInputReportEditor6 = this;
            AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode6 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor6, alternativeInputReportEditor6._nodeMap.get((Object)AlternativeInputReport.f[i]));
            alternativeInputReportEditor$OutputDataNode4.add(alternativeInputReportEditor$OutputDataNode6);
        }
        alternativeInputReportEditor$OutputDataNode3.add(alternativeInputReportEditor$OutputDataNode4);
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        AlternativeInputReportEditor alternativeInputReportEditor7 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode7 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor7, alternativeInputReportEditor7._nodeMap.get((Object)AltInputReportEnums.REACHES));
        for (n2 = 0; n2 < AlternativeInputReport.g.length; ++n2) {
            if (AlternativeInputReport.h.length <= n2) continue;
            AlternativeInputReportEditor alternativeInputReportEditor8 = this;
            alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor8, alternativeInputReportEditor8._nodeMap.get((Object)AlternativeInputReport.h[n2]));
            alternativeInputReportEditor$OutputDataNode7.add(alternativeInputReportEditor$OutputDataNode3);
        }
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode7);
        AlternativeInputReportEditor alternativeInputReportEditor9 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode8 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor9, alternativeInputReportEditor9._nodeMap.get((Object)AltInputReportEnums.JUNCTIONS));
        for (n = 0; n < AlternativeInputReport.i.length; ++n) {
            if (AlternativeInputReport.j.length <= n) continue;
            AlternativeInputReportEditor alternativeInputReportEditor10 = this;
            alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor10, alternativeInputReportEditor10._nodeMap.get((Object)AlternativeInputReport.j[n]));
            alternativeInputReportEditor$OutputDataNode8.add(alternativeInputReportEditor$OutputDataNode3);
        }
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode8);
        AlternativeInputReportEditor alternativeInputReportEditor11 = this;
        alternativeInputReportEditor$OutputDataNode8 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor11, alternativeInputReportEditor11._nodeMap.get((Object)AltInputReportEnums.DIVERSIONS));
        for (n = 0; n < AlternativeInputReport.k.length; ++n) {
            if (AlternativeInputReport.l.length <= n) continue;
            AlternativeInputReportEditor alternativeInputReportEditor12 = this;
            alternativeInputReportEditor$OutputDataNode4 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor12, alternativeInputReportEditor12._nodeMap.get((Object)AlternativeInputReport.l[n]));
            alternativeInputReportEditor$OutputDataNode8.add(alternativeInputReportEditor$OutputDataNode4);
        }
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode8);
        AlternativeInputReportEditor alternativeInputReportEditor13 = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode9 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor13, alternativeInputReportEditor13._nodeMap.get((Object)AltInputReportEnums.STATE_VARIABLES));
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode9);
        AlternativeInputReportEditor alternativeInputReportEditor14 = this;
        alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor14, alternativeInputReportEditor14._nodeMap.get((Object)AltInputReportEnums.NET_GLOBAL_VARS));
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        AlternativeInputReportEditor alternativeInputReportEditor15 = this;
        alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor15, alternativeInputReportEditor15._nodeMap.get((Object)AltInputReportEnums.RESERVOIR_SYSTEMS));
        alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        alternativeInputReportEditor$OutputDataNode.add(alternativeInputReportEditor$OutputDataNode2);
    }

    private void addSimRunNodes(AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode) {
        AlternativeInputReportEditor alternativeInputReportEditor = this;
        AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode2 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor, alternativeInputReportEditor._nodeMap.get((Object)AltInputReportEnums.SIMULATION_RUN));
        for (int i = 0; i < AlternativeInputReport.m.length; ++i) {
            if (AlternativeInputReport.n.length <= i) continue;
            AlternativeInputReportEditor alternativeInputReportEditor2 = this;
            AlternativeInputReportEditor$OutputDataNode alternativeInputReportEditor$OutputDataNode3 = new AlternativeInputReportEditor$OutputDataNode(alternativeInputReportEditor2, alternativeInputReportEditor2._nodeMap.get((Object)AlternativeInputReport.n[i]));
            alternativeInputReportEditor$OutputDataNode2.add(alternativeInputReportEditor$OutputDataNode3);
        }
        alternativeInputReportEditor$OutputDataNode.add(alternativeInputReportEditor$OutputDataNode2);
    }

    private void savePreferences() {
        this._report.a(this._displayReportCheckbox.isSelected());
        this._report.a(RMAIO.getRelativePath((String)this._alt.getWorkspacePath(), (String)this._folderFld.getText()));
        this._report.b((String)this._outputOrderCombo.getSelectedItem());
        this._report.c((String)this._outputTypeCombo.getSelectedItem());
        this._report.a(this._nodeMap);
        this._report.f();
    }
}

