/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.gui.NameDialog;
import hec.gui.SelectorPanelEditor;
import hec.rss.client.reports.ReportIntervalPanel;
import hec.rss.model.ReportInterval;
import hec.rss.model.ReportIntervalManager;
import hec.rss.model.SeasonalReportInterval;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import rma.swing.event.ReflectMultiListener;

public class CustomIntervalEditor
extends SelectorPanelEditor {
    ReportIntervalPanel _intervalPanel;
    ReportIntervalManager _manager;
    ReflectMultiListener _listener;

    public CustomIntervalEditor(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.setTitle("Custom Interval Editor");
        CustomIntervalEditor customIntervalEditor = this;
        customIntervalEditor.setLocationRelativeTo(customIntervalEditor.getParent());
        this.buildControls();
    }

    protected void buildControls() {
        this._listener = new ReflectMultiListener();
        this._intervalPanel = new ReportIntervalPanel(this);
        CustomIntervalEditor customIntervalEditor = this;
        customIntervalEditor.addPanel(customIntervalEditor._intervalPanel);
        this.buildMenus();
        this.pack();
    }

    private void buildMenus() {
        JComponent jComponent = new JMenuBar();
        this.setJMenuBar((JMenuBar)jComponent);
        JMenu jMenu = new JMenu("File");
        ((JMenuBar)jComponent).add(jMenu);
        jComponent = new JMenuItem("New...");
        jMenu.add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "newIntervalAction"));
        jComponent = new JMenuItem("Delete");
        jMenu.add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "deleteIntervalAction"));
        jComponent = new JMenuItem("Rename...");
        jMenu.add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "renameIntervalAction"));
        jComponent = new JMenuItem("Save As...");
        jMenu.add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "saveAsIntervalAction"));
        jMenu.addSeparator();
        jComponent = new JMenuItem("Close");
        jMenu.add((JMenuItem)jComponent);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "closeDialog"));
    }

    private void newIntervalAction() {
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), "New Custom Interval", true);
        nameDialog.setShowWarningForEmptyName(true);
        nameDialog.setExistingNames(this._manager.getCustomeIntervalNameList());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        String string = nameDialog.getName();
        string = string.trim();
        ReportInterval reportInterval = new ReportInterval();
        reportInterval.setName(string);
        reportInterval.setDescription(nameDialog.getDescription());
        reportInterval.setType(ReportInterval.a);
        this.getSelectorPanel().addSelectionItem((Object)reportInterval, true);
        this.setModified(true);
    }

    private void saveAsIntervalAction() {
        CustomIntervalEditor customIntervalEditor = this;
        NameDialog nameDialog = new NameDialog((Dialog)((Object)customIntervalEditor), "Save " + ((ReportInterval)customIntervalEditor.getSelectorPanel().getSelectedItem()).getName() + " Custom Interval As", true);
        nameDialog.setExistingNames(this._manager.getCustomeIntervalNameList());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        String string = nameDialog.getName();
        if ((string = string.trim()).isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Requires a name", "Missing name", 0);
            return;
        }
        if (((ReportInterval)this.getSelectorPanel().getSelectedItem()).getType().equals(ReportInterval.a)) {
            SeasonalReportInterval seasonalReportInterval = new SeasonalReportInterval((ReportInterval)this.getSelectorPanel().getSelectedItem());
            seasonalReportInterval.setName(string);
            seasonalReportInterval.setDescription(nameDialog.getDescription());
            seasonalReportInterval.setDates(((SeasonalReportInterval)this.getSelectorPanel().getSelectedItem()).getDates());
            this.getSelectorPanel().addSelectionItem((Object)seasonalReportInterval, true);
            this.setModified(true);
        }
    }

    private boolean confirmDelete(String string) {
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Delete Custom Interval " + string + "?", "Delete Custom Interval", 0);
        return n == 0;
    }

    private void deleteIntervalAction() {
        ReportInterval reportInterval = (ReportInterval)this.getSelectorPanel().getSelectedItem();
        if (reportInterval == null) {
            return;
        }
        if (!this.confirmDelete(reportInterval.getName())) {
            return;
        }
        this.getSelectorPanel().removeSelectionItem((Object)reportInterval);
        if (this.getSelectorPanel().getSelectorItems().size() == 0) {
            this.fillForm(null);
        }
        CustomIntervalEditor customIntervalEditor = this;
        customIntervalEditor.setEditable(customIntervalEditor.getSelectorPanel().getSelectedItem() != null);
        this.setModified(true);
    }

    private void renameIntervalAction() {
        ReportInterval reportInterval = (ReportInterval)this.getSelectorPanel().getSelectedItem();
        if (reportInterval == null) {
            return;
        }
        String string = "Rename";
        string = new NameDialog((Dialog)((Object)this), string, true);
        string.setExistingNames(this._manager.getCustomIntervallList());
        string.setName(reportInterval.getName());
        string.setDescription(reportInterval.getDescription());
        string.setVisible(true);
        if (string.isCanceled()) {
            return;
        }
        String string2 = string.getName();
        if ((string2 = string2.trim()).isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Requires a name", "Missing name", 0);
            return;
        }
        reportInterval.setName(string.getName());
        reportInterval.setDescription(string.getDescription());
        this.getSelectorPanel().setDescription(reportInterval.getDescription());
        this.getSelectorPanel().getComboBox().repaint();
        this.setModified(true);
    }

    public void fillForm(ReportIntervalManager reportIntervalManager) {
        this._manager = reportIntervalManager;
        CustomIntervalEditor customIntervalEditor = this;
        customIntervalEditor.setSelectionList(customIntervalEditor._manager.getCustomIntervallList());
        if (this._manager.getCustomIntervallList() != null && this._manager.getCustomIntervallList().size() > 0) {
            this.getSelectorPanel().setSelectedIndex(0);
        }
        this.fillPanel();
        this.setModified(false);
    }

    public void fillPanel() {
        Object object = this.getSelectorPanel().getSelectedItem();
        if (object == null) {
            this._intervalPanel.fillPanel(null);
        }
        if (object instanceof ReportInterval) {
            this._intervalPanel.fillPanel((ReportInterval)object);
        }
    }

    private boolean saveInterval() {
        this.setIgnoreModifiedEvents(true);
        Object object = this.getSelectorPanel().getSelectedItem();
        if (object instanceof ReportInterval && this._intervalPanel.savePanel((ReportInterval)object)) {
            this.setIgnoreModifiedEvents(false);
            return true;
        }
        return false;
    }

    public boolean saveForm() {
        if (this.saveInterval()) {
            this._manager.setIntervalList(this.getSelectorPanel().getSelectorItems());
            this._manager.save(this._manager.getIdentifier());
            this._manager.setModified(false);
            this.setModified(false);
            return true;
        }
        return false;
    }
}

