/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.rss.client.reports.AvailableTimeSeriesPanel;
import hec.rss.client.reports.ReportBlockColumnEditor$1;
import hec.rss.client.reports.ReportBlockColumnEditor$2;
import hec.rss.client.reports.ReportBlockColumnEditor$3;
import hec.rss.client.reports.ReportBlockColumnEditor$4;
import hec.rss.client.reports.ReportBlockColumnEditor$5;
import hec.rss.client.reports.ReportBlockColumnEditor$ReportColumnsTableModel;
import hec.rss.client.reports.ReportColumnOptionsEditor;
import hec.rss.client.reports.ReportDialog;
import hec.rss.client.reports.UserReportBlock;
import hec.rss.client.reports.UserReportColumn;
import hec.rss.client.reports.UserReportColumnOptions;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rma.lang.Modifiable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;

public class ReportBlockColumnEditor
extends ReportDialog {
    private AvailableTimeSeriesPanel _tsPanel;
    JButton _selectButton;
    private RmaJTable _columnTable;
    private ButtonCmdPanel _cmdPanel;
    private JButton _insertButton;
    private JButton _deleteButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private boolean _canceled;
    private ReportBlockColumnEditor$ReportColumnsTableModel _columnModel;
    private ReflectMultiListener _listener;
    private ReportColumnOptionsEditor _reportColumnOptionsEditor;
    private UserReportBlock _selectedReportBlock;
    private JLabel _reportBlockName;
    private Modifiable _parentModifiable;

    public ReportBlockColumnEditor(Dialog dialog) {
        super(dialog, true);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Report Content Selection");
        this._listener = new ReflectMultiListener();
        JComponent jComponent = new JLabel("Report Block:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._reportBlockName = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._reportBlockName, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Available Time Series"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._tsPanel = new AvailableTimeSeriesPanel(this);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        jComponent.add((Component)this._tsPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jComponent.add((Component)jPanel, gridBagConstraints);
        this._selectButton = new JButton("Add to Report Columns");
        this._selectButton.setMnemonic('S');
        this._selectButton.setEnabled(false);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this._selectButton, gridBagConstraints);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Report Columns"));
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        ReportBlockColumnEditor reportBlockColumnEditor = this;
        this._columnTable = new ReportBlockColumnEditor$1(reportBlockColumnEditor, (Component)((Object)reportBlockColumnEditor));
        this._columnModel = new ReportBlockColumnEditor$ReportColumnsTableModel(this);
        this._columnTable.setModel((TableModel)((Object)this._columnModel));
        this._columnTable.setHorizontalAlignment(0, 0);
        this._columnTable.setTextAreaCellEditor(3);
        this._columnTable.setAddRemoveEnabled(false);
        JButton jButton = this._columnTable.setButtonCellEditor(4);
        this._columnTable.setColumnWidths(new int[]{41, 219, 118, 213, 70});
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this._columnTable.getScrollPane(), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JButton jButton2 = new JButton("Append");
        jButton2.setMnemonic('A');
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        jPanel2.add((Component)jButton2, gridBagConstraints);
        this._insertButton = new JButton("Insert");
        this._insertButton.setEnabled(false);
        this._insertButton.setMnemonic('I');
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this._insertButton, gridBagConstraints);
        this._deleteButton = new JButton("Delete");
        this._deleteButton.setEnabled(false);
        this._deleteButton.setMnemonic('D');
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)this._deleteButton, gridBagConstraints);
        this._moveUpButton = new JButton("Move Up");
        this._moveUpButton.setEnabled(false);
        this._moveUpButton.setMnemonic('U');
        gridBagConstraints.gridx = 3;
        jPanel2.add((Component)this._moveUpButton, gridBagConstraints);
        this._moveDownButton = new JButton("Move Down");
        this._moveDownButton.setEnabled(false);
        this._moveDownButton.setMnemonic('M');
        gridBagConstraints.gridx = 4;
        jPanel2.add((Component)this._moveDownButton, gridBagConstraints);
        jComponent = new JSplitPane(0, jComponent, jPanel);
        jComponent.setBorder(null);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._cmdPanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gridBagConstraints);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)new ReportBlockColumnEditor$2(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ReportBlockColumnEditor$3(this));
        jButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jButton, "editColumnOptionsAction"));
        jButton2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jButton2, "appendRowAction"));
        ReportBlockColumnEditor reportBlockColumnEditor2 = this;
        this._insertButton.addActionListener((ActionListener)this._listener.add((Object)reportBlockColumnEditor2, (Object)reportBlockColumnEditor2._insertButton, "insertRowAction"));
        ReportBlockColumnEditor reportBlockColumnEditor3 = this;
        this._deleteButton.addActionListener((ActionListener)this._listener.add((Object)reportBlockColumnEditor3, (Object)reportBlockColumnEditor3._deleteButton, "deleteRowAction"));
        ReportBlockColumnEditor reportBlockColumnEditor4 = this;
        this._moveUpButton.addActionListener((ActionListener)this._listener.add((Object)reportBlockColumnEditor4, (Object)reportBlockColumnEditor4._moveUpButton, "moveRowUpAction"));
        ReportBlockColumnEditor reportBlockColumnEditor5 = this;
        this._moveDownButton.addActionListener((ActionListener)this._listener.add((Object)reportBlockColumnEditor5, (Object)reportBlockColumnEditor5._moveDownButton, "moveRowDownAction"));
        ReportBlockColumnEditor reportBlockColumnEditor6 = this;
        this._selectButton.addActionListener((ActionListener)this._listener.add((Object)reportBlockColumnEditor6, (Object)reportBlockColumnEditor6._selectButton, "selectTimeSeriesAction"));
        this._columnTable.getSelectionModel().addListSelectionListener(new ReportBlockColumnEditor$4(this));
        this.pack();
        this.setLocation();
        this.setSizeAndLocation();
    }

    public void columnTabledSelectedAction() {
        int n = this._columnTable.getSelectedRow();
        boolean bl = n != -1;
        int n2 = this._columnTable.getRowCount();
        this._insertButton.setEnabled(bl);
        this._deleteButton.setEnabled(bl);
        this._moveUpButton.setEnabled(bl && n2 > 1);
        this._moveDownButton.setEnabled(bl && n2 > 1);
        if (n == 0) {
            this._moveUpButton.setEnabled(false);
        } else if (n == n2 - 1) {
            this._moveDownButton.setEnabled(false);
        }
        if (this._columnTable.getSelectedRowCount() == n2) {
            this._moveUpButton.setEnabled(false);
            this._moveDownButton.setEnabled(false);
        }
    }

    public void appendRowAction() {
        this._columnTable.appendRow();
        this.setModified(true);
    }

    public void insertRowAction() {
        this._columnTable.insertRow();
        this.setModified(true);
    }

    protected void closeAction() {
        if (this.isModified()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>Report Block has changed.<br><br> Save Changes?</html>", "Save Changes", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.saveFormAction();
            }
        }
        this.setVisible(false);
    }

    public void deleteRowAction() {
        int n;
        int[] nArray = this._columnTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("<html>Confirm deletion of the following Report Columns:<br>");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append("<b>");
            stringBuffer.append(this._columnTable.getValueAt(nArray[n], 0));
            stringBuffer.append("</b><br>");
        }
        stringBuffer.append("Ok to delete rows?");
        n = JOptionPane.showConfirmDialog((Component)((Object)this), stringBuffer.toString(), "Confirm Deletion", 0);
        if (n == 0) {
            this._columnTable.deleteRow();
        }
        this.setModified(true);
    }

    public void moveRowUpAction() {
        int[] nArray = this._columnTable.getSelectedRows();
        if (nArray.length == 0 || nArray[0] == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2;
            int n3 = n2 = nArray[n];
            this.swapTableRow(n3, n3 - 1);
            int n4 = n++;
            nArray[n4] = nArray[n4] - 1;
        }
        this._columnModel.fireTableDataChanged();
    }

    public void moveRowDownAction() {
        int[] nArray = this._columnTable.getSelectedRows();
        if (nArray.length == 0 || nArray[nArray.length - 1] == this._columnTable.getRowCount() - 1) {
            return;
        }
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2;
            int n3 = n2 = nArray[n];
            this.swapTableRow(n3, n3 + 1);
            int n4 = n--;
            nArray[n4] = nArray[n4] + 1;
        }
        this._columnModel.fireTableDataChanged();
    }

    protected void swapTableRow(int n, int n2) {
        List list = this._columnModel._data;
        Object e = list.remove(n);
        list.add(n2, e);
    }

    public void editColumnOptionsAction() {
        int n = this._columnTable.getEditingRow();
        if (n == -1) {
            return;
        }
        if (this._reportColumnOptionsEditor == null) {
            this._reportColumnOptionsEditor = new ReportColumnOptionsEditor((Dialog)((Object)this));
        }
        this._reportColumnOptionsEditor.setColumnTitleText((String)this._columnTable.getValueAt(n, 0));
        Cloneable cloneable = this._columnModel.getReportColumnAt(n);
        this._reportColumnOptionsEditor.setColumnName(cloneable.a());
        this._reportColumnOptionsEditor.setParameter(cloneable.c());
        cloneable = cloneable.g();
        this._reportColumnOptionsEditor.fillForm((UserReportColumnOptions)cloneable);
        this._reportColumnOptionsEditor.setVisible(true);
        if (this._reportColumnOptionsEditor.isCanceled()) {
            return;
        }
        this._reportColumnOptionsEditor.saveForm();
    }

    public void selectTimeSeriesAction() {
        int[] nArray = this._tsPanel.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            String[] stringArray = this._tsPanel.getRowInfo(nArray[i]);
            UserReportColumn userReportColumn = new UserReportColumn();
            userReportColumn.d(stringArray[0]);
            userReportColumn.a(stringArray[0].replace('-', '\n') + "\n" + stringArray[1]);
            userReportColumn.c(stringArray[1]);
            this._columnModel.addReportColumn(userReportColumn);
        }
        this.setModified(true);
    }

    public void fillForm(UserReportBlock object, String string) {
        this._selectedReportBlock = (UserReportBlock)((UserReportBlock)object).clone();
        this._columnModel.setData(this._selectedReportBlock.d());
        object = this._selectedReportBlock.e();
        if (object != null && ((String)object).length() > 0) {
            this._reportBlockName.setText((String)object);
        } else {
            this._reportBlockName.setText(string);
        }
        this.setModified(false);
    }

    public UserReportBlock saveFormAction() {
        if (this._selectedReportBlock == null) {
            return this._selectedReportBlock;
        }
        this._columnTable.commitEdit(true);
        List list = this._columnModel.getData();
        this._selectedReportBlock.a(list);
        if (this._parentModifiable != null) {
            this._parentModifiable.setModified(true);
        }
        return this._selectedReportBlock;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setCanceled(boolean bl) {
        this._canceled = bl;
    }

    public void setNetwork(RssSystem rssSystem, RssRun rssRun) {
        this._tsPanel.setNetwork(rssSystem, rssRun);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            this.setTitle("Report Content Selection*");
            return;
        }
        this.setTitle("Report Content Selection");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            SwingUtilities.invokeLater(new ReportBlockColumnEditor$5(this));
            return;
        }
        this.saveSizeAndLocation();
    }

    public Modifiable getParentModifiable() {
        return this._parentModifiable;
    }

    public void setParentModifiable(Modifiable modifiable) {
        this._parentModifiable = modifiable;
    }

    @Override
    public String getPropPrefix() {
        return "ResSim.reports.columnEditor";
    }
}

