/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.data.Parameter;
import hec.heclib.util.Unit;
import hec.rss.client.reports.ReportColumnOptionsEditor$1;
import hec.rss.client.reports.ReportColumnOptionsEditor$2;
import hec.rss.client.reports.ReportColumnOptionsEditor$3;
import hec.rss.client.reports.ReportDialog;
import hec.rss.client.reports.UserReportColumnOptions;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import rma.lang.Modifiable;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;

public class ReportColumnOptionsEditor
extends ReportDialog {
    private static final String[] a = new String[]{"SOP", "EOP", "PAVG", "PCUM"};
    private RmaJComboBox _intervalCombo;
    private RmaJIntegerField _decPlacesFld;
    private RmaJComboBox _unitConversionCombo;
    private RmaJIntegerField _colWidthFld;
    private RmaJCheckBox _hiddenColCheck;
    private RmaJCheckBox _maxCheck;
    private RmaJCheckBox _timeMaxOccurredCheck;
    private RmaJCheckBox _minCheck;
    private RmaJCheckBox _timeMinOccurredCheck;
    private RmaJCheckBox _sumCheck;
    private RmaJCheckBox _countCheck;
    private RmaJCheckBox _averageCheck;
    private RmaJCheckBox _enableRangeLimitsCheck;
    private RmaJCheckBox _showClippedAsMissingCheck;
    private RmaJCheckBox _displayUnitsCheck;
    private JPanel _rangeLimitsPanel;
    private RmaJDecimalField _minRangeFld;
    private RmaJDecimalField _maxRangeFld;
    private JLabel _reportColumnName;
    private ButtonCmdPanel _cmdpanel;
    private boolean _canceled;
    private UserReportColumnOptions _currentOptions;
    private String _columnName;
    private Modifiable _parentModifiable;

    public ReportColumnOptionsEditor(Dialog dialog) {
        super(dialog, true);
        this.setParentModifiable((Modifiable)dialog);
        this.buildControls();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Report Column Options - ");
        JComponent jComponent = new JLabel("Report Column:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._reportColumnName = new JLabel();
        ((JLabel)jComponent).setLabelFor((Component)this._intervalCombo);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._reportColumnName, gridBagConstraints);
        jComponent = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        jComponent = new JLabel("Interval Option");
        ((JLabel)jComponent).setDisplayedMnemonic('I');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._intervalCombo = new RmaJComboBox((Object[])a);
        this._intervalCombo.setModifiable(true);
        ((JLabel)jComponent).setLabelFor((Component)this._intervalCombo);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._intervalCombo, gridBagConstraints);
        jComponent = new JLabel("Num. Decimal Places");
        ((JLabel)jComponent).setDisplayedMnemonic('N');
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._decPlacesFld = new RmaJIntegerField();
        this._decPlacesFld.setMinValue(0);
        ((JLabel)jComponent).setLabelFor((Component)this._decPlacesFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._decPlacesFld, gridBagConstraints);
        jComponent = new JLabel("Convert Units to");
        ((JLabel)jComponent).setDisplayedMnemonic('p');
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._unitConversionCombo = new RmaJComboBox();
        this._unitConversionCombo.setModifiable(true);
        ((JLabel)jComponent).setLabelFor((Component)this._unitConversionCombo);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._unitConversionCombo, gridBagConstraints);
        this._displayUnitsCheck = new RmaJCheckBox("Display Units in Column Header");
        ((JLabel)jComponent).setLabelFor((Component)this._unitConversionCombo);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._displayUnitsCheck, gridBagConstraints);
        jComponent = new JLabel("Column Width");
        ((JLabel)jComponent).setDisplayedMnemonic('C');
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._colWidthFld = new RmaJIntegerField();
        this._colWidthFld.setMinValue(0);
        ((JLabel)jComponent).setLabelFor((Component)this._colWidthFld);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this._colWidthFld, gridBagConstraints);
        this._hiddenColCheck = new RmaJCheckBox("Hidden Column");
        this._hiddenColCheck.setMnemonic('H');
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        this.getContentPane().add((Component)this._hiddenColCheck, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Summary Statistics"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._maxCheck = new RmaJCheckBox("Maximum");
        this._maxCheck.setMnemonic('M');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._maxCheck, gridBagConstraints);
        this._timeMaxOccurredCheck = new RmaJCheckBox("Time Max Occurred");
        this._timeMaxOccurredCheck.setMnemonic('x');
        gridBagConstraints.gridy = 1;
        jComponent.add((Component)this._timeMaxOccurredCheck, gridBagConstraints);
        this._minCheck = new RmaJCheckBox("Minimum");
        this._minCheck.setMnemonic('u');
        gridBagConstraints.gridy = 2;
        jComponent.add((Component)this._minCheck, gridBagConstraints);
        this._timeMinOccurredCheck = new RmaJCheckBox("Time Min Occurred");
        this._timeMinOccurredCheck.setMnemonic('O');
        gridBagConstraints.gridy = 3;
        jComponent.add((Component)this._timeMinOccurredCheck, gridBagConstraints);
        this._averageCheck = new RmaJCheckBox("Average");
        this._averageCheck.setMnemonic('A');
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.1;
        jComponent.add((Component)this._averageCheck, gridBagConstraints);
        this._sumCheck = new RmaJCheckBox("Sum");
        this._sumCheck.setMnemonic('S');
        gridBagConstraints.gridy = 5;
        jComponent.add((Component)this._sumCheck, gridBagConstraints);
        this._countCheck = new RmaJCheckBox("Count");
        this._countCheck.setMnemonic('t');
        gridBagConstraints.gridy = 6;
        jComponent.add((Component)this._countCheck, gridBagConstraints);
        jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Value Range Limits"));
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)jComponent, gridBagConstraints);
        this._enableRangeLimitsCheck = new RmaJCheckBox("Clip Values to Range");
        this._enableRangeLimitsCheck.setMnemonic('V');
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        jComponent.add((Component)this._enableRangeLimitsCheck, gridBagConstraints);
        this._rangeLimitsPanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        jComponent.add((Component)this._rangeLimitsPanel, gridBagConstraints);
        jComponent = new JLabel("Minimum:");
        ((JLabel)jComponent).setDisplayedMnemonic('M');
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this._rangeLimitsPanel.add((Component)jComponent, gridBagConstraints);
        this._minRangeFld = new RmaJDecimalField();
        ((JLabel)jComponent).setLabelFor((Component)this._minRangeFld);
        this._minRangeFld.setColumns(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        this._rangeLimitsPanel.add((Component)this._minRangeFld, gridBagConstraints);
        jComponent = new JLabel("Maximum:");
        ((JLabel)jComponent).setDisplayedMnemonic('x');
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this._rangeLimitsPanel.add((Component)jComponent, gridBagConstraints);
        this._maxRangeFld = new RmaJDecimalField();
        ((JLabel)jComponent).setLabelFor((Component)this._maxRangeFld);
        this._maxRangeFld.setColumns(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        this._rangeLimitsPanel.add((Component)this._maxRangeFld, gridBagConstraints);
        this._showClippedAsMissingCheck = new RmaJCheckBox("Show Clipped as Missing");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 0;
        this._rangeLimitsPanel.add((Component)this._showClippedAsMissingCheck, gridBagConstraints);
        this._cmdpanel = new ButtonCmdPanel(12);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdpanel, gridBagConstraints);
        this.pack();
        ReportColumnOptionsEditor reportColumnOptionsEditor = this;
        reportColumnOptionsEditor.setLocationRelativeTo(reportColumnOptionsEditor.getParent());
        ReportColumnOptionsEditor reportColumnOptionsEditor2 = this;
        reportColumnOptionsEditor2.setDefaultSize(reportColumnOptionsEditor2.getWidth() + 50, this.getHeight());
        this._enableRangeLimitsCheck.addActionListener((ActionListener)new ReportColumnOptionsEditor$1(this));
        this._cmdpanel.addCmdPanelListener((ButtonCmdPanelListener)new ReportColumnOptionsEditor$2(this));
        this.setSizeAndLocation();
    }

    public void fillForm(UserReportColumnOptions userReportColumnOptions) {
        if (userReportColumnOptions == null) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        this._currentOptions = userReportColumnOptions;
        this._intervalCombo.setSelectedItem((Object)this._currentOptions.d());
        this._decPlacesFld.setValue(this._currentOptions.b());
        this._unitConversionCombo.setSelectedItem((Object)String.valueOf(this._currentOptions.g()));
        this._displayUnitsCheck.setSelected(this._currentOptions.h());
        this._colWidthFld.setValue(this._currentOptions.a());
        this._hiddenColCheck.setSelected(this._currentOptions.c());
        this._maxCheck.setSelected(this._currentOptions.o());
        this._timeMaxOccurredCheck.setSelected(this._currentOptions.e());
        this._minCheck.setSelected(this._currentOptions.p());
        this._timeMinOccurredCheck.setSelected(this._currentOptions.f());
        this._sumCheck.setSelected(this._currentOptions.q());
        this._countCheck.setSelected(this._currentOptions.n());
        this._averageCheck.setSelected(this._currentOptions.r());
        this._enableRangeLimitsCheck.setSelected(this._currentOptions.j());
        this._minRangeFld.setValue(this._currentOptions.k());
        this._maxRangeFld.setValue(this._currentOptions.l());
        this._showClippedAsMissingCheck.setSelected(this._currentOptions.m());
        this.enableRangeLimitsAction();
        this.setIgnoreModifiedEvents(false);
        this.setModified(false);
    }

    public boolean saveForm() {
        if (this._currentOptions == null) {
            this._currentOptions = new UserReportColumnOptions();
        }
        this._currentOptions.a((String)this._intervalCombo.getSelectedItem());
        this._currentOptions.b(this._decPlacesFld.getValue());
        if (this._unitConversionCombo.getSelectedItem() == null) {
            this._currentOptions.b("");
        } else {
            this._currentOptions.b((String)this._unitConversionCombo.getSelectedItem());
        }
        this._currentOptions.d(this._displayUnitsCheck.isSelected());
        this._currentOptions.a(this._colWidthFld.getValueUndefined());
        this._currentOptions.a(this._hiddenColCheck.isSelected());
        this._currentOptions.h(this._maxCheck.isSelected());
        this._currentOptions.b(this._timeMaxOccurredCheck.isSelected());
        this._currentOptions.i(this._minCheck.isSelected());
        this._currentOptions.c(this._timeMinOccurredCheck.isSelected());
        this._currentOptions.j(this._sumCheck.isSelected());
        this._currentOptions.g(this._countCheck.isSelected());
        this._currentOptions.k(this._averageCheck.isSelected());
        this._currentOptions.e(this._enableRangeLimitsCheck.isSelected());
        this._currentOptions.a(this._minRangeFld.getValueUndefined());
        this._currentOptions.b(this._maxRangeFld.getValueUndefined());
        this._currentOptions.f(this._showClippedAsMissingCheck.isSelected());
        if (this._parentModifiable != null) {
            this._parentModifiable.setModified(true);
        }
        this.setModified(false);
        return true;
    }

    public void enableRangeLimitsAction() {
        this._rangeLimitsPanel.setEnabled(this._enableRangeLimitsCheck.isSelected());
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setColumnName(String string) {
        this._reportColumnName.setText(string);
    }

    public void setParameter(String string) {
        if ((string = string.trim()).isEmpty()) {
            return;
        }
        this._unitConversionCombo.removeAllItems();
        int[] nArray = new int[]{1, 2};
        if (!Parameter.isValid((String)string)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Parameter - " + string + " is not a valid ResSim parameter and will not have conversion units.", "Not a Valid Parameter", 2);
        }
        for (int i = 0; i < nArray.length; ++i) {
            String[] stringArray = Unit.getUnitsToConvertTo((String)"English", (String)Parameter.getUnitsStringForSystem((String)string, (int)nArray[i]));
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                string2 = string2.substring(string2.indexOf(46) + 1, string2.length());
                this._unitConversionCombo.addItem((Object)string2);
            }
        }
        this._unitConversionCombo.repaint();
    }

    public void setColumnTitleText(String string) {
        this._columnName = string;
        ReportColumnOptionsEditor reportColumnOptionsEditor = this;
        reportColumnOptionsEditor.setTitle("Report Column Options - " + reportColumnOptionsEditor._columnName);
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl) {
            ReportColumnOptionsEditor reportColumnOptionsEditor = this;
            reportColumnOptionsEditor.setTitle("Report Column Options - " + (reportColumnOptionsEditor._columnName != null ? this._columnName : "") + "*");
            return;
        }
        ReportColumnOptionsEditor reportColumnOptionsEditor = this;
        reportColumnOptionsEditor.setTitle("Report Column Options - " + (reportColumnOptionsEditor._columnName != null ? this._columnName : ""));
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            SwingUtilities.invokeLater(new ReportColumnOptionsEditor$3(this));
            return;
        }
        this.saveSizeAndLocation();
    }

    public Modifiable getParentModifiable() {
        return this._parentModifiable;
    }

    public void setParentModifiable(Modifiable modifiable) {
        this._parentModifiable = modifiable;
    }

    @Override
    public String getPropPrefix() {
        return "ResSim.reports.columnOptionsEditor";
    }
}

