/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.gui.AbstractEditorPanel;
import hec.heclib.util.HecTime;
import hec.lang.NamedType;
import hec.rss.client.reports.CustomIntervalEditor;
import hec.rss.model.ReportInterval;
import hec.rss.model.SeasonalReportInterval;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;

public class ReportIntervalPanel
extends AbstractEditorPanel {
    private RmaJComboBox _intervalTypeCombo;
    private JPanel _cardPanel;
    private JPanel _seasonalPanel;
    private RmaJTable _seasonalTable;
    private CustomIntervalEditor _editor;
    private ReflectMultiListener _listener = new ReflectMultiListener();

    public ReportIntervalPanel(CustomIntervalEditor customIntervalEditor) {
        this._editor = customIntervalEditor;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        RmaJPanel rmaJPanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("Interval Type:");
        jLabel.setDisplayedMnemonic('T');
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        rmaJPanel.add((Component)jLabel, (Object)gridBagConstraints);
        this._intervalTypeCombo = new RmaJComboBox((Object[])new String[]{ReportInterval.a});
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        gridBagConstraints.weightx = 1.0;
        rmaJPanel.add((Component)this._intervalTypeCombo, (Object)gridBagConstraints);
        ReportIntervalPanel reportIntervalPanel = this;
        this._intervalTypeCombo.addActionListener((ActionListener)this._listener.add((Object)reportIntervalPanel, (Object)reportIntervalPanel._intervalTypeCombo, "intervalTypeAction"));
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)rmaJPanel, gridBagConstraints);
        this._seasonalPanel = new JPanel(new GridBagLayout());
        this._seasonalTable = new RmaJTable((Component)((Object)this), (Object[])new String[]{"Date"});
        this._seasonalTable.setDateCellEditor(0, "DDMMM", true);
        this._seasonalTable.appendRows(10);
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._seasonalPanel.add((Component)this._seasonalTable.getScrollPane(), gridBagConstraints);
        this._cardPanel = new JPanel(new CardLayout());
        gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.INSETS0000;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        ReportIntervalPanel reportIntervalPanel2 = this;
        reportIntervalPanel2.add(reportIntervalPanel2._cardPanel, gridBagConstraints);
        this._cardPanel.setBackground(Color.BLUE);
        this._cardPanel.add(ReportInterval.a, this._seasonalPanel);
    }

    private void intervalTypeAction() {
        String string = (String)this._intervalTypeCombo.getSelectedItem();
        if (string != null) {
            ((CardLayout)this._cardPanel.getLayout()).show(this._cardPanel, string);
            this.setModified(true);
        }
    }

    public void fillPanel(NamedType stringArray) {
        if (stringArray instanceof ReportInterval && (stringArray = (ReportInterval)stringArray).getType().equals(ReportInterval.a)) {
            SeasonalReportInterval seasonalReportInterval;
            this._intervalTypeCombo.setSelectedIndex(0);
            if (stringArray instanceof SeasonalReportInterval) {
                seasonalReportInterval = (SeasonalReportInterval)stringArray;
            } else {
                seasonalReportInterval = new SeasonalReportInterval(stringArray.getName());
                seasonalReportInterval.setDescription(stringArray.getDescription());
            }
            stringArray = seasonalReportInterval.getDates();
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this._seasonalTable.setCell((Object)stringArray[i], i, 0);
            }
        }
    }

    public String getTabname() {
        return null;
    }

    public boolean savePanel(NamedType namedType) {
        if (namedType instanceof ReportInterval) {
            if (this._intervalTypeCombo.getSelectedItem().equals(ReportInterval.a)) {
                Object object;
                SeasonalReportInterval seasonalReportInterval = namedType instanceof SeasonalReportInterval ? (SeasonalReportInterval)namedType : new SeasonalReportInterval((ReportInterval)namedType);
                ArrayList<String> arrayList = new ArrayList<String>();
                this._seasonalTable.commitEdit(true);
                HecTime hecTime = null;
                for (int i = 0; i < this._seasonalTable.getRowCount(); ++i) {
                    object = this._seasonalTable.getCell(i, 0);
                    if (object == null || !(object instanceof String) || ((String)(object = ((String)object).trim())).length() != 5) continue;
                    HecTime hecTime2 = new HecTime();
                    hecTime2.setDate((String)object);
                    if (hecTime != null && hecTime2.month() <= hecTime.month() && (hecTime2.day() < hecTime.day() || hecTime2.month() < hecTime.month())) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Dates must be consecutive within a year.", "", 0);
                        return false;
                    }
                    arrayList.add((String)object);
                    hecTime = new HecTime((String)object);
                }
                String[] stringArray = new String[arrayList.size()];
                System.arraycopy(arrayList.toArray(), 0, stringArray, 0, arrayList.size());
                if (stringArray.length == 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Seasonal Intervals Require at least one date", "Missing Date", 0);
                    return false;
                }
                seasonalReportInterval.setDates(stringArray);
                object = this._editor.getSelectorPanel().getSelectorItems();
                object.remove(namedType);
                this._editor.getSelectorPanel().setSelectionList((Collection)object);
                this._editor.getSelectorPanel().addSelectionItem((Object)seasonalReportInterval, true);
            }
            return true;
        }
        return false;
    }
}

