/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.rss.client.reports.CutCopyPastePanel;
import hec.rss.client.reports.ReportBlockColumnEditor;
import hec.rss.client.reports.ReportsContentsTab$1;
import hec.rss.client.reports.ReportsContentsTab$2;
import hec.rss.client.reports.ReportsContentsTab$3;
import hec.rss.client.reports.ReportsContentsTab$4;
import hec.rss.client.reports.ReportsContentsTab$ReportBlocksTableModel;
import hec.rss.client.reports.ReportsContentsTab$StatsTableModel;
import hec.rss.client.reports.UserReport;
import hec.rss.client.reports.UserReportBlock;
import hec.rss.client.reports.UserReportColumnStats;
import hec.rss.client.reports.UserReportColumnSummary;
import hec.rss.client.reports.UserReportEditor;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableModel;
import rma.lang.Modifiable;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;

public class ReportsContentsTab
extends CutCopyPastePanel {
    private RmaJTable _blocksTable;
    private RmaJCheckBox _showStatsCheck;
    private RmaJTable _statsTable;
    private JButton _deleteButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private ReportsContentsTab$ReportBlocksTableModel _blockTableModel;
    private ReportsContentsTab$StatsTableModel _statsTableModel;
    private UserReport _selectedReport;
    private ReflectMultiListener _listener;
    private ReportBlockColumnEditor _blockEditor;
    private RssRun _run;
    private RssSystem _network;

    public ReportsContentsTab() {
        this.buildControls();
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._listener = new ReflectMultiListener();
        JComponent jComponent = new JPanel(new GridBagLayout());
        jComponent.setBorder(BorderFactory.createTitledBorder("Report Blocks"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(jComponent, gridBagConstraints);
        ReportsContentsTab reportsContentsTab = this;
        this._blocksTable = new ReportsContentsTab$1(reportsContentsTab, (Component)((Object)reportsContentsTab));
        this._blockTableModel = new ReportsContentsTab$ReportBlocksTableModel(this);
        this._blocksTable.setModel((TableModel)((Object)this._blockTableModel));
        this._blocksTable.setCheckBoxCellEditor(3);
        this._blocksTable.setRowHeight(20);
        this._blocksTable.setHorizontalAlignment(0, 0);
        this._blocksTable.setHorizontalAlignment(0, 4);
        this._blocksTable.setAddRemoveEnabled(false);
        JButton jButton = this._blocksTable.setButtonCellEditor(4);
        this._blocksTable.setColumnWidths(new int[]{35, 74, 210, 80, 75});
        gridBagConstraints.gridwidth = 1;
        jComponent.add((Component)this._blocksTable.getScrollPane(), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        jComponent.add((Component)jPanel, gridBagConstraints);
        jComponent = new JButton("Add");
        ((AbstractButton)jComponent).setMnemonic('A');
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jComponent, gridBagConstraints);
        this._deleteButton = new JButton("Delete");
        this._deleteButton.setMnemonic('D');
        this._deleteButton.setEnabled(false);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this._deleteButton, gridBagConstraints);
        this._moveUpButton = new JButton("Move Up");
        this._moveUpButton.setMnemonic('U');
        this._moveUpButton.setEnabled(false);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this._moveUpButton, gridBagConstraints);
        this._moveDownButton = new JButton("Move Down");
        this._moveDownButton.setMnemonic('M');
        this._moveDownButton.setEnabled(false);
        gridBagConstraints.gridx = 3;
        jPanel.add((Component)this._moveDownButton, gridBagConstraints);
        this._showStatsCheck = new RmaJCheckBox("Show Report Summary Statistics");
        this._showStatsCheck.setMnemonic('S');
        this._showStatsCheck.setEnabled(false);
        this._showStatsCheck.setModifiable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        ReportsContentsTab reportsContentsTab2 = this;
        reportsContentsTab2.add((Component)reportsContentsTab2._showStatsCheck, gridBagConstraints);
        ReportsContentsTab reportsContentsTab3 = this;
        this._statsTable = new ReportsContentsTab$2(reportsContentsTab3, (Component)((Object)reportsContentsTab3));
        this._statsTableModel = new ReportsContentsTab$StatsTableModel(this);
        this._statsTable.setModel((TableModel)((Object)this._statsTableModel));
        this._statsTable.setHorizontalAlignment(0, 0);
        this._statsTable.setCheckBoxCellEditor(1);
        this._statsTable.setCheckBoxCellEditor(2);
        this._statsTable.setCheckBoxCellEditor(3);
        this._statsTable.setCheckBoxCellEditor(4);
        this._statsTable.setCheckBoxCellEditor(5);
        this._statsTable.setColumnWidths(new int[]{70, 45, 45, 45, 45, 45});
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5555;
        ReportsContentsTab reportsContentsTab4 = this;
        reportsContentsTab4.add(reportsContentsTab4._statsTable.getScrollPane(), gridBagConstraints);
        ((AbstractButton)jComponent).addActionListener((ActionListener)this._listener.add((Object)this, (Object)jComponent, "addReportBlockAction"));
        ReportsContentsTab reportsContentsTab5 = this;
        this._deleteButton.addActionListener((ActionListener)this._listener.add((Object)reportsContentsTab5, (Object)reportsContentsTab5._deleteButton, "deleteReportBlockAction"));
        ReportsContentsTab reportsContentsTab6 = this;
        this._moveUpButton.addActionListener((ActionListener)this._listener.add((Object)reportsContentsTab6, (Object)reportsContentsTab6._moveUpButton, "moveReportBlockUpAction"));
        ReportsContentsTab reportsContentsTab7 = this;
        this._moveDownButton.addActionListener((ActionListener)this._listener.add((Object)reportsContentsTab7, (Object)reportsContentsTab7._moveDownButton, "moveReportBlockDownAction"));
        jButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jButton, "editReportBlockAction"));
        ReportsContentsTab reportsContentsTab8 = this;
        this._showStatsCheck.addActionListener((ActionListener)this._listener.add((Object)reportsContentsTab8, (Object)reportsContentsTab8._showStatsCheck, "showReportSummaryStatsAction"));
        this._blocksTable.getSelectionModel().addListSelectionListener(new ReportsContentsTab$3(this));
    }

    public void editReportBlockAction() {
        int n = this._blocksTable.getEditingRow();
        if (n < 0) {
            return;
        }
        if (this._blockEditor == null) {
            this._blockEditor = new ReportBlockColumnEditor((Dialog)((Object)((UserReportEditor)((Object)SwingUtilities.windowForComponent((Component)((Object)this))))));
            this._blockEditor.setParentModifiable((Modifiable)SwingUtilities.windowForComponent((Component)((Object)this)));
        }
        UserReportBlock userReportBlock = this._blockTableModel.getReportBlockAt(n);
        String string = (String)this._blocksTable.getValueAt(n, 0);
        this._blockEditor.fillForm(userReportBlock, string);
        this._blockEditor.setNetwork(this._network, this._run);
        this._blockEditor.setVisible(true);
        if (this._blockEditor.isCanceled()) {
            return;
        }
        userReportBlock = this._blockEditor.saveFormAction();
        this._blockTableModel.setReportBlockAt(n, userReportBlock);
        this.blockTableRowSelectedAction();
    }

    public void blockTableRowSelectedAction() {
        boolean bl;
        int n = this._blocksTable.getSelectedRow();
        int n2 = this._blocksTable.getRowCount();
        boolean bl2 = bl = n != -1;
        if (n == -1) {
            this._deleteButton.setEnabled(false);
            this._moveUpButton.setEnabled(false);
            this._moveDownButton.setEnabled(false);
            return;
        }
        this._deleteButton.setEnabled(bl);
        this._moveUpButton.setEnabled(bl && n2 > 1);
        this._moveDownButton.setEnabled(bl && n2 > 1);
        if (n == 0) {
            this._moveUpButton.setEnabled(false);
            return;
        }
        if (n == n2 - 1) {
            this._moveDownButton.setEnabled(false);
        }
    }

    public void showReportSummaryStatsAction() {
        this._statsTable.setEnabled(this._showStatsCheck.isSelected());
        this._statsTable.repaint();
    }

    protected void fillSummaryPanel() {
        int n;
        int n2 = this._blocksTable.getRowCount();
        System.out.println("fillSummaryPanel:numBlocks=" + n2);
        if (n2 < 2) {
            this._showStatsCheck.setEnabled(false);
            this._statsTable.setEnabled(false);
            return;
        }
        this._showStatsCheck.setEnabled(true);
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            UserReportBlock userReportBlock = this._blockTableModel.getReportBlockAt(n);
            n3 = Math.max(userReportBlock.d().size(), n3);
        }
        n = this._statsTableModel._data.size();
        if (n3 < n) {
            for (n2 = n - 1; n2 >= n3; --n2) {
                this._statsTableModel._data.remove(n2);
            }
            this._statsTableModel.fireTableDataChanged();
            return;
        }
        if (n3 > n) {
            for (n2 = n; n2 < n3; ++n2) {
                this._statsTableModel._data.add(new UserReportColumnStats());
            }
            this._statsTableModel.fireTableDataChanged();
        }
    }

    public void addReportBlockAction() {
        UserReportBlock userReportBlock = new UserReportBlock();
        this._blockTableModel.addBlock(userReportBlock);
        this.fillSummaryPanel();
    }

    public void deleteReportBlockAction() {
        int n;
        int[] nArray = this._blocksTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("<html>Confirm deletion of the following Report Blocks:<br>");
        for (n = 0; n < nArray.length; ++n) {
            stringBuffer.append("<b>");
            stringBuffer.append(this._blocksTable.getValueAt(nArray[n], 0));
            stringBuffer.append("</b><br>");
        }
        stringBuffer.append("Ok to delete Blocks?");
        n = JOptionPane.showConfirmDialog((Component)((Object)this), stringBuffer.toString(), "Confirm Deletion", 0);
        if (n == 0) {
            this._blocksTable.deleteRow();
            this.fillSummaryPanel();
        }
    }

    public void moveReportBlockUpAction() {
        int[] nArray = this._blocksTable.getSelectedRows();
        if (nArray.length == 0 || nArray[0] == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            int n2;
            int n3 = n2 = nArray[n];
            this.swapTableRow(n3, n3 - 1);
            int n4 = n++;
            nArray[n4] = nArray[n4] - 1;
        }
        this._blocksTable.clearSelection();
        for (n = 0; n < nArray.length; ++n) {
            this._blocksTable.updateSelection(nArray[n], 0, true, true);
        }
        this._blockTableModel.fireTableDataChanged();
        this.setModified(true);
    }

    public void moveReportBlockDownAction() {
        int[] nArray = this._blocksTable.getSelectedRows();
        if (nArray.length == 0 || nArray[nArray.length - 1] == this._blocksTable.getRowCount() - 1) {
            return;
        }
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2;
            int n3 = n2 = nArray[n];
            this.swapTableRow(n3, n3 + 1);
            int n4 = n--;
            nArray[n4] = nArray[n4] + 1;
        }
        this._blockTableModel.fireTableDataChanged();
        SwingUtilities.invokeLater(new ReportsContentsTab$4(this, nArray));
        this.setModified(true);
    }

    protected void swapTableRow(int n, int n2) {
        List list = this._blockTableModel._blockList;
        Object e = list.remove(n);
        list.add(n2, e);
    }

    public void fillPanel(UserReport cloneable) {
        this._selectedReport = cloneable;
        if (this._selectedReport == null) {
            return;
        }
        this._blockTableModel.setData(((UserReport)cloneable).getBlockList());
        cloneable = this._selectedReport.getColumnSummary();
        this._statsTableModel.setData(((UserReportColumnSummary)cloneable).a());
        this._showStatsCheck.setSelected(((UserReportColumnSummary)cloneable).b());
        this.showReportSummaryStatsAction();
        this._statsTable.setEditable(false);
        this._statsTable.setColumnBackground(0, UIManager.getColor("TextField.inactiveBackground"));
    }

    public void setRun(RssRun rssRun) {
        this._run = rssRun;
    }

    public void setNetwork(RssSystem rssSystem) {
        this._network = rssSystem;
    }

    public boolean savePanel() {
        if (this._selectedReport == null) {
            this._blockTableModel.clearAll();
            return true;
        }
        Object object = this._blockTableModel.getData();
        this._selectedReport.setBlockList((List)object);
        this._blocksTable.commitEdit(true);
        this._statsTable.commitEdit(true);
        object = this._selectedReport.getColumnSummary();
        ((UserReportColumnSummary)object).a(this._showStatsCheck.isSelected());
        ((UserReportColumnSummary)object).a(this._statsTableModel._data);
        return true;
    }

    @Override
    public void copy() {
        Object object = SwingUtilities.windowForComponent((Component)((Object)this));
        if ((object = ((Window)object).getFocusOwner()) == null) {
            return;
        }
        if (object == this._blocksTable) {
            int n;
            object = this._blocksTable.getSelectedRows();
            ArrayList<Object> arrayList = new ArrayList<Object>(((Object)object).length);
            for (n = 0; n < ((Object)object).length; ++n) {
                UserReportBlock userReportBlock = this._blockTableModel.getReportBlockAt(n);
                arrayList.add(userReportBlock.clone());
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this._blockTableModel.addBlock((UserReportBlock)arrayList.get(n));
            }
            return;
        }
        super.copy();
    }
}

