/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.clientapp.client.ClientApp;
import hec.gui.NameDialog;
import hec.gui.SelectorPanel;
import hec.io.FileLock;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.rss.client.reports.CustomIntervalEditor;
import hec.rss.client.reports.CutCopyPastePanel;
import hec.rss.client.reports.ReportDialog;
import hec.rss.client.reports.ReportPageHeaderFooterTab;
import hec.rss.client.reports.ReportsContentsTab;
import hec.rss.client.reports.ReportsHeaderFooterTab;
import hec.rss.client.reports.ReportsOptionsTab;
import hec.rss.client.reports.UserReport;
import hec.rss.client.reports.UserReportBlock;
import hec.rss.client.reports.UserReportEditor$1;
import hec.rss.client.reports.UserReportEditor$10;
import hec.rss.client.reports.UserReportEditor$11;
import hec.rss.client.reports.UserReportEditor$12;
import hec.rss.client.reports.UserReportEditor$13;
import hec.rss.client.reports.UserReportEditor$14;
import hec.rss.client.reports.UserReportEditor$15;
import hec.rss.client.reports.UserReportEditor$16;
import hec.rss.client.reports.UserReportEditor$17;
import hec.rss.client.reports.UserReportEditor$18;
import hec.rss.client.reports.UserReportEditor$19;
import hec.rss.client.reports.UserReportEditor$2;
import hec.rss.client.reports.UserReportEditor$3;
import hec.rss.client.reports.UserReportEditor$4;
import hec.rss.client.reports.UserReportEditor$5;
import hec.rss.client.reports.UserReportEditor$6;
import hec.rss.client.reports.UserReportEditor$7;
import hec.rss.client.reports.UserReportEditor$8;
import hec.rss.client.reports.UserReportEditor$9;
import hec.rss.client.reports.UserReportViewerDialog;
import hec.rss.model.ReportIntervalManager;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.client.FileLockInfoJDialog;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJTabbedPane;
import rma.util.RMAIO;

public class UserReportEditor
extends ReportDialog
implements CallBackInterface {
    private SelectorPanel _selectorPanel;
    private RmaJTabbedPane _tabbedPane;
    private ReportsOptionsTab _optionsTab;
    private ReportsHeaderFooterTab _headerFooterTab;
    private ReportsContentsTab _contentsTab;
    private ReportPageHeaderFooterTab _pageHeaderFooterTab;
    private Action _newAction;
    private Action _deleteAction;
    private Action _renameAction;
    private Action _saveAction;
    private Action _saveAsAction;
    private Action _displayReportAction;
    private Action _closeAction;
    private Action _undoChangesAction;
    private Action _cutAction;
    private Action _copyAction;
    private Action _pasteAction;
    private Action _defineIntervalAction;
    private UserReport _selectedReport;
    private String _reportDir;
    private RssRun _run;
    private RssSystem _network;
    private ReportIntervalManager _intervalManager;
    private RmiFileCallBackImpl _reportCallback;
    protected Component _lastComponent;

    public UserReportEditor(Frame frame) {
        super(frame, true);
        this.buildControls();
    }

    public UserReportEditor(Dialog dialog) {
        super(dialog, true);
        this.buildControls();
    }

    protected void buildControls() {
        super.setTitle("User Report Editor");
        this.getContentPane().setLayout(new BorderLayout());
        Serializable serializable = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)serializable, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._selectorPanel = new SelectorPanel(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        serializable.add((Component)this._selectorPanel, gridBagConstraints);
        this._tabbedPane = new RmaJTabbedPane();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        serializable.add((Component)this._tabbedPane, gridBagConstraints);
        this._optionsTab = new ReportsOptionsTab();
        this._headerFooterTab = new ReportsHeaderFooterTab();
        this._contentsTab = new ReportsContentsTab();
        this._pageHeaderFooterTab = new ReportPageHeaderFooterTab();
        this._tabbedPane.addTab("Contents", (Component)((Object)this._contentsTab));
        this._tabbedPane.addTab("Options", (Component)((Object)this._optionsTab));
        this._tabbedPane.addTab("Report Header/Footer", (Component)((Object)this._headerFooterTab));
        this._tabbedPane.addTab("Page Header/Footer", (Component)((Object)this._pageHeaderFooterTab));
        this.createActions();
        this.buildMenuBar();
        this.buildToolBar();
        this._selectorPanel.addItemListener((ItemListener)new UserReportEditor$1(this));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new UserReportEditor$2(this));
        this.pack();
        UserReportEditor userReportEditor = this;
        userReportEditor.setLocationRelativeTo(userReportEditor.getParent());
        this.setEditable(false);
        this.setSizeAndLocation();
        serializable = this._selectorPanel.getComboBox().getPreferredSize();
        ((Dimension)serializable).width += 70;
        this._selectorPanel.getComboBox().setPreferredSize((Dimension)serializable);
    }

    protected void createActions() {
        this._newAction = new UserReportEditor$3(this, "New", RmaImage.getImageIcon((String)"Images/New.gif"));
        this._newAction.putValue("MnemonicKey", 78);
        this._newAction.putValue("ShortDescription", "Create a New Report Template");
        this._newAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        this._renameAction = new UserReportEditor$4(this, "Rename...", RmaImage.getImageIcon((String)"Images/empty18.gif"));
        this._renameAction.putValue("MnemonicKey", 82);
        this._renameAction.putValue("ShortDescription", "Rename the current Report Template");
        this._deleteAction = new UserReportEditor$5(this, "Delete", RmaImage.getImageIcon((String)"Images/delete.gif"));
        this._deleteAction.putValue("MnemonicKey", 68);
        this._deleteAction.putValue("ShortDescription", "Delete the current Report Template");
        this._saveAction = new UserReportEditor$6(this, "Save Report Settings", RmaImage.getImageIcon((String)"Images/Save.gif"));
        this._saveAction.setEnabled(false);
        this._saveAction.putValue("MnemonicKey", 83);
        this._saveAction.putValue("ShortDescription", "Save the current Report Template");
        this._saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this._saveAsAction = new UserReportEditor$7(this, "SaveAs...", RmaImage.getImageIcon((String)"Images/saveAs.gif"));
        this._saveAsAction.putValue("MnemonicKey", 65);
        this._saveAsAction.putValue("ShortDescription", "Save the current Report Template under a new name");
        this._saveAsAction.setEnabled(false);
        this._displayReportAction = new UserReportEditor$8(this, "Save and View Report", RmaImage.getImageIcon((String)"Images/rss/report.gif"));
        this._displayReportAction.putValue("MnemonicKey", 68);
        this._displayReportAction.putValue("ShortDescription", "Save and View Report");
        this._displayReportAction.setEnabled(false);
        this._closeAction = new UserReportEditor$9(this, "Close", RmaImage.getImageIcon((String)"Images/empty18.gif"));
        this._closeAction.putValue("MnemonicKey", 67);
        this._undoChangesAction = new UserReportEditor$10(this, "Undo Changes", RmaImage.getImageIcon((String)"Images/undo.gif"));
        this._undoChangesAction.putValue("MnemonicKey", 85);
        this._undoChangesAction.putValue("ShortDescription", "Undo all changes since last save");
        this._undoChangesAction.setEnabled(false);
        this._cutAction = new UserReportEditor$11(this, "Cut", RmaImage.getImageIcon((String)"Images/Cut.gif"));
        this._cutAction.putValue("ShortDescription", "Cut");
        this._cutAction.putValue("MnemonicKey", 84);
        this._copyAction = new UserReportEditor$12(this, "Copy", RmaImage.getImageIcon((String)"Images/Copy.gif"));
        this._copyAction.putValue("MnemonicKey", 67);
        this._copyAction.putValue("ShortDescription", "Copy");
        this._pasteAction = new UserReportEditor$13(this, "Paste", RmaImage.getImageIcon((String)"Images/Past.gif"));
        this._pasteAction.putValue("MnemonicKey", 80);
        this._pasteAction.putValue("ShortDescription", "Paste");
        this._defineIntervalAction = new UserReportEditor$14(this, "Define Custom Interval...");
        this._defineIntervalAction.putValue("MnemonicKey", 73);
        this._defineIntervalAction.putValue("ShortDescription", "Define a custom interval");
        this._defineIntervalAction.setEnabled(true);
    }

    protected void buildMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Report");
        jMenu.setMnemonic('R');
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(this._newAction);
        jMenu.add(jMenuItem);
        jMenu.add(this._deleteAction);
        jMenu.add(this._renameAction);
        jMenuItem = new JMenuItem(this._saveAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this._saveAsAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this._displayReportAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this._closeAction);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenu.setMnemonic('E');
        jMenuItem = new JMenuItem(this._undoChangesAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this._defineIntervalAction);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this._cutAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this._copyAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(this._pasteAction);
        jMenu.add(jMenuItem);
    }

    protected void buildToolBar() {
        Object object = new JToolBar();
        ((JToolBar)object).add(this._newAction);
        ((JToolBar)object).add(this._saveAction);
        ((JToolBar)object).add(this._saveAsAction);
        ((JToolBar)object).addSeparator();
        ((JToolBar)object).add(this._displayReportAction);
        ((JToolBar)object).addSeparator();
        ((JToolBar)object).add(this._undoChangesAction);
        JButton jButton = ((JToolBar)object).add(this._cutAction);
        JButton jButton2 = ((JToolBar)object).add(this._copyAction);
        JButton jButton3 = ((JToolBar)object).add(this._pasteAction);
        this.getContentPane().add((Component)object, "North");
        object = new UserReportEditor$15(this);
        jButton.addFocusListener((FocusListener)object);
        jButton2.addFocusListener((FocusListener)object);
        jButton3.addFocusListener((FocusListener)object);
    }

    protected void saveForm() {
        if (this._selectedReport != null && this.isModified()) {
            UserReportEditor userReportEditor = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)userReportEditor), "<html>Report <b>" + String.valueOf(userReportEditor._selectedReport) + "</b> has changed.<br><br> Save Changes?</html>", "Save Changes", 0);
            if (n == 0) {
                this.saveReportAction();
            }
        }
    }

    public void setReportDirectory(String object) {
        this._reportDir = object;
        this._selectorPanel.getComboBox().removeAllItems();
        if (this._reportDir != null && this._reportDir.length() > 0) {
            object = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                object = object.getRemoteFileIDList(UserId.getUserId(), this._reportDir, "*.*");
            }
            catch (RemoteException remoteException) {
                System.out.println("setReportDirectory:RemoteException occurred " + String.valueOf(remoteException));
                return;
            }
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Identifier identifier = (Identifier)((Vector)object).get(i);
                if (identifier.getPath().endsWith(".bak") || identifier.getPath().endsWith(".tmp") || identifier.getPath().endsWith("ReportIntervals.xml")) continue;
                UserReport userReport = new UserReport(identifier.getName());
                userReport.setIdentifer(identifier);
                this._selectorPanel.getComboBox().addItem((Object)userReport);
            }
            if (this._selectorPanel.getComboBox().getItemCount() > 0) {
                this._selectorPanel.getComboBox().setSelectedIndex(0);
            }
        }
    }

    protected void fillForm(UserReport userReport) {
        if (userReport != this._selectedReport && this._reportCallback != null && this._selectedReport != null) {
            UserReportEditor userReportEditor = this;
            userReportEditor.unlockReport(userReportEditor._selectedReport);
        }
        this.setIgnoreModifiedEvents(true);
        this._selectedReport = userReport;
        if (this._selectedReport != null && !this._selectedReport.isLoaded()) {
            UserReportEditor userReportEditor = this;
            userReportEditor.loadUserReport(userReportEditor._selectedReport);
        }
        if (this._intervalManager == null) {
            String string = this._reportDir + "/" + RMAIO.userNameToFileName((String)ReportIntervalManager.a);
            string = new Identifier(string);
            string.setName(ReportIntervalManager.a);
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier identifier = null;
            try {
                identifier = rmiFileManager.openFile(UserId.getUserId(), (Identifier)string);
                if (identifier == null) {
                    identifier = rmiFileManager.newFile(UserId.getUserId(), (Identifier)string);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("getReportIdentifier:RMI Error opening file " + string.getPath() + " Error:" + String.valueOf(remoteException));
            }
            this._intervalManager = new ReportIntervalManager();
            this._intervalManager.reLoadFile(identifier);
            this._intervalManager.setIdentifier(identifier);
        }
        this._optionsTab.updateIntervalComboBox(this._intervalManager);
        this._optionsTab.fillPanel(userReport);
        this._headerFooterTab.fillPanel(userReport);
        this._contentsTab.fillPanel(userReport);
        this._pageHeaderFooterTab.fillPanel(userReport);
        if (userReport != null) {
            this._saveAction.setEnabled(true);
            this._saveAsAction.setEnabled(true);
            this._displayReportAction.setEnabled(true);
        }
        this.setIgnoreModifiedEvents(false);
        this.setModified(false);
        this.setEditable(true);
    }

    protected boolean loadUserReport(UserReport userReport) {
        userReport = this._selectedReport.getIdentifier();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            rmiFileManager = rmiFileManager.openFile(UserId.getUserId(), (Identifier)userReport);
        }
        catch (RemoteException remoteException) {
            System.out.println("loadUserReport:RMI Error reading report " + userReport.getName() + " Error:" + String.valueOf(remoteException));
            return false;
        }
        if (rmiFileManager != null) {
            BufferedReader bufferedReader = rmiFileManager.getFile().getBufferedReader();
            this._selectedReport.setIdentifer((Identifier)rmiFileManager);
            System.out.println("loadUserReport:reading " + userReport.getPath());
            this._selectedReport.readReport(bufferedReader);
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            return true;
        }
        System.out.println("loadUserReport:failed to open report file " + userReport.getPath());
        return false;
    }

    protected void newReportAction() {
        this.saveForm();
        Object object = new NameDialog((Dialog)((Object)this), "Create New Report Template", true);
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        object = new UserReport(object.getName(), object.getDescription());
        ((UserReport)object).setIdentifer(this.getReportIdentifier((UserReport)object));
        ((UserReport)object).getBlockList().add(new UserReportBlock());
        this._selectorPanel.addSelectionItem(object, true);
    }

    protected void deleteReportAction() {
        UserReport userReport = (UserReport)this._selectorPanel.getSelectedItem();
        if (userReport == null) {
            return;
        }
        Identifier identifier = userReport.getIdentifier();
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to delete Report " + userReport.getName() + "?", "Confirm Report Delete", 0);
        if (n == 0) {
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            try {
                if (rmiFileManager.deleteFile(identifier.getPath())) {
                    this._selectorPanel.getComboBox().removeItem((Object)userReport);
                    int n2 = this._selectorPanel.getComboBox().getItemCount();
                    if (n2 > 0) {
                        this._selectorPanel.setSelectedIndex(0);
                    }
                }
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println("deleteReportAction:Exception occurred deleting file " + identifier.getPath() + " Error:" + String.valueOf(remoteException));
            }
        }
    }

    protected void renameReportAction() {
        UserReport userReport = (UserReport)this._selectorPanel.getSelectedItem();
        if (userReport == null) {
            return;
        }
        NameDialog nameDialog = new NameDialog((Dialog)((Object)this), "Rename Report Template", true);
        nameDialog.setName(userReport.getName());
        nameDialog.setDescription(userReport.getDescription());
        nameDialog.setExistingNames(this._selectorPanel.getSelectorItems());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        this.setModified(true);
        userReport.setName(nameDialog.getName());
        userReport.setDescription(nameDialog.getDescription());
        this._selectorPanel.getComboBox().repaint();
        nameDialog = this.getReportIdentifier(userReport);
        Identifier identifier = userReport.getIdentifier();
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            if (rmiFileManager.copyFile(identifier, (Identifier)nameDialog)) {
                rmiFileManager.deleteFile(identifier.getPath());
                userReport.setIdentifer((Identifier)nameDialog);
            }
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("renameReportAction: Error updating report file " + String.valueOf(remoteException));
            return;
        }
    }

    protected void defineIntervalAction() {
        CustomIntervalEditor customIntervalEditor = new CustomIntervalEditor((JDialog)((Object)this));
        if (this._intervalManager == null) {
            String string = this._reportDir + "/" + RMAIO.userNameToFileName((String)ReportIntervalManager.a);
            string = new Identifier(string);
            string.setName(ReportIntervalManager.a);
            RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier identifier = null;
            try {
                identifier = rmiFileManager.openFile(UserId.getUserId(), (Identifier)string);
                if (identifier == null) {
                    identifier = rmiFileManager.newFile(UserId.getUserId(), (Identifier)string);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println("getReportIdentifier:RMI Error opening file " + string.getPath() + " Error:" + String.valueOf(remoteException));
            }
            this._intervalManager = new ReportIntervalManager();
            this._intervalManager.reLoadFile(identifier);
            this._intervalManager.setIdentifier(identifier);
        }
        customIntervalEditor.fillForm(this._intervalManager);
        customIntervalEditor.setVisible(true);
        this._optionsTab.updateIntervalComboBox(this._intervalManager);
    }

    protected Identifier getReportIdentifier(UserReport userReport) {
        String string = this._reportDir + "/" + RMAIO.userNameToFileName((String)userReport.getName());
        string = new Identifier(string);
        string.setName(userReport.getName());
        userReport = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            Identifier identifier = userReport.openFile(UserId.getUserId(), (Identifier)string);
            if (identifier == null) {
                identifier = userReport.newFile(UserId.getUserId(), (Identifier)string);
            }
            return identifier;
        }
        catch (RemoteException remoteException) {
            System.out.println("getReportIdentifier:RMI Error opening file " + string.getPath() + " Error:" + String.valueOf(remoteException));
            return string;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void saveReportAction() {
        block21: {
            if (this._selectedReport == null) {
                return;
            }
            this._selectedReport.setDescription(this._selectorPanel.getDescription());
            this._optionsTab.savePanel();
            this._headerFooterTab.savePanel();
            this._contentsTab.savePanel();
            this._pageHeaderFooterTab.savePanel();
            var1_1 = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            var2_3 = this._selectedReport.getIdentifier();
            var3_6 = null;
            System.out.println("saveReportAction:saving report " + var2_3.getPath());
            if (var2_3.getFile() == null) {
                try {
                    var3_6 = var1_1.openFile(UserId.getUserId(), var2_3);
                    if (var3_6 == null) {
                        var3_6 = var1_1.newFile(UserId.getUserId(), var2_3);
                    }
                }
                catch (RemoteException var1_2) {
                    System.out.println("saveReportAction: RMI Error opening report file " + var2_3.getPath() + " Error:" + String.valueOf(var1_2));
                }
            } else {
                var3_6 = var2_3;
            }
            if (var3_6 != null) {
                var1_1 = var3_6.getFile().getBufferedWriter();
                try {
                    this._selectedReport.writeReport((BufferedWriter)var1_1);
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (IOException var2_4) {
                    try {
                        System.out.println("saveReportAction:IOException occurred writing " + var3_6.getPath() + " Error:" + String.valueOf(var2_4));
                        v1 = this;
                        JOptionPane.showMessageDialog((Component)v1, "<html>Error saving report <b>" + v1._selectedReport.getName() + "</b> to disk.<br>  Error " + String.valueOf(var2_4) + "</html>", "Save Error", 0);
                        ** if (var1_1 == null) goto lbl-1000
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 != null) {
                            try {
                                var1_1.close();
                            }
                            catch (IOException v3) {}
                        }
                        throw var2_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var1_1.close();
                        }
                        catch (IOException v2) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block21;
                    }
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                    }
                    catch (IOException v0) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                }
            }
            System.out.println("saveReportAction:failed to open file " + var2_3.getPath());
        }
        this.setModified(false);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void saveReportAsAction() {
        UserReport userReport = (UserReport)this._selectorPanel.getSelectedItem();
        if (userReport == null) {
            return;
        }
        Object object = new NameDialog((Dialog)((Object)this), "Save Report Template As", true);
        object.setName(userReport.getName());
        object.setDescription(userReport.getDescription());
        object.setExistingNames(this._selectorPanel.getSelectorItems());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        userReport = (UserReport)userReport.clone();
        userReport.setName(object.getName());
        userReport.setDescription(object.getDescription());
        userReport.setIdentifer(this.getReportIdentifier(userReport));
        this._selectorPanel.addSelectionItem((Object)userReport, true);
        object = null;
        object = userReport.getIdentifier().getFile().getBufferedWriter();
        userReport.writeReport((BufferedWriter)object);
        if (object == null) return;
        try {
            ((BufferedWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                System.out.println("saveReportAsAction: Error saving report " + String.valueOf(userReport) + " Error:" + String.valueOf(exception));
                JOptionPane.showMessageDialog((Component)((Object)this), "<html>Error saving report <b>" + userReport.getName() + "</b> to disk.</html>", "Save Error", 0);
                if (object == null) return;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((BufferedWriter)object).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((BufferedWriter)object).close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    protected void displayReportAction() {
        if (this._selectedReport == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Report Template Selected");
            return;
        }
        this.saveReportAction();
        UserReportEditor userReportEditor = this;
        new UserReportViewerDialog((Dialog)((Object)userReportEditor), userReportEditor._selectedReport, this._run).setVisible(true);
        UserReportEditor userReportEditor2 = this;
        if (userReportEditor2.loadUserReport(userReportEditor2._selectedReport)) {
            UserReportEditor userReportEditor3 = this;
            userReportEditor3.fillForm(userReportEditor3._selectedReport);
        }
    }

    protected void closeAction() {
        Object object;
        if (this.isModified() && (object = this._selectorPanel.getSelectedItem()) != null) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this), "<html>Report <b>" + String.valueOf(object) + "</b> has changed.<br><br> Save Changes?</html>", "Save Changes", 1);
            if (n == 2) {
                return;
            }
            if (n == 0) {
                this.saveReportAction();
            }
        }
        if (this._reportCallback != null && this._selectedReport != null) {
            UserReportEditor userReportEditor = this;
            userReportEditor.unlockReport(userReportEditor._selectedReport);
        }
        this.setVisible(false);
    }

    protected void undoChangesAction() {
        if (this._selectedReport == null) {
            return;
        }
        UserReportEditor userReportEditor = this;
        int n = JOptionPane.showConfirmDialog((Component)((Object)userReportEditor), "<html>This will undo <b>all</b> changes to <b>" + userReportEditor._selectedReport.getName() + "</b> since the last save.<br> Do you want to lose your changes?", "Undo All Changes?", 0);
        if (n == 0) {
            UserReportEditor userReportEditor2 = this;
            if (userReportEditor2.loadUserReport(userReportEditor2._selectedReport)) {
                UserReportEditor userReportEditor3 = this;
                userReportEditor3.fillForm(userReportEditor3._selectedReport);
            }
        }
    }

    protected void cutAction() {
        CutCopyPastePanel cutCopyPastePanel = (CutCopyPastePanel)((Object)this._tabbedPane.getSelectedComponent());
        if (this._lastComponent != null) {
            this._lastComponent.requestFocus();
            this._lastComponent = null;
        }
        SwingUtilities.invokeLater(new UserReportEditor$16(cutCopyPastePanel));
    }

    private void copyAction() {
        CutCopyPastePanel cutCopyPastePanel = (CutCopyPastePanel)((Object)this._tabbedPane.getSelectedComponent());
        if (this._lastComponent != null) {
            this._lastComponent.requestFocus();
            this._lastComponent = null;
        }
        SwingUtilities.invokeLater(new UserReportEditor$17(cutCopyPastePanel));
    }

    private void pasteAction() {
        CutCopyPastePanel cutCopyPastePanel = (CutCopyPastePanel)((Object)this._tabbedPane.getSelectedComponent());
        if (this._lastComponent != null) {
            this._lastComponent.requestFocus();
            this._lastComponent = null;
        }
        SwingUtilities.invokeLater(new UserReportEditor$18(cutCopyPastePanel));
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.saveSizeAndLocation();
        }
        super.setVisible(bl);
    }

    @Override
    public String getPropPrefix() {
        return "ResSim.reports.editor";
    }

    public void setModified(boolean bl) {
        if (!this.isIgnoreModifiedEvents() && bl && this._selectedReport != null) {
            UserReportEditor userReportEditor = this;
            if (!userReportEditor.lockReport(userReportEditor._selectedReport)) {
                this.setEditable(false);
            }
        }
        super.setModified(bl);
        if (bl && this.isEditable()) {
            this.setTitle("User Report Editor*");
            this._saveAction.setEnabled(true);
            this._saveAsAction.setEnabled(true);
            this._undoChangesAction.setEnabled(true);
            return;
        }
        this.setTitle("User Report Editor");
        this._undoChangesAction.setEnabled(false);
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this._cutAction.setEnabled(bl);
        this._pasteAction.setEnabled(bl);
    }

    private boolean lockReport(UserReport userReport) {
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        Identifier identifier = userReport.getIdentifier();
        FileLock fileLock = new FileLock(UserId.getUserId(), 6);
        try {
            boolean bl = rmiFileManager.lockFile(identifier, fileLock);
            if (!bl) {
                int n = JOptionPane.showOptionDialog((Component)((Object)this), "Failed to lock User Report " + userReport.getName(), "Lock Failed", 0, 2, null, new Object[]{"OK", "More Info"}, "OK");
                if (n == 0) {
                    return false;
                }
                FileLockInfoJDialog fileLockInfoJDialog = new FileLockInfoJDialog((Dialog)((Object)this));
                fileLockInfoJDialog.setFileManager(rmiFileManager);
                fileLockInfoJDialog.setUserId(UserId.getUserId());
                Vector vector = null;
                try {
                    vector = rmiFileManager.getLockers(identifier);
                }
                catch (RemoteException remoteException) {
                    System.out.println("lockReport:Failed to get Lock info for UserReport " + String.valueOf(remoteException));
                }
                fileLockInfoJDialog.fillForm(identifier, vector);
                fileLockInfoJDialog.setVisible(true);
                return false;
            }
            this._reportCallback = this.setCallback(userReport);
        }
        catch (RemoteException remoteException) {
            System.out.println("lockReport:RemoteException occurred locking " + identifier.getPath() + " Error:" + String.valueOf(remoteException));
        }
        return true;
    }

    private boolean unlockReport(UserReport userReport) {
        if (this._reportCallback == null || userReport == null) {
            return true;
        }
        RmiFileManager rmiFileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        Identifier identifier = userReport.getIdentifier();
        FileLock fileLock = new FileLock(UserId.getUserId(), 2);
        System.out.println("unlockReport:unlocking " + identifier.getPath());
        try {
            boolean bl = rmiFileManager.unlockFile(identifier, fileLock);
            if (bl) {
                UserReportEditor userReportEditor = this;
                if (userReportEditor.removeCallback(userReportEditor._reportCallback, userReport.getIdentifier())) {
                    this._reportCallback = null;
                }
            }
        }
        catch (RemoteException remoteException) {
            System.out.println("unlockFile:RemoteException occurred unlocking " + identifier.getPath() + " Error:" + String.valueOf(remoteException));
        }
        return false;
    }

    protected RmiFileCallBackImpl setCallback(UserReport userReport) {
        RmiFileCallBackImpl rmiFileCallBackImpl;
        if ((userReport = userReport.getIdentifier()) == null || userReport.getFile() == null) {
            System.out.println("setCallback:setCallback failed missing id or file");
            return null;
        }
        try {
            rmiFileCallBackImpl = new RmiFileCallBackImpl((CallBackInterface)this);
        }
        catch (RemoteException remoteException) {
            System.out.println("Error creating callback exception: " + String.valueOf(remoteException));
            remoteException.printStackTrace(System.out);
            return null;
        }
        RemoteWrapper remoteWrapper = new RemoteWrapper((Remote)rmiFileCallBackImpl);
        userReport = userReport.getFile();
        if (userReport instanceof HecFileImpl) {
            ((HecFileImpl)userReport).setCallBack(remoteWrapper);
        }
        return rmiFileCallBackImpl;
    }

    protected boolean removeCallback(RmiFileCallBackImpl rmiFileCallBackImpl, Identifier identifier) {
        if (identifier == null || identifier.getFile() == null || rmiFileCallBackImpl == null) {
            System.out.println("removeCallback:remove callback failed missing id, file or callback");
            return false;
        }
        rmiFileCallBackImpl = new RemoteWrapper((Remote)rmiFileCallBackImpl);
        if ((identifier = identifier.getFile()) instanceof HecFileImpl) {
            ((HecFileImpl)identifier).removeCallBack((RemoteWrapper)rmiFileCallBackImpl);
            return true;
        }
        return false;
    }

    public void setRun(RssRun rssRun) {
        this._run = rssRun;
        this._contentsTab.setRun(rssRun);
    }

    public void setNetwork(RssSystem rssSystem) {
        this._network = rssSystem;
        this._contentsTab.setNetwork(this._network);
    }

    public void notify(String object) {
        if (this._reportCallback == null) {
            return;
        }
        System.out.println((String)object);
        object = new StringTokenizer((String)object, "|");
        if (((StringTokenizer)object).countTokens() < 3) {
            return;
        }
        String string = ((StringTokenizer)object).nextToken();
        String string2 = ((StringTokenizer)object).nextToken();
        object = ((StringTokenizer)object).nextToken();
        if (!string2.equalsIgnoreCase("unlocked") || ((String)object).equals(ClientApp.app().getUser())) {
            return;
        }
        object = new UserReportEditor$19(this, string, (String)object);
        SwingUtilities.invokeLater((Runnable)object);
    }
}

