/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.gfx2d.G2dDialog;
import hec.io.Identifier;
import hec.lang.annotation.Scriptable;
import hec.rss.client.reports.UserReport;
import hec.rss.client.reports.UserReportBlock;
import hec.rss.client.reports.UserReportColumn;
import hec.rss.client.reports.UserReportHeaderFooter;
import hec.rss.client.reports.UserReportOptions;
import hec.rss.client.reports.UserReportPageHeaderFooter;
import hec.rss.client.reports.UserReportViewerPanel$1;
import hec.rss.client.reports.UserReportViewerPanel$2;
import hec.rss.client.reports.UserReportViewerPanel$ReportTable;
import hec.rss.model.RssRun;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import rma.swing.FontChooser;
import rma.swing.MlLabel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.table.MultiTablePrintManager;
import rma.swing.table.RmaCellRenderer;
import rma.swing.table.RmaJTableExportDialog;
import rma.swing.table.TableExportOptions;
import rma.swing.table.TablePrintProperties;
import rma.util.RMAConst;

public class UserReportViewerPanel
extends JPanel {
    private MlLabel _titleText;
    private MlLabel _headerText;
    private UserReportViewerPanel$ReportTable[] _reportBlocks;
    private MlLabel _footerText;
    private JMenuBar _mbar;
    private JMenuItem _plotMenuItem;
    private UserReport _report;
    private List<RssRun> _runs = new ArrayList<RssRun>();
    private ReflectMultiListener _listener;
    private ComponentAdapter _compAdapter;
    private boolean _columnsResized;
    private boolean _windowMoved;
    private boolean _windowResized;
    private boolean _tablesFontSet;
    private MultiTablePrintManager _tablePrintManager;
    private RmaJTableExportDialog _exportOptionsDialog;
    private JRadioButtonMenuItem _showMissingAsBlankMenuItem;
    private JRadioButtonMenuItem _showMissingAsM;
    private JRadioButtonMenuItem _showMissingAsDashMDash;
    private JCheckBoxMenuItem _showCommasMenuItem;

    public UserReportViewerPanel(UserReport userReport, List<RssRun> list) {
        super(new GridBagLayout());
        this._report = userReport;
        this._runs.addAll(list);
        this.buildControls();
        this.fillTables();
    }

    public JMenuBar getMenuBar() {
        return this._mbar;
    }

    public void positionWindow(Window window) {
        UserReportOptions userReportOptions = this._report.getOptions();
        Cloneable cloneable = window.getSize();
        int n = userReportOptions.j();
        int n2 = userReportOptions.i();
        int n3 = userReportOptions.k();
        int n4 = userReportOptions.l();
        if (!RMAConst.isUndefinedValue((int)n)) {
            cloneable.width = n;
        }
        if (!RMAConst.isUndefinedValue((int)n2)) {
            cloneable.height = n2;
        }
        window.setSize((Dimension)cloneable);
        cloneable = window.getLocation();
        if (!RMAConst.isUndefinedValue((int)n3)) {
            ((Point)cloneable).x = n3;
        }
        if (!RMAConst.isUndefinedValue((int)n4)) {
            ((Point)cloneable).y = n4;
        }
        window.setLocation((Point)cloneable);
    }

    public void closeAction() {
        Window window = SwingUtilities.windowForComponent(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    public void plotAction() {
        Vector vector = new Vector();
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            Object object = this._report.getBlockAt(i);
            object = ((UserReportBlock)object).k();
            vector.addAll(object);
        }
        G2dDialog g2dDialog = new G2dDialog(null, "User Report - " + this._report._name, false, vector);
        g2dDialog.setVisible(true);
    }

    public void showMissingAsBlankAction() {
        this.showMissingAction("");
    }

    public void showMissingAsMAction() {
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.showMissingAction(userReportViewerPanel._showMissingAsM.getText());
    }

    public void showMissingAsDashMDashAction() {
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.showMissingAction(userReportViewerPanel._showMissingAsDashMDash.getText());
    }

    public void showCommasAction() {
        boolean bl = this._showCommasMenuItem.isSelected();
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            TableColumnModel tableColumnModel = this._reportBlocks[i].getColumnModel();
            for (int j = 1; j < tableColumnModel.getColumnCount(); ++j) {
                Object object = tableColumnModel.getColumn(j);
                if (!((object = ((TableColumn)object).getCellRenderer()) instanceof RmaCellRenderer)) continue;
                object = (RmaCellRenderer)object;
                object.setShowCommas(bl);
            }
            this._reportBlocks[i].repaint();
        }
    }

    public void printReportAction() {
        MultiTablePrintManager multiTablePrintManager = this.getTablePrintManager();
        multiTablePrintManager.printTables();
    }

    public void printPreviewAction() {
        MultiTablePrintManager multiTablePrintManager = this.getTablePrintManager();
        multiTablePrintManager.printPreview();
    }

    public void exportReportAction() {
        if (this._exportOptionsDialog == null) {
            this._exportOptionsDialog = RmaJTableExportDialog.getExportDialog((RmaJTable)this._reportBlocks[0]);
        }
        this._exportOptionsDialog.setVisible(true);
        if (this._exportOptionsDialog.isCanceled()) {
            return;
        }
        Serializable serializable = JOptionPane.getFrameForComponent(this);
        if (serializable != null) {
            serializable.setCursor(Cursor.getPredefinedCursor(3));
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (serializable != null) {
            serializable.setCursor(Cursor.getDefaultCursor());
        }
        jFileChooser.showSaveDialog(this);
        serializable = jFileChooser.getSelectedFile();
        if (serializable == null) {
            return;
        }
        this.exportReportAction((File)serializable, this._exportOptionsDialog.getExportOptions());
    }

    @Scriptable
    public boolean exportReportAction(File file, TableExportOptions tableExportOptions) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("exportData: failed to open file " + file.getPath() + " error " + String.valueOf(iOException));
            JOptionPane.showMessageDialog(this, "Failed to open export file " + file.getPath());
            return false;
        }
        ListModel listModel = this._titleText.getModel();
        boolean bl = true;
        if (!this.writeListModel(bufferedWriter, listModel)) {
            bl = false;
        }
        if (!this.writeListModel(bufferedWriter, listModel = this._headerText.getModel())) {
            bl = false;
        }
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            this._reportBlocks[i].exportData(bufferedWriter, tableExportOptions);
        }
        ListModel listModel2 = this._footerText.getModel();
        if (!this.writeListModel(bufferedWriter, listModel2)) {
            bl = false;
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
        return bl;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveReportAction() {
        Object object;
        Object object2;
        UserReportOptions userReportOptions = this._report.getOptions();
        Window window = SwingUtilities.windowForComponent(this);
        if (this._windowResized) {
            object2 = window.getSize();
            userReportOptions.g(((Dimension)object2).width);
            userReportOptions.f(((Dimension)object2).height);
        }
        if (this._windowMoved) {
            object2 = window.getLocation();
            userReportOptions.h(((Point)object2).x);
            userReportOptions.i(((Point)object2).y);
        }
        if (this._columnsResized) {
            UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable = this._reportBlocks[0];
            object2 = userReportViewerPanel$ReportTable.getColumnModel();
            int n = object2.getColumnCount();
            object = object2.getColumn(0);
            userReportOptions.j(((TableColumn)object).getWidth());
            for (int i = 0; i < this._report.getBlockCount(); ++i) {
                object = this._report.getBlockAt(i);
                List list = ((UserReportBlock)object).d();
                int n2 = Math.min(list.size(), n);
                for (int j = 1; j < n2; ++j) {
                    UserReportColumn userReportColumn = (UserReportColumn)list.get(j - 1);
                    object = object2.getColumn(j);
                    if (userReportColumn.g().c()) {
                        userReportColumn = (UserReportColumn)list.get(++j - 1);
                    }
                    userReportColumn.g().a(((TableColumn)object).getWidth());
                }
            }
        }
        if (this._tablesFontSet) {
            this._report.getOptions().a(this._reportBlocks[0].getFont());
        }
        object2 = this._report.getHeaderFooter();
        ((UserReportHeaderFooter)object2).a(this._footerText.getFont());
        ((UserReportHeaderFooter)object2).b(this._headerText.getFont());
        ((UserReportHeaderFooter)object2).c(this._titleText.getFont());
        Identifier identifier = this._report.getIdentifier();
        userReportOptions = identifier.getFile();
        if (userReportOptions == null) {
            System.out.println("saveReportAction:Failed to save Report " + this._report.getName() + ". No HecFile to save to.");
            return;
        }
        System.out.println("saveReportAction:saving report " + userReportOptions.getPath());
        object = userReportOptions.getBufferedWriter();
        this._report.writeReport((BufferedWriter)object);
        if (object == null) return;
        try {
            ((BufferedWriter)object).close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (IOException iOException) {
            try {
                System.out.println("saveReportAction:Error writing " + userReportOptions.getPath() + " Error:" + String.valueOf(iOException));
                if (object == null) return;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((BufferedWriter)object).close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                ((BufferedWriter)object).close();
                return;
            }
            catch (IOException iOException3) {
                return;
            }
        }
    }

    public void editTitleFontAction() {
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.editComponentFont(userReportViewerPanel._titleText);
    }

    public void editHeaderFontAction() {
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.editComponentFont(userReportViewerPanel._headerText);
    }

    public void editFooterFontAction() {
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.editComponentFont(userReportViewerPanel._footerText);
    }

    public void editTableFontAction() {
        Serializable serializable = SwingUtilities.windowForComponent(this);
        if (serializable instanceof Dialog) {
            serializable = (Dialog)serializable;
            serializable = new FontChooser((Dialog)serializable, "Change Font", true, this._reportBlocks[0].getFont());
        } else {
            serializable = (Frame)serializable;
            serializable = new FontChooser((Frame)serializable, "Change Font", true, this._reportBlocks[0].getFont());
        }
        serializable = serializable.getSelectedFont();
        if (serializable == null) {
            return;
        }
        this.setTablesFont((Font)serializable);
        this._tablesFontSet = true;
    }

    protected void setTableColumnWidths(int[] nArray) {
        int n;
        Object object = this._reportBlocks[0].getTableHeader().getFont();
        FontMetrics fontMetrics = this._reportBlocks[0].getTableHeader().getFontMetrics((Font)object);
        for (n = 0; n < this._reportBlocks.length; ++n) {
            object = this._reportBlocks[n];
            object = object.getColumnModel();
            int n2 = object.getColumnCount();
            n2 = Math.min(n2, nArray.length);
            for (int i = 0; i < n2; ++i) {
                Object object2 = object.getColumn(i);
                object2 = (String)((TableColumn)object2).getHeaderValue();
                int n3 = this.getWidestStringWidth((String)object2, fontMetrics);
                nArray[i] = Math.max(n3, nArray[i]);
            }
        }
        for (n = 0; n < this._reportBlocks.length; ++n) {
            this._reportBlocks[n].setColumnWidths(nArray);
        }
    }

    public void setPlotEnabled(boolean bl) {
        this._plotMenuItem.setEnabled(bl);
    }

    protected void setTablesFont(Font font) {
        int n;
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            this._reportBlocks[i].setFont(font);
            this._reportBlocks[i].getTableHeader().setFont(font);
        }
        FontMetrics fontMetrics = this._reportBlocks[0].getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        if (n2 > (n = this._reportBlocks[0].getRowHeight()) || (double)n2 < (double)n * 0.9) {
            for (n = 0; n < this._reportBlocks.length; ++n) {
                this._reportBlocks[n].setRowHeight(n2);
            }
        }
    }

    protected int getWidestStringWidth(String string, FontMetrics fontMetrics) {
        if (string.indexOf("\n") == -1) {
            return fontMetrics.stringWidth(string) + 10;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n = Math.max(fontMetrics.stringWidth(string), n);
        }
        return n + 10;
    }

    protected void fillTables() {
        if (this._report == null) {
            return;
        }
        if (this._runs.size() == 0) {
            return;
        }
        this._report.fillData(this._runs);
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            UserReportBlock userReportBlock = this._report.getBlockAt(i);
            Object[][] objectArray = userReportBlock.c();
            if (objectArray == null) continue;
            UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable = this._reportBlocks[i];
            int n = userReportBlock.a();
            int n2 = userReportBlock.h() + 1;
            userReportViewerPanel$ReportTable.setNumRows(n);
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    userReportViewerPanel$ReportTable.setCell(objectArray[j][k], k, j);
                }
            }
        }
    }

    protected void buildControls() {
        UserReportHeaderFooter userReportHeaderFooter = this._report.getHeaderFooter();
        Object object = userReportHeaderFooter.a(this._runs.get(0));
        this._titleText = new MlLabel((String)object);
        this._titleText.setHorizontalAlignment(0);
        this._titleText.setName((String)object);
        this._titleText.setFont(userReportHeaderFooter.f());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        UserReportViewerPanel userReportViewerPanel = this;
        userReportViewerPanel.add((Component)userReportViewerPanel._titleText, gridBagConstraints);
        object = userReportHeaderFooter.b(this._runs.get(0));
        this._headerText = new MlLabel((String)object);
        this._headerText.setHorizontalAlignment(2);
        this._headerText.setName((String)object);
        this._headerText.setFont(userReportHeaderFooter.e());
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        UserReportViewerPanel userReportViewerPanel2 = this;
        userReportViewerPanel2.add((Component)userReportViewerPanel2._headerText, gridBagConstraints);
        this._reportBlocks = new UserReportViewerPanel$ReportTable[this._report.getBlockCount()];
        int n = this._report.getMaxVisibleColumnCount();
        BoundedRangeModel boundedRangeModel = null;
        BoundedRangeModel boundedRangeModel2 = null;
        int[] nArray = new int[n + 1];
        Arrays.fill(nArray, this._report.getOptions().h());
        nArray[0] = this._report.getOptions().p();
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable;
            object = this._report.getBlockAt(i);
            UserReportViewerPanel userReportViewerPanel3 = this;
            this._reportBlocks[i] = userReportViewerPanel$ReportTable = new UserReportViewerPanel$ReportTable(userReportViewerPanel3, userReportViewerPanel3, ((UserReportBlock)object).a(n));
            int[] nArray2 = ((UserReportBlock)object).b(this._report.getOptions().h());
            if (i == 0) {
                boundedRangeModel2 = userReportViewerPanel$ReportTable.getScrollPane().getHorizontalScrollBar().getModel();
            } else {
                userReportViewerPanel$ReportTable.getScrollPane().getHorizontalScrollBar().setModel(boundedRangeModel2);
            }
            if (boundedRangeModel == null && !((UserReportBlock)object).f()) {
                boundedRangeModel = userReportViewerPanel$ReportTable.getScrollPane().getVerticalScrollBar().getModel();
            } else if (boundedRangeModel != null && !((UserReportBlock)object).f()) {
                userReportViewerPanel$ReportTable.getScrollPane().getVerticalScrollBar().setModel(boundedRangeModel);
            }
            for (int j = 0; j < nArray2.length; ++j) {
                nArray[j + 1] = Math.max(nArray[j + 1], nArray2[j]);
            }
            userReportViewerPanel$ReportTable.setUnitsHeaderRenderer();
            userReportViewerPanel$ReportTable.setAddRemoveEnabled(false);
            userReportViewerPanel$ReportTable.setEnabled(false);
            userReportViewerPanel$ReportTable.setAutoResizeMode(0);
            userReportViewerPanel$ReportTable.setHorizontalAlignment(4);
            userReportViewerPanel$ReportTable.setHorizontalAlignment(0, 0);
            int[] nArray3 = ((UserReportBlock)object).g();
            object = nArray3;
            if (nArray3.length > 0) {
                for (int j = ((Object)object).length - 1; j >= 0; --j) {
                    userReportViewerPanel$ReportTable.setColumnVisible((int)(object[j] + true), false, 0);
                }
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            UserReportViewerPanel userReportViewerPanel4 = this;
            userReportViewerPanel4.add((Component)userReportViewerPanel4._reportBlocks[i].getScrollPane(), gridBagConstraints);
        }
        Font font = this._report.getOptions().a();
        if (font != null) {
            this.setTablesFont(font);
        }
        this.setTableColumnWidths(nArray);
        object = userReportHeaderFooter.c(this._runs.get(0));
        this._footerText = new MlLabel((String)object);
        this._footerText.setName((String)object);
        this._footerText.setHorizontalAlignment(2);
        this._footerText.setFont(userReportHeaderFooter.d());
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        UserReportViewerPanel userReportViewerPanel5 = this;
        userReportViewerPanel5.add((Component)userReportViewerPanel5._footerText, gridBagConstraints);
        this.buildMenus();
        this._compAdapter = new UserReportViewerPanel$1(this);
    }

    protected void addComponentListeners(UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable) {
        userReportViewerPanel$ReportTable.addComponentListener(this._compAdapter);
        userReportViewerPanel$ReportTable.getTableHeader().addComponentListener(this._compAdapter);
        userReportViewerPanel$ReportTable.getScrollPane().addComponentListener(this._compAdapter);
    }

    protected void removeComponentListeners(UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable) {
        userReportViewerPanel$ReportTable.removeComponentListener(this._compAdapter);
        userReportViewerPanel$ReportTable.getTableHeader().removeComponentListener(this._compAdapter);
        userReportViewerPanel$ReportTable.getScrollPane().removeComponentListener(this._compAdapter);
    }

    protected void buildMenus() {
        this._listener = new ReflectMultiListener();
        this._mbar = new JMenuBar();
        Serializable serializable = new JMenu("File");
        ((AbstractButton)serializable).setMnemonic('F');
        this._mbar.add((JMenu)serializable);
        JMenuItem jMenuItem = new JMenuItem("Export", 69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "exportReportAction"));
        ((JMenu)serializable).add(jMenuItem);
        ((JMenu)serializable).addSeparator();
        jMenuItem = new JMenuItem("Print", 80);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printReportAction"));
        ((JMenu)serializable).add(jMenuItem);
        jMenuItem = new JMenuItem("Print Preview", 86);
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "printPreviewAction"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        ((JMenu)serializable).add(jMenuItem);
        ((JMenu)serializable).addSeparator();
        jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        jMenuItem.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem, "closeAction"));
        ((JMenu)serializable).add(jMenuItem);
        serializable = new JMenu("View");
        ((AbstractButton)serializable).setMnemonic('V');
        this._mbar.add((JMenu)serializable);
        jMenuItem = new JMenu("Show Missing As");
        jMenuItem.setMnemonic('S');
        ((JMenu)serializable).add(jMenuItem);
        this._showMissingAsBlankMenuItem = new JRadioButtonMenuItem("blank");
        UserReportViewerPanel userReportViewerPanel = this;
        this._showMissingAsBlankMenuItem.addActionListener((ActionListener)this._listener.add((Object)userReportViewerPanel, (Object)userReportViewerPanel._showMissingAsBlankMenuItem, "showMissingAsBlankAction"));
        ((JMenu)jMenuItem).add(this._showMissingAsBlankMenuItem);
        this._showMissingAsM = new JRadioButtonMenuItem("M");
        UserReportViewerPanel userReportViewerPanel2 = this;
        this._showMissingAsM.addActionListener((ActionListener)this._listener.add((Object)userReportViewerPanel2, (Object)userReportViewerPanel2._showMissingAsM, "showMissingAsMAction"));
        ((JMenu)jMenuItem).add(this._showMissingAsM);
        this._showMissingAsDashMDash = new JRadioButtonMenuItem("-M-");
        UserReportViewerPanel userReportViewerPanel3 = this;
        this._showMissingAsDashMDash.addActionListener((ActionListener)this._listener.add((Object)userReportViewerPanel3, (Object)userReportViewerPanel3._showMissingAsDashMDash, "showMissingAsDashMDashAction"));
        ((JMenu)jMenuItem).add(this._showMissingAsDashMDash);
        this._showCommasMenuItem = new JCheckBoxMenuItem("Show Commas");
        UserReportViewerPanel userReportViewerPanel4 = this;
        this._showCommasMenuItem.addActionListener((ActionListener)this._listener.add((Object)userReportViewerPanel4, (Object)userReportViewerPanel4._showCommasMenuItem, "showCommasAction"));
        ((JMenu)serializable).add(this._showCommasMenuItem);
        jMenuItem = new JMenu("Format");
        jMenuItem.setMnemonic('F');
        this._mbar.add((JMenu)jMenuItem);
        ((JMenu)serializable).addSeparator();
        this._plotMenuItem = new JMenuItem("Plot", 80);
        UserReportViewerPanel userReportViewerPanel5 = this;
        this._plotMenuItem.addActionListener((ActionListener)this._listener.add((Object)userReportViewerPanel5, (Object)userReportViewerPanel5._plotMenuItem, "plotAction"));
        ((JMenu)serializable).add(this._plotMenuItem);
        serializable = new JMenu("Font");
        ((AbstractButton)serializable).setMnemonic('F');
        ((JMenu)jMenuItem).add((JMenuItem)serializable);
        JMenuItem jMenuItem2 = new JMenuItem("Title...", 84);
        jMenuItem2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem2, "editTitleFontAction"));
        ((JMenu)serializable).add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Header...", 72);
        jMenuItem2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem2, "editHeaderFontAction"));
        ((JMenu)serializable).add(jMenuItem2);
        jMenuItem2 = new JMenuItem("Footer...", 70);
        jMenuItem2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem2, "editFooterFontAction"));
        ((JMenu)serializable).add(jMenuItem2);
        ((JMenu)serializable).addSeparator();
        jMenuItem2 = new JMenuItem("Tables...", 65);
        jMenuItem2.addActionListener((ActionListener)this._listener.add((Object)this, (Object)jMenuItem2, "editTableFontAction"));
        ((JMenu)serializable).add(jMenuItem2);
        serializable = new JMenuItem("Save Settings", 83);
        ((JMenuItem)serializable).setAccelerator(KeyStroke.getKeyStroke(83, 2));
        ((AbstractButton)serializable).addActionListener((ActionListener)this._listener.add((Object)this, (Object)serializable, "saveReportAction"));
        ((JMenu)jMenuItem).add((JMenuItem)serializable);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._showMissingAsBlankMenuItem);
        ((ButtonGroup)serializable).add(this._showMissingAsM);
        ((ButtonGroup)serializable).add(this._showMissingAsDashMDash);
        this._showMissingAsBlankMenuItem.doClick(0);
    }

    protected void showMissingAction(String string) {
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            TableColumnModel tableColumnModel = this._reportBlocks[i].getColumnModel();
            for (int j = 1; j < tableColumnModel.getColumnCount(); ++j) {
                Object object = tableColumnModel.getColumn(j);
                if (!((object = ((TableColumn)object).getCellRenderer()) instanceof RmaCellRenderer)) continue;
                object = (RmaCellRenderer)object;
                object.setMissingString(string);
            }
            this._reportBlocks[i].repaint();
        }
    }

    protected void updateTableColumnWidths(UserReportViewerPanel$ReportTable userReportViewerPanel$ReportTable) {
        int n;
        this._columnsResized = true;
        TableColumnModel tableColumnModel = userReportViewerPanel$ReportTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        for (n = 0; n < this._reportBlocks.length; ++n) {
            UserReportViewerPanel userReportViewerPanel = this;
            userReportViewerPanel.removeComponentListeners(userReportViewerPanel._reportBlocks[n]);
        }
        for (n = 0; n < this._reportBlocks.length; ++n) {
            int n3;
            Object object = this._reportBlocks[n];
            if (userReportViewerPanel$ReportTable == object) continue;
            object = object.getColumnModel();
            for (n3 = 0; n3 < n2; ++n3) {
                object.getColumn(n3).setMinWidth(0);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                int n4 = tableColumnModel.getColumn(n3).getWidth();
                object.getColumn(n3).setWidth(n4);
                object.getColumn(n3).setPreferredWidth(n4);
            }
        }
        for (n = 0; n < this._reportBlocks.length; ++n) {
            UserReportViewerPanel userReportViewerPanel = this;
            userReportViewerPanel.addComponentListeners(userReportViewerPanel._reportBlocks[n]);
        }
    }

    protected boolean editComponentFont(MlLabel mlLabel) {
        Serializable serializable = SwingUtilities.windowForComponent(this);
        if (serializable instanceof Dialog) {
            serializable = (Dialog)serializable;
            serializable = new FontChooser((Dialog)serializable, "Change Font", true, mlLabel.getFont());
        } else {
            serializable = (Frame)serializable;
            serializable = new FontChooser((Frame)serializable, "Change Font", true, mlLabel.getFont());
        }
        serializable = serializable.getSelectedFont();
        if (serializable == null) {
            return false;
        }
        mlLabel.setFont((Font)serializable);
        return true;
    }

    void addTableListeners() {
        for (int i = 0; i < this._reportBlocks.length; ++i) {
            UserReportViewerPanel userReportViewerPanel = this;
            userReportViewerPanel.addComponentListeners(userReportViewerPanel._reportBlocks[i]);
        }
        UserReportViewerPanel$2 userReportViewerPanel$2 = new UserReportViewerPanel$2(this);
        Window window = SwingUtilities.windowForComponent(this);
        window.addComponentListener(userReportViewerPanel$2);
    }

    private int getLineCnt(String string) {
        int n = 1;
        int n2 = 0;
        while ((n2 = string.indexOf("\n", n2)) >= 0) {
            ++n;
            ++n2;
        }
        return n;
    }

    private MultiTablePrintManager getTablePrintManager() {
        this._tablePrintManager = new MultiTablePrintManager((JTable[])this._reportBlocks);
        TablePrintProperties tablePrintProperties = this._tablePrintManager.getPrintProperties();
        Object object = this._report.getHeaderFooter();
        if (object != null && this._runs.size() != 0) {
            tablePrintProperties.title = ((UserReportHeaderFooter)object).a(this._runs.get(0));
            tablePrintProperties.subTitle = ((UserReportHeaderFooter)object).b(this._runs.get(0));
            tablePrintProperties.remarksTitle = ((UserReportHeaderFooter)object).c(this._runs.get(0));
            tablePrintProperties.remarksFont = ((UserReportHeaderFooter)object).d();
            tablePrintProperties.titleFont = ((UserReportHeaderFooter)object).f();
            tablePrintProperties.subTitleFont = ((UserReportHeaderFooter)object).e();
        } else {
            System.out.println("printReportAction:HeaderFooter object is NULL");
        }
        object = this._report.getPageHeaderFooter();
        if (object != null) {
            tablePrintProperties.skipFooterOnFirstPage = ((UserReportPageHeaderFooter)object).g();
            tablePrintProperties.skipHeaderOnFirstPage = ((UserReportPageHeaderFooter)object).h();
            tablePrintProperties.header = ((UserReportPageHeaderFooter)object).d();
            tablePrintProperties.footer = ((UserReportPageHeaderFooter)object).a();
            tablePrintProperties.rightFooter = ((UserReportPageHeaderFooter)object).c();
            tablePrintProperties.leftFooter = ((UserReportPageHeaderFooter)object).b();
            tablePrintProperties.leftHeader = ((UserReportPageHeaderFooter)object).e();
            tablePrintProperties.rightHeader = ((UserReportPageHeaderFooter)object).f();
        } else {
            System.out.println("printReportAction:PageHeaderFooter object is NULL");
        }
        return this._tablePrintManager;
    }

    private boolean writeListModel(BufferedWriter bufferedWriter, ListModel listModel) {
        try {
            int n;
            for (n = 0; n < listModel.getSize(); ++n) {
                bufferedWriter.write(listModel.getElementAt(n).toString());
                bufferedWriter.newLine();
            }
            if (n > 0) {
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.out.println("writeListModel:Error writing report info " + String.valueOf(iOException));
            return false;
        }
        return true;
    }
}

