/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.reports;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.io.Identifier;
import hec.lang.annotation.Scriptable;
import hec.model.RunTimeWindow;
import hec.rss.client.reports.PrintableReport;
import hec.rss.model.ReverseYieldAnalysisBase;
import hec.rss.model.RssRun;
import hec.rss.model.ScheduledHydropowerOpRule;
import hec.rss.model.YieldAnalysis;
import hec.rss.model.YieldAnalysisData;
import hec.rss.model.YieldAnalysisRuleRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.EventObject;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaInsets;
import rma.swing.RmaJFrame;
import rma.swing.RmaJLabel;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaJTableExportDialog;
import rma.swing.table.RmaTableModel;
import rma.swing.table.TableExportOptions;
import rma.util.RMAIO;

public class YieldAnalysisReportDialog
extends RmaJFrame
implements PrintableReport,
ActionListener {
    JMenuBar _menuBar;
    JMenu _fileMnu;
    JMenuItem _printPreviewItem;
    JMenuItem _printItem;
    JMenuItem _exportItem;
    JMenuItem _closeCmd;
    private RmaJTableExportDialog _exportOptionsDialog;
    String[] _headers;
    protected RmaJTable _table;
    protected RmaJTextArea _footerTxtArea;
    private RssRun _run;
    private String _wkspPath;
    private Object[] _titleCriteria = new Object[8];
    protected ManagerProxyListContainer _wksp;
    private int _iterations = 0;
    private String[] _ruleNames;
    private List<YieldAnalysisRuleRef> _rules;
    private YieldAnalysisData _yieldAnalysisData;
    private boolean _isReverseYield;
    private GroupableTableHeader _header;

    public YieldAnalysisReportDialog(Frame frame, RssRun rssRun, ManagerProxyListContainer managerProxyListContainer) {
        this._wksp = managerProxyListContainer;
        this._run = rssRun;
        this._wkspPath = rssRun.getWorkspacePath();
        this.setTitle("Yield Analysis Summary");
        boolean bl = this.init();
        if (!bl) {
            return;
        }
        this.buildControls();
        this.buildMenus();
        this.createTableHeaders();
        this.fillTable();
        this.setSize(1000, this.getPreferredSize().height);
        this.setLocationRelativeTo(frame);
    }

    protected Identifier getRunId(String object, String string, RmiFileManager rmiFileManager) {
        object = string + "/rss/" + (String)object + ".rssrun";
        string = new Identifier((String)object);
        try {
            rmiFileManager = rmiFileManager.openFile(ClientApp.app().getUser(), (Identifier)string);
            if (rmiFileManager == null) {
                System.out.println("Failed to open ResSim run file " + string.getPath());
            }
            return rmiFileManager;
        }
        catch (RemoteException remoteException) {
            System.out.println("RemoteException opening " + (String)object + " error " + String.valueOf(remoteException));
            return null;
        }
    }

    private boolean init() {
        Object object;
        Object object2;
        if (this._wksp != null) {
            this._titleCriteria[0] = "rss".equals(ClientApp.app().getAppType()) ? new RmaJLabel("Simulation: " + RMAIO.getFileFromPath((String)this._run.getWorkspacePath())) : new RmaJLabel("Forecast: " + this._wksp.toString());
        }
        if ((object2 = this._run.getAlternative()) != null) {
            this._titleCriteria[1] = new RmaJLabel("Alternative: " + this._run.getName());
        }
        object2 = ClientApp.Workspace().getWatershedTimeZone();
        RunTimeWindow runTimeWindow = this._run.getRunTimeWindow();
        if (runTimeWindow != null) {
            object = "Start Time: ";
            this._titleCriteria[2] = new RmaJLabel("Lookback:  ", runTimeWindow.getLookbackTime(), (TimeZone)object2, "dd MMM yyyy kk:mm");
            if ("cavi".equals(ClientApp.app().getAppType())) {
                object = "Forecast Time: ";
            }
            this._titleCriteria[3] = new RmaJLabel((String)object, runTimeWindow.getStartTime(), (TimeZone)object2, "dd MMM yyyy kk:mm");
            this._titleCriteria[4] = new RmaJLabel("End Time:  ", runTimeWindow.getEndTime(), (TimeZone)object2, "dd MMM yyyy kk:mm");
        }
        if ((object = this._run.getAlternative().getYieldAnalysis()) == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No active yield analysis for this alternative.", "No Results To Report", 1);
            return false;
        }
        this._rules = ((YieldAnalysis)object).getYieldAnalysisRuleRefs();
        this._isReverseYield = object instanceof ReverseYieldAnalysisBase;
        if (this._rules.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "This alternative and analysis have no results to show.", "No Results To Report", 1);
            return false;
        }
        this._ruleNames = new String[this._rules.size()];
        object2 = "Yield Analysis Rule: ";
        for (int i = 0; i < this._rules.size(); ++i) {
            if (!this._rules.get(i).isInitialized()) {
                this._rules.get(i).initializeData(this._run.getAlternative().getSystem());
            }
            if (this._rules.size() == 1) {
                object2 = (String)object2 + this._rules.get(i).getRuleName();
                this._ruleNames[0] = this._rules.get(i).getRuleName();
                break;
            }
            object2 = (String)object2 + this._rules.get(i).getRuleName() + "/n";
            this._ruleNames[i] = this._rules.get(i).getRuleName();
        }
        this._titleCriteria[5] = new RmaJLabel("Reservoir: " + this._rules.get(0).getLocationName());
        this._titleCriteria[6] = new RmaJLabel((String)object2);
        this._yieldAnalysisData = ((YieldAnalysis)object).getYieldAnalysisData();
        if (this._isReverseYield) {
            this._yieldAnalysisData.readPairedDataReverse(this._run, (ReverseYieldAnalysisBase)object);
        } else {
            this._yieldAnalysisData.readPairedData(this._run, (YieldAnalysis)object);
        }
        this._iterations = this._yieldAnalysisData.getTotalIterations();
        this._titleCriteria[7] = new RmaJLabel("Maximum Number of Iterations: " + this._iterations);
        return true;
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        new Insets(3, 3, 0, 3);
        Serializable serializable = new Insets(0, 3, 0, 3);
        new Insets(0, 3, 3, 3);
        new Insets(3, 3, 3, 3);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(jPanel, gridBagConstraints);
        int n = 0;
        Object object = new String("");
        while (n < this._titleCriteria.length) {
            if (this._titleCriteria[n] == null) {
                ++n;
                continue;
            }
            JLabel jLabel = this._titleCriteria[n] instanceof JLabel ? (JLabel)this._titleCriteria[n] : new JLabel(this._titleCriteria[n].toString());
            object = (String)object + "\n " + jLabel.getText();
            jPanel.add((Component)jLabel, new RmaGridBagConstraints(0, this._titleCriteria.length + n++, 1, 1, 1.0, 0.0, 17, 2, (Insets)serializable, 0, 0));
        }
        this._table = new RmaJTable((Component)((Object)this));
        this._table.setTableHeader((JTableHeader)new GroupableTableHeader(this._table.getColumnModel()));
        this._table.setEnabled(false);
        this._table.setDisplayUnitsSystem(ClientApp.frame().getDisplayUnitSystem());
        serializable = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        ((Container)serializable).add(this._table.getScrollPane(), gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        new GridBagConstraints().gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)serializable, gridBagConstraints2);
        serializable = new JPanel(new GridBagLayout());
        gridBagConstraints2 = new RmaGridBagConstraints();
        this._footerTxtArea = new RmaJTextArea();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        ((Container)serializable).add((Component)this._footerTxtArea, gridBagConstraints2);
        gridBagConstraints2 = new RmaGridBagConstraints();
        new RmaGridBagConstraints().gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        this.add((Component)serializable, gridBagConstraints2);
    }

    public void buildMenus() {
        this._menuBar = new JMenuBar();
        this._fileMnu = new JMenu("File");
        this._fileMnu.setMnemonic('f');
        this._exportItem = new JMenuItem("Export", 69);
        this._exportItem.setAccelerator(KeyStroke.getKeyStroke(69, 2, false));
        this._exportItem.addActionListener(this);
        this._fileMnu.add(this._exportItem);
        this._fileMnu.addSeparator();
        this._printItem = new JMenuItem("Print", 112);
        this._printItem.setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        this._printItem.addActionListener(this);
        this._fileMnu.add(this._printItem);
        this._printPreviewItem = new JMenuItem("Print Preview", 112);
        this._printPreviewItem.setAccelerator(KeyStroke.getKeyStroke(79, 192));
        this._printPreviewItem.addActionListener(this);
        this._fileMnu.add(this._printPreviewItem);
        this._fileMnu.addSeparator();
        this._closeCmd = new JMenuItem("Close", 99);
        this._closeCmd.setAccelerator(KeyStroke.getKeyStroke(87, 2, false));
        this._closeCmd.addActionListener(this);
        this._fileMnu.add(this._closeCmd);
        this._menuBar.add(this._fileMnu);
        YieldAnalysisReportDialog yieldAnalysisReportDialog = this;
        yieldAnalysisReportDialog.setJMenuBar(yieldAnalysisReportDialog._menuBar);
    }

    private void createTableHeaders() {
        String[] stringArray = new String[16];
        Object object = new int[16];
        this._headers = new String[16];
        this._headers[0] = "Min Factor";
        stringArray[0] = "Min Factor";
        object[0] = -1;
        this._headers[1] = "Max Factor";
        stringArray[1] = "Max Factor";
        object[1] = -1;
        this._headers[2] = "Trial Factor";
        object[2] = -1;
        this._headers[3] = "Decreasing\nScale Ratio";
        object[3] = -1;
        this._headers[4] = "Increasing\nScale Ratio";
        object[4] = -1;
        if (this._isReverseYield) {
            stringArray[2] = "<html>Storage scale = increase/decrease in water supply pool storage, <br>given as a fraction of the maximum/minimum allowable storage. <br><br>0 indicates no change in the pool storage. <br>+1 indicates an increase to the maximum allowable storage. <br>-1 indicates a decrease to the minimum allowable storage.</html>";
            stringArray[3] = "<html>Heuristic Decrease Scale Ratio = new storage scale<br>calculated based on remaining con pool storage</html>";
            stringArray[4] = "<html>Heuristic Increase Scale Ratio = new storage scale<br>calculated based on accumulated demand shortage during the critical period.</html>";
        } else {
            stringArray[2] = "Demand scale = Multiplicative factor by which rule demand is increased or decreased.";
            stringArray[3] = "<html>Heuristic Decrease Scale Ratio = previous demand scale<br>multiplied by a factor based on accumulated demand shortage during the critical period.<br>(1 - max(accumulated demand shortage / accumulated demand))</html>";
            stringArray[4] = "<html>Heuristic Increase Scale Ratio = previous demand scale<br>multiplied by a factor based on the minimum storage during the critical period.<br>(1 + min(remaining storage / accumulated demand))</html>";
        }
        int n = Parameter.PARAMID_FLOW;
        if (this._rules.get(0).getRule() instanceof ScheduledHydropowerOpRule) {
            n = Parameter.PARAMID_POWER;
        }
        if (this._isReverseYield) {
            this._headers[5] = "Average\nCon Pool\nStorage\n(%S)";
            stringArray[5] = "Average Con Pool Storage";
            object[5] = Parameter.PARAMID_STOR;
        } else {
            this._headers[5] = "Average\nSimulation\nRule Demand\n(%S)";
            stringArray[5] = "Average Simulation Rule Demand";
            object[5] = n;
        }
        this._headers[6] = "Lower Limit of Con\nPool\n(%S)";
        stringArray[6] = "Lower Limit of Con Pool";
        object[6] = Parameter.PARAMID_STOR;
        this._headers[7] = "Simulated\nMinimum\nStorage\n(%S)";
        stringArray[7] = "Simulated Minimum Storage";
        object[7] = Parameter.PARAMID_STOR;
        this._headers[8] = "Lower Limit of Con\nPool + Storage\n Tolerance\n(%S)";
        stringArray[8] = "Lower Limit of Con Pool + Storage Tolerance";
        object[8] = Parameter.PARAMID_STOR;
        this._headers[9] = "Storage\nConvergence\nTest\n(Pass/Fail)";
        stringArray[9] = "Storage Convergence Test (Pass/Fail)";
        object[9] = -1;
        this._headers[10] = "Maximum Demand\nShortage\n(%S)";
        stringArray[10] = "Max Shortage = max(rule demand - rule delivery, 0.0)";
        object[10] = n;
        this._headers[11] = "Rule\nTolerance\n(%S)";
        stringArray[11] = "Rule Tolerance";
        object[11] = n;
        this._headers[12] = "Rule\nConvergence\nTest\n(Pass/Fail)";
        stringArray[12] = "Rule Convergence Test (Pass/Fail)";
        object[12] = -1;
        this._headers[13] = "Start Date";
        stringArray[13] = "Start Date";
        object[13] = -1;
        this._headers[14] = "Min Date";
        stringArray[14] = "Min Date";
        object[14] = -1;
        this._headers[15] = "End Date";
        stringArray[15] = "End Date";
        object[15] = -1;
        boolean[] blArray = new boolean[this._headers.length];
        for (int i = 0; i < this._headers.length; ++i) {
            blArray[i] = false;
        }
        this._table.setModel((TableModel)new RmaTableModel(this._headers, new Object[0][0], blArray));
        ((RmaTableModel)this._table.getModel()).setColumnParameters(object);
        this._table.setMlHeaderRenderer();
        this._table.setUnitsHeaderRenderer();
        this._table.setAutoResizeMode(0);
        String[] stringArray2 = new String[]{"\n\n\nIteration\nNumber"};
        if (this._iterations == Integer.MIN_VALUE) {
            return;
        }
        object = new Object[this._iterations][1];
        for (int i = 0; i < ((int[])object).length; ++i) {
            object[i][0] = i + 1;
        }
        this._table.setViewportRowHeader(stringArray2, (Object[][])object, null, null, 70);
        this._header = (GroupableTableHeader)this._table.getTableHeader();
        String string = this._isReverseYield ? "Storage" : "Demand";
        ColumnGroup columnGroup = new ColumnGroup(string + " Scale Limits");
        object = columnGroup;
        columnGroup.add((Object)this._table.getColumnModel().getColumn(0));
        object.add((Object)this._table.getColumnModel().getColumn(1));
        stringArray2 = new ColumnGroup(string + " Scale");
        stringArray2.add((Object)this._table.getColumnModel().getColumn(2));
        ColumnGroup columnGroup2 = new ColumnGroup("Heuristic Method");
        columnGroup2.add((Object)this._table.getColumnModel().getColumn(3));
        columnGroup2.add((Object)this._table.getColumnModel().getColumn(4));
        ColumnGroup columnGroup3 = new ColumnGroup("Bisection Method");
        columnGroup3.add(object);
        columnGroup3.add((Object)stringArray2);
        ColumnGroup columnGroup4 = new ColumnGroup(string + " Estimate Factors");
        object = columnGroup4;
        columnGroup4.add((Object)columnGroup3);
        object.add((Object)columnGroup2);
        this._header.addColumnGroup((ColumnGroup)object);
        ColumnGroup columnGroup5 = new ColumnGroup("Simulation Results");
        object = columnGroup5;
        columnGroup5.add((Object)this._table.getColumnModel().getColumn(5));
        string = new ColumnGroup("Storage Convergence");
        string.add((Object)this._table.getColumnModel().getColumn(6));
        string.add((Object)this._table.getColumnModel().getColumn(7));
        string.add((Object)this._table.getColumnModel().getColumn(8));
        string.add((Object)this._table.getColumnModel().getColumn(9));
        object.add((Object)string);
        string = new ColumnGroup("Rule Convergence");
        string.add((Object)this._table.getColumnModel().getColumn(10));
        string.add((Object)this._table.getColumnModel().getColumn(11));
        string.add((Object)this._table.getColumnModel().getColumn(12));
        object.add((Object)string);
        string = new ColumnGroup("Critical Period");
        string.add((Object)this._table.getColumnModel().getColumn(13));
        string.add((Object)this._table.getColumnModel().getColumn(14));
        string.add((Object)this._table.getColumnModel().getColumn(15));
        object.add((Object)string);
        this._header.addColumnGroup((ColumnGroup)object);
        this._header.setToolTipStrings(stringArray);
        this._table.setColumnPrecision(0, 6);
        this._table.setColumnPrecision(1, 6);
        this._table.setColumnPrecision(2, 6);
        this._table.setColumnPrecision(3, 6);
        this._table.setColumnPrecision(4, 6);
        this._table.setColumnPrecision(5, 2);
        this._table.setColumnPrecision(6, 1);
        this._table.setColumnPrecision(7, 1);
        this._table.setColumnPrecision(8, 1);
        this._table.setColumnPrecision(10, 2);
        this._table.setColumnPrecision(11, 2);
    }

    private void fillTable() {
        Cloneable cloneable = this._run.getAlternative().getYieldAnalysis();
        if (this._isReverseYield) {
            this._yieldAnalysisData.readPairedDataReverse(this._run, (ReverseYieldAnalysisBase)cloneable);
        } else {
            this._yieldAnalysisData.readPairedData(this._run, (YieldAnalysis)cloneable);
        }
        for (int i = 1; i < this._iterations + 1; ++i) {
            cloneable = new Vector();
            if (this._yieldAnalysisData.getLowerScale(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getLowerScale(i));
            }
            if (this._yieldAnalysisData.getUpperScale(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getUpperScale(i));
            }
            if (this._yieldAnalysisData.getStartScale(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getStartScale(i));
            }
            if (this._yieldAnalysisData.getHeuristicRatioDecr(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getHeuristicRatioDecr(i));
            }
            if (this._yieldAnalysisData.getHeuristicRatioIncr(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getHeuristicRatioIncr(i));
            }
            if (this._isReverseYield) {
                if (this._yieldAnalysisData.getAvgConPoolStorage(i) == -3.4028234663852886E38) {
                    ((Vector)cloneable).add("");
                } else {
                    ((Vector)cloneable).add(this._yieldAnalysisData.getAvgConPoolStorage(i));
                }
            } else if (this._yieldAnalysisData.getAvgStartingRuleDemand() == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getAvgStartingRuleDemand() * this._yieldAnalysisData.getStartScale(i));
            }
            if (this._yieldAnalysisData.getLowerLimitStor() == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(new ParamDouble(this._yieldAnalysisData.getLowerLimitStor(), Parameter.PARAMID_STOR, this._wksp.getUnitSystem()));
            }
            if (this._yieldAnalysisData.getMinStorage(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(new ParamDouble(this._yieldAnalysisData.getMinStorage(i), Parameter.PARAMID_STOR, this._wksp.getUnitSystem(), 4));
            }
            if (this._yieldAnalysisData.getLowerLimitStorTol() == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(new ParamDouble(this._yieldAnalysisData.getLowerLimitStorTol(), Parameter.PARAMID_STOR, this._wksp.getUnitSystem(), 4));
            }
            if (this._yieldAnalysisData.getStorageTolTest(i)) {
                double d = this._yieldAnalysisData.getMinStorage(i);
                if (d != -3.4028234663852886E38 && d < 0.0) {
                    ((Vector)cloneable).add("Fail");
                } else {
                    ((Vector)cloneable).add("Pass");
                }
            } else {
                ((Vector)cloneable).add("Fail");
            }
            if (this._yieldAnalysisData.getMaxDemandShortage(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(new ParamDouble(this._yieldAnalysisData.getMaxDemandShortage(i), Parameter.PARAMID_FLOW, this._wksp.getUnitSystem()));
            }
            if (this._yieldAnalysisData.getLimitingRuleTol(i) == -3.4028234663852886E38) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(new ParamDouble(this._yieldAnalysisData.getLimitingRuleTol(i), Parameter.PARAMID_FLOW, this._wksp.getUnitSystem()));
            }
            if (this._yieldAnalysisData.getRuleTest(i)) {
                ((Vector)cloneable).add("Pass");
            } else {
                ((Vector)cloneable).add("Fail");
            }
            if (this._yieldAnalysisData.getStartCritDate(i) == null) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getStartCritDate(i));
            }
            if (this._yieldAnalysisData.getMinCritDate(i) == null) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getMinCritDate(i));
            }
            if (this._yieldAnalysisData.getEndCritDate(i) == null) {
                ((Vector)cloneable).add("");
            } else {
                ((Vector)cloneable).add(this._yieldAnalysisData.getEndCritDate(i));
            }
            this._table.setRow(i - 1, (Vector)cloneable);
        }
        this._table.setAutoResizeMode(4);
    }

    public void printReport() {
        this._table.printData();
    }

    @Override
    public void printPreviewReport() {
        this._table.printPreview();
    }

    public RmaJTable getTable() {
        return this._table;
    }

    public String getWkspPath() {
        return this._wkspPath;
    }

    public ManagerProxyListContainer getWorkspace() {
        return this._wksp;
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._closeCmd) {
            this.CloseCmd_Action();
            return;
        }
        if (object == this._exportItem) {
            this.exportReport();
            return;
        }
        if (object == this._printItem) {
            this.printReport();
            return;
        }
        if (object == this._printPreviewItem) {
            this.printPreviewReport();
        }
    }

    @Deprecated
    public void exportReportAction() {
        this.exportReport();
    }

    @Override
    public void exportReport() {
        if (this._exportOptionsDialog == null) {
            this._exportOptionsDialog = RmaJTableExportDialog.getExportDialog((RmaJTable)this._table);
        }
        this._exportOptionsDialog.setVisible(true);
        if (this._exportOptionsDialog.isCanceled()) {
            return;
        }
        Serializable serializable = JOptionPane.getFrameForComponent((Component)((Object)this));
        if (serializable != null) {
            serializable.setCursor(Cursor.getPredefinedCursor(3));
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (serializable != null) {
            serializable.setCursor(Cursor.getDefaultCursor());
        }
        jFileChooser.showSaveDialog((Component)((Object)this));
        serializable = jFileChooser.getSelectedFile();
        if (serializable == null) {
            return;
        }
        this.exportReportAction((File)serializable, this._exportOptionsDialog.getExportOptions());
    }

    @Scriptable
    public boolean exportReportAction(File file, TableExportOptions tableExportOptions) {
        BufferedWriter bufferedWriter;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            System.out.println("exportData: failed to open file " + file.getPath() + " error " + String.valueOf(iOException));
            JOptionPane.showMessageDialog((Component)((Object)this), "Failed to open export file " + file.getPath());
            return false;
        }
        this._table.exportData(bufferedWriter, tableExportOptions);
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    private boolean writeListModel(BufferedWriter bufferedWriter, ListModel listModel) {
        try {
            int n;
            for (n = 0; n < listModel.getSize(); ++n) {
                bufferedWriter.write(listModel.getElementAt(n).toString());
                bufferedWriter.newLine();
            }
            if (n > 0) {
                bufferedWriter.newLine();
            }
        }
        catch (IOException iOException) {
            System.out.println("writeListModel:Error writing report info " + String.valueOf(iOException));
            return false;
        }
        return true;
    }

    void CloseCmd_Action() {
        this.setVisible(false);
        this.dispose();
    }
}

