/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.scriptsSearch;

import hec.rss.client.scriptsSearch.ScriptSearchOptions;
import hec.rss.client.scriptsSearch.ScriptsSearchListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;

public class SearchScriptDialog
extends RmaJDialog {
    private static RmaListModel<String> a = new RmaListModel();
    private RmaJComboBox<String> _findCombo;
    protected JPanel _leftPanel;
    private RmaJCheckBox _matchCaseCheck;
    protected JPanel _rightPanel;
    private JButton _findButton;
    private JButton _closeButton;
    private List<ScriptsSearchListener> _listeners;

    public SearchScriptDialog(Window window) {
        super(window);
        this.buildControls();
        this.addListeners();
        this.setSize(400, 300);
        this.pack();
        SearchScriptDialog searchScriptDialog = this;
        searchScriptDialog.setLocationRelativeTo(searchScriptDialog.getParent());
    }

    protected void buildControls() {
        this.setTitle("Search in Scripts");
        this._listeners = new ArrayList<ScriptsSearchListener>();
        this.getContentPane().setLayout(new GridBagLayout());
        this._leftPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._leftPanel, gridBagConstraints);
        this.buildLeftPanel();
        this._rightPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._rightPanel, gridBagConstraints);
        this.buildrightPanel();
    }

    protected void buildLeftPanel() {
        JLabel jLabel = new JLabel("Find What:");
        jLabel.setDisplayedMnemonic('F');
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)jLabel, gridBagConstraints);
        this._findCombo = new RmaJComboBox(a);
        this._findCombo.setEditable(true);
        jLabel.setLabelFor((Component)this._findCombo);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)this._findCombo, gridBagConstraints);
        this.addOptionalPanel();
        this._matchCaseCheck = new RmaJCheckBox("Match Case");
        this._matchCaseCheck.setMnemonic('M');
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._leftPanel.add((Component)this._matchCaseCheck, gridBagConstraints);
    }

    private void buildrightPanel() {
        this._findButton = new JButton("Find...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        new GridBagConstraints().gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._findButton, gridBagConstraints);
        this._closeButton = new JButton("Close");
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.001;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = RmaInsets.INSETS5505;
        this._rightPanel.add((Component)this._closeButton, gridBagConstraints);
        this.getRootPane().setDefaultButton(this._findButton);
    }

    protected void addOptionalPanel() {
    }

    private void addListeners() {
        this._findCombo.addItemListener(itemEvent -> this.findItemSelected(itemEvent));
        this._findButton.addActionListener(actionEvent -> this.findAction());
        this._closeButton.addActionListener(actionEvent -> this.setVisible(false));
    }

    private void findItemSelected(ItemEvent itemEvent) {
        if (2 == itemEvent.getStateChange()) {
            return;
        }
        this._findButton.setEnabled(this._findCombo.getSelectedItem() != null);
    }

    protected void findAction() {
        ScriptSearchOptions scriptSearchOptions = this.createSearchOptions();
        String string = (String)this._findCombo.getSelectedItem();
        if (!((RmaListModel)this._findCombo.getModel()).contains((Object)string)) {
            this._findCombo.insertItemAt((Object)string, 0);
        }
        this.fireListeners(scriptSearchOptions);
    }

    private void fireListeners(ScriptSearchOptions scriptSearchOptions) {
        for (int i = this._listeners.size() - 1; i >= 0; --i) {
            this._listeners.get(i).search(scriptSearchOptions);
        }
    }

    protected ScriptSearchOptions createSearchOptions() {
        return new ScriptSearchOptions(this.getSearchText(), this.shouldMatchCase());
    }

    public void addSearchListener(ScriptsSearchListener scriptsSearchListener) {
        if (scriptsSearchListener != null) {
            this._listeners.add(scriptsSearchListener);
        }
    }

    public boolean removeSearchListener(ScriptsSearchListener scriptsSearchListener) {
        return this._listeners.remove(scriptsSearchListener);
    }

    public boolean shouldMatchCase() {
        return this._matchCaseCheck.isSelected();
    }

    public String getSearchText() {
        return (String)this._findCombo.getSelectedItem();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._findCombo.setSelectedIndex(-1);
        }
        super.setVisible(bl);
    }
}

