/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.client.systsplot;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.geometry.Axis;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportLayout;
import hec.io.TimeSeriesContainer;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.client.systsplot.SysTSScrollViewData;
import hec.rss.client.systsplot.SysTSScrollViewGlyph;
import hec.rss.client.systsplot.SystemTSPlotPanel$1;
import hec.rss.client.systsplot.SystemTSPlotPanel$2;
import hec.rss.model.DownstreamOpRule;
import hec.rss.model.Element;
import hec.rss.model.ElementGraph;
import hec.rss.model.OpRule;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.SystemHydropowerRule;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import rma.services.ServiceLookup;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.util.RmaDrawConst;

public class SystemTSPlotPanel
extends RmaJPanel
implements Observer {
    public static final Color[] SYSPLOTCOLOR = new Color[]{Color.blue, Color.red, Color.green.darker(), Color.magenta, Color.orange, Color.cyan, new Color(64, 128, 225), new Color(225, 128, 68), new Color(128, 64, 225), new Color(128, 225, 68), new Color(225, 64, 128), new Color(64, 225, 128)};
    public static final int[] SYSPLOTSYMBOL = new int[]{0, 1, 4, 2, 3, 5, 6, 7, 10, 8, 9, 11};
    public static final float[][] SYSPLOTLINESTYLE = new float[][]{RmaDrawConst.SOLID_STYLE_PATTERN, RmaDrawConst.DASH_STYLE_PATTERN, RmaDrawConst.DOT_STYLE_PATTERN, RmaDrawConst.DASHDOT_STYLE_PATTERN, RmaDrawConst.DASHDOTDOT_STYLE_PATTERN};
    public static final int LP_LOC_SYS = 0;
    public static final int LP_LOC_RES = 1;
    public static final int LP_LOC_TAR = 2;
    public static final int LP_COEF_BAL = 3;
    public static final int LP_STOR = 4;
    public static final int LP_STOR_BAL = 5;
    public static final int LP_STOR_ZONE = 6;
    public static final int LP_FLOW_IN = 7;
    public static final int LP_FLOW_OUT = 8;
    public static final int LP_LIMIT_MAX = 9;
    public static final int LP_LIMIT_MIN = 10;
    public static final int LP_LIMIT_TAR = 11;
    private RssSystem _system;
    private RunTimeWindow _rtw;
    private OpRule _rule;
    private ElementGraph _elemGraph;
    private ReservoirElement[] _resArray;
    private RmaJComboBox _ruleCombo;
    private G2dPanel _g2dPanel;
    private PlotLayout _plotLayout;
    private JSlider _timeSlider;
    RmaJLabel _currentTime;

    public SystemTSPlotPanel() {
        this.buildComponents();
    }

    public void setSystem(RssSystem object, RunTimeWindow object2) {
        this._system = object;
        this._rtw = object2;
        if (this._system == null && this._rtw == null) {
            return;
        }
        this.setVisible(false);
        this._ruleCombo.removeAllItems();
        object = this._system.getSystemRules();
        object = object.iterator();
        while (object.hasNext()) {
            object2 = object.next();
            this._ruleCombo.addItem(object2);
        }
        this._timeSlider.setMinimum(0);
        this._timeSlider.setMaximum(this._rtw.getNumSteps());
        this._timeSlider.setMajorTickSpacing(this._rtw.getNumSteps() / 10);
        this._timeSlider.setMinorTickSpacing(this._timeSlider.getMajorTickSpacing() / 10);
        this._timeSlider.setValue(this._rtw.getNumLookbackSteps());
        object = (OpRule)this._ruleCombo.getSelectedItem();
        this.buildPlots((OpRule)object);
        object2 = ServiceLookup.getTimeZoneDisplayService();
        object = ServiceLookup.getUnitsDisplayService();
        this._g2dPanel.setTimeZone(object2.getTimeZone());
        this._g2dPanel.setDisplayUnitsSystem(object.getDisplayUnitsSystem());
        this.setVisible(true);
    }

    private void buildComponents() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        Object object = new RmaJPanel();
        object.setLayout((LayoutManager)new FlowLayout());
        RmaJLabel rmaJLabel = new RmaJLabel("System Rule Selection");
        object.add((Component)rmaJLabel);
        this._ruleCombo = new RmaJComboBox();
        object.add((Component)this._ruleCombo);
        this.add((Component)object, "North");
        this._g2dPanel = new G2dPanel();
        object = new JScrollPane((Component)this._g2dPanel);
        object.setHorizontalScrollBarPolicy(31);
        this.add((Component)object, "Center");
        object = new RmaJPanel();
        object.setLayout((LayoutManager)new GridBagLayout());
        rmaJLabel = new RmaJLabel("Time Selection");
        object.add((Component)rmaJLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this._timeSlider = new JSlider(0, 0, 100, 10);
        this._timeSlider.setPaintTicks(true);
        object.add((Component)this._timeSlider);
        object.add((Component)this._timeSlider, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(2, 2, 2, 2), 0, 0));
        this._currentTime = new RmaJLabel("01JUL2016 1200");
        object.add((Component)this._currentTime, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)object, "South");
        this._ruleCombo.addItemListener((ItemListener)new SystemTSPlotPanel$1(this));
        this._timeSlider.addChangeListener(new SystemTSPlotPanel$2(this));
    }

    public void buildPlots(OpRule opRule) {
        OpRule opRule2;
        G2dLineProperties g2dLineProperties;
        Object object;
        Object object2;
        G2dMarkerProperties g2dMarkerProperties;
        this._rule = opRule;
        if (this._system == null || this._g2dPanel == null) {
            return;
        }
        this.buildElementGraph();
        if (this._resArray == null || this._resArray.length <= 0) {
            this._g2dPanel.buildDefaultComponents();
            return;
        }
        int n = this._resArray.length;
        if (n <= 0) {
            return;
        }
        this._g2dPanel.setMinimumSize(new Dimension(400, n * 50));
        this._g2dPanel.setPreferredSize(new Dimension(400, n * 200));
        this._g2dPanel.revalidate();
        this._plotLayout = new PlotLayout();
        this._plotLayout.setTitle("System Time Series Plot");
        int n2 = 0;
        n = this._resArray.length + 2;
        ViewportLayout[] viewportLayoutArray = new ViewportLayout[n];
        Object object3 = viewportLayoutArray;
        viewportLayoutArray[0] = this._plotLayout.addViewport();
        object3[0].setAxisName("Y1", "Balance");
        object3[0].setAxisLabel("Y1", "Resevoir Balance\nStorage Coefficient");
        ++n2;
        for (int i = 0; i < this._resArray.length; ++i) {
            object3[n2] = this._plotLayout.addViewport();
            object3[n2].setAxisName("Y1", "Stor" + i);
            object3[n2].setAxisName("Y2", "Release" + i);
            object3[n2].setAxisLabel("Y1", this._resArray[i].getName() + "\nStorage (%S)");
            object3[n2].setAxisLabel("Y2", "Flow (%S)");
            ++n2;
        }
        object3[n2] = this._plotLayout.addViewport();
        object3[n2].setAxisName("Y1", "Target");
        object3[n2].setAxisLabel("Y1", this._rule.getName() + "\nTarget (%S)");
        TSRecordProxy tSRecordProxy = new Vector();
        Cloneable cloneable = new Vector<RssRun>();
        ((Vector)cloneable).add(this._system.getRssRun());
        TSDataSet tSDataSet = this._system.getRssRun().getRegOutputTSData();
        tSDataSet.initialize(this._rtw);
        if (this._rule != null) {
            g2dMarkerProperties = new G2dMarkerProperties();
            new G2dMarkerProperties()._name = "Conservation";
            g2dMarkerProperties.drawLabel = true;
            g2dMarkerProperties.markerLabel = "Conservation";
            g2dMarkerProperties.setLinePattern(G2dLineProperties.DASH_STYLE_PATTERN);
            g2dMarkerProperties.setLineWidth(1.5f);
            object2 = object3;
            int cfr_ignored_0 = ((ViewportLayout[])object3).length;
            for (int i = 0; i < n; ++i) {
                object = object2[i];
                if (object == null) continue;
                object3[0].addMarkerLine("Y1", 2.0, g2dMarkerProperties);
            }
            object2 = this._rule.getTSProxyName();
            g2dMarkerProperties = this._rule.getTSRecordProxy((String)object2 + "-Final", 167);
            if (g2dMarkerProperties != null) {
                TSRecord tSRecord = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(0, 0, 3);
                object = new TimeSeriesDataSet(tSRecord.getTimeSeriesContainer());
                object.setName("System Balance");
                object3[0].addCurve("Y1", object, g2dLineProperties);
            }
            tSRecordProxy.clear();
            if (this._rule instanceof DownstreamOpRule) {
                DownstreamOpRule downstreamOpRule = (DownstreamOpRule)this._rule;
                downstreamOpRule.getTSRecordProxyVecResVar((Vector)tSRecordProxy, 167);
            } else if (this._rule instanceof SystemHydropowerRule) {
                SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)this._rule;
                systemHydropowerRule.getTSRecordProxyVecResVar((Vector)tSRecordProxy, 167);
            }
            for (int i = 0; i < tSRecordProxy.size(); ++i) {
                g2dMarkerProperties = (TSRecordProxy)tSRecordProxy.get(i);
                object = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(i + 1, 1, 3);
                opRule2 = new TimeSeriesDataSet(object.getTimeSeriesContainer());
                opRule2.setName(this._resArray[i].getName());
                object3[0].addCurve("Y1", (Object)opRule2, g2dLineProperties);
            }
        }
        Vector vector = new Vector();
        if (this._rule instanceof DownstreamOpRule) {
            opRule2 = (DownstreamOpRule)this._rule;
            opRule2.getTSRecordProxyVecResVar(vector, 89);
        } else if (this._rule instanceof SystemHydropowerRule) {
            opRule2 = (SystemHydropowerRule)this._rule;
            ((SystemHydropowerRule)opRule2).getTSRecordProxyVecResVar(vector, 89);
        }
        for (int i = 0; i < this._resArray.length; ++i) {
            tSRecordProxy.clear();
            ((Element)this._resArray[i]).getTSRecords(RssModelVariableSet.getModelVariable(12), (Vector)tSRecordProxy, (Vector)cloneable);
            if (tSRecordProxy.size() > 0) {
                g2dMarkerProperties = (TSRecordProxy)tSRecordProxy.get(0);
                object2 = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(i + 1, 1, 7);
                g2dMarkerProperties = new TimeSeriesDataSet(object2.getTimeSeriesContainer());
                g2dMarkerProperties.setName("Pool Inflow");
                object3[i + 1].addCurve("Y2", (Object)g2dMarkerProperties, g2dLineProperties);
            }
            tSRecordProxy.clear();
            ((Element)this._resArray[i]).getTSRecords(RssModelVariableSet.getModelVariable(21), (Vector)tSRecordProxy, (Vector)cloneable);
            if (tSRecordProxy.size() > 0) {
                g2dMarkerProperties = (TSRecordProxy)tSRecordProxy.get(0);
                object2 = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(i + 1, 1, 8);
                g2dMarkerProperties = new TimeSeriesDataSet(object2.getTimeSeriesContainer());
                g2dMarkerProperties.setName("Pool Outflow");
                object3[i + 1].addCurve("Y2", (Object)g2dMarkerProperties, g2dLineProperties);
            }
            if (vector.size() > i) {
                g2dMarkerProperties = (TSRecordProxy)vector.get(i);
                object2 = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(i + 1, 1, 5);
                g2dMarkerProperties = new TimeSeriesDataSet(object2.getTimeSeriesContainer());
                g2dMarkerProperties.setName("Balanced Storage");
                object3[i + 1].addCurve("Y1", (Object)g2dMarkerProperties, g2dLineProperties);
            }
            tSRecordProxy.clear();
            ((Element)this._resArray[i]).getTSRecords(RssModelVariableSet.getModelVariable(11), (Vector)tSRecordProxy, (Vector)cloneable);
            if (tSRecordProxy.size() <= 0) continue;
            g2dMarkerProperties = (TSRecordProxy)tSRecordProxy.get(0);
            object2 = tSDataSet.loadTSRecord(g2dMarkerProperties.getName(), g2dMarkerProperties.getVariableId(), this._system.getRssRun().getTimeWindowString());
            g2dLineProperties = this.getLineProperties(i + 1, 1, 4);
            g2dMarkerProperties = new TimeSeriesDataSet(object2.getTimeSeriesContainer());
            g2dMarkerProperties.setName("Storage");
            object3[i + 1].addCurve("Y1", (Object)g2dMarkerProperties, g2dLineProperties);
        }
        if (this._rule instanceof DownstreamOpRule) {
            TSRecordProxy tSRecordProxy2;
            if (this._rule.getRuleLimitType() == 2) {
                tSRecordProxy2 = this._rule.getTSRecordProxy(81);
                g2dLineProperties = this.getLineProperties(0, 0, 9);
            } else {
                tSRecordProxy2 = this._rule.getTSRecordProxy(82);
                g2dLineProperties = this.getLineProperties(0, 0, 10);
            }
            if (tSRecordProxy2 != null) {
                g2dMarkerProperties = tSDataSet.loadTSRecord(tSRecordProxy2.getName(), tSRecordProxy2.getVariableId(), this._system.getRssRun().getTimeWindowString());
                object2 = new TimeSeriesDataSet(g2dMarkerProperties.getTimeSeriesContainer());
                object2.setName("Flow Limit");
                object3[n - 1].addCurve("Y1", object2, g2dLineProperties);
            }
            if ((tSRecordProxy2 = this._rule.getTargetTSRecordProxy()) != null) {
                g2dMarkerProperties = tSDataSet.loadTSRecord(tSRecordProxy2.getName(), tSRecordProxy2.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(0, 0, 11);
                object2 = new TimeSeriesDataSet(g2dMarkerProperties.getTimeSeriesContainer());
                object2.setName("Downstream Flow");
                object3[n - 1].addCurve("Y1", object2, g2dLineProperties);
            }
        } else if (this._rule instanceof SystemHydropowerRule) {
            object2 = this._rule.getTSProxyName();
            TSRecordProxy tSRecordProxy3 = this._rule.getTSRecordProxy((String)object2, 157);
            g2dLineProperties = this.getLineProperties(0, 0, 10);
            if (tSRecordProxy3 != null) {
                g2dMarkerProperties = tSDataSet.loadTSRecord(tSRecordProxy3.getName(), tSRecordProxy3.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dMarkerProperties = new TimeSeriesDataSet(g2dMarkerProperties.getTimeSeriesContainer());
                g2dMarkerProperties.setName("Generation Target");
                object3[n - 1].addCurve("Y1", (Object)g2dMarkerProperties, g2dLineProperties);
            }
            if ((tSRecordProxy3 = this._rule.getTSRecordProxy((String)object2, 156)) != null) {
                g2dMarkerProperties = tSDataSet.loadTSRecord(tSRecordProxy3.getName(), tSRecordProxy3.getVariableId(), this._system.getRssRun().getTimeWindowString());
                g2dLineProperties = this.getLineProperties(0, 0, 11);
                g2dMarkerProperties = new TimeSeriesDataSet(g2dMarkerProperties.getTimeSeriesContainer());
                g2dMarkerProperties.setName("Period Generation");
                object3[n - 1].addCurve("Y1", (Object)g2dMarkerProperties, g2dLineProperties);
            }
        }
        int n3 = this._system.getRssRun().getRunTimeWindow().getStartTime().value();
        g2dMarkerProperties = new G2dMarkerProperties();
        g2dMarkerProperties.setLinePattern(G2dLineProperties.DASH_STYLE_PATTERN);
        g2dMarkerProperties.setLineWidth(1.0f);
        object2 = object3;
        int cfr_ignored_1 = ((ViewportLayout[])object3).length;
        for (int i = 0; i < n; ++i) {
            object = object2[i];
            if (object == null) continue;
            object.addMarkerLine("X1", (double)n3, g2dMarkerProperties);
        }
        this._g2dPanel.buildComponents(this._plotLayout);
        object2 = this._g2dPanel.getViewports();
        g2dMarkerProperties = new G2dLineProperties();
        new G2dLineProperties()._lineColor = Color.red;
        g2dMarkerProperties._lineWidth = 1.5f;
        G2dLineProperties g2dLineProperties2 = new G2dLineProperties();
        new G2dLineProperties()._lineColor = Color.gray;
        g2dLineProperties2._lineWidth = 1.5f;
        object = new Vector();
        TimeSeriesContainer timeSeriesContainer = new Vector();
        Cloneable cloneable2 = new Vector();
        if (this._rule instanceof DownstreamOpRule) {
            cloneable = (DownstreamOpRule)this._rule;
            ((DownstreamOpRule)cloneable).getTSRecordProxyVecResVar((Vector)object, 198);
            ((DownstreamOpRule)cloneable).getTSRecordProxyVecResVar((Vector)timeSeriesContainer, 199);
            ((DownstreamOpRule)cloneable).getTSRecordProxyVecResVar((Vector)cloneable2, 200);
        }
        for (int i = 0; object2 != null && i < ((TSRecord)object2).length; ++i) {
            if (object2[i] == null || ((Vector)(cloneable2 = object2[i].getGlyphVector())).size() <= 0) continue;
            object3 = new SysTSScrollViewData();
            ((SysTSScrollViewData)object3).setData(this._timeSlider, this._rtw, ((G2dGlyph)((Vector)cloneable2).get(0)).getG2dObject());
            if (this._rule instanceof DownstreamOpRule && i > 0 && i < ((TSRecord)object2).length - 1) {
                cloneable2 = (DownstreamOpRule)this._rule;
                tSRecordProxy = ((DownstreamOpRule)cloneable2).getTSRecordProxyResVar(i - 1, 198);
                g2dLineProperties = tSDataSet.loadTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId(), this._system.getRssRun().getTimeWindowString());
                timeSeriesContainer = g2dLineProperties.getTimeSeriesContainer();
                tSRecordProxy = ((DownstreamOpRule)cloneable2).getTSRecordProxyResVar(i - 1, 199);
                g2dLineProperties = tSDataSet.loadTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId(), this._system.getRssRun().getTimeWindowString());
                object = g2dLineProperties.getTimeSeriesContainer();
                tSRecordProxy = ((DownstreamOpRule)cloneable2).getTSRecordProxyResVar(i - 1, 200);
                g2dLineProperties = tSDataSet.loadTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId(), this._system.getRssRun().getTimeWindowString());
                cloneable2 = g2dLineProperties.getTimeSeriesContainer();
                ((SysTSScrollViewData)object3).setRouteTS(timeSeriesContainer, (TimeSeriesContainer)object, (TimeSeriesContainer)cloneable2);
            }
            object2[i].getGlyphVector();
            tSRecordProxy = new SysTSScrollViewGlyph((Viewport)object2[i], (SysTSScrollViewData)object3, object2[i].getScale());
            g2dLineProperties = tSRecordProxy.getProperties();
            tSRecordProxy.getProperties().lineProperties = new ArrayList();
            g2dLineProperties.lineProperties.add(g2dMarkerProperties);
            g2dLineProperties.lineProperties.add(g2dLineProperties2);
            g2dLineProperties.polygonProperties = new G2dPolygonProperties();
            g2dLineProperties.polygonProperties.setDrawBackground(true);
            g2dLineProperties.polygonProperties.setLineColor(Color.green.brighter());
            g2dLineProperties.polygonProperties.setBackgroundColor(Color.lightGray);
            g2dLineProperties.polygonProperties.setBackgroundFill(0);
            g2dLineProperties.polygonProperties.setAlphaComposite(0.25f);
            tSRecordProxy.setProperties((G2dGlyphDrawProp)g2dLineProperties);
            tSRecordProxy.setLegendItemsVisible(false);
            object2[i].insertG2dGlyph((G2dGlyph)tSRecordProxy, 0);
            object2[i].setDoubleBuffered(false);
        }
        this._g2dPanel.moveLegendToPosition(7);
        if (this._g2dPanel.getLegendPanel() != null) {
            this._g2dPanel.getLegendPanel().refreshLegendItems();
        }
        if (object2 != null && ((TSRecord)object2).length > 0) {
            object2[0].getAxis("X1").addObserver((Observer)this);
        }
        this._g2dPanel.revalidate();
    }

    void buildElementGraph() {
        if (this._system == null) {
            this._elemGraph = null;
            return;
        }
        this._elemGraph = this._system.buildElementGraph(0, true, false);
        if (this._rule == null) {
            Vector<ReservoirElement> vector = this._system.getElementVectorByClass(ReservoirElement.class);
            if (vector == null || vector.size() <= 0) {
                this._resArray = null;
            } else {
                this._resArray = new ReservoirElement[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    this._resArray[i] = vector.get(i);
                }
            }
        } else {
            Object object = this._rule;
            if (object instanceof DownstreamOpRule) {
                DownstreamOpRule downstreamOpRule = (DownstreamOpRule)object;
                if ((object = downstreamOpRule.getReservoirs(null)) == null || object.size() <= 0) {
                    this._resArray = null;
                } else {
                    this._resArray = new ReservoirElement[object.size()];
                    for (int i = 0; i < object.size(); ++i) {
                        this._resArray[i] = object.get(i);
                    }
                }
            } else if (object instanceof SystemHydropowerRule) {
                SystemHydropowerRule systemHydropowerRule = (SystemHydropowerRule)object;
                if ((object = systemHydropowerRule.getReservoirs(null)) == null || object.size() <= 0) {
                    this._resArray = null;
                } else {
                    this._resArray = new ReservoirElement[object.size()];
                    for (int i = 0; i < object.size(); ++i) {
                        this._resArray[i] = object.get(i);
                    }
                }
            } else {
                this._resArray = null;
            }
        }
        if (this._rule != null) {
            this._elemGraph.a(this._resArray);
        }
    }

    protected G2dLineProperties getLineProperties(int n, int n2, int n3) {
        G2dLineProperties g2dLineProperties = new G2dLineProperties();
        int n4 = n % SYSPLOTCOLOR.length;
        g2dLineProperties._lineColor = SYSPLOTCOLOR[n4];
        switch (n2) {
            case 0: {
                g2dLineProperties._lineWidth = 2.0f;
                break;
            }
            case 1: {
                g2dLineProperties._lineWidth = 1.0f;
                break;
            }
            case 2: {
                g2dLineProperties._lineWidth = 1.5f;
                break;
            }
            default: {
                g2dLineProperties._lineWidth = 0.1f;
            }
        }
        switch (n3) {
            case 3: {
                break;
            }
            case 4: {
                g2dLineProperties._lineWidth = 1.5f;
                break;
            }
            case 5: {
                g2dLineProperties._lineWidth = 1.5f;
                g2dLineProperties._lineStylePattern = RmaDrawConst.DOT_STYLE_PATTERN;
                break;
            }
            case 6: {
                g2dLineProperties._lineStylePattern = RmaDrawConst.DASHDOT_STYLE_PATTERN;
                break;
            }
            case 7: {
                Color color = g2dLineProperties._lineColor;
                g2dLineProperties._lineColor = color.darker().darker();
                g2dLineProperties._drawPoints = true;
                g2dLineProperties._autoSkipPoints = true;
                g2dLineProperties._symbolType = SYSPLOTSYMBOL[n % SYSPLOTSYMBOL.length];
                g2dLineProperties._pointLineColor = g2dLineProperties._lineColor;
                g2dLineProperties._pointFillColor = g2dLineProperties._lineColor.brighter();
                g2dLineProperties._symbolSize = 5.0f;
                break;
            }
            case 8: {
                g2dLineProperties._drawPoints = true;
                g2dLineProperties._autoSkipPoints = true;
                g2dLineProperties._symbolType = SYSPLOTSYMBOL[n % SYSPLOTSYMBOL.length];
                g2dLineProperties._pointLineColor = g2dLineProperties._lineColor;
                g2dLineProperties._pointFillColor = g2dLineProperties._lineColor.brighter();
                g2dLineProperties._symbolSize = 5.0f;
                break;
            }
            case 9: {
                g2dLineProperties._lineColor = g2dLineProperties._lineColor.brighter();
                g2dLineProperties._fillType = 1;
                g2dLineProperties._fillColor = g2dLineProperties._lineColor;
                g2dLineProperties._fillPattern = 3;
                break;
            }
            case 10: {
                g2dLineProperties._lineColor = g2dLineProperties._lineColor.brighter();
                g2dLineProperties._fillType = 2;
                g2dLineProperties._fillColor = g2dLineProperties._lineColor;
                g2dLineProperties._fillPattern = 4;
            }
        }
        return g2dLineProperties;
    }

    public void zoomToAll() {
        this._g2dPanel.zoomToAll();
    }

    public G2dPanel getG2dPanel() {
        return this._g2dPanel;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof Axis && object == "NEW_ZOOM") {
            System.out.println("Got zoom msg");
        }
    }
}

