/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.gfx2d;

import hec.data.Parameter;
import hec.geometry.WorldPt;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.PairedDataContainer;
import hec.rss.gfx2d.SimpleJTableGlyph;
import rma.swing.RmaJTable;
import rma.swing.table.RmaTableModelInterface;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableData
extends hec.gfx2d.SimpleJTableData
implements G2dObject {
    public double[][] xdata;
    public double[][] ydata;
    int[] _rowData;
    public int _startRow = 0;
    int _xAxisType = 0;
    int _yAxisType = 0;
    String[] _curveNames = null;
    RmaJTable _table;
    int _xCol;
    int _yCol;
    private double undef = -3.4028234663852886E38;
    private HecTime htime = new HecTime();
    private String pdcYUnits;
    private String pdcXUnits;
    boolean _addToPairedDataRev = true;

    public SimpleJTableData() {
        this.name = "Simple Table Data";
        this.xunits = "xunits";
        this.yunits = "yunits";
        this.xdata = new double[1][100];
        this.ydata = new double[1][100];
        for (int i = 0; i < 100; ++i) {
            this.xdata[0][i] = Math.PI * (double)i / 20.0;
            this.ydata[0][i] = 5.0 * Math.sin(this.xdata[0][i]);
        }
    }

    public String getXAxisName() {
        return this.xunits;
    }

    public String getYAxisName() {
        return this.yunits;
    }

    public void setXAxisType(int n) {
        this._xAxisType = n;
    }

    public int getXAxisType() {
        return this._xAxisType;
    }

    public void setYAxisType(int n) {
        this._yAxisType = n;
    }

    public int getYAxisType() {
        return this._yAxisType;
    }

    public int getCurveCount() {
        if (this.xdata == null || this.ydata == null) {
            return 0;
        }
        return Math.max(this.xdata.length, this.ydata.length);
    }

    public String getCurveName(int n) {
        if (this._curveNames == null) {
            return null;
        }
        if (n < 0 || n >= this._curveNames.length) {
            return null;
        }
        return this._curveNames[n];
    }

    public void clearData() {
        this.xdata = null;
        this.ydata = null;
        this.setChanged();
        SimpleJTableData simpleJTableData = this;
        simpleJTableData.notifyObservers(simpleJTableData.getDataResetType());
    }

    public void setMultipleColumnData(RmaJTable rmaJTable, int[] nArray, int[] nArray2) {
        if (rmaJTable != null & nArray != null & nArray2 != null) {
            this.xdata = new double[nArray.length][0];
            this.ydata = new double[nArray2.length][0];
            int n = rmaJTable.getRowCount();
            int n2 = Math.max(nArray.length, nArray2.length);
            this._rowData = new int[n2];
            this._curveNames = new String[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = i < nArray.length ? i : -1;
                int n4 = i < nArray2.length ? i : -1;
                double d = 0.0;
                double d2 = 0.0;
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                int n5 = 0;
                for (int j = 0; j < n; ++j) {
                    if (n3 >= 0) {
                        d = this.parseValue(rmaJTable.getCell(j, nArray[n3]), this._xAxisType);
                    }
                    if (n4 >= 0) {
                        d2 = this.parseValue(rmaJTable.getCell(j, nArray2[n4]), this._yAxisType);
                    }
                    if (RMAConst.isValidValue((double)d)) {
                        dArray[j] = d;
                    }
                    if (RMAConst.isValidValue((double)d2)) {
                        dArray2[j] = d2;
                    }
                    if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) continue;
                    ++n5;
                }
                if (n3 >= 0) {
                    this.xdata[n3] = dArray;
                }
                if (n4 >= 0) {
                    this.ydata[n4] = dArray2;
                }
                this._rowData[i] = Math.max(n5, this._rowData[i]);
                Object object = rmaJTable.getModel();
                if (object instanceof RmaTableModelInterface) {
                    if (n3 >= 0 && (n5 = ((RmaTableModelInterface)object).getColumnParameter(nArray[n3])) != -1) {
                        super.setXParameterId(n5);
                    }
                    if (n4 >= 0 && (n5 = ((RmaTableModelInterface)object).getColumnParameter(nArray2[n4])) != -1) {
                        super.setYParameterId(n5);
                    }
                    this.setUnitSystem(((RmaTableModelInterface)object).getUnitSystem());
                }
                n5 = n3 == -1 ? nArray.length - 1 : n3;
                int n6 = n3 = n4 == -1 ? nArray2.length - 1 : n4;
                if (nArray[n5] >= object.getColumnCount() || nArray2[n3] >= object.getColumnCount()) continue;
                String string = object.getColumnName(nArray[n5]);
                object = object.getColumnName(nArray2[n3]);
                string = this.stripUnitsFromLabel(string);
                object = this.stripUnitsFromLabel((String)object);
                this.name = string + "-" + (String)object;
                this._curveNames[i] = string + "-" + (String)object;
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem((int)this.getXParameterId(), (int)this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem((int)this.getYParameterId(), (int)this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        SimpleJTableData simpleJTableData = this;
        simpleJTableData.notifyObservers(simpleJTableData.getDataResetType());
        this.clearChanged();
    }

    public void setData(RmaJTable object, int[] nArray, int[] nArray2) {
        if (object != null) {
            this.xdata = new double[1][object.getRowCount()];
            int n = this.fillData((RmaJTable)object, this.xdata[0], nArray2, this._xAxisType);
            int n2 = n < Integer.MAX_VALUE ? n : Integer.MAX_VALUE;
            this.ydata = new double[1][object.getRowCount()];
            n = this.fillData((RmaJTable)object, this.ydata[0], nArray2, this._yAxisType);
            n = n < Integer.MAX_VALUE ? n : Integer.MAX_VALUE;
            this._rowData = new int[1];
            this._rowData[0] = n < n2 ? n : n2;
            if ((object = object.getModel()) instanceof RmaTableModelInterface) {
                int n3 = ((RmaTableModelInterface)object).getColumnParameter(nArray[0]);
                if (n3 != -1) {
                    super.setXParameterId(n3);
                }
                if ((n3 = ((RmaTableModelInterface)object).getColumnParameter(nArray2[0])) != -1) {
                    super.setYParameterId(n3);
                }
                this.setUnitSystem(((RmaTableModelInterface)object).getUnitSystem());
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem((int)this.getXParameterId(), (int)this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem((int)this.getYParameterId(), (int)this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        SimpleJTableData simpleJTableData = this;
        simpleJTableData.notifyObservers(simpleJTableData.getDataResetType());
        this.clearChanged();
    }

    public void setData(RmaJTable object, int n, int n2) {
        if (object != null) {
            int n3;
            this._table = object;
            int n4 = object.getRowCount();
            this._xCol = n;
            this._yCol = n2;
            double[] dArray = new double[n4];
            double[] dArray2 = new double[n4];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                dArray[n3] = this.parseValue(object.getCell(n3, n), this._xAxisType);
                dArray2[n3] = this.parseValue(object.getCell(n3, n2), this._yAxisType);
                if (!RMAConst.isValidValue((double)dArray[n3]) || !RMAConst.isValidValue((double)dArray2[n3])) continue;
                ++n5;
            }
            this.xdata = new double[1][n5];
            this.ydata = new double[1][n5];
            n5 = 0;
            this._rowData = new int[1];
            this._curveNames = new String[1];
            for (n3 = 0; n3 < n4; ++n3) {
                if (!RMAConst.isValidValue((double)dArray[n3]) || !RMAConst.isValidValue((double)dArray2[n3])) continue;
                this.xdata[0][n5] = dArray[n3];
                this.ydata[0][n5] = dArray2[n3];
                ++n5;
            }
            this._rowData[0] = n5;
            if ((object = object.getModel()) instanceof RmaTableModelInterface) {
                n4 = ((RmaTableModelInterface)object).getColumnParameter(n);
                if (n4 != -1) {
                    super.setXParameterId(n4);
                }
                if ((n4 = ((RmaTableModelInterface)object).getColumnParameter(n2)) != -1) {
                    super.setYParameterId(n4);
                }
                this.setUnitSystem(((RmaTableModelInterface)object).getUnitSystem());
            }
            if (n < object.getColumnCount() && n2 < object.getColumnCount()) {
                String string = object.getColumnName(n);
                object = object.getColumnName(n2);
                string = this.stripUnitsFromLabel(string);
                object = this.stripUnitsFromLabel((String)object);
                this.name = string + "-" + (String)object;
                this._curveNames[0] = this.name;
            }
        } else {
            this.xdata = null;
            this.ydata = null;
        }
        this.pdcYUnits = this.yunits;
        this.pdcXUnits = this.xunits;
        if (this.getUnitSystem() != 0) {
            if (this.getXParameterId() != -1) {
                this.pdcXUnits = Parameter.getUnitsStringForSystem((int)this.getXParameterId(), (int)this.getUnitSystem());
            }
            if (this.getYParameterId() != -1) {
                this.pdcYUnits = Parameter.getUnitsStringForSystem((int)this.getYParameterId(), (int)this.getUnitSystem());
            }
        }
        this.bounds = null;
        this.setChanged();
        SimpleJTableData simpleJTableData = this;
        simpleJTableData.notifyObservers(simpleJTableData.getDataResetType());
        this.clearChanged();
    }

    protected double parseValue(Object object, int n) {
        double d;
        block9: {
            d = this.undef;
            try {
                if (object.toString().trim().isEmpty()) break block9;
                if (n == 1 || n == 2) {
                    try {
                        if (object instanceof HecTimeArray) {
                            this.htime = new HecTime(((HecTimeArray)object).element(0));
                        } else {
                            n = RMAIO.parseInt((String)object.toString());
                            if (n == Integer.MIN_VALUE) {
                                this.htime.set(object.toString());
                            } else {
                                this.htime.set(n);
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.htime.set(object.toString());
                    }
                    d = this.htime.value();
                    break block9;
                }
                d = n == 3 ? RMAIO.parseDouble((Object)object) : RMAIO.parseDouble((Object)object);
            }
            catch (Exception exception) {}
        }
        return d;
    }

    public void setXDataElement(int n, double d) {
        if (this.xdata.length == 0 || n >= this.xdata[0].length) {
            return;
        }
        this.xdata[0][n] = d;
    }

    public void setYDataElement(int n, double d) {
        if (this.ydata.length == 0 || n >= this.ydata[0].length) {
            return;
        }
        this.ydata[0][n] = d;
    }

    public void setStartRow(int n) {
        this._startRow = n;
    }

    public int getStartRow() {
        return this._startRow;
    }

    int fillData(RmaJTable rmaJTable, double[] dArray, int[] nArray, int n) {
        int n2 = 0;
        HecTime hecTime = null;
        if (n == 1 || n == 2) {
            hecTime = new HecTime();
        }
        for (int i = this._startRow; i < rmaJTable.getRowCount(); ++i) {
            try {
                Object object = rmaJTable.getCell(i, nArray[0]);
                for (int j = 1; j < nArray.length; ++j) {
                    object = object.toString() + " " + rmaJTable.getCell(i, nArray[j]).toString();
                }
                if (object.toString().trim().isEmpty()) continue;
                if (n == 1 || n == 2) {
                    try {
                        int n3 = RMAIO.parseInt((String)object.toString());
                        if (n3 == Integer.MIN_VALUE) {
                            hecTime.set(object.toString());
                        } else {
                            hecTime.set(n3);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        hecTime.set(object.toString());
                    }
                    dArray[n2++] = hecTime.value();
                    continue;
                }
                double d = RMAIO.parseDouble((Object)object);
                dArray[n2++] = d;
                continue;
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    public void load() {
    }

    public void unload() {
    }

    public WorldRect getBounds() {
        if (this.xdata == null || this.ydata == null) {
            return null;
        }
        if (this._rowData == null) {
            return null;
        }
        if (this.bounds == null) {
            if (this._rowData.length <= 0) {
                return null;
            }
            if (this.ydata.length == 0 || this.ydata[0].length == 0) {
                return null;
            }
            if (this.xdata.length == 0 || this.xdata[0].length == 0) {
                return null;
            }
            this.bounds = this.ydata[0][0] < 0.0 || this.xdata[0][0] < 0.0 ? new WorldRect(this.xdata[0][0], this.ydata[0][0], 0.0, 0.0) : new WorldRect(this.xdata[0][0], this.ydata[0][0], this.xdata[0][0], this.ydata[0][0]);
            int n = this.getMaxRow();
            for (int i = 1; i < n; ++i) {
                int n2;
                for (n2 = 0; n2 < this.xdata.length; ++n2) {
                    if (!RMAConst.isValidValue((double)this.xdata[n2][i])) continue;
                    if (this.bounds.w > this.xdata[n2][i]) {
                        this.bounds.w = this.xdata[n2][i];
                        continue;
                    }
                    if (!(this.bounds.e < this.xdata[n2][i])) continue;
                    this.bounds.e = this.xdata[n2][i];
                }
                for (n2 = 0; n2 < this.ydata.length; ++n2) {
                    if (!RMAConst.isValidValue((double)this.ydata[n2][i])) continue;
                    if (this.bounds.s > this.ydata[n2][i]) {
                        this.bounds.s = this.ydata[n2][i];
                        continue;
                    }
                    if (!(this.bounds.n < this.ydata[n2][i])) continue;
                    this.bounds.n = this.ydata[n2][i];
                }
            }
        }
        return this.bounds;
    }

    private int getMaxRow() {
        int n = 0;
        for (int i = 0; i < this._rowData.length; ++i) {
            n = Math.max(n, this._rowData[i]);
        }
        return n;
    }

    public void setCurveNames(String[] stringArray) {
        for (int i = 0; i < this._curveNames.length; ++i) {
            if (i >= stringArray.length) continue;
            this._curveNames[i] = stringArray[i];
        }
    }

    public PairedDataContainer getPairedDataContainer() {
        int n;
        String string;
        String string2;
        double[] dArray;
        double[][] dArray2;
        if (this._addToPairedDataRev) {
            dArray2 = this.xdata;
            dArray = this.ydata[0];
            string2 = this.pdcXUnits;
            string = this.pdcYUnits;
        } else {
            dArray2 = this.ydata;
            dArray = this.xdata[0];
            string2 = this.pdcYUnits;
            string = this.pdcXUnits;
        }
        PairedDataContainer pairedDataContainer = new PairedDataContainer();
        new PairedDataContainer().numberOrdinates = this.getMaxRow();
        pairedDataContainer.numberCurves = this.getCurveCount();
        pairedDataContainer.xOrdinates = new double[pairedDataContainer.numberOrdinates];
        pairedDataContainer.yOrdinates = new double[pairedDataContainer.numberCurves][pairedDataContainer.numberOrdinates];
        for (n = 0; n < pairedDataContainer.numberOrdinates; ++n) {
            if (n >= dArray.length) continue;
            pairedDataContainer.xOrdinates[n] = dArray[n];
        }
        for (n = 0; n < dArray2.length; ++n) {
            for (int i = 0; i < pairedDataContainer.numberOrdinates; ++i) {
                if (i >= dArray2[n].length) continue;
                pairedDataContainer.yOrdinates[n][i] = dArray2[n][i];
            }
        }
        pairedDataContainer.labelsUsed = true;
        pairedDataContainer.labels = new String[pairedDataContainer.numberCurves];
        for (n = 0; n < pairedDataContainer.labels.length; ++n) {
            pairedDataContainer.labels[n] = this.getCurveName(n);
        }
        pairedDataContainer.xunits = string;
        pairedDataContainer.yunits = string2;
        pairedDataContainer.xtype = "UNT";
        pairedDataContainer.ytype = "UNT";
        pairedDataContainer.xprecision = -1;
        pairedDataContainer.yprecision = -1;
        return pairedDataContainer;
    }

    public void addToPairedDataContainerReveresed(boolean bl) {
        this._addToPairedDataRev = bl;
    }

    public int addToPairedDataContainer(PairedDataContainer pairedDataContainer) {
        int n;
        double[] dArray;
        double[][] dArray2;
        if (!pairedDataContainer.xunits.equals(this.pdcYUnits)) {
            return -1;
        }
        if (this._addToPairedDataRev) {
            dArray2 = this.xdata;
            dArray = this.ydata[0];
        } else {
            dArray2 = this.ydata;
            dArray = this.xdata[0];
        }
        Object object = new HecDoubleArray(dArray);
        HecDoubleArray hecDoubleArray = new HecDoubleArray(pairedDataContainer.xOrdinates);
        object = hecDoubleArray.merge(object);
        int n2 = object.numberElements();
        double[][] dArray3 = new double[pairedDataContainer.numberCurves + dArray2.length][n2];
        object = object.getDoubleArray();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < dArray2.length; ++i) {
            for (n = 0; n < n2; ++n) {
                if (object[n] == pairedDataContainer.xOrdinates[n3]) {
                    for (int j = 0; j < pairedDataContainer.numberCurves; ++j) {
                        dArray3[j][n] = pairedDataContainer.yOrdinates[j][n3];
                    }
                    ++n3;
                }
                if (object[n] != dArray[n4]) continue;
                dArray3[pairedDataContainer.numberCurves + i][n] = dArray2[i][n4];
                ++n4;
            }
        }
        pairedDataContainer.xOrdinates = (double[])object;
        pairedDataContainer.yOrdinates = dArray3;
        String[] stringArray = new String[pairedDataContainer.numberCurves + 1];
        for (n = 0; n < pairedDataContainer.numberCurves; ++n) {
            stringArray[n] = pairedDataContainer.labels[n];
        }
        stringArray[pairedDataContainer.numberCurves] = this.name;
        pairedDataContainer.labels = stringArray;
        ++pairedDataContainer.numberCurves;
        return 0;
    }

    public WorldPt getNearestDataPt(WorldPt worldPt) {
        if (this.getMaxRow() == 0) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        WorldPt worldPt2 = null;
        int n = this.getMaxRow();
        for (int i = 0; i < this.xdata.length; ++i) {
            for (int j = 0; j < this.ydata.length; ++j) {
                for (int k = 0; k < n; ++k) {
                    double d2;
                    if (worldPt2 == null) {
                        worldPt2 = new WorldPt(this.xdata[i][0], this.ydata[j][0]);
                    }
                    double d3 = this.xdata[i][k];
                    double d4 = this.ydata[j][k];
                    double d5 = worldPt.e - d3;
                    double d6 = worldPt.n - d4;
                    if (d5 == 0.0 && d6 == 0.0) {
                        return worldPt;
                    }
                    double d7 = d5;
                    double d8 = d6;
                    double d9 = Math.sqrt(d7 * d7 + d8 * d8);
                    if (!(d2 < d)) continue;
                    d = d9;
                    worldPt2.init(d3, d4);
                }
            }
        }
        return worldPt2;
    }

    RmaJTable getRmaJTable() {
        return this._table;
    }

    static {
        G2dGlyphFactory.addMapping(SimpleJTableData.class, SimpleJTableGlyph.class);
    }
}

