/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.gfx2d;

import hec.data.DataSetException;
import hec.data.Units;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.geometry.WorldPt;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import hec.rss.gfx2d.SimpleJTableData;
import hec.rss.gfx2d.SimpleJTableGlyph$1;
import hec.rss.gfx2d.SimpleJTableGlyph$PropertiesOKListener;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class SimpleJTableGlyph
extends G2dGlyph
implements TableChangeListener {
    SimpleJTableData _obj;
    double[] xarray = new double[10000];
    double[] yarray = new double[10000];
    protected boolean _firstDraw = true;

    public SimpleJTableGlyph(Viewport viewport, SimpleJTableData simpleJTableData, Scale scale) {
        super(viewport, (G2dObject)simpleJTableData, scale);
        this._obj = simpleJTableData;
    }

    protected void buildLineArray() {
        super.buildLineArray();
        for (int i = 0; this._g2dObject != null && i < this._g2dObject.getCurveCount(); ++i) {
            this._lineArray[i].setName(((SimpleJTableData)this._g2dObject).getCurveName(i));
            this._lineArray[i].setLineLabel(this._lineArray[i].getName());
        }
    }

    protected List getOKListeners() {
        List list = super.getOKListeners();
        list.add(new SimpleJTableGlyph$PropertiesOKListener(this));
        return list;
    }

    public void draw(Graphics graphics) {
        int n;
        if (this._lineArray == null || this._lineArray.length != this._obj.getCurveCount()) {
            this.buildLineArray();
        }
        if (this._obj.xdata == null || this._obj.ydata == null) {
            return;
        }
        if (this._obj._rowData == null) {
            return;
        }
        if (this._firstDraw && this._obj._table != null) {
            this._obj._table.addTableChangeListener((TableChangeListener)this);
            this._firstDraw = false;
        }
        Rectangle rectangle = this.getVisibleRect();
        for (n = 0; n < this._lineArray.length; ++n) {
            this._lineArray[n].clearLineData();
        }
        for (int i = 0; i < this._obj.getCurveCount(); ++i) {
            int n2 = i < this._obj.xdata.length ? i : this._obj.xdata.length - 1;
            int n3 = i < this._obj.ydata.length ? i : this._obj.ydata.length - 1;
            int n4 = 0;
            for (n = 0; n < this._obj._rowData[i]; ++n) {
                double d = this._obj.xdata[n2][n];
                double d2 = this._obj.ydata[n3][n];
                if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) {
                    if (n4 > 0) {
                        this._lineArray[i].addLineData(this.xarray, this.yarray, n4);
                        n4 = 0;
                    }
                } else {
                    this.xarray[n4] = d;
                    this.yarray[n4] = d2;
                    ++n4;
                }
                if (n4 < 10000) continue;
                this._lineArray[i].addLineData(this.xarray, this.yarray, n4);
                n4 = 0;
            }
            if (n4 <= 0) continue;
            this._lineArray[i].addLineData(this.xarray, this.yarray, n4);
        }
        for (n = 0; n < this._obj.getCurveCount(); ++n) {
            this._lineArray[n].drawLine(graphics, rectangle);
        }
    }

    public String getToolTipText(MouseEvent object) {
        if (object == null) {
            return null;
        }
        if (this._line.contains((LocalPt)(object = new LocalPt(((MouseEvent)object).getX(), ((MouseEvent)object).getY()))) && (object = this._line.getNearestDataPt((LocalPt)object)) != null) {
            double d = this._scale.x2e(((LocalPt)object).x);
            double d2 = this._scale.y2n(((LocalPt)object).y);
            object = new WorldPt(d, d2);
            if ((object = this._obj.getNearestDataPt((WorldPt)object)) == null) {
                return null;
            }
            try {
                if (this._obj.getYParameterId() != -1 && this._obj.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0) {
                    d2 = Units.convertUnits((double)((WorldPt)object).n, (int)this._obj.getYParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem());
                    if (this._obj.getXAxisType() != 1 && this._obj.getXParameterId() != -1) {
                        d = Units.convertUnits((double)((WorldPt)object).e, (int)this._obj.getXParameterId(), (int)this._obj.getUnitSystem(), (int)this._scale.getDisplayUnitSystem());
                    }
                } else {
                    d2 = ((WorldPt)object).n;
                    d = ((WorldPt)object).e;
                }
            }
            catch (DataSetException dataSetException) {}
            if (this._obj.getXAxisType() != 1) {
                return new String("[" + RMAIO.setPrecision2((double)d, (int)2) + "," + Double.toString(d2) + "]");
            }
            HecTime hecTime = new HecTime();
            hecTime.setMinutes(((WorldPt)object).e);
            this._scale.convertDataTime(hecTime);
            object = RMAIO.setPrecision2((double)d2, (int)2);
            return new String("[" + hecTime.dateAndTime() + " ," + (String)object + "]");
        }
        return null;
    }

    public void tableDataChanged(TableUpdateEvent tableUpdateEvent) {
        if (this._obj._table != null) {
            SwingUtilities.invokeLater(new SimpleJTableGlyph$1(this));
        }
    }

    static /* synthetic */ Viewport access$000(SimpleJTableGlyph simpleJTableGlyph) {
        return simpleJTableGlyph._viewport;
    }

    static /* synthetic */ Viewport access$100(SimpleJTableGlyph simpleJTableGlyph) {
        return simpleJTableGlyph._viewport;
    }

    static /* synthetic */ Viewport access$200(SimpleJTableGlyph simpleJTableGlyph) {
        return simpleJTableGlyph._viewport;
    }
}

