/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.map;

import hec.clientapp.client.ClientApp;
import hec.map.LocalPt;
import hec.map.MapCanvas;
import hec.map.MapPanel;
import hec.map.MapScale;
import hec.map.PointerMouseAdapter;
import hec.map.WorldPt;
import hec.rss.map.ResSimPointerMouseAdapter$ZoomSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import rma.swing.RmaJObjectMenuItem;

public class ResSimPointerMouseAdapter
extends PointerMouseAdapter
implements ActionListener {
    private boolean _panning;
    private LocalPt _oldPoint = new LocalPt();
    private LocalPt _newPoint = new LocalPt();
    private WorldPt _newWorldPoint = new WorldPt();
    private WorldPt _oldWorldPoint = new WorldPt();
    private WorldPt _newOrigin = new WorldPt();
    private List<ResSimPointerMouseAdapter$ZoomSettings> _zoomSettings = new ArrayList<ResSimPointerMouseAdapter$ZoomSettings>();

    public ResSimPointerMouseAdapter(MapPanel mapPanel, MapCanvas mapCanvas) {
        super(mapPanel, mapCanvas);
    }

    protected void handleEmptyRightClick(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Map Window Properties...");
        jMenuItem.setActionCommand("windowProperties");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Zoom to All");
        jMenuItem.setActionCommand("zoomToAll");
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenu("Zoom to");
        jPopupMenu.add(jMenuItem);
        for (int i = 0; i < this._zoomSettings.size(); ++i) {
            ResSimPointerMouseAdapter$ZoomSettings resSimPointerMouseAdapter$ZoomSettings = this._zoomSettings.get(i);
            resSimPointerMouseAdapter$ZoomSettings = new RmaJObjectMenuItem(resSimPointerMouseAdapter$ZoomSettings.a, (Object)resSimPointerMouseAdapter$ZoomSettings);
            resSimPointerMouseAdapter$ZoomSettings.setActionCommand("zoomToSetting");
            resSimPointerMouseAdapter$ZoomSettings.addActionListener(this);
            ((JMenu)jMenuItem).add((JMenuItem)((Object)resSimPointerMouseAdapter$ZoomSettings));
        }
        if (this._zoomSettings.size() > 0) {
            ((JMenu)jMenuItem).addSeparator();
        }
        JMenuItem jMenuItem2 = new JMenuItem("Save Zoom Settings");
        jMenuItem2.setActionCommand("saveZoomSettings");
        jMenuItem2.addActionListener(this);
        ((JMenu)jMenuItem).add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.show((Component)this._mapCanvas, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem) {
            if ("windowProperties".equals(((AbstractButton)(object = (JMenuItem)object)).getActionCommand())) {
                ClientApp.frame().menuItemGeoDialog_Action(null);
                return;
            }
            if ("zoomToAll".equalsIgnoreCase(((AbstractButton)object).getActionCommand())) {
                this._mapPanel.showAll();
                return;
            }
            if ("saveZoomSettings".equalsIgnoreCase(((AbstractButton)object).getActionCommand())) {
                this.saveZoomSettings();
                return;
            }
            if ("zoomToSetting".equalsIgnoreCase(((AbstractButton)object).getActionCommand())) {
                object = (RmaJObjectMenuItem)object;
                object = (ResSimPointerMouseAdapter$ZoomSettings)object.getObject();
                ((ResSimPointerMouseAdapter$ZoomSettings)object).a();
            }
        }
    }

    private void saveZoomSettings() {
        Object object = JOptionPane.showInputDialog((Component)this._mapPanel, (Object)"Enter Name for View:");
        if (object == null || ((String)object).isEmpty()) {
            return;
        }
        MapScale mapScale = this._mapPanel.scale();
        WorldPt worldPt = mapScale.getOrigin();
        double d = mapScale.getZoom();
        object = new ResSimPointerMouseAdapter$ZoomSettings(this, (String)object, d, worldPt);
        this._zoomSettings.add((ResSimPointerMouseAdapter$ZoomSettings)object);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this._mapCanvas != null && this._mapPanel != null) {
            this._mapCanvas.setCursor(this.getCursor());
            this._oldPoint.x = mouseEvent.getX();
            this._oldPoint.y = mouseEvent.getY();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._mapCanvas != null && this._mapPanel != null && this._panning) {
            this._mapCanvas.setCursor(this.getCursor());
            this._mapPanel.resetScrollbars();
            this._mapPanel.paintMap();
            this._panning = false;
            return;
        }
        this._panning = false;
        super.mouseReleased(mouseEvent);
    }

    protected void objectSelect(List list, LocalPt localPt, int n) {
        if (this._panning) {
            return;
        }
        super.objectSelect(list, localPt, n);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this._panning = true;
        if (this._mapCanvas != null && this._mapPanel != null && this._panning) {
            this._newPoint.x = mouseEvent.getX();
            this._newPoint.y = mouseEvent.getY();
            if (!this._mapCanvas.contains(this._newPoint.x, this._newPoint.y)) {
                return;
            }
            mouseEvent = this._mapPanel.scale();
            WorldPt worldPt = mouseEvent.getOrigin();
            mouseEvent.lp2wp(this._newPoint, this._newWorldPoint);
            mouseEvent.lp2wp(this._oldPoint, this._oldWorldPoint);
            this._newOrigin.e = worldPt.e - (this._newWorldPoint.e - this._oldWorldPoint.e);
            this._newOrigin.n = worldPt.n - (this._newWorldPoint.n - this._oldWorldPoint.n);
            this._mapPanel.setOrigin(this._newOrigin, false);
            this._oldPoint.x = this._newPoint.x;
            this._oldPoint.y = this._newPoint.y;
        }
    }

    static /* synthetic */ MapPanel access$000(ResSimPointerMouseAdapter resSimPointerMouseAdapter) {
        return resSimPointerMouseAdapter._mapPanel;
    }

    static /* synthetic */ MapPanel access$100(ResSimPointerMouseAdapter resSimPointerMouseAdapter) {
        return resSimPointerMouseAdapter._mapPanel;
    }

    static /* synthetic */ MapPanel access$200(ResSimPointerMouseAdapter resSimPointerMouseAdapter) {
        return resSimPointerMouseAdapter._mapPanel;
    }
}

