/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.model.PairedValues;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ControlStructure;
import hec.rss.model.Controller;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.HindcastData;
import hec.rss.model.Junction;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.RssNode;
import hec.rss.model.RssReturnStatusConstants;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import rma.util.RMAConst;

public class AdjustableDiversion
extends ControlStructure {
    public static final int KNOWN_RELEASE_CONST = 0;
    public static final int KNOWN_RELEASE_TS = 1;
    public static final int FIRST_HINDCAST_COND = 0;
    public static final int LAST_HINDCAST_COND = 1;
    AdjustableParameter _flowParam;
    int _hindcastCondition = 0;
    double _initialRelease = 0.0;
    PairedValues _capacityValues = new PairedValues();
    Controller _controller;
    private transient Vector a;
    private transient Vector b;
    private transient doubleArrayContainer c;
    private transient doubleArrayContainer d;
    private transient doubleArrayContainer e;
    private transient Hashtable f = null;

    public AdjustableDiversion() {
    }

    public AdjustableDiversion(Element element) {
        super(element);
        this.getController();
    }

    public AdjustableParameter getFlowParam() {
        return this._flowParam;
    }

    @Override
    public boolean isNodeComputed(int n, RssNode rssNode, Integer n2) {
        return true;
    }

    @Override
    public int initForecastOperations(RunTimeWindow runTimeWindow) {
        if (this.d == null || this.e == null) {
            return 1;
        }
        int n = runTimeWindow.getNumLookbackSteps();
        int n2 = runTimeWindow.getNumSteps();
        for (int i = n; i <= n2; ++i) {
            this.e.array[i] = this.d.array[n];
        }
        return 0;
    }

    @Override
    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        if (hindcastData.getVariableId() == 43) {
            if (hindcastData.getType() == 1) {
                this._hindcastCondition = 0;
                this._initialRelease = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this._hindcastCondition = 1;
            }
        }
    }

    @Override
    public void getHindcastDataList(Vector vector) {
        if (vector == null) {
            return;
        }
        Object object = this.element.getSystem().getKeyStringForObject(this);
        object = new HindcastData((String)object, 43, 1);
        vector.add(object);
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector();
        }
        if (n == 1 && this._hindcastCondition == 1) {
            vector.add(this.getTSRecordProxy(43));
        }
        if (n == 0 && this._flowParam != null) {
            vector.add(this.getTSRecordProxy(47));
        }
        if (this._controller != null) {
            vector = this._controller.getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this.element == null) {
            return;
        }
        RssNode rssNode = this.element.getNode(0);
        if (rssNode != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if ((rssNode = this.element.getNode(1)) != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if (this.getTSRecordProxy(43) == null) {
            this.addTSRecordProxy(43);
        }
        if (this._flowParam != null && this.getTSRecordProxy(47) == null) {
            this.addTSRecordProxy(47);
        }
        if (this._controller != null) {
            this._controller.updateTSProxyList();
        }
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        if (this._capacityValues == null) {
            return;
        }
        Object object = new DSSPathname();
        object.setAPart(this.getElement().getSystem().getName());
        object.setBPart(this.getOutputBPart());
        Object object2 = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
        object.setCPart((String)object2);
        object2 = this.getElement().getSystem().getDssPairedDataFilePath();
        object = object.getPathname();
        this._capacityValues.setDssIdentifer(new DSSIdentifier((String)object2, (String)object));
        this._capacityValues.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityValues.setParamYId(Parameter.PARAMID_FLOW);
        this._capacityValues.setUnitSystem(this.getUnitSystem());
    }

    @Override
    public boolean initialize() {
        this.c = null;
        this.d = null;
        this.e = null;
        super.initialize();
        if (this.getController() == null) {
            return false;
        }
        RssReturnStatusConstants rssReturnStatusConstants = this.element.getNode(1);
        Object object = this.element.getNode(0);
        if (object == null || rssReturnStatusConstants == null) {
            this.element.getSystem().printErrorMessage("AdjustableDiversion:initialize - error in node connectivity");
            return false;
        }
        this.c = rssReturnStatusConstants.getTSContainer(0);
        this.d = object.getTSContainer(0);
        if (this.d == null || this.c == null) {
            this.element.getSystem().printErrorMessage("AdjustableDiversion:initialize - error finding time series");
            return false;
        }
        this._flowParam = super.getAdjustableParameter();
        if (this._flowParam != null) {
            if (this._flowParam.getMaxValue() <= 0.0) {
                this._flowParam.setMaxValue(Double.MAX_VALUE);
            }
            if (this._flowParam.getMinValue() >= 0.0) {
                this._flowParam.setMinValue(-1.7976931348623157E308);
            }
            this._flowParam.setMaxRateOfIncrease(Double.NEGATIVE_INFINITY);
            this._flowParam.setMaxRateOfDecrease(Double.NEGATIVE_INFINITY);
            this.e = this.getTSContainer(47);
            if (this.e == null) {
                this.printErrorMessage("initialize", "failed to load flow setting time-series");
                return false;
            }
            this._flowParam.setValueTSContainer(this.e);
        }
        this.a = new Vector();
        this.b = new Vector();
        rssReturnStatusConstants = (DiversionElement)this.element.getParent();
        if ((rssReturnStatusConstants = ((DiversionElement)rssReturnStatusConstants).getSourceElement()) != null) {
            object = ((Element)rssReturnStatusConstants).getNodeVector();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Element element;
                int n;
                RssNode rssNode = (RssNode)((Vector)object).elementAt(i);
                if (rssNode == null || (n = ((Element)rssReturnStatusConstants).getNodeDir(i)) == 0 || (element = rssNode.getUpstreamElement()) != null && element.getFunction() instanceof AdjustableDiversion && element.getParent() != null && element.getParent().getIndex() >= this.element.getParent().getIndex()) continue;
                element = rssNode.getTSContainer(0);
                if (element == null) {
                    element = rssNode.getTSContainer(4);
                }
                if (element == null) continue;
                this.a.addElement(element);
                double d = rssNode.getTSFactor(0);
                this.b.addElement(d);
            }
        }
        this.f = null;
        object = ((RssTSLocationObject)this).getSystem().getRssRun().getDiversionOverrides();
        if (object != null) {
            String string = ((RssTSLocationObject)this).getSystem().getKeyStringForObject(this.getElement().getDownstreamNode());
            this.f = ((ReleaseOverrides)object).getReleaseValues(string);
        }
        return true;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new Controller(this);
            if (this._flowParam == null) {
                this._flowParam = new AdjustableParameter(this);
                this._flowParam.setName("Flow");
                this._flowParam.setMaxValue(Double.MAX_VALUE);
                this._flowParam.setMinValue(-1.7976931348623157E308);
                this._flowParam.setMaxRateOfIncrease(Double.MAX_VALUE);
                this._flowParam.setMaxRateOfDecrease(Double.MAX_VALUE);
            }
        }
        this._flowParam.setController(this._controller);
        return this._controller;
    }

    @Override
    public synchronized Object clone() {
        AdjustableDiversion adjustableDiversion = (AdjustableDiversion)super.clone();
        if (this._controller != null) {
            adjustableDiversion._controller = (Controller)((Object)this._controller.clone());
            adjustableDiversion._controller.setDiversionFunction(adjustableDiversion);
        }
        if (this._flowParam != null) {
            adjustableDiversion._flowParam = (AdjustableParameter)this._flowParam.clone();
            adjustableDiversion._flowParam.setFunction(adjustableDiversion);
            adjustableDiversion._flowParam.setController(null);
        }
        if (this._capacityValues != null) {
            adjustableDiversion._capacityValues = (PairedValues)this._capacityValues.clone();
        }
        return adjustableDiversion;
    }

    public double getInitialRelease() {
        return this._initialRelease;
    }

    public void setInitialRelease(double d) {
        this._initialRelease = d;
    }

    public int getHindcastCondition() {
        return this._hindcastCondition;
    }

    public boolean setHindcastCondition(int n) {
        if (n < 0 || n > 1) {
            return false;
        }
        this._hindcastCondition = n;
        return true;
    }

    @Override
    public AdjustableParameter findAdjParam(String string) {
        if (string.compareTo("Flow") == 0) {
            return this._flowParam;
        }
        return null;
    }

    public PairedValues getCapacityValues() {
        return this._capacityValues;
    }

    public void setCapacityValues(PairedValues pairedValues) {
        this._capacityValues = pairedValues;
    }

    public double getAvailableFlow(RunTimeStep runTimeStep) {
        RssReturnStatusConstants rssReturnStatusConstants = this.element.getNode(1);
        double d = 0.0;
        if ((rssReturnStatusConstants = ((RssNode)rssReturnStatusConstants).getDownstreamElement()) != null) {
            if ((rssReturnStatusConstants = ((Element)rssReturnStatusConstants).getFunction()) instanceof Junction) {
                d = 0.0;
                for (int i = 0; i < this.a.size(); ++i) {
                    doubleArrayContainer doubleArrayContainer2 = (doubleArrayContainer)this.a.elementAt(i);
                    if (doubleArrayContainer2 == null || doubleArrayContainer2.array[runTimeStep.step] == -3.4028234663852886E38) continue;
                    d += doubleArrayContainer2.array[runTimeStep.step] * (Double)this.b.elementAt(i);
                }
            } else if (rssReturnStatusConstants instanceof Storage) {
                double d2 = ((Storage)rssReturnStatusConstants).getStorage(runTimeStep);
                d = d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q;
            }
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        double[] dArray;
        block8: {
            if (this.c == null || this.d == null) {
                this.element.getSystem().printErrorMessage("AdjustableDiversion:getForecastEquation - error in node connectivity");
                return 1;
            }
            double[] dArray2 = this.c.array;
            dArray = this.d.array;
            if (this.d.array == null || dArray2 == null) {
                this.element.getSystem().printErrorMessage("AdjustableDiversion:getForecastEquation - error finding time series");
                return 1;
            }
            if (runTimeStep.flag == 4 || runTimeStep.flag == 2 || runTimeStep.flag == 3) {
                dArray2[runTimeStep.step] = 0.0;
                dArray[runTimeStep.step] = 0.0;
                this._flowParam.setValue(dArray[runTimeStep.step]);
                return 0;
            }
            int n = this.getHindcastCondition();
            if (n == 1) {
                double[] dArray3 = this.getTSArray(43);
                if (dArray3 != null && RMAConst.isValidValue((double)dArray3[runTimeStep.step])) {
                    dArray[runTimeStep.step] = dArray3[runTimeStep.step];
                    break block8;
                } else {
                    this.element.getSystem().printErrorMessage("AdjustableDiversion.getHindcastEquation: known release TS empty or invalid");
                    this.element.getSystem().printErrorMessage("Date and Time: " + runTimeStep.dateTimeString());
                    return 1;
                }
            }
            if (n != 0) {
                this.element.getSystem().printErrorMessage("AdjustableDiversion.getHindcastEquation: unknown hindcast equation " + n);
                return 1;
            }
            dArray[runTimeStep.step] = this.getInitialRelease();
        }
        double d = this.getAvailableFlow(runTimeStep);
        if (dArray[runTimeStep.step] > d) {
            dArray[runTimeStep.step] = d;
        }
        dArray2[runTimeStep.step] = -dArray[runTimeStep.step];
        this._flowParam.setValue(dArray[runTimeStep.step]);
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep object) {
        RssReturnStatusConstants rssReturnStatusConstants = this.element.getNode(1);
        if (this.c == null || this.d == null) {
            this.element.getSystem().printMessage("AdjustableDiversion:getForecastEquation - error in node connectivity");
            return 1;
        }
        double[] dArray = this.c.array;
        double[] dArray2 = this.d.array;
        if (this.d.array == null || dArray == null) {
            this.element.getSystem().printMessage("AdjustableDiversion:getForecastEquation - error finding time series");
            return 1;
        }
        if (((RunTimeStep)object).flag == 4 || ((RunTimeStep)object).flag == 2 || ((RunTimeStep)object).flag == 3) {
            dArray[((RunTimeStep)object).step] = 0.0;
            dArray2[((RunTimeStep)object).step] = 0.0;
            this._flowParam.setValue(dArray2[((RunTimeStep)object).step]);
            return 0;
        }
        this._flowParam.setMaxValue(this.getAvailableFlow((RunTimeStep)object));
        double d = this._flowParam.getValue((RunTimeStep)object);
        double d2 = this.getOverrideVal((RunTimeStep)object);
        if (d2 != Double.NEGATIVE_INFINITY) {
            d = d2;
        }
        dArray2[((RunTimeStep)object).step] = d;
        dArray[((RunTimeStep)object).step] = -dArray2[((RunTimeStep)object).step];
        if (!RMAConst.isValidValue((double)d)) {
            return 1;
        }
        object = rssReturnStatusConstants.getDownstreamElement();
        rssReturnStatusConstants = null;
        if (object != null) {
            rssReturnStatusConstants = ((Element)object).getFunction();
        }
        if (rssReturnStatusConstants instanceof Junction) {
            object = (Junction)rssReturnStatusConstants;
            double d3 = ((Junction)object).getAvailableFlow();
            ((Junction)object).setAvailableFlow(d3 - d);
        }
        return 0;
    }

    public double getOverrideVal(RunTimeStep object) {
        double d = Double.NEGATIVE_INFINITY;
        if (this.f != null && (object = (Double)this.f.get(new Integer(object.valueMinutes()))) != null && (Double)object != Double.NEGATIVE_INFINITY) {
            d = (Double)object;
            d = Math.max(0.0, Math.min(this._flowParam.getMaxValue(), d));
        }
        return d;
    }

    @Override
    public Vector getComputedTSRecordProxies() {
        Vector<TSRecordProxy> vector = new Vector<TSRecordProxy>();
        RssNode rssNode = this.element.getNode(1);
        if (rssNode != null && rssNode.getTSRecordProxy(0) != null) {
            vector.addElement(rssNode.getTSRecordProxy(0));
        }
        if ((rssNode = this.element.getNode(0)) != null && rssNode.getTSRecordProxy(0) != null) {
            vector.addElement(rssNode.getTSRecordProxy(0));
        }
        return vector;
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

