/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.clientapp.model.TSRecordProxy;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.doubleArrayContainer;
import hec.io.DSSIdentifier;
import hec.lang.NamedType;
import hec.model.Interpolate;
import hec.model.PairedValues;
import hec.model.PairedValuesExt;
import hec.model.RunTimeStep;
import hec.model.RunTimeWindow;
import hec.model.ValuePair;
import hec.rss.model.AdjustableParameter;
import hec.rss.model.ControlStructure;
import hec.rss.model.Element;
import hec.rss.model.Function;
import hec.rss.model.HindcastData;
import hec.rss.model.PowerPlant;
import hec.rss.model.PowerPlantContainer;
import hec.rss.model.Pump;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssNode;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocationObject;
import hec.rss.model.Storage;
import hec.rss.model.TailElevContainer;
import hec.rss.model.TailwaterElevation;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import hec.util.XMLUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Vector;
import org.jdom.Content;
import rma.util.DSSPathPartGenerator;
import rma.util.RMAConst;

public class AdjustableFlow
extends ControlStructure
implements PowerPlantContainer,
TailElevContainer,
AltInputReportInfc {
    public static final int KNOWN_RELEASE_CONST = 0;
    public static final int KNOWN_RELEASE_TS = 1;
    public static final int KNOWN_RELEASE_STOR = 3;
    public static final int FIRST_HINDCAST_COND = 0;
    public static final int LAST_HINDCAST_COND = 3;
    AdjustableParameter _flowParam;
    int _hindcastCondition = 0;
    double _initialRelease = 10.0;
    PairedValues _capacityValues = new PairedValues();
    int _numGates = 1;
    boolean _multipleGateSettings = false;
    double[] _gateSettings = null;
    int _gateSettingParamId = Parameter.PARAMID_PERCENT;
    PairedValuesExt _capacityValuesBySetting = new PairedValuesExt();
    private transient double[] e = null;
    private transient double[] f = null;
    boolean _hasPlant = false;
    PowerPlant _powerPlant;
    boolean _hasPump = false;
    Pump _pump = null;
    boolean _hasTailElev = false;
    TailwaterElevation _tailElev;
    transient doubleArrayContainer a;
    transient doubleArrayContainer b;
    transient doubleArrayContainer c;
    transient doubleArrayContainer d;
    private transient doubleArrayContainer g;
    private transient doubleArrayContainer h;
    private transient doubleArrayContainer i;

    public AdjustableFlow() {
    }

    public AdjustableFlow(Element element) {
        super(element);
        this._capacityValuesBySetting.setUnitSystem(this.getUnitSystem());
        this._capacityValuesBySetting.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityValuesBySetting.setParamYId(Parameter.PARAMID_FLOW);
        this._capacityValues.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityValues.setParamXId(Parameter.PARAMID_FLOW);
        this._capacityValues.setUnitSystem(this.getUnitSystem());
        this._flowParam = this.createDefaultAdjustableParameter();
    }

    protected AdjustableParameter createDefaultAdjustableParameter() {
        AdjustableParameter adjustableParameter = new AdjustableParameter(this);
        adjustableParameter.setName("Flow");
        return adjustableParameter;
    }

    public double getStateRate(RunTimeStep runTimeStep) {
        double d = 1.0;
        if (this._gateSettings != null) {
            double d2 = this.a.array[runTimeStep.step];
            double d3 = this.g.array[runTimeStep.step];
            double d4 = this.getFlowForGateHeight(d2, d3);
            int n = d3 > 0.01 ? -1 : 1;
            double d5 = this.getFlowForGateHeight(d2, d3 + 0.01 * (double)n);
            d = (double)n * (d5 - d4) / 0.01;
        }
        return d;
    }

    public double computeStepFlow(RunTimeStep runTimeStep) {
        double d = 0.0;
        if (this._gateSettings == null) {
            d = this.h.array[runTimeStep.step];
        } else {
            double d2 = this.a.array[runTimeStep.step];
            double d3 = this.g.array[runTimeStep.step];
            this.getFlowForGateHeight(d2, d3);
        }
        return d;
    }

    public double getMaxCapacity() {
        double d = this._multipleGateSettings ? this._capacityValuesBySetting.getLargestValue() * (double)this._numGates : this._capacityValues.getMaxY() * (double)this._numGates;
        return d;
    }

    public double calcFlow(RunTimeStep runTimeStep) {
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        double d = this.getCurrentCapacity(runTimeStep);
        double d2 = 0.0;
        if (this._gateSettings == null) {
            d2 = this.h.array[runTimeStep.step];
        } else {
            double d3 = this.a.array[runTimeStep.step];
            double d4 = this.g.array[runTimeStep.step];
            this.getFlowForGateHeight(d3, d4);
        }
        double d5 = Math.max(0.0, Math.min(d2, d));
        return d5;
    }

    @Override
    public int initForecastOperations(RunTimeWindow runTimeWindow) {
        if (this.c == null || this.h == null) {
            return 1;
        }
        int n = runTimeWindow.getNumLookbackSteps();
        int n2 = runTimeWindow.getNumSteps();
        for (int i = n; i <= n2; ++i) {
            this.h.array[i] = this.c.array[n];
        }
        return 0;
    }

    @Override
    public void applyHindcastData(HindcastData hindcastData) {
        if (hindcastData == null) {
            return;
        }
        if (this.hasPump()) {
            this._hindcastCondition = 0;
            this._initialRelease = 0.0;
            return;
        }
        if (hindcastData.getVariableId() == 41) {
            if (hindcastData.getType() == 1) {
                this._hindcastCondition = 0;
                this._initialRelease = hindcastData.getValue();
                return;
            }
            if (hindcastData.getType() == 0) {
                this._hindcastCondition = 1;
                return;
            }
            if (hindcastData.getType() == 4) {
                this._hindcastCondition = 3;
            }
        }
    }

    @Override
    public void getHindcastDataList(Vector vector) {
        if (vector == null || this.hasPump()) {
            return;
        }
        Object object = this.element.getSystem().getKeyStringForObject(this);
        object = new HindcastData((String)object, 41, 1);
        vector.add(object);
    }

    public PowerPlant getPowerPlant() {
        if (this._powerPlant == null) {
            this._powerPlant = new PowerPlant(this);
        }
        if (this._powerPlant.getAdjustableFlow() == null) {
            this._powerPlant.setAdjustableFlow(this);
        }
        return this._powerPlant;
    }

    public Pump getPump() {
        if (this._pump == null) {
            this._pump = new Pump(this);
        }
        if (this._pump.getAdjustableFlow() == null) {
            this._pump.setAdjustableFlow(this);
        }
        return this._pump;
    }

    @Override
    public TailwaterElevation getTailwaterElevation() {
        if (this._tailElev == null) {
            this._tailElev = new TailwaterElevation(this.element);
        }
        if (this._tailElev.getElement() == null) {
            this._tailElev.setElement(this.element);
        }
        return this._tailElev;
    }

    @Override
    public void setElement(Element element) {
        super.setElement(element);
        if (this._tailElev != null) {
            this._tailElev.setElement(element);
        }
    }

    @Override
    public boolean isNodeComputed(int n, RssNode rssNode, Integer n2) {
        return true;
    }

    public PairedValuesExt getCapacityValuesBySetting() {
        this._capacityValuesBySetting.setUnitSystem(this.getUnitSystem());
        this._capacityValuesBySetting.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityValuesBySetting.setParamYId(Parameter.PARAMID_FLOW);
        return this._capacityValuesBySetting;
    }

    @Override
    public void setupForSerialization() {
        super.setupForSerialization();
        String string = this.getElement() != null ? this.getElement().getSystem().getDssPairedDataFilePath() : "";
        DSSPathname dSSPathname = new DSSPathname();
        DSSPathPartGenerator dSSPathPartGenerator = new DSSPathPartGenerator();
        Object object = this.getElement() != null ? this.getElement().getTopParent().getName() : "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((String)object);
        object = dSSPathPartGenerator.generatePathnamePart(arrayList, "");
        dSSPathname.setAPart((String)object);
        if (this._capacityValues != null) {
            arrayList.clear();
            object = this.getElement() != null ? this.getElement().getName() : "";
            arrayList.add((String)object);
            arrayList.add("Rating");
            object = ((RssTSLocationObject)this).getSystem();
            object = object != null ? ((RssSystem)object).generateUniquePathPart(arrayList, "-") : dSSPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            dSSPathname.setCPart((String)object);
            object = dSSPathname.getPathname();
            this._capacityValues.setDssIdentifer(new DSSIdentifier(string, (String)object));
            this._capacityValues.setParamXId(Parameter.PARAMID_ELEV);
            this._capacityValues.setParamYId(Parameter.PARAMID_FLOW);
            this._capacityValues.setUnitSystem(this.getUnitSystem());
        }
        if (this._capacityValuesBySetting != null) {
            arrayList.clear();
            arrayList.add(this.getElement().getName());
            arrayList.add("Gate Rating");
            object = ((RssTSLocationObject)this).getSystem();
            object = object != null ? ((RssSystem)object).generateUniquePathPart(arrayList, "-") : dSSPathPartGenerator.generatePathnamePart(arrayList, "-");
            dSSPathname.setBPart((String)object);
            object = Parameter.getParamString((int)Parameter.PARAMID_ELEV) + "-" + Parameter.getParamString((int)Parameter.PARAMID_FLOW);
            dSSPathname.setCPart((String)object);
            dSSPathname.setDPart("PairedValuesExt");
            object = dSSPathname.getPathname();
            this._capacityValuesBySetting.setDssIdentifier(new DSSIdentifier(string, (String)object));
            this._capacityValuesBySetting.setParamXId(Parameter.PARAMID_ELEV);
            this._capacityValuesBySetting.setParamYId(Parameter.PARAMID_FLOW);
            this._capacityValuesBySetting.setUnitSystem(this.getUnitSystem());
        }
        if (this._tailElev != null) {
            this._tailElev.setupForSerialization();
        }
        if (this._powerPlant != null) {
            this._powerPlant.setupForSerialization();
        }
        if (this._pump != null) {
            this._pump.setupForSerialization();
        }
    }

    public void setCapacityValuesBySetting(PairedValuesExt pairedValuesExt) {
        this._capacityValuesBySetting = pairedValuesExt;
    }

    public boolean hasMultipleGateSettings() {
        return this._multipleGateSettings;
    }

    public void setMultipleGateSettings(boolean bl) {
        if (this._multipleGateSettings != bl) {
            this._multipleGateSettings = bl;
            this.setModified(true);
        }
    }

    public double[] getGateSettings() {
        return this._gateSettings;
    }

    public void setGateSettings(double[] dArray) {
        this._gateSettings = dArray;
        this.setModified(true);
    }

    public int getGateSettingsParamId() {
        return this._gateSettingParamId;
    }

    public void setGateSettingsParamId(int n) {
        if (this._gateSettingParamId != n) {
            this._gateSettingParamId = n;
            this.setModified(true);
        }
    }

    public int getGateCount() {
        return this._numGates;
    }

    public void setGateCount(int n) {
        this._numGates = n;
    }

    @Override
    public void setHasTailElev(boolean bl) {
        this._hasTailElev = bl;
    }

    @Override
    public boolean hasTailElev() {
        return this._hasTailElev;
    }

    @Override
    public void setHasPowerPlant(boolean bl) {
        this._hasPlant = bl;
    }

    @Override
    public boolean hasPowerPlant() {
        return this._hasPlant;
    }

    public boolean hasPump() {
        return this._hasPump;
    }

    public void setHasPump(boolean bl) {
        this._hasPump = bl;
    }

    public boolean hasReversiblePump() {
        return this.hasPowerPlant() && this.hasPump();
    }

    public void setHasReversiblePump(boolean bl) {
        this.setHasPowerPlant(bl);
        this.setHasPump(bl);
    }

    public double getGateHeightForElevFlow(double d, double d2) {
        double d3;
        int n;
        int n2;
        if (!this._multipleGateSettings || this._gateSettings == null || this._gateSettings.length <= 0 || this._capacityValuesBySetting == null || this._capacityValuesBySetting.size() <= 0) {
            System.out.println("AdjustableFlow.getGateHeightForElevFlow: no gate setting data ");
            return 0.0;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (this._numGates > 0) {
            d2 /= (double)this._numGates;
        }
        int n3 = this._gateSettings.length;
        if (this.e == null) {
            this.e = new double[n3 + 1];
            this.f = new double[n3 + 1];
            this.f[0] = 0.0;
            for (n2 = 0; n2 < n3; ++n2) {
                this.f[n2 + 1] = this._gateSettings[n2];
            }
        }
        this.e[0] = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            this.e[n2 + 1] = this._capacityValuesBySetting.interpolateValue(d, n2);
        }
        for (n = 0; n < n3; ++n) {
            if (n == 0) {
                if (!(this.e[n] < 0.0)) continue;
                this.e[n] = 0.0;
                continue;
            }
            if (!(this.e[n] <= this.e[n - 1])) continue;
            this.e[n] = this.e[n - 1] + 0.001;
        }
        n = n3 + 1;
        double d4 = Interpolate.linearInterpolate((double[])this.e, (double[])this.f, (double)d2, (int)n);
        if (d3 < 0.0) {
            d4 = 0.0;
        }
        return d4;
    }

    public double getPrevGateHeight(RunTimeStep runTimeStep) {
        double d;
        int n = runTimeStep.step - 1;
        if (n < 0) {
            n = 0;
        }
        if (this.g != null && this.g.array[n] != Double.NEGATIVE_INFINITY) {
            d = this.g.array[n];
        } else {
            AdjustableFlow adjustableFlow = this;
            double d2 = adjustableFlow.getMaxCapacityForElevation(adjustableFlow.getElement().getPrevEffectiveElev(runTimeStep));
            double d3 = this.c.array[n];
            d = d2 > 0.0 ? d3 / d2 : 0.0;
        }
        return d;
    }

    public double getFlowForGateHeight(double d, double d2) {
        double d3;
        double[] dArray;
        if (!this._multipleGateSettings || this._gateSettings == null || this._gateSettings.length <= 0 || this._capacityValuesBySetting == null || this._capacityValuesBySetting.size() <= 0) {
            double d4 = this.getMaxCapacityForElevation(d);
            return d4 * d2;
        }
        int n = this._gateSettings.length;
        boolean bl = false;
        if (this._gateSettings[0] > d2) {
            dArray = new double[n + 1];
            System.arraycopy(this._gateSettings, 0, dArray, 1, n);
            dArray[0] = 0.0;
            bl = true;
        } else {
            dArray = this._gateSettings;
        }
        double[] dArray2 = new double[n + 1];
        int n2 = 0;
        if (bl) {
            dArray2[0] = 0.0;
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            dArray2[i + n2] = this._capacityValuesBySetting.interpolateValue(d, i);
        }
        double d5 = Interpolate.linearInterpolate((double[])dArray, (double[])dArray2, (double)d2, (int)dArray.length);
        if (d3 < 0.0) {
            d5 = 0.0;
        }
        return d5 * (double)this._numGates;
    }

    @Deprecated
    public double getMaxCapacityForElevation(double d) {
        return this.getCapacity(d);
    }

    public void copyInto(AdjustableFlow adjustableFlow) {
        super.copyInto(adjustableFlow);
        if (adjustableFlow._flowParam != null) {
            this._flowParam = (AdjustableParameter)adjustableFlow._flowParam.clone();
            this._flowParam.setFunction(this);
        } else {
            this._flowParam = null;
        }
        this._capacityValues = adjustableFlow._capacityValues != null ? (PairedValues)adjustableFlow._capacityValues.clone() : null;
        if (adjustableFlow._tailElev != null) {
            this._tailElev = (TailwaterElevation)((RssTSLocationObject)adjustableFlow._tailElev).clone();
            this._tailElev.setElement(this.element);
        } else {
            this._tailElev = null;
        }
        if (adjustableFlow._powerPlant != null) {
            this._powerPlant = (PowerPlant)adjustableFlow._powerPlant.clone();
            this._powerPlant.setAdjustableFlow(this);
        } else {
            this._powerPlant = null;
        }
        if (adjustableFlow._pump != null) {
            this._pump = (Pump)adjustableFlow._pump.clone();
            this._pump.setAdjustableFlow(this);
        } else {
            this._pump = null;
        }
        this._hindcastCondition = adjustableFlow._hindcastCondition;
        this._initialRelease = adjustableFlow._initialRelease;
        this._numGates = adjustableFlow._numGates;
        this._multipleGateSettings = adjustableFlow._multipleGateSettings;
        this._gateSettings = adjustableFlow._gateSettings;
        this._gateSettingParamId = adjustableFlow._gateSettingParamId;
        this._capacityValuesBySetting = adjustableFlow._capacityValuesBySetting;
        this.e = adjustableFlow.e;
        this.f = adjustableFlow.f;
        this._hasPlant = adjustableFlow._hasPlant;
        this._hasPump = adjustableFlow._hasPump;
        this._hasTailElev = adjustableFlow._hasTailElev;
    }

    @Override
    public synchronized Object clone() {
        AdjustableFlow adjustableFlow = (AdjustableFlow)super.clone();
        if (this._flowParam != null) {
            adjustableFlow._flowParam = (AdjustableParameter)this._flowParam.clone();
            adjustableFlow._flowParam.setFunction(adjustableFlow);
        }
        if (this._capacityValues != null) {
            adjustableFlow._capacityValues = (PairedValues)this._capacityValues.clone();
        }
        if (this._tailElev != null) {
            adjustableFlow._tailElev = (TailwaterElevation)((RssTSLocationObject)this._tailElev).clone();
            adjustableFlow._tailElev.setElement(adjustableFlow.element);
        }
        if (this._powerPlant != null) {
            adjustableFlow._powerPlant = (PowerPlant)this._powerPlant.clone();
            adjustableFlow._powerPlant.setAdjustableFlow(adjustableFlow);
        }
        if (this._pump != null) {
            adjustableFlow._pump = (Pump)this._pump.clone();
            adjustableFlow._pump.setAdjustableFlow(adjustableFlow);
        }
        return adjustableFlow;
    }

    public double getInitialRelease() {
        return this._initialRelease;
    }

    public void setInitialRelease(double d) {
        this._initialRelease = d;
    }

    public int getHindcastCondition() {
        return this._hindcastCondition;
    }

    public boolean setHindcastCondition(int n) {
        if (n < 0 || n > 3) {
            return false;
        }
        this._hindcastCondition = n;
        return true;
    }

    @Override
    public AdjustableParameter getAdjustableParameter() {
        return this._flowParam;
    }

    @Override
    public AdjustableParameter findAdjParam(String string) {
        if (string.compareTo("Flow") == 0) {
            return this._flowParam;
        }
        return null;
    }

    @Override
    public boolean hasDefaultParameters() {
        Vector vector = this._capacityValues.getDataVector();
        if (vector.size() != 2) {
            return false;
        }
        ValuePair valuePair = (ValuePair)vector.elementAt(0);
        if (valuePair.xval != 0.0 || valuePair.yval != 0.0) {
            return false;
        }
        valuePair = (ValuePair)vector.elementAt(1);
        return valuePair.xval == 1000.0 && valuePair.yval == 1000.0;
    }

    public PairedValues getCapacityValues() {
        this._capacityValues.setUnitSystem(this.getUnitSystem());
        this._capacityValues.setParamXId(Parameter.PARAMID_ELEV);
        this._capacityValues.setParamYId(Parameter.PARAMID_FLOW);
        return this._capacityValues;
    }

    public void setCapacityValues(PairedValues pairedValues) {
        this._capacityValues = pairedValues;
    }

    @Override
    public boolean initialize() {
        this.b = null;
        this.c = null;
        this.a = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.e = null;
        this.f = null;
        if (!super.initialize()) {
            return false;
        }
        RssNode rssNode = this.element.getNode(0);
        RssNode rssNode2 = this.element.getNode(1);
        if (rssNode == null || rssNode2 == null) {
            this.printErrorMessage("initialize", "Failed to load up and down stream nodes");
            return false;
        }
        Element element = this.element.getTopParent();
        if (!(element instanceof ReservoirElement)) {
            this.printErrorMessage("initialize", "no parent reservoir");
            return false;
        }
        this.a = ((ReservoirElement)element).getStorageFunction().getTSContainer(10);
        this.b = rssNode.getTSContainer(0);
        this.c = rssNode2.getTSContainer(0);
        if (this.a == null || this.b == null || this.c == null) {
            this.printErrorMessage("initialize", "failed to load elevation or flow time-series");
            return false;
        }
        if (this._hindcastCondition == 1 && !this.hasPump()) {
            this.d = this.getTSContainer(41);
            if (this.d == null) {
                this.printErrorMessage("initialize", "failed to find lookback time-series");
                return false;
            }
        }
        if (this._flowParam != null) {
            this.h = this.getTSContainer(47);
            if (this.h == null) {
                this.printErrorMessage("initialize", "failed to load flow setting time-series");
                return false;
            }
            this._flowParam.setValueTSContainer(this.h);
        }
        if (this._multipleGateSettings && this._gateSettings != null) {
            this.g = this._gateSettingParamId == Parameter.PARAMID_PERCENT ? this.getTSContainer(32) : this.getTSContainer(31);
        }
        this.i = this.getTSContainer(127);
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.initialize();
        }
        if (this._powerPlant != null && this._hasPlant) {
            if (this._powerPlant.findTailwaterElevation() == null) {
                this.printErrorMessage("initialize", "No Tailwater Elevation found for power plant calculations");
                return false;
            }
            this._powerPlant.initialize();
        }
        if (this._pump != null && this._hasPump && !this._pump.initialize()) {
            this.printErrorMessage("initialize", "Pump failed to initialize");
            return false;
        }
        return true;
    }

    public double getCurrentCapacity(RunTimeStep runTimeStep) {
        double d;
        Element element = this.getElement();
        double d2 = element.getPrevEffectiveElev(runTimeStep);
        if (!RMAConst.isValidValue((double)d2)) {
            d2 = ((ReservoirElement)this.element.getTopParent()).getStorageFunction().getMaxElevation();
        }
        if (!RMAConst.isValidValue((double)(d = element.getEffectiveElev(runTimeStep)))) {
            d = d2;
        }
        return this.getCurrentCapacity(runTimeStep, d2, d);
    }

    public double getCurrentCapacity(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        double d;
        if (runTimeStep.isPerAvgTimeStep() && n > 1) {
            double d2 = 0.0;
            double d3 = dArray[n - 1] - dArray[0];
            for (int i = 1; i < n; ++i) {
                double d4 = (dArray2[i] + dArray2[i - 1]) * 0.5;
                double d5 = this.getCapacity(d4);
                d2 += d5 * (dArray[i] - dArray[i - 1]) / d3;
            }
            d = d2;
        } else {
            d = this.getCapacity(dArray2[n - 1]);
        }
        if (this.hasPowerPlant() && this._powerPlant.isRestrictMaximum()) {
            d = Math.min(d, this._powerPlant.getRestrictMaximum());
        }
        return d;
    }

    public double getCurrentCapacity(RunTimeStep runTimeStep, double d, double d2) {
        double d3;
        if (runTimeStep.isPerAvgTimeStep()) {
            int n = runTimeStep.step - 1;
            if (n < 0) {
                n = 0;
            }
            double d4 = this.c.array[n];
            d3 = this.getPerAvgCapacity(d4, d2, runTimeStep.getTimeStepSeconds());
        } else {
            d3 = this.getCapacity(d2);
        }
        return d3;
    }

    public double getCapacity(double d) {
        double d2;
        if (this._multipleGateSettings) {
            int n = this._gateSettings.length - 1;
            d2 = this._capacityValuesBySetting.interpolateValue(d, n) * (double)this._numGates;
        } else {
            d2 = this._capacityValues.interpolateValue(d) * (double)this._numGates;
        }
        return d2;
    }

    private double getPerAvgCapacity(double d, double d2, double d3) {
        double d4 = this.getCapacity(d2);
        if (d <= 0.0 && d4 <= 0.0) {
            return 0.0;
        }
        return (d + d4) * 0.5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getHindcastValue(RunTimeStep runTimeStep) {
        if (this.c == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._hindcastCondition == 1) {
            if (this.d != null && runTimeStep.step < this.d.length && RMAConst.isValidValue((double)this.d.array[runTimeStep.step])) {
                return this.d.array[runTimeStep.step];
            }
            this.printErrorMessage("computeHindcastStep", "known release TS empty or invalid");
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return Double.NEGATIVE_INFINITY;
        }
        if (this._hindcastCondition == 0) {
            return this._initialRelease;
        }
        if (this._hindcastCondition == 3) {
            NamedType namedType = (ReservoirElement)this.getElement().getTopParent();
            namedType = namedType.getStorageFunction();
            namedType.computeInflow(runTimeStep);
            double d = namedType.getNetInflow(runTimeStep);
            double d2 = 0.0;
            if (runTimeStep.step <= 0) return Math.max(0.0, d - d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q);
            namedType.computeHindcastStep(runTimeStep);
            d2 = namedType.getStorage(runTimeStep) - namedType.getPreviousStorage(runTimeStep);
            return Math.max(0.0, d - d2 / (double)runTimeStep.getTimeStepSeconds() * Storage.DSDT_TO_Q);
        }
        this.printErrorMessage("computeHindcastStep", "unknown hindcast equation " + this._hindcastCondition);
        this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public int computeHindcastStep(RunTimeStep runTimeStep) {
        double d = this.getHindcastValue(runTimeStep);
        if (d == Double.NEGATIVE_INFINITY) {
            return 1;
        }
        this.c.array[runTimeStep.step] = d;
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        this._flowParam.setMaxValue(this.getCurrentCapacity(runTimeStep));
        this._flowParam.setValue(this.c.array[runTimeStep.step]);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        double d2 = this.getElement().getEffectiveElev(runTimeStep);
        double d3 = this.c.array[runTimeStep.step];
        if (this._powerPlant != null && this._hasPlant) {
            this._powerPlant.computePower(runTimeStep, d2, d3);
        }
        if (this._multipleGateSettings && this._gateSettings != null) {
            this.g.array[runTimeStep.step] = this.getGateHeightForElevFlow(d2, this.c.array[runTimeStep.step]);
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep) {
        double d;
        if (this.c == null || this.b == null) {
            this.printErrorMessage("computeForecastStep", "missing timeseries arrays" + this._hindcastCondition);
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        double d2 = this.getCurrentCapacity(runTimeStep);
        this._flowParam.setMaxValue(d2);
        this.c.array[runTimeStep.step] = d = this._flowParam.getValue(runTimeStep);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        if (this._multipleGateSettings && this._gateSettings != null) {
            AdjustableFlow adjustableFlow = this;
            this.g.array[runTimeStep.step] = adjustableFlow.getGateHeightForElevFlow(adjustableFlow.a.array[runTimeStep.step], this.c.array[runTimeStep.step]);
        }
        double d3 = this.getElement().getEffectiveElev(runTimeStep);
        double d4 = this.c.array[runTimeStep.step];
        if (this._powerPlant != null && this._hasPlant) {
            this._powerPlant.computePower(runTimeStep, d3, d4);
        }
        return 0;
    }

    @Override
    public int computeForecastStep(RunTimeStep runTimeStep, double[] dArray, double[] dArray2, int n) {
        double d;
        double d2;
        if (this.c == null || this.b == null) {
            this.printErrorMessage("computeForecastStep", "missing timeseries arrays" + this._hindcastCondition);
            this.element.getSystem().printMessage("Date and Time: " + runTimeStep.dateTimeString());
            return 1;
        }
        if (this._tailElev != null && this._hasTailElev) {
            this._tailElev.computeElevation(runTimeStep);
        }
        double d3 = this.getCurrentCapacity(runTimeStep, dArray, dArray2, n);
        this._flowParam.setMaxValue(d3);
        this.c.array[runTimeStep.step] = d2 = this._flowParam.getValue(runTimeStep);
        this.b.array[runTimeStep.step] = this.c.array[runTimeStep.step];
        double d4 = dArray2[n - 1];
        if (runTimeStep.isPerAvgTimeStep()) {
            d4 = 0.0;
            d = dArray[n - 1] - dArray[0];
            for (int i = 0; i < n - 1; ++i) {
                d4 += dArray2[i] * (dArray[i + 1] - dArray[i]) / d;
            }
        }
        d = this.c.array[runTimeStep.step];
        if (this._powerPlant != null && this._hasPlant) {
            double d5 = this._powerPlant.getPoolElevation(runTimeStep);
            this._powerPlant.computePower(runTimeStep, d5, d);
        }
        if (this._multipleGateSettings && this._gateSettings != null) {
            this.g.array[runTimeStep.step] = this.getGateHeightForElevFlow(d4, this.c.array[runTimeStep.step]);
        }
        return 0;
    }

    @Override
    public double computeSubStepFlow(RunTimeStep runTimeStep, double d, double d2) {
        double d3;
        if (runTimeStep.isPerAvgTimeStep()) {
            d3 = this._flowParam.getValue(runTimeStep);
        } else {
            double d4;
            double d5;
            double d6 = this.c.array[runTimeStep.getPrevStep()];
            d3 = d6 + ((d5 = this._flowParam.getValue(runTimeStep)) - d6) * (d / (double)runTimeStep.getTimeStepSeconds());
            if (d3 > (d4 = this.getCapacity(d2))) {
                d3 = d4;
            }
        }
        return d3;
    }

    @Override
    public Vector getActiveTSProxies(Vector vector, int n) {
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1 && this._hindcastCondition == 1) {
            vector.add(this.getTSRecordProxy(41));
        }
        if (n == 0) {
            if (this._flowParam != null) {
                vector.add(this.getTSRecordProxy(47));
            }
            if (this._multipleGateSettings && this._gateSettings != null) {
                if (this._gateSettingParamId == Parameter.PARAMID_PERCENT) {
                    vector.add(this.getTSRecordProxy(32));
                } else {
                    vector.add(this.getTSRecordProxy(31));
                }
            }
            vector.add(this.getTSRecordProxy(127));
        }
        if (this._powerPlant != null && this._hasPlant) {
            this._powerPlant.getActiveTSRecordProxies(vector, n);
        }
        if (this._tailElev != null && this._hasTailElev) {
            ((RssTSLocationObject)this._tailElev).getActiveTSRecordProxies(vector, n);
        }
        if (this._pump != null && this._hasPump) {
            this._pump.getActiveTSRecordProxies(vector, n);
        }
        return vector;
    }

    @Override
    public void updateTSProxyList() {
        if (this.element == null) {
            return;
        }
        RssNode rssNode = this.element.getNode(0);
        if (rssNode != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if ((rssNode = this.element.getNode(1)) != null && rssNode.getTSRecordProxy(0) == null) {
            rssNode.addTSRecordProxy(0);
        }
        if (this._flowParam != null && this.getTSRecordProxy(47) == null) {
            this.addTSRecordProxy(47);
        }
        if (this.getTSRecordProxy(41) == null) {
            this.addTSRecordProxy(41);
        }
        if (this.getTSRecordProxy(31) == null) {
            this.addTSRecordProxy(31);
        }
        if (this.getTSRecordProxy(32) == null) {
            this.addTSRecordProxy(32);
        }
        if (this.getTSRecordProxy(127) == null) {
            this.addTSRecordProxy(127);
        }
        if (this._powerPlant != null && this._hasPlant) {
            this._powerPlant.updateTSProxyList();
        }
        if (this._tailElev != null && this._hasTailElev) {
            ((RssTSLocationObject)this._tailElev).updateTSProxyList();
        }
        if (this._pump != null && this._hasPump) {
            this._pump.updateTSProxyList();
        }
    }

    @Override
    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    @Override
    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, org.jdom.Element element) {
        ParamDouble paramDouble;
        element.setAttribute("Name", this.getDisplayName());
        element.setAttribute("Number_of_Gates", Integer.toString(this._numGates));
        AdjustableParameter adjustableParameter = ((Function)this).findAdjParam("Flow");
        if (adjustableParameter != null) {
            paramDouble = new ParamDouble();
            adjustableParameter.getMaxRateOfIncrease(paramDouble);
            element.setAttribute("Max_Rate_Increase", Double.toString(paramDouble.getValue()));
            adjustableParameter.getMaxRateOfDecrease(paramDouble);
            element.setAttribute("Max_Rate_Decrease", Double.toString(paramDouble.getValue()));
        }
        if (this._multipleGateSettings) {
            for (int i = 0; i < this._capacityValuesBySetting.getNumberCurves(); ++i) {
                paramDouble = this._capacityValuesBySetting.getCurve(i);
                if (i <= 0 || i >= this._capacityValuesBySetting.getNumberCurves() - 2) continue;
                adjustableParameter = new org.jdom.Element("GateSetting" + Double.toString(this.getGateSettings()[i]));
                element.addContent((Content)adjustableParameter);
                XMLUtilities.createArrayElements((org.jdom.Element)adjustableParameter, (double[])paramDouble.getXArray());
            }
        } else {
            adjustableParameter = new org.jdom.Element("Gate_Elevation");
            element.addContent((Content)adjustableParameter);
            XMLUtilities.createArrayElements((org.jdom.Element)adjustableParameter, (double[])this._capacityValues.getYArray());
            adjustableParameter = new org.jdom.Element("Gate_MaxCapacity");
            element.addContent((Content)adjustableParameter);
            XMLUtilities.createArrayElements((org.jdom.Element)adjustableParameter, (double[])this._capacityValues.getXArray());
        }
        if (this._hasPlant) {
            this.getPowerPlant().outputReport(alternativeInputReport, element);
        }
        if (this._hasPump) {
            this.getPump().outputReport(alternativeInputReport, element);
        }
        if (this._hasTailElev) {
            adjustableParameter = new org.jdom.Element("Tailwater");
            element.addContent((Content)adjustableParameter);
            this.getTailwaterElevation().outputReport(alternativeInputReport, (org.jdom.Element)adjustableParameter);
        }
    }

    public void updateSystemState(RunTimeStep runTimeStep, int n) {
        RunTimeStep runTimeStep2 = new RunTimeStep(runTimeStep);
        for (int i = 0; i < n; ++i) {
            runTimeStep2.step = runTimeStep.step + i;
            this.h.array[runTimeStep2.step] = this.c.array[runTimeStep2.step];
            this.b.array[runTimeStep2.step] = this.c.array[runTimeStep2.step];
            if (this._multipleGateSettings && this._gateSettings != null) {
                AdjustableFlow adjustableFlow = this;
                this.g.array[runTimeStep2.step] = adjustableFlow.getGateHeightForElevFlow(adjustableFlow.a.array[runTimeStep2.step], this.c.array[runTimeStep2.step]);
            }
            double d = this.getElement().getEffectiveElev(runTimeStep2);
            double d2 = this.c.array[runTimeStep2.step];
            if (this._powerPlant == null || !this._hasPlant) continue;
            this._powerPlant.computePower(runTimeStep2, d, d2);
        }
    }
}

