/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.heclib.util.doubleArrayContainer;
import hec.lang.NamedType;
import hec.model.RunTimeStep;
import hec.rss.model.AdjustableDiversion;
import hec.rss.model.AdjustableFlow;
import hec.rss.model.ControlStructure;
import hec.rss.model.Controller;
import hec.rss.model.Function;
import hec.rss.model.OpController;
import hec.rss.model.PowerPlant;
import hec.rss.model.PumpFlow;
import hec.rss.model.RssReturnStatusConstants;
import java.lang.reflect.Field;

public class AdjustableParameter
extends NamedType
implements RssReturnStatusConstants {
    private static double c = 0.0;
    private static double d = 0.0;
    private static double e = Double.MAX_VALUE;
    private static double f = Double.NEGATIVE_INFINITY;
    private static double g = Double.NEGATIVE_INFINITY;
    Function _function;
    double _value = 0.0;
    double _minValue = 0.0;
    double _maxValue = e;
    double _maxRateOfIncrease = f;
    double _maxRateOfDecrease = g;
    double _minThresholdValue = 0.0;
    private transient Controller h = null;
    transient doubleArrayContainer a;
    transient OpController b = null;

    public AdjustableParameter() {
    }

    public AdjustableParameter(Function function) {
        this._function = function;
    }

    public void setValueTSContainer(doubleArrayContainer doubleArrayContainer2) {
        this.a = doubleArrayContainer2;
    }

    public synchronized Object clone() {
        try {
            AdjustableParameter adjustableParameter = (AdjustableParameter)super.clone();
            this.h = null;
            this.b = null;
            return adjustableParameter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setFunction(Function function) {
        this._function = function;
    }

    public void setConstraints(AdjustableParameter adjustableParameter) {
        if (adjustableParameter == null) {
            return;
        }
        this._minValue = adjustableParameter._minValue;
        if (this._minValue < 0.0) {
            this._minValue = 0.0;
        }
        this._maxValue = adjustableParameter._maxValue;
        this._maxRateOfIncrease = adjustableParameter._maxRateOfIncrease;
        this._maxRateOfDecrease = adjustableParameter._maxRateOfDecrease;
    }

    public void sumConstraints(AdjustableParameter adjustableParameter) {
        if (adjustableParameter == null) {
            return;
        }
        if (this.hasDefaultParameters()) {
            this.setConstraints(adjustableParameter);
            return;
        }
        if (this._minValue == Double.NEGATIVE_INFINITY) {
            this._minValue = adjustableParameter._minValue;
        } else if (adjustableParameter._minValue != Double.NEGATIVE_INFINITY) {
            this._minValue += adjustableParameter._minValue;
        }
        if (this._minValue < 0.0) {
            this._minValue = 0.0;
        }
        if (this._maxValue == Double.NEGATIVE_INFINITY) {
            this._maxValue = adjustableParameter._maxValue;
        } else if (adjustableParameter._maxValue != Double.NEGATIVE_INFINITY) {
            this._maxValue += adjustableParameter._maxValue;
        }
        if (this._maxRateOfIncrease != Double.NEGATIVE_INFINITY) {
            this._maxRateOfIncrease = adjustableParameter._maxRateOfIncrease == Double.NEGATIVE_INFINITY ? adjustableParameter._maxRateOfIncrease : (this._maxRateOfIncrease += adjustableParameter._maxRateOfIncrease);
        }
        if (this._maxRateOfDecrease != Double.NEGATIVE_INFINITY) {
            if (adjustableParameter._maxRateOfDecrease == Double.NEGATIVE_INFINITY) {
                this._maxRateOfDecrease = adjustableParameter._maxRateOfDecrease;
                return;
            }
            this._maxRateOfDecrease += adjustableParameter._maxRateOfDecrease;
        }
    }

    public void initialize() {
        this.h = null;
    }

    public Function getFunction() {
        return this._function;
    }

    public double getCurrentValue() {
        return this._value;
    }

    public void setCurrentValue(double d) {
        this._value = d;
    }

    public double setValueConstrained(double d, double d2) {
        double d3;
        if (d < this._minValue) {
            d = this._minValue;
        } else if (d > this._maxValue) {
            d = this._maxValue;
        }
        double d4 = d - this._value;
        if (d3 >= 0.0) {
            if (this._maxRateOfIncrease != Double.NEGATIVE_INFINITY && d4 > this._maxRateOfIncrease * d2) {
                d = this._value + this._maxRateOfIncrease * d2;
            }
        } else if (this._maxRateOfDecrease != Double.NEGATIVE_INFINITY && -d4 > this._maxRateOfDecrease * d2) {
            d = this._value - this._maxRateOfDecrease * d2;
        }
        this._value = d;
        return this._value;
    }

    public void setValue(double d) {
        this._value = d;
    }

    public double testValue(double d, RunTimeStep runTimeStep) {
        double d2;
        double d3 = runTimeStep.getTimeStepSeconds();
        if (d > this._maxValue) {
            d = this._maxValue;
        }
        if (d < this._minValue) {
            d = this._minValue;
        }
        if (d < this._minThresholdValue) {
            d = this._minValue;
        }
        if ((d2 = this.a != null ? this.a.array[runTimeStep.getPrevStep()] : this._value) == Double.NEGATIVE_INFINITY) {
            return d;
        }
        double d4 = (d - d2) / (d3 / 3600.0);
        if (d > d2) {
            if (this._maxRateOfIncrease != Double.NEGATIVE_INFINITY && d4 > this._maxRateOfIncrease) {
                d = d2 + this._maxRateOfIncrease * (d3 / 3600.0);
            }
        } else if (d < d2 && this._maxRateOfDecrease != Double.NEGATIVE_INFINITY && -d4 > this._maxRateOfDecrease) {
            d = d2 - this._maxRateOfDecrease * (d3 / 3600.0);
        }
        return d;
    }

    public double getMaxByIROC(RunTimeStep runTimeStep) {
        if (!(this._function instanceof AdjustableFlow) || this._maxRateOfIncrease == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.a == null && runTimeStep.step <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = runTimeStep.getTimeStepSeconds();
        double d2 = this.a.array[runTimeStep.step - 1];
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = d2 + this._maxRateOfIncrease * (d / 3600.0);
        return d3;
    }

    public double getMinByDROC(RunTimeStep runTimeStep) {
        if (!(this._function instanceof AdjustableFlow) || this._maxRateOfDecrease == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.a == null && runTimeStep.step <= 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = runTimeStep.getTimeStepSeconds();
        double d2 = this.a.array[runTimeStep.step - 1];
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double d3 = d2 - this._maxRateOfDecrease * (d / 3600.0);
        return d3;
    }

    public double setValue(double d, RunTimeStep runTimeStep, int n) {
        double d2 = runTimeStep.getTimeStepSeconds();
        if (d > this._maxValue) {
            d = this._maxValue;
        }
        if (d < this._minValue) {
            d = this._minValue;
        }
        for (int i = 0; i < n && runTimeStep.step + i <= runTimeStep.getTotalNumSteps(); ++i) {
            double d3 = this.a != null ? this.a.array[runTimeStep.step - 1 + i] : this._value;
            if (d3 == Double.NEGATIVE_INFINITY) {
                this._value = d;
                if (this.a == null) continue;
                this.a.array[runTimeStep.step + i] = this._value;
                continue;
            }
            this._value = d;
            double d4 = (d - d3) / (d2 / 3600.0);
            if (d > d3) {
                if (this._maxRateOfIncrease != Double.NEGATIVE_INFINITY && d4 > this._maxRateOfIncrease) {
                    this._value = d3 + this._maxRateOfIncrease * (d2 / 3600.0);
                }
            } else if (d < d3 && this._maxRateOfDecrease != Double.NEGATIVE_INFINITY && -d4 > this._maxRateOfDecrease) {
                this._value = d3 - this._maxRateOfDecrease * (d2 / 3600.0);
            }
            if (this.a == null) continue;
            this.a.array[runTimeStep.step + i] = this._value;
        }
        return this._value;
    }

    public double getControlledValue(RunTimeStep runTimeStep) {
        if (this.h != null) {
            this._value = this.h.getValue(this, runTimeStep);
        }
        return this._value;
    }

    public double getValue(RunTimeStep runTimeStep) {
        double d = this._value;
        if (this.a != null) {
            d = this.a.array[runTimeStep.step];
        }
        if (d < this._minValue) {
            d = this._minValue;
        }
        if (d > this._maxValue) {
            d = this._maxValue;
        }
        return d;
    }

    public double getPreviousValue(RunTimeStep runTimeStep) {
        if (this.a != null) {
            return this.a.array[runTimeStep.step - 1];
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void setController(Controller controller) {
        this.h = controller;
    }

    public void setOpController(OpController opController) {
        this.b = opController;
    }

    public void setMinValue(double d) {
        this._minValue = d;
    }

    public void setMaxValue(double d) {
        this._maxValue = d;
    }

    public void setMaxRateOfIncrease(double d) {
        if (d <= 0.0) {
            this._maxRateOfIncrease = Double.NEGATIVE_INFINITY;
            return;
        }
        this._maxRateOfIncrease = d;
    }

    public void setMaxRateOfIncrease(ParamDouble paramDouble) {
        double d;
        double d2 = paramDouble.getValue();
        if (d <= 0.0) {
            this._maxRateOfIncrease = Double.NEGATIVE_INFINITY;
            return;
        }
        this._maxRateOfIncrease = d2;
    }

    public void setMaxRateOfDecrease(double d) {
        if (d <= 0.0) {
            this._maxRateOfDecrease = Double.NEGATIVE_INFINITY;
            return;
        }
        this._maxRateOfDecrease = d;
    }

    public void setMaxRateOfDecrease(ParamDouble paramDouble) {
        double d;
        double d2 = paramDouble.getValue();
        if (d <= 0.0) {
            this._maxRateOfDecrease = Double.NEGATIVE_INFINITY;
            return;
        }
        this._maxRateOfDecrease = d2;
    }

    public double getMinValue() {
        return this._minValue;
    }

    public double getMaxValue() {
        return this._maxValue;
    }

    public double getMaxRateOfIncrease() {
        return this._maxRateOfIncrease;
    }

    public void getMaxRateOfIncrease(ParamDouble paramDouble) {
        paramDouble.setValue(this._maxRateOfIncrease);
        paramDouble.setUnitSystem(this._function.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public double getMaxRateOfDecrease() {
        return this._maxRateOfDecrease;
    }

    public void getMaxRateOfDecrease(ParamDouble paramDouble) {
        paramDouble.setValue(this._maxRateOfDecrease);
        paramDouble.setUnitSystem(this._function.getUnitSystem());
        paramDouble.setParameterId(Parameter.PARAMID_FLOW);
    }

    public void setDefaultParameters() {
        this._minValue = 0.0;
        this._maxValue = e;
        this._minThresholdValue = 0.0;
        this._maxRateOfIncrease = f;
        this._maxRateOfDecrease = g;
    }

    public boolean hasDefaultParameters() {
        return this._minValue == 0.0 && this._maxValue == e && this._maxRateOfIncrease == f && this._maxRateOfDecrease == g && this._minThresholdValue == 0.0;
    }

    public int initCurrentLimits(RunTimeStep runTimeStep, int n) {
        if (this._function instanceof PumpFlow) {
            this._maxValue = 0.0;
        } else if (this._function instanceof AdjustableFlow) {
            NamedType namedType = (AdjustableFlow)this._function;
            this._maxValue = namedType.getCurrentCapacity(runTimeStep);
            if (namedType.hasPowerPlant()) {
                if ((namedType = namedType.getPowerPlant()).isRestrictMaximum()) {
                    this._maxValue = Math.min(this._maxValue, namedType.getRestrictMaximum());
                }
                if (namedType.isRestrictMinimum()) {
                    this._minThresholdValue = Math.max(this._minThresholdValue, namedType.getRestrictMinimum());
                }
                if (namedType.isEfficiencyRelease()) {
                    double d = namedType.getPoolElevation(runTimeStep);
                    double d2 = namedType.getTailwaterElevation(runTimeStep);
                    double d3 = d - d2;
                    double d4 = namedType.calcEfficiency(d, d3, this._maxValue);
                    double d5 = namedType.calcRelForMinEff(d4, d, d3, this._maxValue);
                    this._maxValue = Math.min(this._maxValue, d5);
                    double d6 = Math.max(this._minValue, 0.01);
                    d4 = namedType.calcEfficiency(d, d3, d6);
                    d6 = namedType.calcRelForMinEff(d4, d, d3, d6);
                    this._minThresholdValue = Math.max(this._minThresholdValue, d6);
                }
            }
        } else if (this._function instanceof AdjustableDiversion) {
            this._maxValue = Double.MAX_VALUE;
            this._minThresholdValue = this._minValue = -1.7976931348623157E308;
            this._maxRateOfDecrease = Double.MAX_VALUE;
            this._maxRateOfIncrease = Double.MAX_VALUE;
        } else if (this._function instanceof ControlStructure) {
            this._maxValue = ((ControlStructure)this._function).getEstimatedFlow(runTimeStep, n);
            if (this._maxValue == Double.NEGATIVE_INFINITY) {
                this._maxValue = 0.0;
            }
            this._minValue = this._maxValue;
            this._value = this._maxValue;
            this._maxRateOfDecrease = ((ControlStructure)this._function).getEstimatedROD(runTimeStep, n);
            this._maxRateOfIncrease = ((ControlStructure)this._function).getEstimatedROI(runTimeStep, n);
            if (this.b != null) {
                this.b.setCurrentOpValue(this._value, -10, Integer.MIN_VALUE, runTimeStep);
                this.b.setCurMaxOpValue(this._value, -10, Integer.MIN_VALUE, runTimeStep);
                this.b.setCurMinOpValue(this._value, -10, Integer.MIN_VALUE, runTimeStep);
                this.b.e[runTimeStep.step] = -10.0;
            }
        }
        return 0;
    }

    public void recalcCurrentLimitsInst(RunTimeStep runTimeStep, double d) {
        if (this._function instanceof PumpFlow) {
            this._maxValue = 0.0;
            return;
        }
        if (this._function instanceof AdjustableFlow) {
            NamedType namedType = (AdjustableFlow)this._function;
            double d2 = d;
            this._maxValue = namedType.getCurrentCapacity(runTimeStep, d2, d2);
            if (namedType.hasPowerPlant()) {
                if ((namedType = namedType.getPowerPlant()).isRestrictMaximum()) {
                    this._maxValue = Math.min(this._maxValue, namedType.getRestrictMaximum());
                }
                if (namedType.isRestrictMinimum()) {
                    this._minThresholdValue = Math.max(this._minThresholdValue, namedType.getRestrictMinimum());
                }
                if (namedType.isEfficiencyRelease()) {
                    double d3 = namedType.getTailwaterElevation(runTimeStep);
                    double d4 = d - d3;
                    double d5 = namedType.calcEfficiency(d, d4, this._maxValue);
                    double d6 = namedType.calcRelForMinEff(d5, d, d4, this._maxValue);
                    this._maxValue = Math.min(this._maxValue, d6);
                    double d7 = Math.max(this._minValue, 0.01);
                    d5 = namedType.calcEfficiency(d, d4, d7);
                    d7 = namedType.calcRelForMinEff(d5, d, d4, d7);
                    this._minThresholdValue = Math.max(this._minThresholdValue, d7);
                }
            }
            return;
        }
        if (this._function instanceof AdjustableDiversion) {
            AdjustableDiversion cfr_ignored_0 = (AdjustableDiversion)this._function;
            this._maxValue = Double.MAX_VALUE;
            return;
        }
        if (this._function instanceof ControlStructure) {
            this._maxValue = ((ControlStructure)this._function).getRelease(d);
            if (this._maxValue == Double.NEGATIVE_INFINITY) {
                this._maxValue = 0.0;
            }
            this._minValue = this._maxValue;
            this._value = this._maxValue;
            this._maxRateOfIncrease = (this._value - this.a.array[runTimeStep.getPrevStep()]) / (double)runTimeStep.getTimeStepSeconds() * 3600.0;
            this._maxRateOfDecrease = -this._maxRateOfIncrease;
        }
    }

    public void recalcCurrentLimits(RunTimeStep runTimeStep, double[] object, double[] dArray, int n) {
        if (this._function instanceof PumpFlow) {
            this._maxValue = 0.0;
            return;
        }
        if (this._function instanceof AdjustableFlow) {
            AdjustableFlow adjustableFlow = (AdjustableFlow)this._function;
            this._maxValue = adjustableFlow.getCurrentCapacity(runTimeStep, (double[])object, dArray, n);
            if (adjustableFlow.hasPowerPlant()) {
                PowerPlant powerPlant = adjustableFlow.getPowerPlant();
                object = powerPlant;
                if (powerPlant.isRestrictMaximum()) {
                    this._maxValue = Math.min(this._maxValue, ((PowerPlant)object).getRestrictMaximum());
                }
                if (((PowerPlant)object).isRestrictMinimum()) {
                    this._minThresholdValue = Math.max(this._minThresholdValue, ((PowerPlant)object).getRestrictMinimum());
                }
                if (((PowerPlant)object).isEfficiencyRelease()) {
                    double d = ((PowerPlant)object).getTailwaterElevation(runTimeStep);
                    double d2 = dArray[0] - d;
                    double d3 = ((PowerPlant)object).calcEfficiency(dArray[0], d2, this._maxValue);
                    double d4 = ((PowerPlant)object).calcRelForMinEff(d3, dArray[0], d2, this._maxValue);
                    this._maxValue = Math.min(this._maxValue, d4);
                    double d5 = Math.max(this._minValue, 0.01);
                    d3 = ((PowerPlant)object).calcEfficiency(dArray[0], d2, d5);
                    d5 = ((PowerPlant)object).calcRelForMinEff(d3, dArray[0], d2, d5);
                    this._minThresholdValue = Math.max(this._minThresholdValue, d5);
                }
            }
            return;
        }
        if (this._function instanceof ControlStructure) {
            this._maxValue = runTimeStep.isPerAvgTimeStep() ? ((ControlStructure)this._function).periodAverageFlow((double[])object, dArray, n) : ((ControlStructure)this._function).getRelease(dArray[n - 1]);
            if (this._maxValue == Double.NEGATIVE_INFINITY) {
                this._maxValue = 0.0;
            }
            this._minValue = this._maxValue;
            this._value = this._maxValue;
            this._maxRateOfIncrease = (this._value - this.a.array[runTimeStep.getPrevStep()]) / (double)runTimeStep.getTimeStepSeconds() * 3600.0;
            this._maxRateOfDecrease = -this._maxRateOfIncrease;
        }
    }

    double getInstFlowCap(RunTimeStep runTimeStep, double d, double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        if (this._function instanceof AdjustableFlow) {
            d2 = ((AdjustableFlow)this._function).getMaxCapacityForElevation(d);
            dArray[0] = dArray[0] + d2;
        } else if (this._function instanceof ControlStructure) {
            d2 = ((ControlStructure)this._function).getRelease(d);
            dArray2[0] = dArray2[0] + d2;
        }
        return d2;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }
}

