/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.lang.NamedType;
import hec.model.NoRepeatInterval;
import hec.model.RepeatInterval;
import hec.rss.model.reports.AltInputReportInfc;
import hec.rss.model.reports.AlternativeInputReport;
import java.lang.reflect.Field;
import org.jdom.Element;

public class CapacityOutage
extends NamedType
implements AsciiSerializable,
AltInputReportInfc,
Cloneable {
    private HecTime _startTime = new HecTime();
    private HecTime _endTime = new HecTime();
    private double _factor;
    private boolean _isActive = true;
    private RepeatInterval _repeatInterval = new NoRepeatInterval();
    private boolean _isPeriodAverage = true;

    public HecTime getStartTime() {
        return this._startTime;
    }

    public void setStartTime(HecTime hecTime) {
        if (hecTime == null) {
            this._startTime.setUndefined();
            return;
        }
        this._startTime.set(hecTime);
    }

    public HecTime getEndTime() {
        return this._endTime;
    }

    public void setEndTime(HecTime hecTime) {
        if (hecTime == null) {
            this._endTime.setUndefined();
            return;
        }
        this._endTime.set(hecTime);
    }

    public void setFactor(double d) {
        this._factor = d;
    }

    public double getFactor() {
        return this._factor;
    }

    public RepeatInterval getRepeatInterval() {
        return this._repeatInterval;
    }

    public void setRepeatInterval(RepeatInterval repeatInterval) {
        this._repeatInterval = repeatInterval;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean bl) {
        this._isActive = bl;
    }

    public synchronized Object clone() {
        CapacityOutage capacityOutage;
        try {
            capacityOutage = (CapacityOutage)super.clone();
            if (this._startTime != null) {
                capacityOutage._startTime = new HecTime(this._startTime);
            }
            if (this._endTime != null) {
                capacityOutage._endTime = new HecTime(this._endTime);
            }
            if (this._repeatInterval != null) {
                capacityOutage._repeatInterval = (RepeatInterval)this._repeatInterval.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            capacityOutage = new CapacityOutage();
            capacityOutage.setName(this.getName());
            capacityOutage.setDescription(this.getDescription());
        }
        return capacityOutage;
    }

    public double getFactorForStep(HecTime hecTime, HecTime hecTime2) {
        return this.getFactorForStep(hecTime, hecTime2, true);
    }

    public double getFactorForStep(HecTime hecTime, HecTime hecTime2, boolean bl) {
        double d;
        if (hecTime == null || !hecTime.isDefined() || hecTime2 == null || !hecTime2.isDefined()) {
            return 1.0;
        }
        int n = this._startTime.value();
        int n2 = this._endTime.value();
        int n3 = hecTime.value();
        int n4 = hecTime2.value();
        if (bl) {
            if (n4 < n) {
                return 1.0;
            }
            if (this._repeatInterval == null || this._repeatInterval instanceof NoRepeatInterval) {
                if (n3 > n2) {
                    return 1.0;
                }
            } else {
                int n5;
                if (this._repeatInterval.getEndDate() != null && this._repeatInterval.getEndDate().greaterThan(this._startTime) && n3 >= (n5 = this._repeatInterval.getEndDate().value())) {
                    return 1.0;
                }
                HecTime[] hecTimeArray = this._repeatInterval.getNextRepeatTime(this._startTime, hecTime, this._endTime, hecTime2);
                if (hecTimeArray.length == 0) {
                    System.out.println(" Capacity Outage: Expected repeat interval but there were none.");
                    return 1.0;
                }
                n = hecTimeArray[0].value();
                n2 = hecTimeArray[1].value();
                if (n > n4) {
                    return 1.0;
                }
            }
            if (n < n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            d = n2 - n;
        } else {
            if (n4 < n) {
                return 1.0;
            }
            if (this._repeatInterval == null || this._repeatInterval instanceof NoRepeatInterval) {
                if (n3 > n2) {
                    return 1.0;
                }
            } else {
                int n6;
                if (this._repeatInterval.getEndDate() != null && this._repeatInterval.getEndDate().greaterThan(this._startTime) && n3 > (n6 = this._repeatInterval.getEndDate().value())) {
                    return 1.0;
                }
                HecTime[] hecTimeArray = this._repeatInterval.getNextRepeatTime(this._startTime, hecTime, this._endTime, hecTime2);
                if (hecTimeArray.length == 0) {
                    System.out.println(" Capacity Outage: Expected repeat interval but there were none.");
                    return 1.0;
                }
                n = hecTimeArray[0].value();
                n2 = hecTimeArray[1].value();
                if (n4 < n) {
                    return 1.0;
                }
            }
            if (n < n3) {
                n = n3;
            }
            if (n2 > n4) {
                n2 = n4;
            }
            d = n2 - n;
        }
        double d2 = n4 - n3;
        double d3 = d / d2;
        double d4 = 1.0 - d3 + d3 * this._factor;
        return d4;
    }

    public Object getFieldObject(Field field) {
        try {
            Object object = field.get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.getFieldObject(field);
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return super.setFieldObject(field, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.setFieldObject(field, object);
        }
    }

    @Override
    public void outputReport(AlternativeInputReport alternativeInputReport, Element element) {
        element.setAttribute("StartTime", this._startTime.toString());
        element.setAttribute("EndTime", this._endTime.toString());
        element.setAttribute("Factor", Double.toString(this._factor));
        element.setAttribute("IsActive", Boolean.toString(this._isActive));
        element.setAttribute("Repeating", Integer.toString(this._repeatInterval.getRepeatType()));
        if (this._repeatInterval.getRepeatType() != 0) {
            element.setAttribute("Every", Integer.toString(this._repeatInterval.getRepeatNumber()));
            if (this._repeatInterval.getEndDate() != null) {
                element.setAttribute("EndOn", this._repeatInterval.getEndDate().toString());
            }
        }
    }
}

