/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.model;

import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.io.AsciiSerializable;
import hec.lang.InvalidStateException;
import hec.rss.model.ChannelType;
import java.lang.reflect.Field;
import rma.util.RMAConst;

public abstract class Channel
implements AsciiSerializable {
    protected double _length;
    protected double _slope;
    protected int _unitSystem = 0;

    public double getLength() {
        return this._length;
    }

    public double getSlope() {
        return this._slope;
    }

    public void setLength(double d) {
        this._length = d;
    }

    public void setSlope(double d) {
        this._slope = d;
    }

    public void getLength(ParamDouble paramDouble) {
        paramDouble.setValue(this._length);
        paramDouble.setUnitSystem(this.getUnitSystem());
        paramDouble.setPrecision(2);
        paramDouble.setParameterId(Parameter.PARAMID_LENGTH);
    }

    public void setchannelLength(ParamDouble paramDouble) {
        if (paramDouble == null) {
            return;
        }
        int n = this.getUnitSystem();
        if (n == paramDouble.getUnitSystem()) {
            this._length = paramDouble.getValue();
            return;
        }
        this._length = paramDouble.convertToUnitSystem(n);
    }

    public int getUnitSystem() {
        return this._unitSystem;
    }

    public void setUnitSystem(int n) {
        this._unitSystem = n;
    }

    public ChannelType getChannelType() {
        return ChannelType.UNKNOWN;
    }

    public boolean isValid() throws InvalidStateException {
        if (this.getChannelType() == ChannelType.UNKNOWN) {
            System.out.println("ERROR: Channel type has not been set");
            throw new InvalidStateException((Object)this, "Channel type has not been set");
        }
        if (!RMAConst.isValidValue((double)this._slope) || this._slope <= 0.0) {
            System.out.println("ERROR: Invalid channel slope");
            Channel channel = this;
            throw new InvalidStateException((Object)channel, "Invalid Channel Slope. Slope (" + channel._slope + ") is not a valid value or is less than or equal to 0");
        }
        if (!RMAConst.isValidValue((double)this._length) || this._length <= 0.0) {
            System.out.println("ERROR: Invalid channel length");
            Channel channel = this;
            throw new InvalidStateException((Object)channel, "Invalid Channel length. Length (" + channel._length + ") is not a valid value or is less than or equal to 0");
        }
        if (this._unitSystem == 0) {
            System.out.println("ERROR: Unit system has not been set for channel");
            throw new InvalidStateException((Object)this, "Unit system has not been set for channel");
        }
        return true;
    }

    public abstract double getCelerity(double var1);

    public abstract double getTopWidth(double var1);

    public abstract double getDepth(double var1);

    public Object getFieldObject(Field object) {
        try {
            object = ((Field)object).get(this);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public boolean setFieldObject(Field field, Object object) {
        try {
            field.set(this, object);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

